/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionRecycler;
import org.apache.mina.common.support.BaseIoAcceptor;
import org.apache.mina.common.support.IoServiceListenerSupport;
import org.apache.mina.transport.socket.nio.DatagramAcceptorConfig;
import org.apache.mina.transport.socket.nio.DatagramServiceConfig;
import org.apache.mina.transport.socket.nio.DatagramSessionConfig;
import org.apache.mina.transport.socket.nio.support.DatagramFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.mina.util.Queue;

public class DatagramAcceptorDelegate
extends BaseIoAcceptor
implements IoAcceptor,
DatagramService {
    private static volatile int nextId = 0;
    private final IoAcceptor wrapper;
    private final Executor executor;
    private final int id = nextId++;
    private Selector selector;
    private DatagramAcceptorConfig defaultConfig = new DatagramAcceptorConfig();
    private final Map channels = new HashMap();
    private final Queue registerQueue = new Queue();
    private final Queue cancelQueue = new Queue();
    private final Queue flushingSessions = new Queue();
    private Worker worker;

    public DatagramAcceptorDelegate(IoAcceptor ioAcceptor, Executor executor) {
        this.wrapper = ioAcceptor;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) throws IOException {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        if (ioHandler == null) {
            throw new NullPointerException("handler");
        }
        if (ioServiceConfig == null) {
            ioServiceConfig = this.getDefaultConfig();
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unexpected address type: " + socketAddress.getClass());
        }
        if (((InetSocketAddress)socketAddress).getPort() == 0) {
            throw new IllegalArgumentException("Unsupported port number: 0");
        }
        RegistrationRequest registrationRequest = new RegistrationRequest(socketAddress, ioHandler, ioServiceConfig);
        Object object = this;
        synchronized (object) {
            Queue queue = this.registerQueue;
            synchronized (queue) {
                this.registerQueue.push(registrationRequest);
            }
            this.startupWorker();
        }
        this.selector.wakeup();
        object = registrationRequest;
        synchronized (object) {
            while (!registrationRequest.done) {
                try {
                    registrationRequest.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (registrationRequest.exception != null) {
            throw (IOException)new IOException("Failed to bind").initCause(registrationRequest.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(SocketAddress socketAddress) {
        if (socketAddress == null) {
            throw new NullPointerException("address");
        }
        CancellationRequest cancellationRequest = new CancellationRequest(socketAddress);
        Object object = this;
        synchronized (object) {
            try {
                this.startupWorker();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Address not bound: " + socketAddress);
            }
            Queue queue = this.cancelQueue;
            synchronized (queue) {
                this.cancelQueue.push(cancellationRequest);
            }
            this.selector.wakeup();
        }
        object = cancellationRequest;
        synchronized (object) {
            while (!cancellationRequest.done) {
                try {
                    cancellationRequest.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (cancellationRequest.exception != null) {
            throw new RuntimeException("Failed to unbind", cancellationRequest.exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAll() {
        ArrayList arrayList;
        Object object = this.channels;
        synchronized (object) {
            arrayList = new ArrayList(this.channels.keySet());
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.unbind((SocketAddress)object.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSession newSession(SocketAddress socketAddress, SocketAddress socketAddress2) {
        Object object;
        Object object2;
        if (socketAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        if (socketAddress2 == null) {
            throw new NullPointerException("localAddress");
        }
        Selector selector = this.selector;
        DatagramChannel datagramChannel = (DatagramChannel)this.channels.get(socketAddress2);
        if (selector == null || datagramChannel == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + socketAddress2);
        }
        SelectionKey selectionKey = datagramChannel.keyFor(selector);
        if (selectionKey == null) {
            throw new IllegalArgumentException("Unknown localAddress: " + socketAddress2);
        }
        RegistrationRequest registrationRequest = (RegistrationRequest)selectionKey.attachment();
        IoSessionRecycler ioSessionRecycler = this.getSessionRecycler(registrationRequest);
        if (ioSessionRecycler == null) {
            object2 = new DatagramSessionImpl(this.wrapper, this, registrationRequest.config, datagramChannel, registrationRequest.handler, registrationRequest.address, registrationRequest.address);
            ((DatagramSessionImpl)object2).setRemoteAddress(socketAddress);
            ((DatagramSessionImpl)object2).setSelectionKey(selectionKey);
            object = object2;
        } else {
            object2 = ioSessionRecycler;
            synchronized (object2) {
                object = ioSessionRecycler.recycle(socketAddress2, socketAddress);
                if (object != null) {
                    return object;
                }
                DatagramSessionImpl datagramSessionImpl = new DatagramSessionImpl(this.wrapper, this, registrationRequest.config, datagramChannel, registrationRequest.handler, registrationRequest.address, registrationRequest.address);
                datagramSessionImpl.setRemoteAddress(socketAddress);
                datagramSessionImpl.setSelectionKey(selectionKey);
                this.getSessionRecycler(registrationRequest).put(datagramSessionImpl);
                object = datagramSessionImpl;
            }
        }
        try {
            this.buildFilterChain(registrationRequest, (IoSession)object);
            this.getListeners().fireSessionCreated((IoSession)object);
        }
        catch (Throwable throwable) {
            ExceptionMonitor.getInstance().exceptionCaught(throwable);
        }
        return object;
    }

    private IoSessionRecycler getSessionRecycler(RegistrationRequest registrationRequest) {
        IoSessionRecycler ioSessionRecycler = registrationRequest.config instanceof DatagramServiceConfig ? ((DatagramServiceConfig)registrationRequest.config).getSessionRecycler() : this.defaultConfig.getSessionRecycler();
        return ioSessionRecycler;
    }

    public IoServiceListenerSupport getListeners() {
        return super.getListeners();
    }

    private void buildFilterChain(RegistrationRequest registrationRequest, IoSession ioSession) throws Exception {
        this.getFilterChainBuilder().buildFilterChain(ioSession.getFilterChain());
        registrationRequest.config.getFilterChainBuilder().buildFilterChain(ioSession.getFilterChain());
        registrationRequest.config.getThreadModel().buildFilterChain(ioSession.getFilterChain());
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(DatagramAcceptorConfig datagramAcceptorConfig) {
        if (datagramAcceptorConfig == null) {
            throw new NullPointerException("defaultConfig");
        }
        this.defaultConfig = datagramAcceptorConfig;
    }

    private synchronized void startupWorker() throws IOException {
        if (this.worker == null) {
            this.selector = Selector.open();
            this.worker = new Worker();
            this.executor.execute(new NamePreservingRunnable(this.worker));
        }
    }

    public void flushSession(DatagramSessionImpl datagramSessionImpl) {
        this.scheduleFlush(datagramSessionImpl);
        Selector selector = this.selector;
        if (selector != null) {
            selector.wakeup();
        }
    }

    public void closeSession(DatagramSessionImpl datagramSessionImpl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFlush(DatagramSessionImpl datagramSessionImpl) {
        Queue queue = this.flushingSessions;
        synchronized (queue) {
            this.flushingSessions.push(datagramSessionImpl);
        }
    }

    private void processReadySessions(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = (SelectionKey)iterator.next();
            iterator.remove();
            DatagramChannel datagramChannel = (DatagramChannel)selectionKey.channel();
            RegistrationRequest registrationRequest = (RegistrationRequest)selectionKey.attachment();
            try {
                if (selectionKey.isReadable()) {
                    this.readSession(datagramChannel, registrationRequest);
                }
                if (!selectionKey.isWritable()) continue;
                Iterator iterator2 = this.getManagedSessions(registrationRequest.address).iterator();
                while (iterator2.hasNext()) {
                    this.scheduleFlush((DatagramSessionImpl)iterator2.next());
                }
            }
            catch (Throwable throwable) {
                ExceptionMonitor.getInstance().exceptionCaught(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSession(DatagramChannel datagramChannel, RegistrationRequest registrationRequest) throws Exception {
        DatagramSessionConfig datagramSessionConfig = (DatagramSessionConfig)registrationRequest.config.getSessionConfig();
        int n = datagramSessionConfig.getReceiveBufferSize();
        if (datagramSessionConfig.getDatagramMaximumPacketSize() > 0) {
            n = datagramSessionConfig.getDatagramMaximumPacketSize();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n, false);
        SocketAddress socketAddress = datagramChannel.receive(byteBuffer.buf());
        if (socketAddress != null) {
            DatagramSessionImpl datagramSessionImpl = (DatagramSessionImpl)this.newSession(socketAddress, registrationRequest.address);
            byteBuffer.flip();
            datagramSessionImpl.increaseReadBytes(byteBuffer.remaining());
            datagramSessionImpl.getFilterChain().fireMessageReceived(datagramSessionImpl, byteBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSessions() {
        if (this.flushingSessions.size() == 0) {
            return;
        }
        while (true) {
            DatagramSessionImpl datagramSessionImpl;
            Queue queue = this.flushingSessions;
            synchronized (queue) {
                datagramSessionImpl = (DatagramSessionImpl)this.flushingSessions.pop();
            }
            if (datagramSessionImpl == null) break;
            try {
                this.flush(datagramSessionImpl);
            }
            catch (IOException iOException) {
                datagramSessionImpl.getFilterChain().fireExceptionCaught(datagramSessionImpl, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(DatagramSessionImpl datagramSessionImpl) throws IOException {
        DatagramChannel datagramChannel = datagramSessionImpl.getChannel();
        Queue queue = datagramSessionImpl.getWriteRequestQueue();
        while (true) {
            int n;
            Object object;
            IoFilter.WriteRequest writeRequest;
            Object object2 = queue;
            synchronized (object2) {
                writeRequest = (IoFilter.WriteRequest)queue.first();
            }
            if (writeRequest == null) break;
            object2 = (ByteBuffer)writeRequest.getMessage();
            if (((ByteBuffer)object2).remaining() == 0) {
                object = queue;
                synchronized (object) {
                    queue.pop();
                }
                datagramSessionImpl.increaseWrittenWriteRequests();
                ((ByteBuffer)object2).reset();
                ((DatagramFilterChain)datagramSessionImpl.getFilterChain()).fireMessageSent(datagramSessionImpl, writeRequest);
                continue;
            }
            object = datagramSessionImpl.getSelectionKey();
            if (object == null) {
                this.scheduleFlush(datagramSessionImpl);
                break;
            }
            if (!((SelectionKey)object).isValid()) continue;
            SocketAddress socketAddress = writeRequest.getDestination();
            if (socketAddress == null) {
                socketAddress = datagramSessionImpl.getRemoteAddress();
            }
            if ((n = datagramChannel.send(((ByteBuffer)object2).buf(), socketAddress)) == 0) {
                ((SelectionKey)object).interestOps(((SelectionKey)object).interestOps() | 4);
                continue;
            }
            if (n <= 0) continue;
            ((SelectionKey)object).interestOps(((SelectionKey)object).interestOps() & 0xFFFFFFFB);
            Queue queue2 = queue;
            synchronized (queue2) {
                queue.pop();
            }
            datagramSessionImpl.increaseWrittenBytes(n);
            datagramSessionImpl.increaseWrittenWriteRequests();
            ((ByteBuffer)object2).reset();
            datagramSessionImpl.getFilterChain().fireMessageSent(datagramSessionImpl, writeRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerNew() {
        if (this.registerQueue.isEmpty()) {
            return;
        }
        while (true) {
            Object object;
            RegistrationRequest registrationRequest;
            Object object2 = this.registerQueue;
            synchronized (object2) {
                registrationRequest = (RegistrationRequest)this.registerQueue.pop();
            }
            if (registrationRequest == null) return;
            object2 = null;
            try {
                object2 = DatagramChannel.open();
                object = registrationRequest.config.getSessionConfig() instanceof DatagramSessionConfig ? (DatagramSessionConfig)registrationRequest.config.getSessionConfig() : (DatagramSessionConfig)this.getDefaultConfig().getSessionConfig();
                ((DatagramChannel)object2).socket().setReuseAddress(object.isReuseAddress());
                ((DatagramChannel)object2).socket().setBroadcast(object.isBroadcast());
                ((DatagramChannel)object2).socket().setReceiveBufferSize(object.getReceiveBufferSize());
                ((DatagramChannel)object2).socket().setSendBufferSize(object.getSendBufferSize());
                if (((DatagramChannel)object2).socket().getTrafficClass() != object.getTrafficClass()) {
                    ((DatagramChannel)object2).socket().setTrafficClass(object.getTrafficClass());
                }
                ((AbstractSelectableChannel)object2).configureBlocking(false);
                ((DatagramChannel)object2).socket().bind(registrationRequest.address);
                ((AbstractSelectableChannel)object2).register(this.selector, 1, registrationRequest);
                Map map = this.channels;
                synchronized (map) {
                    this.channels.put(registrationRequest.address, object2);
                }
                this.getListeners().fireServiceActivated(this, registrationRequest.address, registrationRequest.handler, registrationRequest.config);
                continue;
            }
            catch (Throwable throwable) {
                registrationRequest.exception = throwable;
                continue;
            }
            finally {
                object = registrationRequest;
                synchronized (object) {
                    registrationRequest.done = true;
                    registrationRequest.notify();
                }
                if (object2 == null || registrationRequest.exception == null) continue;
                try {
                    ((DatagramChannel)object2).disconnect();
                    ((AbstractInterruptibleChannel)object2).close();
                }
                catch (Throwable throwable) {
                    ExceptionMonitor.getInstance().exceptionCaught(throwable);
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cancelKeys() {
        if (this.cancelQueue.isEmpty()) {
            return;
        }
        while (true) {
            CancellationRequest cancellationRequest;
            Object object = this.cancelQueue;
            synchronized (object) {
                cancellationRequest = (CancellationRequest)this.cancelQueue.pop();
            }
            if (cancellationRequest == null) return;
            Object object2 = this.channels;
            synchronized (object2) {
                object = (DatagramChannel)this.channels.remove(cancellationRequest.address);
            }
            try {
                if (object == null) {
                    cancellationRequest.exception = new IllegalArgumentException("Address not bound: " + cancellationRequest.address);
                    continue;
                }
                object2 = ((AbstractSelectableChannel)object).keyFor(this.selector);
                cancellationRequest.registrationRequest = (RegistrationRequest)((SelectionKey)object2).attachment();
                ((SelectionKey)object2).cancel();
                this.selector.wakeup();
                ((DatagramChannel)object).disconnect();
                ((AbstractInterruptibleChannel)object).close();
                continue;
            }
            catch (Throwable throwable) {
                ExceptionMonitor.getInstance().exceptionCaught(throwable);
                continue;
            }
            finally {
                object2 = cancellationRequest;
                synchronized (object2) {
                    cancellationRequest.done = true;
                    cancellationRequest.notify();
                }
                if (cancellationRequest.exception != null) continue;
                this.getListeners().fireServiceDeactivated(this, cancellationRequest.address, cancellationRequest.registrationRequest.handler, cancellationRequest.registrationRequest.config);
                continue;
            }
            break;
        }
    }

    public void updateTrafficMask(DatagramSessionImpl datagramSessionImpl) {
    }

    private static class CancellationRequest {
        private final SocketAddress address;
        private boolean done;
        private RegistrationRequest registrationRequest;
        private RuntimeException exception;

        private CancellationRequest(SocketAddress socketAddress) {
            this.address = socketAddress;
        }
    }

    private static class RegistrationRequest {
        private final SocketAddress address;
        private final IoHandler handler;
        private final IoServiceConfig config;
        private Throwable exception;
        private boolean done;

        private RegistrationRequest(SocketAddress socketAddress, IoHandler ioHandler, IoServiceConfig ioServiceConfig) {
            this.address = socketAddress;
            this.handler = ioHandler;
            this.config = ioServiceConfig;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName("DatagramAcceptor-" + DatagramAcceptorDelegate.this.id);
            while (true) {
                try {
                    do {
                        int n = DatagramAcceptorDelegate.this.selector.select();
                        DatagramAcceptorDelegate.this.registerNew();
                        if (n > 0) {
                            DatagramAcceptorDelegate.this.processReadySessions(DatagramAcceptorDelegate.this.selector.selectedKeys());
                        }
                        DatagramAcceptorDelegate.this.flushSessions();
                        DatagramAcceptorDelegate.this.cancelKeys();
                    } while (!DatagramAcceptorDelegate.this.selector.keys().isEmpty());
                    DatagramAcceptorDelegate datagramAcceptorDelegate = DatagramAcceptorDelegate.this;
                    synchronized (datagramAcceptorDelegate) {
                        if (DatagramAcceptorDelegate.this.selector.keys().isEmpty() && DatagramAcceptorDelegate.this.registerQueue.isEmpty() && DatagramAcceptorDelegate.this.cancelQueue.isEmpty()) {
                            DatagramAcceptorDelegate.this.worker = null;
                            try {
                                DatagramAcceptorDelegate.this.selector.close();
                            }
                            catch (IOException iOException) {
                                ExceptionMonitor.getInstance().exceptionCaught(iOException);
                            }
                            finally {
                                DatagramAcceptorDelegate.this.selector = null;
                            }
                            break;
                        }
                        continue;
                    }
                }
                catch (IOException iOException) {
                    ExceptionMonitor.getInstance().exceptionCaught(iOException);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
    }
}

