/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.cupertinostreaming.util;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.StringUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamPacketizerCupertinoChunk;
import com.wowza.wms.httpstreamer.cupertinostreaming.livestreampacketizer.LiveStreamingCupertinoBlock;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.util.HTTPStreamerUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import java.io.File;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LiveStreamPacketizerCupertinoUtils {
    public static boolean initProvider = true;
    public static final String CRLF_STR = "\n";
    public static final String EMPTYPLAYLISTSTR = "#EXTM3U\n#EXT-X-ENDLIST";
    public static final String PLAYLISTSTARTSTR = "#EXTM3U";
    public static final String EXTXVERSIONPLACEHOLDER = "{ext-x-version}";
    public static final String EXTXVERSIONSTR = "#EXT-X-VERSION:{ext-x-version}";
    public static final String PLAYLISTSTOPSTR = "#EXT-X-ENDLIST";
    public static final String PLAYLISTTARGETDURATIONSTR = "#EXT-X-TARGETDURATION";
    public static final String PLAYLISTMEDIASEQSTR = "#EXT-X-MEDIA-SEQUENCE";
    public static final String PLAYLISTITEMSTR = "#EXTINF";
    public static final String CACHECONTROLSTR = "#EXT-X-ALLOW-CACHE";
    public static final String AVAILABILITYSTR = "#E";
    public static final String PLAYLISTSTREAMINF = "#EXT-X-STREAM-INF";
    public static final String DOMAINPLACHOLDER = "{domain}";
    public static final String APPLICATIONPLACHOLDER = "{application}";
    public static final String APPINSTANCEPLACHOLDER = "{appInstance}";
    public static final String STREAMPLACHOLDER = "{stream}";
    public static final String FILENAMEPLACHOLDER = "{filename}";
    public static final String INDEXPLACHOLDER = "{index}";
    public static final String EXTPLACEHOLDER = "{ext}";
    public static final String QUERYSTRPLACHOLDER = "{query}";
    public static final String QUERYSTR_NODVR_PLACHOLDER = "{query_no_dvr}";
    public static final String RESOLUTIONPLACEHOLDER = "{resolution}";
    public static final String RESOLUTIONWIDTHPLACEHOLDER = "{resolution-width}";
    public static final String RESOLUTIONHEIGHTPLACEHOLDER = "{resolution-height}";
    public static final String AUDIOONLYPLACHOLDER = "{audioOnly}";
    public static final String PLAYSTARTNAME = "{playStartName}";
    public static final String PLAYSTARTVALUE = "{playStartValue}";
    public static final String PLAYSTARTPLACHOLDER = "{playStartName}={playStartValue}";
    public static final String PLAYDURATIONNAME = "{playDurationName}";
    public static final String PLAYDURATIONVALUE = "{playDurationValue}";
    public static final String PLAYDURATIONPLACHOLDER = "{playDurationName}={playDurationValue}";
    public static final String QUERYSTRAUDIOONLYPLACHOLDER = "{query}{audioOnly}";
    public static final String ENCKEYPLACEHOLDERPLACHOLDER = "{enckeyurl}";
    public static final String ENCMETHODPLACEHOLDERPLACHOLDER = "{encmethod}";
    public static final String ENCIVPLACEHOLDER = "{encIV}";
    public static final String ENCKEYSTR = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\"";
    public static final String ENCKEYSTRWITHIV = "#EXT-X-KEY:METHOD={encmethod},URI=\"{enckeyurl}\",IV=\"{encIV}\"";
    public static final String DISCONTINUITYSTR = "#EXT-X-DISCONTINUITY";
    public static final String RESOLUTIONSTR = ",RESOLUTION={resolution-width}x{resolution-height}";
    public static final String MEDIANAMEPLACEHOLDER = "{mediaName}";
    public static final String BITRATEPLACEHOLDER = "{bitrate}";
    public static final String FILENAMEPATTERN = "{mediaName}{bitrate}_{index}{ext}";
    public static final String URLPATTERN = "{domain}/{application}/{appInstance}/{stream}/{filename}?{query}";
    public static final String URLPATTERN_RELATIVE = "{filename}?{query}";
    public static final String ENCMETHOD_DEFAULT = "AES-128";
    public static final String DEFAULT_MEDIANAME = "media";
    public static final String DEFAULT_CHUNKLISTNAME = "chunklist";

    /*
     * Enabled aggressive block sorting
     */
    public static String streamModeToFileExtension(int n) {
        String string = FileChunk.concat((int)(57 - 43), (String)" {c");
        switch (n) {
            case 2: {
                string = FileChunk.concat((int)(227 / 36), (String)"(jx:");
            }
            default: {
                return string;
            }
            case 3: 
        }
        return FileChunk.concat((int)(41 * 31), (String)"y989");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToIndex(String string) {
        int n = -1;
        int n2 = string.lastIndexOf("_");
        if (n2 < 0) {
            return n;
        }
        int n3 = string.lastIndexOf(".");
        if (n3 < 0) {
            return n;
        }
        if (n2 >= n3) {
            return n;
        }
        String string2 = string.substring(n2 + 1, n3);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void encryptChunk(LiveStreamPacketizerCupertinoChunk liveStreamPacketizerCupertinoChunk, CupertinoEncInfo cupertinoEncInfo) {
        int n;
        int n2;
        ArrayList<LiveStreamingCupertinoBlock> arrayList;
        List<LiveStreamingCupertinoBlock> list;
        Cipher cipher;
        if (cupertinoEncInfo == null) return;
        if (initProvider) {
            try {
                SystemUtils.addBouncyCastleSecurityProvider();
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).info(Base64.subSequence((String)"IoqmZ~yilc_qryv`|lrjZokyojvnn,ehpuoXhi`iy}50pvwVzcy{`Yzoirz\u0013$!66,2>\u0018;%=%)+=jq", (int)(1440 / 241)) + exception.toString());
            }
            initProvider = false;
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(cupertinoEncInfo.getEncKeyBytes(), FileChunk.concat((int)(5 * 33), (String)"DCT"));
            long l = liveStreamPacketizerCupertinoChunk.getChunkIndex();
            byte[] byArray = new byte[16];
            BufferUtils.longToByteArray((long)l, (byte[])byArray, (int)8, (int)8);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            cipher = Cipher.getInstance(Base64.subSequence((String)"\u001a\u0019\u000eq\u001cBB-SOFU0Xhnoeci", (int)(-39 - -34)), "BC");
            cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            list = liveStreamPacketizerCupertinoChunk.getBlockList();
            arrayList = new ArrayList<LiveStreamingCupertinoBlock>();
            n2 = list.size();
            int n3 = 0;
            int n4 = 0;
            n = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).error(Base64.subSequence((String)"Y\u007fa}Jniy|sO!\")&0,<\":\n?;)?:&>>\u0007'=9%y=79)%-*\u001c(4,(~e\u0007\u0002\u001bd{ytm+!3#+# <99by", (int)(78 + 103)) + exception.toString());
            return;
        }
        while (true) {
            if (n >= n2) {
                liveStreamPacketizerCupertinoChunk.setBlockList(arrayList);
                return;
            }
            LiveStreamingCupertinoBlock liveStreamingCupertinoBlock = list.get(n);
            n4 += liveStreamingCupertinoBlock.getLen();
            byte[] byArray = null;
            byArray = n == n2 - 1 ? cipher.doFinal(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen()) : cipher.update(liveStreamingCupertinoBlock.getBuffer(), liveStreamingCupertinoBlock.getOffset(), liveStreamingCupertinoBlock.getLen());
            if (byArray != null) {
                n3 += byArray.length;
                LiveStreamingCupertinoBlock liveStreamingCupertinoBlock2 = new LiveStreamingCupertinoBlock(byArray, 0, byArray.length);
                arrayList.add(liveStreamingCupertinoBlock2);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CupertinoEncInfo getEncInfo(IApplicationInstance iApplicationInstance, String string) {
        Object object;
        String string2 = null;
        byte[] byArray = null;
        String string3 = null;
        String string4 = iApplicationInstance.getStreamKeyPath();
        File file = new File(string4 + "/" + string + Base64.subSequence((String)"'anu", (int)(117 + -76)));
        if (file.exists()) {
            object = HTTPStreamerUtils.parseEncryptionKeyFile((File)file);
            string3 = (String)object.get(FileChunk.concat((int)(234 / 66), (String)"vvi"));
            if (string3 != null || (string3 = (String)object.get(FileChunk.concat((int)(-39 - 2), (String)"\"*0"))) != null || (string3 = (String)object.get(FileChunk.concat((int)(116 + -49), (String)" 15#5< $$?9<*1<;=3x72+hhcq(,3"))) != null || (string3 = (String)object.get(Base64.subSequence((String)" 15#5< $$?9<*1<;=3x72+hhcq(,6", (int)(92 + 7)))) != null) {
                // empty if block
            }
            if ((string2 = (String)object.get(Base64.subSequence((String)"09$", (int)(32 + 91)))) != null || (string2 = (String)object.get(Base64.subSequence((String)"`qucu|`dd\u007fy|jq|{}s8wrk((#1v{f", (int)(63 * 29)))) != null) {
                // empty if block
            }
            if (string2 != null) {
                if (string2.length() == 32) {
                    byArray = BufferUtils.decodeHexString((String)string2);
                } else {
                    WMSLoggerFactory.getLogger(LiveStreamPacketizerCupertino.class).warn(Base64.subSequence((String)"AgyuBfaqt{Gyzq~htdz2\u000273!72.&&d\"\"$:up\u001a7*t939?-2{53=023' 0kf\n=:>k.(n~fq0* 0%wpjh{?5?-abvfvv/'dfdl,V", (int)(49 * 61)) + file + Base64.subSequence((String)"\blw", (int)(55 * 51)) + string2.length());
                }
            }
        }
        object = null;
        if (string3 == null) return object;
        if (string2 == null) return object;
        return new CupertinoEncInfo(string2, byArray, string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int millisToSecondsDuration(long l) {
        int n = (int)Math.round((double)l / 1000.0);
        if (n > 0) return n;
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToResolutionStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        int n = mediaCodecInfoVideo.getDisplayWidth();
        int n2 = mediaCodecInfoVideo.getDisplayHeight();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return n + "x" + n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoAudioToCodecsStr(MediaCodecInfoAudio mediaCodecInfoAudio) {
        String string = null;
        if (mediaCodecInfoAudio == null) return string;
        switch (mediaCodecInfoAudio.getCodecId()) {
            case 2: {
                string = Base64.subSequence((String)"8&c9wnkr", (int)(55 + 30)) + mediaCodecInfoAudio.getAudioObjectType();
            }
            default: {
                return string;
            }
            case 10: 
        }
        if (mediaCodecInfoAudio.getAudioObjectType() <= 0) return string;
        return Base64.subSequence((String)"*8}+ex}`", (int)(93 + -22)) + mediaCodecInfoAudio.getAudioObjectType();
    }

    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo) {
        return LiveStreamPacketizerCupertinoUtils.codecInfoVideoToCodecsStr(mediaCodecInfoVideo, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String codecInfoVideoToCodecsStr(MediaCodecInfoVideo mediaCodecInfoVideo, boolean bl) {
        String string = null;
        if (mediaCodecInfoVideo == null) return string;
        switch (mediaCodecInfoVideo.getCodecId()) {
            case 7: {
                if (!bl) break;
                return FileChunk.concat((int)(78 + 124), (String)"+=/|`yf\u007fac");
            }
            default: {
                return string;
            }
        }
        int n = mediaCodecInfoVideo.getVideoLevel();
        int n2 = mediaCodecInfoVideo.getVideoProfile();
        if (n <= 0) return string;
        if (n2 <= 0) return string;
        return FileChunk.concat((int)(27 * 37), (String)"&>*{e") + n2 + "." + n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int chunkFilenameToStreamMode(String var0) {
        var1_1 = 1;
        var2_2 = var0.lastIndexOf(".");
        if (var2_2 >= 0) ** GOTO lbl-1000
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var3_3 = var0.substring(var2_2);
            if (StringUtils.isEmpty((String)var3_3)) {
                return var1_1;
            }
            if (var3_3.startsWith(FileChunk.concat((int)(113 + 109), (String)"p>!\""))) {
                var1_1 = 3;
            }
            if (var3_3.startsWith(Base64.subSequence((String)"+kw;", (int)(1133 / 201))) == false) return var1_1;
            return 2;
        }
    }
}

