/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.transcoder.model;

import com.wowza.io.FileChunk;
import com.wowza.util.Base64;
import com.wowza.util.FLVUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.medialist.MediaList;
import com.wowza.wms.medialist.MediaListSegment;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.MediaStreamMapGroup;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderStream;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroupMember;
import com.wowza.wms.transcoder.model.TranscoderStreamNameGroupRediness;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscoderStreamNameGroup {
    public static final int STATE_PREINIT = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_SHUTDOWN = 3;
    protected Object lock = new Object();
    protected String name = "";
    protected List<TranscoderStreamNameGroupMember> members = new ArrayList<TranscoderStreamNameGroupMember>();
    protected MediaList mediaList = new MediaList();
    protected MediaStreamMapGroup nameGroup = null;
    protected MediaListSegment mediaListSegment = new MediaListSegment();
    protected LiveStreamTranscoder liveStreamTranscoder = null;
    protected TranscoderStream transcodingStream = null;
    protected int lifecycle = 1;
    protected boolean isSent = false;

    public TranscoderStreamNameGroup() {
        this.mediaList.addSegment(this.mediaListSegment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(LiveStreamTranscoder liveStreamTranscoder) {
        int n;
        Object object = this.lock;
        synchronized (object) {
            if (this.isSent) return;
            if (this.lifecycle != 2) {
                return;
            }
            // MONITOREXIT @DISABLED, blocks:[1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            LiveStreamTranscoder liveStreamTranscoder2 = liveStreamTranscoder;
            this.validateMemberCodec(liveStreamTranscoder2, liveStreamTranscoder2.getTranscodingStream());
            n = 0;
        }
        synchronized (this.lock) {
            block13: {
                n = this.members.size();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                if (n > 0) break block13;
                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.concat((int)(-24 - 43), (String)"Il~.2!,  4\u0014<;/*!\u0003/\"5\u0016 <!%x6<=\u00135(8,1!-\u0019") + liveStreamTranscoder.getContextStr() + Base64.subSequence((String)"\u0011wn\u00011<7s3'9\"(y-:/}004a#'  \"kh >k%>n*=!&*nu", (int)(-9 - 43)) + this.getName());
                return;
            }
            this.addInternal(liveStreamTranscoder);
            boolean bl = false;
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.lifecycle == 2) {
                    this.isSent = true;
                } else {
                    bl = true;
                }
            }
            if (!bl) return;
            this.removeInternal(liveStreamTranscoder);
            return;
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addInternal(LiveStreamTranscoder liveStreamTranscoder) {
        IApplicationInstance iApplicationInstance = liveStreamTranscoder.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        MediaStreamMapGroup mediaStreamMapGroup = new MediaStreamMapGroup();
        mediaStreamMapGroup.setName(this.name);
        mediaStreamMapGroup.setMediaList(this.mediaList);
        ArrayList<TranscoderStreamNameGroupMember> arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            arrayList.addAll(this.members);
        }
        for (Object object : arrayList) {
            String string = ((TranscoderStreamNameGroupMember)object).getName();
            mediaStreamMapGroup.add(string);
        }
        mediaStreamMap.addNameGroup(mediaStreamMapGroup);
        synchronized (this.lock) {
            this.nameGroup = mediaStreamMapGroup;
            // ** MonitorExit[var7_8] (shouldn't be in output)
            liveStreamTranscoder.notifyRegisterStreamNameGroup(this);
            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).info(FileChunk.concat((int)(37 - 56), (String)"\u0019<.>\"1<00$\u0004,+?:1\u0013?2eFplqu(flmCexh|aq}I") + liveStreamTranscoder.getContextStr() + FileChunk.concat((int)(22 - -28), (String)"O)4Trs8w{vy=ym/42yd") + mediaStreamMapGroup.getName());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeInternal(LiveStreamTranscoder liveStreamTranscoder) {
        IApplicationInstance iApplicationInstance = liveStreamTranscoder.getAppInstance();
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        MediaStreamMapGroup mediaStreamMapGroup = null;
        Object object = this.lock;
        synchronized (object) {
            mediaStreamMapGroup = this.nameGroup;
            this.nameGroup = null;
        }
        if (mediaStreamMapGroup == null) return;
        mediaStreamMap.removeNameGroup(mediaStreamMapGroup);
        liveStreamTranscoder.notifyUnregisterStreamNameGroup(this);
        WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).info(FileChunk.concat((int)(-52 - 31), (String)"Y|n~bq|ppdDlk\u007fzqS\u007fr%\u00060,15h5-$%=)\u0004 ;5#<28\u000e") + liveStreamTranscoder.getContextStr() + FileChunk.concat((int)(19 * 41), (String)"V6-\\j}~dv4{wz}9}ishn% ") + mediaStreamMapGroup.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(LiveStreamTranscoder liveStreamTranscoder, TranscoderStream transcoderStream) {
        this.liveStreamTranscoder = liveStreamTranscoder;
        this.transcodingStream = transcoderStream;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(Base64.subSequence((String)"\\\u007fd`pqFbe}xwU}p{", (int)(57 * 39)), liveStreamTranscoder.getStreamName());
        this.name = SystemUtils.expandEnvironmentVariables((String)this.name, hashMap);
        this.validateMembers(liveStreamTranscoder, transcoderStream);
        Object object = this.lock;
        synchronized (object) {
            this.lifecycle = 2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown(LiveStreamTranscoder liveStreamTranscoder) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.lifecycle = 3;
            if (this.isSent) {
                this.isSent = false;
                bl = true;
            }
        }
        if (!bl) return;
        this.removeInternal(liveStreamTranscoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkRediness(TranscoderStreamNameGroupRediness transcoderStreamNameGroupRediness) {
        ArrayList<TranscoderStreamNameGroupMember> arrayList = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            if (!this.isSent) {
                arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
                arrayList.addAll(this.members);
            }
        }
        if (arrayList == null) {
            return;
        }
        if (arrayList.size() <= 0) {
            return;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TranscoderStreamNameGroupMember transcoderStreamNameGroupMember = (TranscoderStreamNameGroupMember)iterator.next();
            transcoderStreamNameGroupMember.checkRediness(transcoderStreamNameGroupRediness, this.liveStreamTranscoder, this.transcodingStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void validateMemberCodec(LiveStreamTranscoder var1_1, TranscoderStream var2_2) {
        block17: {
            block25: {
                block20: {
                    block22: {
                        block21: {
                            block18: {
                                block19: {
                                    block23: {
                                        block24: {
                                            break block24;
                                            while (true) {
                                                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.concat((int)(46 - 54), (String)"\f+;5/>1;esQwv`gjFhgnK\u007faz`?drx|rvl|W~q\u007f{msZ") + var1_1.getContextStr() + Base64.subSequence((String)"X<'[}xnm`@n}tUa{`fL", (int)(465 / 87)) + var5_5.getName() + FileChunk.concat((int)(41 - 45), (String)"\u0001}(6ddm#gjbbk)cx,ca{0gs\u007f}q6qwk:u}p{?gsmvt?&") + FLVUtils.videoCodecToString((int)var7_8) + FileChunk.concat((int)(75 + -11), (String)"`i") + var8_9 + ")");
                                                var6_7 = true;
                                                ** GOTO lbl30
                                                break;
                                            }
lbl5:
                                            // 1 sources

                                            while (true) {
                                                var8_9 = FileChunk.concat((int)(38 + 112), (String)"cyswulr");
                                                break block17;
                                                break;
                                            }
lbl8:
                                            // 1 sources

                                            while (true) {
                                                WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(Base64.subSequence((String)"Wvdhtkfnn~^z}up\u007f]uxsPjvok2k\u007fs)%#7!\b#**,88\u0017", (int)(15 * 45)) + var1_1.getContextStr() + Base64.subSequence((String)"X<'[}xnm`@n}tUa{`fL", (int)(5 * 33)) + var5_5.getName() + Base64.subSequence((String)"\rq3&0<9w;6>>?}7,`/-7d3'+!-j-#?n!1<7s3'9\"(cz", (int)(15 - 63)) + FLVUtils.audioCodecToString((int)var7_8) + Base64.subSequence((String)"#,", (int)(731 / 211)) + var8_9 + ")");
                                                var6_7 = true;
                                                break block18;
                                                break;
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                while (true) {
                                                    var3_3.addAll(this.members);
                                                    break block19;
                                                    break;
                                                }
                                            }
                                        }
                                        var3_3 = new ArrayList<TranscoderStreamNameGroupMember>();
                                        var4_4 = this.lock;
                                        synchronized (var4_4) {
                                            ** continue;
                                        }
lbl22:
                                        // 4 sources

                                        while (true) {
                                            if (!var5_5.isVideo) ** GOTO lbl30
                                            break block20;
lbl25:
                                            // 3 sources

                                            while (var4_4.hasNext()) {
                                                break block21;
                                            }
                                            break block22;
                                            break;
                                        }
lbl28:
                                        // 2 sources

                                        while (true) {
                                            if (var7_8 != 7) ** continue;
lbl30:
                                            // 3 sources

                                            if (!var6_7) ** GOTO lbl25
                                            break block23;
                                            break;
                                        }
lbl32:
                                        // 1 sources

                                        throw var5_6;
lbl34:
                                        // 1 sources

                                        while (true) {
                                            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.concat((int)(-33 - 29), (String)"\u00161%+5$'-/9\u001f9<*1<\u001c290\u0011%7,*u*<26$ 6&\t +%-;9\u0010") + var1_1.getContextStr() + Base64.subSequence((String)"Q7.\\dcwry[wz}^htimE", (int)(-48 - -60)) + var5_5.getName() + FileChunk.concat((int)(18 - -32), (String)"O3u`r~w9ytxx}?)2b-+1f1)%#/l+!=p?3>1u1%7,*a|") + FLVUtils.audioCodecToString((int)var7_8) + FileChunk.concat((int)(63 * 41), (String)"70") + var8_9 + ")");
                                            var6_7 = true;
                                            ** GOTO lbl22
                                            break;
                                        }
lbl38:
                                        // 1 sources

                                        while (true) {
                                            if (var7_8 != 2) {
                                                ** continue;
                                            }
                                            break block18;
                                            break;
                                        }
                                    }
                                    this.removeMember(var5_5);
                                    ** GOTO lbl25
lbl46:
                                    // 1 sources

                                    while (true) {
                                        if (FileChunk.concat((int)(28 - -24), (String)"ye\"v6-*5/)").equals(var8_9)) ** GOTO lbl22
                                        ** continue;
                                        break;
                                    }
                                }
                                var4_4 = var3_3.iterator();
                                ** GOTO lbl25
                            }
lbl53:
                            // 2 sources

                            while (true) {
                                if (var7_8 != 2) ** GOTO lbl22
                                ** continue;
                                break;
                            }
                            {
                                catch (Throwable var5_6) {
                                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl54 : MonitorExitStatement: MONITOREXIT : var4_4
                                    ** continue;
                                }
                            }
                        }
                        var5_5 = (TranscoderStreamNameGroupMember)var4_4.next();
                        var6_7 = false;
                        if (var5_5.isAudio) ** break;
                        ** while (true)
                        break block25;
                    }
                    return;
lbl67:
                    // 1 sources

                    while (true) {
                        var8_9 = FileChunk.concat((int)(45 * 9), (String)"`x|vvmu");
                        ** GOTO lbl28
                        break;
                    }
                }
                var7_8 = var5_5.geVideoCodec(var1_1, var2_2);
                var8_9 = var5_5.getMediaListRendition().getVideoCodecId();
                if (var8_9 == null) ** break;
                ** while (true)
                ** while (true)
            }
            var7_8 = var5_5.getAudioCodec(var1_1, var2_2);
            ** while ((var8_9 = var5_5.getMediaListRendition().getAudioCodecId()) == null)
        }
        ** while (var7_8 == 10)
lbl81:
        // 1 sources

        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validateMembers(LiveStreamTranscoder var1_1, TranscoderStream var2_2) {
        var3_3 = new ArrayList<TranscoderStreamNameGroupMember>();
        var4_4 = this.lock;
        synchronized (var4_4) {
            var3_3.addAll(this.members);
        }
        var4_4 = var3_3.iterator();
        ** GOTO lbl29
        while (true) {
            var9_10 = this.lock;
            synchronized (var9_10) {
                if (var7_8.isAudioDisable()) {
                    var5_5.isAudio = false;
                }
                if (var7_8.isVideoDisable()) {
                    var5_5.isVideo = false;
                }
                // MONITOREXIT @DISABLED, blocks:[1, 3, 6] lbl22 : MonitorExitStatement: MONITOREXIT : var9_10
                if (true) ** GOTO lbl29
            }
            break;
        }
        while (true) {
            if (var7_8 != null && var8_9 != null) ** continue;
            WMSLoggerFactory.getLogger(TranscoderStreamNameGroup.class).warn(FileChunk.concat((int)(-60 - 25), (String)"_~l`|s~vvfFbe}xwU}p{X2.73j3'+!-+?)\u0000+\"24  \u000f") + var1_1.getContextStr() + FileChunk.concat((int)(23 + 37), (String)"A'>L43'\")\u000b'*-\u000e8$9=n\"5<06&u28=*z53)~:8(17d,(g\r')$((=o<8!'nu") + var6_7);
            this.removeMember(var5_5);
lbl29:
            // 4 sources

            while (var4_4.hasNext() != false) {
                var5_5 = (TranscoderStreamNameGroupMember)var4_4.next();
                var6_7 = var5_5.getName();
                var7_8 = var2_2.getDestination(var6_7);
                var8_9 = var1_1.getTranscodingSession().getSessionDestination(var6_7);
                if (var7_8 == null || var7_8.isEnable()) ** continue;
                this.removeMember(var5_5);
            }
            return;
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object object) {
        this.lock = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMemberCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.members.size();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName(String string) {
        String string2 = this.getName();
        if (string2 != null) return string2.replace(FileChunk.concat((int)(497 / 120), (String)" ~Uh}{in_y|jq|\\rypk"), string);
        string2 = FileChunk.concat((int)(18 + 13), (String)";{RmvvfcT|{ojaCobulM") + this.name;
        return string2.replace(FileChunk.concat((int)(497 / 120), (String)" ~Uh}{in_y|jq|\\rypk"), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setName(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.name = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addMember(TranscoderStreamNameGroupMember transcoderStreamNameGroupMember) {
        Object object = this.lock;
        synchronized (object) {
            this.members.add(transcoderStreamNameGroupMember);
            transcoderStreamNameGroupMember.setLock(this.lock);
            this.mediaListSegment.addRendition(transcoderStreamNameGroupMember.getMediaListRendition());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranscoderStreamNameGroupMember removeMember(TranscoderStreamNameGroupMember transcoderStreamNameGroupMember) {
        TranscoderStreamNameGroupMember transcoderStreamNameGroupMember2 = null;
        Object object = this.lock;
        synchronized (object) {
            this.members.remove(transcoderStreamNameGroupMember);
            this.mediaListSegment.removeRendition(transcoderStreamNameGroupMember.getMediaListRendition());
            return transcoderStreamNameGroupMember2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TranscoderStreamNameGroupMember> getMembers() {
        ArrayList<TranscoderStreamNameGroupMember> arrayList = new ArrayList<TranscoderStreamNameGroupMember>();
        Object object = this.lock;
        synchronized (object) {
            arrayList.addAll(this.members);
            return arrayList;
        }
    }
}

