/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.util.Iterator;
import org.farng.mp3.AbstractMP3Tag;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.MP3File;
import org.farng.mp3.RandomAccessFile;
import org.farng.mp3.TagConstant;
import org.farng.mp3.TagException;
import org.farng.mp3.TagNotFoundException;
import org.farng.mp3.filename.FilenameTag;
import org.farng.mp3.id3.AbstractID3v2;
import org.farng.mp3.id3.AbstractID3v2Frame;
import org.farng.mp3.id3.AbstractID3v2FrameBody;
import org.farng.mp3.id3.FrameBodyCOMM;
import org.farng.mp3.id3.FrameBodyTALB;
import org.farng.mp3.id3.FrameBodyTCON;
import org.farng.mp3.id3.FrameBodyTDRC;
import org.farng.mp3.id3.FrameBodyTIT2;
import org.farng.mp3.id3.FrameBodyTPE1;
import org.farng.mp3.id3.FrameBodyTRCK;
import org.farng.mp3.id3.ID3v1;
import org.farng.mp3.id3.ID3v1_1;
import org.farng.mp3.id3.ID3v2_2;
import org.farng.mp3.id3.ID3v2_3;
import org.farng.mp3.id3.ID3v2_3Frame;
import org.farng.mp3.id3.ID3v2_4Frame;
import org.farng.mp3.lyrics3.AbstractLyrics3;
import org.farng.mp3.lyrics3.Lyrics3v2;
import org.farng.mp3.lyrics3.Lyrics3v2Field;

public class ID3v2_4
extends ID3v2_3 {
    protected boolean footer = false;
    protected boolean tagRestriction = false;
    protected boolean updateTag = false;
    protected byte imageEncodingRestriction = 0;
    protected byte imageSizeRestriction = 0;
    protected byte tagSizeRestriction = 0;
    protected byte textEncodingRestriction = 0;
    protected byte textFieldSizeRestriction = 0;

    public ID3v2_4() {
        this.setMajorVersion((byte)2);
        this.setRevision((byte)4);
    }

    public ID3v2_4(ID3v2_4 iD3v2_4) {
        super(iD3v2_4);
        this.footer = iD3v2_4.footer;
        this.tagRestriction = iD3v2_4.tagRestriction;
        this.updateTag = iD3v2_4.updateTag;
        this.imageEncodingRestriction = iD3v2_4.imageEncodingRestriction;
        this.imageSizeRestriction = iD3v2_4.imageSizeRestriction;
        this.tagSizeRestriction = iD3v2_4.tagSizeRestriction;
        this.textEncodingRestriction = iD3v2_4.textEncodingRestriction;
        this.textFieldSizeRestriction = iD3v2_4.textFieldSizeRestriction;
    }

    public ID3v2_4(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag != null) {
            if (abstractMP3Tag instanceof AbstractID3v2) {
                this.copyFromID3v2Tag((AbstractID3v2)abstractMP3Tag);
            } else if (abstractMP3Tag instanceof ID3v1) {
                Object object;
                ID3v2_4Frame iD3v2_4Frame;
                AbstractID3v2FrameBody abstractID3v2FrameBody;
                ID3v1 iD3v1 = (ID3v1)abstractMP3Tag;
                if (iD3v1.title.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTIT2(0, iD3v1.title);
                    iD3v2_4Frame = new ID3v2_4Frame(false, false, false, false, false, false, abstractID3v2FrameBody);
                    this.setFrame(iD3v2_4Frame);
                }
                if (iD3v1.artist.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTPE1(0, iD3v1.artist);
                    iD3v2_4Frame = new ID3v2_4Frame(false, false, false, false, false, false, abstractID3v2FrameBody);
                    this.setFrame(iD3v2_4Frame);
                }
                if (iD3v1.album.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTALB(0, iD3v1.album);
                    iD3v2_4Frame = new ID3v2_4Frame(false, false, false, false, false, false, abstractID3v2FrameBody);
                    this.setFrame(iD3v2_4Frame);
                }
                if (iD3v1.year.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyTDRC(0, iD3v1.year);
                    iD3v2_4Frame = new ID3v2_4Frame(false, false, false, false, false, false, abstractID3v2FrameBody);
                    this.setFrame(iD3v2_4Frame);
                }
                if (iD3v1.comment.length() > 0) {
                    abstractID3v2FrameBody = new FrameBodyCOMM(0, "ENG", "", iD3v1.comment);
                    iD3v2_4Frame = new ID3v2_4Frame(false, false, false, false, false, false, abstractID3v2FrameBody);
                    this.setFrame(iD3v2_4Frame);
                }
                if (iD3v1.genre >= 0) {
                    object = "(" + Byte.toString(iD3v1.genre) + ") " + TagConstant.genreIdToString.get(new Long(iD3v1.genre));
                    abstractID3v2FrameBody = new FrameBodyTCON(0, (String)object);
                    iD3v2_4Frame = new ID3v2_4Frame(false, false, false, false, false, false, abstractID3v2FrameBody);
                    this.setFrame(iD3v2_4Frame);
                }
                if (abstractMP3Tag instanceof ID3v1_1) {
                    object = (ID3v1_1)abstractMP3Tag;
                    if (((ID3v1_1)object).track > 0) {
                        abstractID3v2FrameBody = new FrameBodyTRCK(0, Byte.toString(((ID3v1_1)object).track));
                        iD3v2_4Frame = new ID3v2_4Frame(false, false, false, false, false, false, abstractID3v2FrameBody);
                        this.setFrame(iD3v2_4Frame);
                    }
                }
            } else if (abstractMP3Tag instanceof AbstractLyrics3) {
                Lyrics3v2 lyrics3v2 = abstractMP3Tag instanceof Lyrics3v2 ? new Lyrics3v2((Lyrics3v2)abstractMP3Tag) : new Lyrics3v2(abstractMP3Tag);
                Iterator iterator = lyrics3v2.iterator();
                while (iterator.hasNext()) {
                    try {
                        Lyrics3v2Field lyrics3v2Field = (Lyrics3v2Field)iterator.next();
                        ID3v2_4Frame iD3v2_4Frame = new ID3v2_4Frame(lyrics3v2Field);
                        this.setFrame(iD3v2_4Frame);
                    }
                    catch (InvalidTagException invalidTagException) {}
                }
            } else if (abstractMP3Tag instanceof FilenameTag) {
                this.copyFromID3v2Tag(((FilenameTag)abstractMP3Tag).getId3tag());
            }
        }
    }

    public ID3v2_4(RandomAccessFile randomAccessFile) throws TagException, IOException {
        this.read(randomAccessFile);
    }

    public String getIdentifier() {
        return "ID3v2.40";
    }

    public int getSize() {
        int n = 10;
        if (this.extended) {
            n += 6;
            if (this.updateTag) {
                ++n;
            }
            if (this.crcDataFlag) {
                n += 5;
            }
            if (this.tagRestriction) {
                n += 2;
            }
        }
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
            n += abstractID3v2Frame.getSize();
        }
        return n;
    }

    public void append(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag instanceof ID3v2_4) {
            this.updateTag = ((ID3v2_4)abstractMP3Tag).updateTag;
            this.footer = ((ID3v2_4)abstractMP3Tag).footer;
            this.tagRestriction = ((ID3v2_4)abstractMP3Tag).tagRestriction;
            this.tagSizeRestriction = ((ID3v2_4)abstractMP3Tag).tagSizeRestriction;
            this.textEncodingRestriction = ((ID3v2_4)abstractMP3Tag).textEncodingRestriction;
            this.textFieldSizeRestriction = ((ID3v2_4)abstractMP3Tag).textFieldSizeRestriction;
            this.imageEncodingRestriction = ((ID3v2_4)abstractMP3Tag).imageEncodingRestriction;
            this.imageSizeRestriction = ((ID3v2_4)abstractMP3Tag).imageSizeRestriction;
        }
        super.append(abstractMP3Tag);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ID3v2_4)) {
            return false;
        }
        ID3v2_4 iD3v2_4 = (ID3v2_4)object;
        if (this.footer != iD3v2_4.footer) {
            return false;
        }
        if (this.imageEncodingRestriction != iD3v2_4.imageEncodingRestriction) {
            return false;
        }
        if (this.imageSizeRestriction != iD3v2_4.imageSizeRestriction) {
            return false;
        }
        if (this.tagRestriction != iD3v2_4.tagRestriction) {
            return false;
        }
        if (this.tagSizeRestriction != iD3v2_4.tagSizeRestriction) {
            return false;
        }
        if (this.textEncodingRestriction != iD3v2_4.textEncodingRestriction) {
            return false;
        }
        if (this.textFieldSizeRestriction != iD3v2_4.textFieldSizeRestriction) {
            return false;
        }
        if (this.updateTag != iD3v2_4.updateTag) {
            return false;
        }
        return super.equals(object);
    }

    public void overwrite(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag instanceof ID3v2_4) {
            this.updateTag = ((ID3v2_4)abstractMP3Tag).updateTag;
            this.footer = ((ID3v2_4)abstractMP3Tag).footer;
            this.tagRestriction = ((ID3v2_4)abstractMP3Tag).tagRestriction;
            this.tagSizeRestriction = ((ID3v2_4)abstractMP3Tag).tagSizeRestriction;
            this.textEncodingRestriction = ((ID3v2_4)abstractMP3Tag).textEncodingRestriction;
            this.textFieldSizeRestriction = ((ID3v2_4)abstractMP3Tag).textFieldSizeRestriction;
            this.imageEncodingRestriction = ((ID3v2_4)abstractMP3Tag).imageEncodingRestriction;
            this.imageSizeRestriction = ((ID3v2_4)abstractMP3Tag).imageSizeRestriction;
        }
        super.overwrite(abstractMP3Tag);
    }

    public void read(RandomAccessFile randomAccessFile) throws TagException, IOException {
        byte[] byArray = new byte[4];
        randomAccessFile.seek(0L);
        if (!this.seek(randomAccessFile)) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        randomAccessFile.read(byArray, 0, 3);
        if (byArray[0] != 4 || byArray[1] != 0) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        this.setMajorVersion(byArray[0]);
        this.setRevision(byArray[1]);
        this.unsynchronization = (byArray[2] & 0x80) != 0;
        this.extended = (byArray[2] & 0x40) != 0;
        this.experimental = (byArray[2] & 0x20) != 0;
        this.footer = (byArray[2] & 0x10) != 0;
        randomAccessFile.read(byArray, 0, 4);
        int n = ID3v2_4.byteArrayToSize(byArray);
        long l = randomAccessFile.getFilePointer();
        if (this.extended) {
            int n2;
            int n3 = randomAccessFile.readInt();
            if (n3 <= 6) {
                throw new InvalidTagException("Invalid Extended Header Size.");
            }
            byte by = randomAccessFile.readByte();
            randomAccessFile.read(byArray, 0, by);
            this.updateTag = (byArray[0] & 0x40) != 0;
            this.crcDataFlag = (byArray[0] & 0x20) != 0;
            boolean bl = this.tagRestriction = (byArray[0] & 0x10) != 0;
            if (this.updateTag) {
                n2 = randomAccessFile.readByte();
                byArray = new byte[n2];
                randomAccessFile.read(byArray, 0, n2);
            }
            if (this.crcDataFlag) {
                n2 = randomAccessFile.readByte();
                byArray = new byte[n2];
                randomAccessFile.read(byArray, 0, n2);
                this.crcData = 0;
                for (int i = 0; i < n2; ++i) {
                    this.crcData <<= 8;
                    this.crcData += byArray[i];
                }
            }
            if (this.tagRestriction) {
                n2 = randomAccessFile.readByte();
                byArray = new byte[n2];
                randomAccessFile.read(byArray, 0, n2);
                this.tagSizeRestriction = (byte)((byArray[0] & 0xFFFFFFC0) >> 6);
                this.textEncodingRestriction = (byte)((byArray[0] & 0x20) >> 5);
                this.textFieldSizeRestriction = (byte)((byArray[0] & 0x18) >> 3);
                this.imageEncodingRestriction = (byte)((byArray[0] & 4) >> 2);
                this.imageSizeRestriction = (byte)(byArray[0] & 6);
            }
        }
        this.clearFrameMap();
        this.setFileReadBytes(n);
        ID3v2_4.resetPaddingCounter();
        while (randomAccessFile.getFilePointer() - l <= (long)n) {
            try {
                ID3v2_4Frame iD3v2_4Frame = new ID3v2_4Frame(randomAccessFile);
                String string = iD3v2_4Frame.getIdentifier();
                if (this.hasFrame(string)) {
                    this.appendDuplicateFrameId(string + "; ");
                    this.incrementDuplicateBytes(this.getFrame(string).getSize());
                }
                this.setFrame(iD3v2_4Frame);
            }
            catch (InvalidTagException invalidTagException) {
                if (invalidTagException.getMessage().equals("Found empty frame")) {
                    this.incrementEmptyFrameBytes(10);
                    continue;
                }
                this.incrementInvalidFrameBytes();
            }
        }
        this.setPaddingSize(ID3v2_4.getPaddingCounter());
    }

    public boolean seek(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[3];
        randomAccessFile.seek(0L);
        randomAccessFile.read(byArray, 0, 3);
        String string = new String(byArray, 0, 3);
        if (!string.equals("ID3")) {
            return false;
        }
        randomAccessFile.read(byArray, 0, 2);
        randomAccessFile.seek(randomAccessFile.getFilePointer() - 2L);
        return byArray[0] == 4 && byArray[1] == 0;
    }

    public String toString() {
        Iterator iterator = this.getFrameIterator();
        String string = this.getIdentifier() + " " + this.getSize() + "\n";
        string = string + "compression              = " + this.compression + "\n";
        string = string + "unsynchronization        = " + this.unsynchronization + "\n";
        string = string + "crcData                  = " + this.crcData + "\n";
        string = string + "crcDataFlag              = " + this.crcDataFlag + "\n";
        string = string + "experimental             = " + this.experimental + "\n";
        string = string + "extended                 = " + this.extended + "\n";
        string = string + "paddingSize              = " + this.paddingSize + "\n";
        string = string + "footer                   = " + this.footer + "\n";
        string = string + "imageEncodingRestriction = " + this.imageEncodingRestriction + "\n";
        string = string + "imageSizeRestriction     = " + this.imageSizeRestriction + "\n";
        string = string + "tagRestriction           = " + this.tagRestriction + "\n";
        string = string + "tagSizeRestriction       = " + this.tagSizeRestriction + "\n";
        string = string + "textEncodingRestriction  = " + this.textEncodingRestriction + "\n";
        string = string + "textFieldSizeRestriction = " + this.textFieldSizeRestriction + "\n";
        string = string + "updateTag                = " + this.updateTag + "\n";
        while (iterator.hasNext()) {
            ID3v2_4Frame iD3v2_4Frame = (ID3v2_4Frame)iterator.next();
            string = string + iD3v2_4Frame.toString() + "\n";
        }
        return string + "\n";
    }

    public void write(AbstractMP3Tag abstractMP3Tag) {
        if (abstractMP3Tag instanceof ID3v2_4) {
            this.updateTag = ((ID3v2_4)abstractMP3Tag).updateTag;
            this.footer = ((ID3v2_4)abstractMP3Tag).footer;
            this.tagRestriction = ((ID3v2_4)abstractMP3Tag).tagRestriction;
            this.tagSizeRestriction = ((ID3v2_4)abstractMP3Tag).tagSizeRestriction;
            this.textEncodingRestriction = ((ID3v2_4)abstractMP3Tag).textEncodingRestriction;
            this.textFieldSizeRestriction = ((ID3v2_4)abstractMP3Tag).textFieldSizeRestriction;
            this.imageEncodingRestriction = ((ID3v2_4)abstractMP3Tag).imageEncodingRestriction;
            this.imageSizeRestriction = ((ID3v2_4)abstractMP3Tag).imageSizeRestriction;
        }
        super.write(abstractMP3Tag);
    }

    public void write(RandomAccessFile randomAccessFile) throws IOException {
        byte[] byArray = new byte[6];
        MP3File mP3File = new MP3File();
        mP3File.seekMP3Frame(randomAccessFile);
        long l = randomAccessFile.getFilePointer();
        randomAccessFile.seek(0L);
        String string = "ID3";
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        byArray[3] = 4;
        byArray[4] = 0;
        if (this.unsynchronization) {
            byArray[5] = (byte)(byArray[5] | 0x80);
        }
        if (this.extended) {
            byArray[5] = (byte)(byArray[5] | 0x40);
        }
        if (this.experimental) {
            byArray[5] = (byte)(byArray[5] | 0x20);
        }
        if (this.footer) {
            byArray[5] = (byte)(byArray[5] | 0x10);
        }
        randomAccessFile.write(byArray);
        randomAccessFile.write(ID3v2_4.sizeToByteArray((int)l - 10));
        if (this.extended) {
            int n = 6;
            if (this.updateTag) {
                ++n;
            }
            if (this.crcDataFlag) {
                n += 5;
            }
            if (this.tagRestriction) {
                n += 2;
            }
            randomAccessFile.writeInt(n);
            randomAccessFile.writeByte(1);
            byArray[0] = 0;
            if (this.updateTag) {
                byArray[0] = (byte)(byArray[0] | 0x40);
            }
            if (this.crcDataFlag) {
                byArray[0] = (byte)(byArray[0] | 0x20);
            }
            if (this.tagRestriction) {
                byArray[0] = (byte)(byArray[0] | 0x10);
            }
            randomAccessFile.writeByte(byArray[0]);
            if (this.updateTag) {
                randomAccessFile.writeByte(0);
            }
            if (this.crcDataFlag) {
                randomAccessFile.writeByte(4);
                randomAccessFile.writeInt(this.crcData);
            }
            if (this.tagRestriction) {
                randomAccessFile.writeByte(1);
                byArray[0] = 0;
                if (this.tagRestriction) {
                    byArray[0] = (byte)(byArray[0] | 0xFFFFFFC0);
                }
                randomAccessFile.writeByte(this.tagSizeRestriction);
                randomAccessFile.writeByte(this.textEncodingRestriction);
                randomAccessFile.writeByte(this.textFieldSizeRestriction);
                randomAccessFile.writeByte(this.imageEncodingRestriction);
                randomAccessFile.writeByte(this.imageSizeRestriction);
                randomAccessFile.writeByte(byArray[0]);
            }
        }
        Iterator iterator = this.getFrameIterator();
        while (iterator.hasNext()) {
            ID3v2_4Frame iD3v2_4Frame = (ID3v2_4Frame)iterator.next();
            iD3v2_4Frame.write(randomAccessFile);
        }
    }

    private void copyFromID3v2Tag(AbstractID3v2 abstractID3v2) {
        AbstractID3v2 abstractID3v22;
        if (abstractID3v2 instanceof ID3v2_4) {
            abstractID3v22 = (ID3v2_4)abstractID3v2;
            this.footer = ((ID3v2_4)abstractID3v22).footer;
            this.tagRestriction = ((ID3v2_4)abstractID3v22).tagRestriction;
            this.updateTag = ((ID3v2_4)abstractID3v22).updateTag;
            this.imageEncodingRestriction = ((ID3v2_4)abstractID3v22).imageEncodingRestriction;
            this.imageSizeRestriction = ((ID3v2_4)abstractID3v22).imageSizeRestriction;
            this.tagSizeRestriction = ((ID3v2_4)abstractID3v22).tagSizeRestriction;
            this.textEncodingRestriction = ((ID3v2_4)abstractID3v22).textEncodingRestriction;
            this.textFieldSizeRestriction = ((ID3v2_4)abstractID3v22).textFieldSizeRestriction;
        }
        if (abstractID3v2 instanceof ID3v2_3) {
            abstractID3v22 = (ID3v2_3)abstractID3v2;
            this.extended = ((ID3v2_3)abstractID3v22).extended;
            this.experimental = ((ID3v2_3)abstractID3v22).experimental;
            this.crcDataFlag = ((ID3v2_3)abstractID3v22).crcDataFlag;
            this.crcData = ((ID3v2_3)abstractID3v22).crcData;
            this.paddingSize = ((ID3v2_3)abstractID3v22).paddingSize;
        }
        if (abstractID3v2 instanceof ID3v2_2) {
            abstractID3v22 = (ID3v2_2)abstractID3v2;
            this.compression = ((ID3v2_2)abstractID3v22).compression;
            this.unsynchronization = ((ID3v2_2)abstractID3v22).unsynchronization;
        }
        abstractID3v22 = abstractID3v2;
        Iterator iterator = abstractID3v22.getFrameIterator();
        while (iterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
            ID3v2_4Frame iD3v2_4Frame = new ID3v2_4Frame(abstractID3v2Frame);
            this.setFrame(iD3v2_4Frame);
        }
    }

    public String getYearReleased() {
        String string = "";
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TDRC");
        if (abstractID3v2Frame != null) {
            FrameBodyTDRC frameBodyTDRC = (FrameBodyTDRC)abstractID3v2Frame.getBody();
            string = frameBodyTDRC.getText();
        }
        return string.trim();
    }

    public void setYearReleased(String string) {
        AbstractID3v2Frame abstractID3v2Frame = this.getFrame("TDRC");
        if (abstractID3v2Frame == null) {
            abstractID3v2Frame = new ID3v2_3Frame(new FrameBodyTDRC(0, string));
            this.setFrame(abstractID3v2Frame);
        } else {
            ((FrameBodyTDRC)abstractID3v2Frame.getBody()).setText(string);
        }
    }
}

