/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.advantechvega.transcoder;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.plugin.advantechvega.device.APIWrapperAdvantechVegaDevicesInfo;
import com.wowza.wms.plugin.advantechvega.device.APIWrapperAdvantechVegaEncodeConfig;
import com.wowza.wms.plugin.advantechvega.device.APIWrapperAdvantechVegaNative;
import com.wowza.wms.server.IServer;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderContextServer;
import com.wowza.wms.transcoder.model.TranscoderSession;
import com.wowza.wms.transcoder.model.TranscoderSessionVideo;
import com.wowza.wms.transcoder.model.TranscoderStream;
import com.wowza.wms.transcoder.model.TranscoderStreamDestination;
import com.wowza.wms.transcoder.model.TranscoderStreamDestinationVideo;
import com.wowza.wms.transcoder.model.TranscoderStreamScaler;
import com.wowza.wms.transcoder.model.TranscoderStreamSource;
import com.wowza.wms.transcoder.model.TranscoderVideoFrameSizeHolder;
import com.wowza.wms.transcoder.model.TranscoderVideoLoadBalancerBase;
import com.wowza.wms.transcoder.model.TranscoderWorkerVideoDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranscoderVideoLoadBalancerAdvantechVega
extends TranscoderVideoLoadBalancerBase {
    private static final Class<TranscoderVideoLoadBalancerAdvantechVega> CLASS = TranscoderVideoLoadBalancerAdvantechVega.class;
    private static final String CLASSNAME = "TranscoderVideoLoadBalancerAdvantechVega";
    protected APIWrapperAdvantechVegaNative advantechVegaNative = null;
    protected long advantechVegaNativeSessionId = 0L;
    protected APIWrapperAdvantechVegaDevicesInfo devicesInfo = new APIWrapperAdvantechVegaDevicesInfo();
    public static final String DEVICE_MODE_PROPERTY = "advantechVegaDeviceModes";
    public static final String DEFAULT_FRAMERATE_PROPERTY = "advantechVegaDefaultFrameRate";
    public static final String ALLOC_MODE_1CH_4K2K = "1CH-4K2K";
    public static final String ALLOC_MODE_4CH_1080P = "4CH-1080P";
    public static final String ALLOC_MODE_8CH_720P = "8CH-720P";
    public static final String ALLOC_MODE_8CH_MIXING = "8CH-MIXING";
    public static final String ALLOC_MODE_16CH_SD = "16CH-SD";
    public static final String ALLOC_MODE_16CH_SEQUENCE = "16CH-SEQUENCE";
    public static final String ALLOC_MODE_16CH_720P_MIXING = "16CH-720P-MIXING";
    protected Object lock = new Object();
    private TranscoderContextServer transcoderContextServer = null;
    protected List<DeviceChannel> availableEncodes = new ArrayList<DeviceChannel>();
    protected Map<TranscoderStreamDestinationVideo, DeviceChannel> runningEncodes = new HashMap<TranscoderStreamDestinationVideo, DeviceChannel>();
    protected int defaultFrameRate = 30;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(IServer server, TranscoderContextServer transcoderContextServer) {
        this.transcoderContextServer = transcoderContextServer;
        this.devicesInfo = new APIWrapperAdvantechVegaDevicesInfo();
        this.advantechVegaNative = new APIWrapperAdvantechVegaNative();
        if (APIWrapperAdvantechVegaNative.isLibLoaded()) {
            this.advantechVegaNativeSessionId = this.advantechVegaNative.createSession();
        }
        if (this.advantechVegaNativeSessionId > 0L) {
            this.advantechVegaNative.deviceGetDevicesInfo(this.advantechVegaNativeSessionId, this.devicesInfo);
            WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: " + this.devicesInfo.toString());
        }
        WMSProperties props = server.getProperties();
        this.defaultFrameRate = props.getPropertyInt(DEFAULT_FRAMERATE_PROPERTY, this.defaultFrameRate);
        String deviceModesStr = props.getPropertyStr(DEVICE_MODE_PROPERTY, null);
        if (deviceModesStr == null) {
            deviceModesStr = ALLOC_MODE_4CH_1080P;
            WMSLoggerFactory.getLogger(CLASS).warn("TranscoderVideoLoadBalancerAdvantechVega.init: Server property advantechVegaDeviceModes missing, defaulting all devices to: " + deviceModesStr);
        }
        String[] deviceModes = deviceModesStr.split("[|]");
        int devNum = 0;
        while ((long)devNum < this.devicesInfo.u32NumOfDevices) {
            String deviceMode = devNum < deviceModes.length ? deviceModes[devNum].trim() : deviceModes[deviceModes.length - 1].trim();
            long eMode = -1L;
            if (deviceMode.equals(ALLOC_MODE_1CH_4K2K)) {
                eMode = 0L;
            } else if (deviceMode.equals(ALLOC_MODE_4CH_1080P)) {
                eMode = 1L;
            } else if (deviceMode.equals(ALLOC_MODE_8CH_720P)) {
                eMode = 2L;
            } else if (deviceMode.equals(ALLOC_MODE_8CH_MIXING)) {
                eMode = 3L;
            } else if (deviceMode.equals(ALLOC_MODE_16CH_SD)) {
                eMode = 4L;
            } else if (deviceMode.equals(ALLOC_MODE_16CH_SEQUENCE)) {
                eMode = 5L;
            } else if (deviceMode.equals(ALLOC_MODE_16CH_720P_MIXING)) {
                eMode = 6L;
            } else {
                WMSLoggerFactory.getLogger(CLASS).warn("TranscoderVideoLoadBalancerAdvantechVega.init: Invalid mode name: " + deviceMode);
            }
            try {
                if (this.advantechVegaNativeSessionId > 0L) {
                    long result = this.advantechVegaNative.deviceReset(this.advantechVegaNativeSessionId, devNum);
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: deviceReset: devNum:" + devNum + " result:" + result);
                    result = this.advantechVegaNative.deviceConfigDeviceMode(this.advantechVegaNativeSessionId, devNum, new APIWrapperAdvantechVegaEncodeConfig(eMode));
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: deviceConfigDeviceMode: devNum:" + devNum + " eMode:" + eMode + " result:" + result);
                }
            }
            catch (Exception e) {
                WMSLoggerFactory.getLogger(CLASS).error("TranscoderVideoLoadBalancerAdvantechVega.init[config]: " + devNum, (Throwable)e);
            }
            ++devNum;
        }
        Object object = this.lock;
        synchronized (object) {
            int devNum2 = 0;
            while ((long)devNum2 < this.devicesInfo.u32NumOfDevices) {
                int i;
                String deviceMode = devNum2 < deviceModes.length ? deviceModes[devNum2].trim() : deviceModes[deviceModes.length - 1].trim();
                int channel = 0;
                if (deviceMode.equals(ALLOC_MODE_1CH_4K2K)) {
                    this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 4096, 2160, 60));
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: Device[" + devNum2 + "]: " + deviceMode + ": Maximum resolution is 4096x2160, 60fps; only 1 channel is allowed");
                } else if (deviceMode.equals(ALLOC_MODE_4CH_1080P)) {
                    i = 0;
                    while (i < 4) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 1920, 1080, 60));
                        ++i;
                    }
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: Device[" + devNum2 + "]: " + deviceMode + ": Maximum resolution is 1920x1080, 60fps; maximum channels allowed is 4");
                } else if (deviceMode.equals(ALLOC_MODE_8CH_720P)) {
                    i = 0;
                    while (i < 8) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 1280, 720, 60));
                        ++i;
                    }
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: Device[" + devNum2 + "]: " + deviceMode + ": Maximum resolution is 1280x720, 60fps; maximum channels allowed is 8");
                } else if (deviceMode.equals(ALLOC_MODE_8CH_MIXING)) {
                    i = 0;
                    while (i < 8) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 1280, 720, 30));
                        ++i;
                    }
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: Device[" + devNum2 + "]: " + deviceMode + ": Maximum resolution is 1920x1080 30fps");
                } else if (deviceMode.equals(ALLOC_MODE_16CH_SD)) {
                    i = 0;
                    while (i < 16) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 720, 480, 30));
                        ++i;
                    }
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: Device[" + devNum2 + "]: " + deviceMode + ": Maximum resolution is SD and the maximum number of channels is 16");
                } else if (deviceMode.equals(ALLOC_MODE_16CH_SEQUENCE)) {
                    i = 0;
                    while (i < 4) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 1920, 1080, 30));
                        ++i;
                    }
                    i = 0;
                    while (i < 4) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 1280, 720, 30));
                        ++i;
                    }
                    i = 0;
                    while (i < 8) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 720, 480, 30));
                        ++i;
                    }
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: Device[" + devNum2 + "]: " + deviceMode + ": Maximum resolutions are ordered in a sequence from large to small (CH0-CH3:1080P, CH4-CH7:720P, CH8-CH15:SD); maximum channels allowed is 16");
                } else if (deviceMode.equals(ALLOC_MODE_16CH_720P_MIXING)) {
                    i = 0;
                    while (i < 16) {
                        this.availableEncodes.add(new DeviceChannel(devNum2, channel++, 1280, 720, 30));
                        ++i;
                    }
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.init: Device[" + devNum2 + "]: " + deviceMode + ": Maximum resolution is 1280x720, 30fps; maximum channels allowed is 16");
                }
                ++devNum2;
            }
        }
    }

    public void shutdown() {
        if (this.advantechVegaNativeSessionId > 0L) {
            this.advantechVegaNative.destroySession(this.advantechVegaNativeSessionId);
            this.advantechVegaNativeSessionId = 0L;
        }
    }

    public void onTranscoderSessionCreate(LiveStreamTranscoder liveStreamTranscoder) {
    }

    public void onTranscoderSessionInit(LiveStreamTranscoder liveStreamTranscoder) {
    }

    public void onHardwareInspection(TranscoderContextServer transcoderContextServer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTranscoderSessionDestroy(LiveStreamTranscoder liveStreamTranscoder) {
        block7: {
            try {
                List destinations;
                TranscoderSessionVideo transcoderSessionVideo;
                TranscoderSession transcoderSession;
                TranscoderStream transcoderStream = liveStreamTranscoder.getTranscodingStream();
                if (transcoderStream == null || (transcoderSession = liveStreamTranscoder.getTranscodingSession()) == null || (transcoderSessionVideo = transcoderSession.getSessionVideo()) == null || (destinations = transcoderStream.getDestinations()) == null) break block7;
                for (TranscoderStreamDestination destination : destinations) {
                    TranscoderStreamDestinationVideo destinationVideo;
                    if (!destination.isEnable() || (destinationVideo = destination.getVideo()) == null || destinationVideo.isPassThrough() || destinationVideo.isDisable()) continue;
                    DeviceChannel deviceChannel = null;
                    Object object = this.lock;
                    synchronized (object) {
                        deviceChannel = this.runningEncodes.remove(destinationVideo);
                        if (deviceChannel != null) {
                            this.availableEncodes.add(deviceChannel);
                        }
                    }
                    if (deviceChannel == null) continue;
                    WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.onTranscoderSessionLoadBalance[" + transcoderSession.getContextStr() + ":" + destination.getName() + "]: Release channel: " + deviceChannel.toString());
                }
            }
            catch (Exception e) {
                WMSLoggerFactory.getLogger(CLASS).error("TranscoderVideoLoadBalancerAdvantechVega.onTranscoderSessionDestroy: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTranscoderSessionLoadBalance(LiveStreamTranscoder liveStreamTranscoder) {
        block11: {
            WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.onTranscoderSessionLoadBalance: " + liveStreamTranscoder.toString());
            try {
                TranscoderSessionVideo transcoderSessionVideo;
                TranscoderSession transcoderSession;
                TranscoderStream transcoderStream = liveStreamTranscoder.getTranscodingStream();
                if (transcoderStream == null || (transcoderSession = liveStreamTranscoder.getTranscodingSession()) == null || (transcoderSessionVideo = transcoderSession.getSessionVideo()) == null) break block11;
                MediaCodecInfoVideo codecInfoVideo = null;
                if (transcoderSessionVideo.getCodecInfo() != null) {
                    codecInfoVideo = transcoderSession.getSessionVideo().getCodecInfo();
                }
                long loadDecode = 0L;
                long loadScale = 0L;
                long loadEncode = 0L;
                boolean isScalerCUDA = false;
                Object transcoderStreamSourceVideo = null;
                TranscoderStreamScaler transcoderStreamScaler = null;
                TranscoderStreamSource transcoderStreamSource = transcoderStream.getSource();
                transcoderStreamScaler = transcoderStream.getScaler();
                List destinations = transcoderStream.getDestinations();
                if (destinations == null) break block11;
                for (TranscoderStreamDestination destination : destinations) {
                    int implementation;
                    TranscoderVideoFrameSizeHolder frameSizeHolder;
                    TranscoderStreamDestinationVideo destinationVideo;
                    if (!destination.isEnable() || (destinationVideo = destination.getVideo()) == null || destinationVideo.isPassThrough() || destinationVideo.isDisable() || (frameSizeHolder = destinationVideo.getFrameSizeHolder()) == null || (implementation = destinationVideo.getImplementation()) != 14 && implementation != 15) continue;
                    long width = frameSizeHolder.getActualWidth();
                    long height = frameSizeHolder.getActualHeight();
                    long frameRate = this.defaultFrameRate;
                    TranscoderWorkerVideoDecoder workerVideoDecoder = transcoderSession.getVideoDecoderWorker();
                    if (workerVideoDecoder != null) {
                        frameRate = (long)(workerVideoDecoder.getDecoderFrameRate() + 0.5);
                    }
                    String sourceInfo = String.format("{frameSize:%dx%d, frameRate:%d}", width, height, frameRate);
                    DeviceChannel deviceChannelMatch = null;
                    Object object = this.lock;
                    synchronized (object) {
                        for (DeviceChannel deviceChannel : this.availableEncodes) {
                            if (!deviceChannel.isMatch(width, height, frameRate) || deviceChannelMatch != null && !deviceChannel.isLessThan(deviceChannelMatch)) continue;
                            deviceChannelMatch = deviceChannel;
                        }
                        if (deviceChannelMatch != null) {
                            this.availableEncodes.remove(deviceChannelMatch);
                            this.runningEncodes.put(destinationVideo, deviceChannelMatch);
                        }
                    }
                    if (deviceChannelMatch != null) {
                        int gpuid = (deviceChannelMatch.devNum & 0xFF) << 8 | (deviceChannelMatch.channel & 0xFF) << 0;
                        destinationVideo.setGPUID(gpuid);
                        WMSLoggerFactory.getLogger(CLASS).info("TranscoderVideoLoadBalancerAdvantechVega.onTranscoderSessionLoadBalance: Acquire channel[" + transcoderSession.getContextStr() + ":" + destination.getName() + "]:" + " src:" + sourceInfo + " dest:" + deviceChannelMatch.toString());
                        continue;
                    }
                    WMSLoggerFactory.getLogger(CLASS).warn("TranscoderVideoLoadBalancerAdvantechVega.onTranscoderSessionLoadBalance: Disable transcode[" + transcoderSession.getContextStr() + ":" + destination.getName() + "]: Could not find suitable channel: src:" + sourceInfo);
                    destination.setEnable(false);
                }
            }
            catch (Exception e) {
                WMSLoggerFactory.getLogger(CLASS).error("TranscoderVideoLoadBalancerAdvantechVega.onTranscoderSessionLoadBalance: ", (Throwable)e);
            }
        }
    }

    public class DeviceChannel {
        public int devNum = 0;
        public int channel = 0;
        public long frameWidth = 0L;
        public long frameHeight = 0L;
        public long frameRate = 0L;

        public DeviceChannel(int devNum, int channel, int frameWidth, int frameHeight, int frameRate) {
            this.devNum = devNum;
            this.channel = channel;
            this.frameWidth = frameWidth;
            this.frameHeight = frameHeight;
            this.frameRate = frameRate;
        }

        public String toString() {
            return String.format("{DeviceChannel: devNum:%d, channel:%d, frameSize:%dx%d, frameRate%d}", this.devNum, this.channel, this.frameWidth, this.frameHeight, this.frameRate);
        }

        public boolean isMatch(long width, long height, long frameRate) {
            return width <= this.frameWidth && height <= this.frameHeight && frameRate <= this.frameRate;
        }

        public boolean isLessThan(DeviceChannel inDeviceChannel) {
            return inDeviceChannel.frameWidth <= this.frameWidth && inDeviceChannel.frameHeight <= this.frameHeight && inDeviceChannel.frameRate <= this.frameRate;
        }
    }
}

