/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.livestreamrecord.module;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.livestreamrecord.manager.IStreamRecorder;
import com.wowza.wms.livestreamrecord.manager.IStreamRecorderActionNotify;
import com.wowza.wms.livestreamrecord.manager.IStreamRecorderFileVersionDelegate;
import com.wowza.wms.livestreamrecord.manager.StreamRecorderParameters;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.IModuleOnApp;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import org.joda.time.DateTime;

public class ModuleAutoRecordAdvancedExample
extends ModuleBase
implements IModuleOnApp {
    private IApplicationInstance appInstance = null;
    private IVHost vhost = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        ModuleAutoRecordAdvancedExample.getLogger().info("ModuleAutoRecordAdvancedExample onAppStart[" + iApplicationInstance.getContextStr() + "]: ");
        this.appInstance = iApplicationInstance;
        this.vhost = iApplicationInstance.getVHost();
        StreamRecorderParameters streamRecorderParameters = new StreamRecorderParameters(iApplicationInstance);
        streamRecorderParameters.segmentationType = "duration";
        streamRecorderParameters.segmentSize = 0x100000L;
        ModuleAutoRecordAdvancedExample.getLogger().info("--- startRecordingSegmentBySize for 1MB");
        streamRecorderParameters.fileFormat = "mp4";
        streamRecorderParameters.startOnKeyFrame = true;
        streamRecorderParameters.recordData = true;
        streamRecorderParameters.fileVersionDelegate = new MyFileVersionDelegate();
        streamRecorderParameters.notifyListener = new MyStreamRecorderListener();
        this.vhost.getLiveStreamRecordManager().startRecording(iApplicationInstance, streamRecorderParameters);
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
    }

    class MyStreamRecorderListener
    implements IStreamRecorderActionNotify {
        MyStreamRecorderListener() {
        }

        public void onCreateRecorder(IStreamRecorder iStreamRecorder) {
            ModuleAutoRecordAdvancedExample.getLogger().info("MyStreamRecorderListener.onCreateRecorder[" + ModuleAutoRecordAdvancedExample.this.appInstance.getContextStr() + "]: new Recording created:" + iStreamRecorder.getStreamName());
        }

        public void onStartRecorder(IStreamRecorder iStreamRecorder) {
            ModuleAutoRecordAdvancedExample.getLogger().info("MyStreamRecorderListener.onStartRecorder[" + ModuleAutoRecordAdvancedExample.this.appInstance.getContextStr() + "]: new Recording started:" + iStreamRecorder.getStreamName() + " " + iStreamRecorder.getFilePath());
        }

        public void onSplitRecorder(IStreamRecorder iStreamRecorder) {
            ModuleAutoRecordAdvancedExample.getLogger().info("MyStreamRecorderListener.onSplitRecorder[" + ModuleAutoRecordAdvancedExample.this.appInstance.getContextStr() + "]: Segment recording:" + iStreamRecorder.getStreamName());
        }

        public void onStopRecorder(IStreamRecorder iStreamRecorder) {
            ModuleAutoRecordAdvancedExample.getLogger().info("MyStreamRecorderListener.onStopRecorder[" + ModuleAutoRecordAdvancedExample.this.appInstance.getContextStr() + "]: Recording stopped:" + iStreamRecorder.getStreamName() + " " + iStreamRecorder.getCurrentFile());
        }

        public void onSwitchRecorder(IStreamRecorder iStreamRecorder, IMediaStream iMediaStream) {
            ModuleAutoRecordAdvancedExample.getLogger().info("MyStreamRecorderListener.onSwitchRecorder[" + ModuleAutoRecordAdvancedExample.this.appInstance.getContextStr() + "]: switch to new stream, old Stream:" + iStreamRecorder.getStreamName() + " new Stream:" + iMediaStream.getName());
        }

        public void onSegmentStart(IStreamRecorder iStreamRecorder) {
            ModuleAutoRecordAdvancedExample.getLogger().info("MyStreamRecorderListener.onSegmentStart[" + ModuleAutoRecordAdvancedExample.this.appInstance.getContextStr() + "]: new segment created:" + iStreamRecorder.getStreamName());
        }

        public void onSegmentEnd(IStreamRecorder iStreamRecorder) {
            ModuleAutoRecordAdvancedExample.getLogger().info("MyStreamRecorderListener.onSegmentEnd[" + ModuleAutoRecordAdvancedExample.this.appInstance.getContextStr() + "]: segment closed:" + iStreamRecorder.getStreamName());
        }
    }

    class MyFileVersionDelegate
    implements IStreamRecorderFileVersionDelegate {
        MyFileVersionDelegate() {
        }

        public String getFilename(IStreamRecorder iStreamRecorder) {
            String string;
            try {
                File file = new File(iStreamRecorder.getBaseFilePath());
                String string2 = file.getParent();
                String string3 = file.getName();
                String string4 = "";
                int n = string3.lastIndexOf(".");
                if (n >= 0) {
                    string4 = string3.substring(n);
                    string3 = string3.substring(0, n);
                }
                if ((file = new File(string = string2 + "/" + string3 + "_" + DateTime.now().millisOfDay().getAsText() + string4)).exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(MyFileVersionDelegate.class).error("LiveStreamRecordFileVersionDelegate.getFilename: " + exception.toString());
                string = "junk.tmp";
            }
            return string;
        }
    }
}

