package com.wowza.wms.plugin.livestreamrecord.module;

import com.wowza.wms.application.*;
import com.wowza.wms.livestreamrecord.manager.*;
import com.wowza.wms.module.*;
import com.wowza.wms.vhost.*;

public class ModuleAutoRecordBasicExample extends ModuleBase implements IModuleOnApp
{
	private IApplicationInstance appInstance = null;
	private IVHost vhost = null;

	public void onAppStart(IApplicationInstance appInstance)
	{
		getLogger().info("ModuleAutoRecordBasicExample onAppStart["+appInstance.getContextStr()+"]: ");

     	this.appInstance = appInstance;
     	this.vhost = appInstance.getVHost();
     	
		// set recording params as desired
		StreamRecorderParameters recordParams = new StreamRecorderParameters(this.appInstance);
		
		// segment by size, create 60 minute segments using default content path
		//recordParams.segmentationType = IStreamRecorderConstants.SEGMENT_BY_DURATION;
		//recordParams.segmentDuration = 60*60*1000;
		//getLogger().info("--- startRecordingSegmentByDuration for 60 minutes");
		
		// segment by duration, create 1MB segments using default content path
		//recordParams.segmentationType = IStreamRecorderConstants.SEGMENT_BY_DURATION;
		//recordParams.segmentSize = 1024*1024;
		//getLogger().info("--- startRecordingSegmentBySize for 1MB");
		
		// segment by duration, create new segment at 1:00am each day.
		//recordParams.segmentationType = IStreamRecorderConstants.SEGMENT_BY_SCHEDULE;
		//recordParams.segmentSchedule = "0 * 1 * * *";
		//getLogger().info("--- startRecordingSegmentBySchedule every * 1 * * * *");

	    // don't segment, use the default content path, overwrite if file exists
		recordParams.segmentationType = IStreamRecorderConstants.SEGMENT_NONE;
		recordParams.versioningOption = IStreamRecorderConstants.OVERWRITE_FILE;
		getLogger().info("--- startRecording");

		// tell LiveStreamRecordManager to record all streams for this Instance using these params
		this.vhost.getLiveStreamRecordManager().startRecording(appInstance, recordParams);
	}

	public void onAppStop(IApplicationInstance appInstance)
	{
		// Nothing to do here because LiveStreamRecord Manager stops and destroys the Stream Recorders when the Application stops.
	}
}