/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.livestreamrecord.module;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.livestreamrecord.model.ILiveStreamRecord;
import com.wowza.wms.livestreamrecord.model.LiveStreamRecorderFLV;
import com.wowza.wms.livestreamrecord.model.LiveStreamRecorderMP4;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.module.IModuleOnStream;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify3;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModuleLiveStreamRecord
extends ModuleBase
implements IModuleOnStream {
    private static final Class<ModuleLiveStreamRecord> CLASS = ModuleLiveStreamRecord.class;
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_FLV = 1;
    public static final int FORMAT_MP4 = 2;
    private Map<String, ILiveStreamRecord> recorders = new HashMap<String, ILiveStreamRecord>();
    private IApplicationInstance appInstance = null;
    private IVHost vhost = null;
    private String recordMethod = "";

    public void recordStream(String string, int n, boolean bl, String string2, boolean bl2, boolean bl3, boolean bl4) {
        IMediaStream iMediaStream = this.appInstance.getStreams().getStream(string);
        if (iMediaStream != null) {
            StartRecordParameters startRecordParameters = new StartRecordParameters();
            startRecordParameters.format = n;
            startRecordParameters.append = bl;
            startRecordParameters.outputPath = string2;
            startRecordParameters.versionFile = bl2;
            startRecordParameters.startOnKeyFrame = bl3;
            startRecordParameters.recordData = bl4;
            this.recordStream(iMediaStream, startRecordParameters);
        } else {
            WMSLoggerFactory.getLogger(CLASS).warn("[" + this.vhost + "]" + "ModuleLiveStreamRecord.recordStream: Stream not found: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordStream(IMediaStream iMediaStream, StartRecordParameters startRecordParameters) {
        File file;
        String string;
        String string2 = iMediaStream.getName();
        if (startRecordParameters.format == 0) {
            startRecordParameters.format = 1;
            string = iMediaStream.getExt();
            if (string.equals("mp4")) {
                startRecordParameters.format = 2;
            }
        }
        string = "action:" + startRecordParameters.action;
        string = string + "stream:" + string2;
        string = string + " format:" + (startRecordParameters.format == 2 ? "mp4" : "flv");
        string = string + " append:" + startRecordParameters.append;
        if (startRecordParameters.outputPath != null) {
            string = string + " outputPath:" + startRecordParameters.outputPath;
        } else {
            file = iMediaStream.getStreamFileForWrite(iMediaStream.getName(), startRecordParameters.format == 2 ? "mp4" : "flv", iMediaStream.getQueryStr());
            string = string + " outputPath:" + file.getAbsolutePath();
        }
        string = string + " versionFile:" + startRecordParameters.versionFile;
        string = string + " startOnKeyFrame:" + startRecordParameters.startOnKeyFrame;
        string = string + " recordData:" + startRecordParameters.recordData;
        string = string + " segmentDuration:" + startRecordParameters.segmentDuration;
        string = string + " segmentSize:" + startRecordParameters.segmentSize;
        string = string + " segmentSchdule:" + startRecordParameters.segmentSchedule;
        WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "ModuleStreamRecord.startRecording: " + string);
        file = null;
        file = startRecordParameters.format == 2 ? new LiveStreamRecorderMP4() : new LiveStreamRecorderFLV();
        file.init(this.appInstance);
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            ILiveStreamRecord iLiveStreamRecord = this.recorders.get(string2);
            if (iLiveStreamRecord != null) {
                iLiveStreamRecord.stopRecording();
            }
            this.recorders.put(string2, (ILiveStreamRecord)file);
        }
        file.setRecordData(startRecordParameters.recordData);
        file.setVersionFile(startRecordParameters.versionFile);
        file.setStartOnKeyFrame(startRecordParameters.startOnKeyFrame);
        if (startRecordParameters.action.equalsIgnoreCase("startRecordingSegmentBySize")) {
            file.startRecordingSegmentBySize(iMediaStream, startRecordParameters.outputPath, null, startRecordParameters.segmentSize);
        } else if (startRecordParameters.action.equalsIgnoreCase("startRecordingSegmentByDuration")) {
            file.startRecordingSegmentByDuration(iMediaStream, startRecordParameters.outputPath, null, startRecordParameters.segmentDuration);
        } else if (startRecordParameters.action.equalsIgnoreCase("startRecordingSegmentBySchedule")) {
            file.startRecordingSegmentBySchedule(iMediaStream, startRecordParameters.outputPath, null, startRecordParameters.segmentSchedule);
        } else {
            file.startRecording(iMediaStream, startRecordParameters.outputPath, startRecordParameters.append);
        }
    }

    public void startRecordingSegmentBySize(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        this.recordMethod = "startRecordingSegmentBySize";
        this.startRecording(iClient, requestFunction, aMFDataList);
    }

    public void startRecordingSegmentByDuration(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        this.recordMethod = "startRecordingSegmentByDuration";
        this.startRecording(iClient, requestFunction, aMFDataList);
    }

    public void startRecordingSegmentBySchedule(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        this.recordMethod = "startRecordingSegmentBySchedule";
        this.startRecording(iClient, requestFunction, aMFDataList);
    }

    public void startRecording(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        Object object;
        Object object2;
        Object object3;
        AMFDataObj aMFDataObj;
        StartRecordParameters startRecordParameters = new StartRecordParameters();
        String string = aMFDataList.getString(3);
        if (4 < aMFDataList.size() && (aMFDataObj = aMFDataList.getObject(4)) != null) {
            object3 = aMFDataObj.getKeys();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                String string2 = (String)object2.next();
                try {
                    if (string2.equalsIgnoreCase("format")) {
                        object = aMFDataObj.getString(string2);
                        if (((String)object).equals("flv")) {
                            startRecordParameters.format = 1;
                            continue;
                        }
                        if (!((String)object).equals("mp4")) continue;
                        startRecordParameters.format = 2;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("append")) {
                        startRecordParameters.append = aMFDataObj.getBoolean(string2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("outputPath")) {
                        startRecordParameters.outputPath = iClient.getAppInstance().decodeStorageDir(aMFDataObj.getString(string2));
                        if (startRecordParameters.outputFile == null) continue;
                        startRecordParameters.outputFile = startRecordParameters.outputFile.equalsIgnoreCase("") ? null : startRecordParameters.outputFile;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("versionFile")) {
                        startRecordParameters.versionFile = aMFDataObj.getBoolean(string2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("startOnKeyFrame")) {
                        startRecordParameters.startOnKeyFrame = aMFDataObj.getBoolean(string2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("recordData")) {
                        startRecordParameters.recordData = aMFDataObj.getBoolean(string2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("segmentSize")) {
                        startRecordParameters.segmentSize = aMFDataObj.getLong(string2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("segmentDuration")) {
                        startRecordParameters.segmentDuration = aMFDataObj.getLong(string2);
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("segmentSchedule")) continue;
                    startRecordParameters.segmentSchedule = aMFDataObj.getString(string2);
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(CLASS).error("[" + this.vhost + "]" + "ModuleLiveStreamRecord.startRecording: Error processing param[" + string2 + "]: " + exception.toString());
                }
            }
        }
        startRecordParameters.action = this.recordMethod.equalsIgnoreCase("startRecordingSegmentBySize") || this.recordMethod.equalsIgnoreCase("startRecordingSegmentByDuration") || this.recordMethod.equalsIgnoreCase("startRecordingSegmentBySchedule") ? this.recordMethod : "startRecording";
        aMFDataObj = iClient.getAppInstance();
        object3 = "default";
        object2 = iClient.getStreamType();
        if (object2 != null) {
            object3 = object2;
        }
        boolean bl = false;
        object = aMFDataObj.getVHost().getStreamTypes();
        StreamItem streamItem = object.getStreamDef((String)object3);
        if (streamItem != null) {
            bl = streamItem.getProperties().getPropertyBoolean("isLiveRepeaterEdge", bl);
        }
        if (bl) {
            string = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)aMFDataObj, (IClient)iClient, (String)string);
        }
        if ((object = aMFDataObj.getStreams().getStream(string)) != null) {
            this.recordStream((IMediaStream)object, startRecordParameters);
        } else {
            WMSLoggerFactory.getLogger(CLASS).warn("[" + this.vhost + "]" + "ModuleStreamRecord." + startRecordParameters.action + ": stream not found: " + string);
        }
    }

    public String[] getRecorderNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.recorders.keySet());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void getPublishStreamNames(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        AMFDataArray aMFDataArray = new AMFDataArray();
        WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "ModuleStreamRecord.getPublishStreamNames");
        List list = iClient.getAppInstance().getPublishStreamNames();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            aMFDataArray.add((AMFData)new AMFDataItem(string));
            WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "  publishName[" + n + "]: " + string);
            ++n;
        }
        ModuleLiveStreamRecord.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (AMFData)aMFDataArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stopRecording(String string) {
        ILiveStreamRecord iLiveStreamRecord = null;
        Object object = this.recorders;
        synchronized (object) {
            iLiveStreamRecord = this.recorders.remove(string);
        }
        object = null;
        if (iLiveStreamRecord != null) {
            object = iLiveStreamRecord.getFilePath();
            iLiveStreamRecord.stopRecording();
        } else {
            WMSLoggerFactory.getLogger(CLASS).warn("[" + this.vhost + "]" + "ModuleStreamRecord.stopRecording: stream recorder not found: " + string);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "ModuleStreamRecord.stopRecording: " + string);
        ILiveStreamRecord iLiveStreamRecord = null;
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            iLiveStreamRecord = this.recorders.remove(string);
        }
        if (iLiveStreamRecord != null) {
            iLiveStreamRecord.stopRecording();
        } else {
            WMSLoggerFactory.getLogger(CLASS).warn("[" + this.vhost + "]" + "ModuleStreamRecord.stopRecording: stream recorder not found: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void splitRecordingNow(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = aMFDataList.getString(3);
        WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "ModuleStreamRecord.splitRecordingNow: " + string);
        ILiveStreamRecord iLiveStreamRecord = null;
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            iLiveStreamRecord = this.recorders.get(string);
        }
        if (iLiveStreamRecord != null) {
            iLiveStreamRecord.splitRecordingNow();
        } else {
            WMSLoggerFactory.getLogger(CLASS).warn("[" + this.vhost + "]" + "ModuleStreamRecord.splitRecordingNow: stream recorder not found: " + string);
        }
    }

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.vhost = iApplicationInstance.getVHost();
        WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "ModuleStreamRecord.onAppStart");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance iApplicationInstance) {
        WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "ModuleStreamRecord.onAppStop");
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            for (String string : this.recorders.keySet()) {
                ILiveStreamRecord iLiveStreamRecord = this.recorders.get(string);
                iLiveStreamRecord.stopRecording();
                WMSLoggerFactory.getLogger(CLASS).info("[" + this.vhost + "]" + "  stopRecording: " + string);
            }
            this.recorders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamCreate(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        ModuleLiveStreamRecord.getLogger().info("onStreamCreate[" + iMediaStream + "]: clientId:" + iMediaStream.getClientId());
        StreamListener streamListener = new StreamListener();
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            wMSProperties.put((Object)"streamActionNotifier", (Object)streamListener);
        }
        iMediaStream.addClientListener((IMediaStreamActionNotify3)streamListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamDestroy(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        ModuleLiveStreamRecord.getLogger().info("onStreamDestroy[" + iMediaStream + "]: clientId:" + iMediaStream.getClientId());
        IMediaStreamActionNotify3 iMediaStreamActionNotify3 = null;
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            iMediaStreamActionNotify3 = (IMediaStreamActionNotify3)iMediaStream.getProperties().get((Object)"streamActionNotifier");
        }
        if (iMediaStreamActionNotify3 != null) {
            iMediaStream.removeClientListener(iMediaStreamActionNotify3);
            ModuleLiveStreamRecord.getLogger().info("removeClientListener: " + iMediaStream.getSrc());
        }
    }

    public class StartRecordParameters {
        public boolean append = false;
        public String outputPath = null;
        public int format = 2;
        public boolean versionFile = true;
        public boolean startOnKeyFrame = true;
        public boolean recordData = true;
        public long segmentSize = 0xA00000L;
        public long segmentDuration = 900000L;
        public String segmentSchedule = null;
        public String action = "";
        public String fileTemplate = null;
        public String outputFile = null;
    }

    class StreamListener
    implements IMediaStreamActionNotify3 {
        StreamListener() {
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            Map map = ModuleLiveStreamRecord.this.recorders;
            synchronized (map) {
                ModuleLiveStreamRecord.this.recorders.remove(string);
            }
        }

        public void onMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        }

        public void onPauseRaw(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onCodecInfoVideo(IMediaStream iMediaStream, MediaCodecInfoVideo mediaCodecInfoVideo) {
        }

        public void onCodecInfoAudio(IMediaStream iMediaStream, MediaCodecInfoAudio mediaCodecInfoAudio) {
        }
    }
}

