/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.encoders;

import com.wowza.util.Base64;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.encoders.Thor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Encrypter {
    private Thor encrypter = null;
    private WMSLogger logger = null;
    private static Pattern base64EncodedPattern = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");

    public Encrypter(WMSLogger wMSLogger) {
        this.logger = wMSLogger;
    }

    public void initEncrypt(String string, boolean bl) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.encrypter = new Thor(byArray);
            if (bl) {
                this.logger.info("Encrypter Initialised.");
            }
        }
        catch (Exception exception) {
            this.logger.error("Encrypter:initEncryptor() failed to initialize encrypter: ", (Throwable)exception);
        }
    }

    public String encrypt(String string, boolean bl) {
        String string2 = "";
        StringBuilder stringBuilder = null;
        try {
            byte[] byArray = string.getBytes("UTF8");
            if (bl) {
                stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append(byArray[i]);
                }
                this.logger.info("Encrypter:Encrypt() RAW:" + stringBuilder.toString());
            }
            byte[] byArray2 = this.encrypter.encrypt(byArray);
            if (bl) {
                stringBuilder = new StringBuilder();
                for (int i = 0; i < byArray2.length; ++i) {
                    stringBuilder.append(byArray2[i]);
                }
                this.logger.info("Encrypter:Encrypt() enc:" + stringBuilder.toString());
            }
            string2 = Base64.encodeBytes((byte[])byArray2);
            if (bl) {
                this.logger.info("Encrypter:Encrypt() B64: " + string2);
            }
            string2 = URLEncoder.encode(string2, "UTF-8");
            if (bl) {
                this.logger.info("Encrypter:Encrypt() URL: " + string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.error("Encrypter:encrypt() Error encrypting '" + string + "'", (Throwable)unsupportedEncodingException);
        }
        return string2;
    }

    public String decrypt(String string, boolean bl) {
        String string2 = "DEAD";
        if (string.length() > 0) {
            try {
                Matcher matcher;
                if (bl) {
                    this.logger.info("Encrypter:Decrypt() URL: " + string);
                }
                if (!(matcher = base64EncodedPattern.matcher(string)).find()) {
                    string = URLDecoder.decode(string, "UTF-8");
                }
                if (bl) {
                    this.logger.info("Encrypter:Decrypt() B64: " + string);
                }
                byte[] byArray = Base64.decode((String)string);
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < byArray.length; ++i) {
                        stringBuilder.append(byArray[i]);
                    }
                    this.logger.info("Encrypter:Decrypt() Raw: " + stringBuilder.toString());
                }
                byte[] byArray2 = this.encrypter.decrypt(byArray);
                string2 = new String(byArray2);
                if (bl) {
                    this.logger.info("Encrypter:Decrypt() Decrypted message is '" + string2 + "'");
                }
            }
            catch (Exception exception) {
                this.logger.error("Encrypter:Decrypt() Error decrypting message: '" + string + ", ", (Throwable)exception);
                string2 = "DEAD";
            }
        }
        return string2;
    }
}

