/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.general;

import com.wowza.util.MD5DigestUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.encoders.Encrypter;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import com.wowza.wms.plugin.loadbalancer.general.URLHandler;
import com.wowza.wms.plugin.loadbalancer.general.XMLParser;
import com.wowza.wms.plugin.loadbalancer.impl.LoadBalancerReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.monitors.BandwidthMonitor;
import com.wowza.wms.plugin.loadbalancer.monitors.LoadBalanceBandwidthMonitorClient;
import com.wowza.wms.plugin.loadbalancer.monitors.LoadBalanceMonitorServer;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.vhost.VHostList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LoadBalancerServer
implements IServerNotify2 {
    private static LoadBalanceBandwidthMonitorClient clientMonitor = null;
    private static LoadBalanceMonitorServer serverMonitor = null;
    private static WMSLogger logger = null;
    private static long developmentTimer = 0L;
    private static PropertyHandler props = null;
    private static URLHandler urlHandler = null;
    private static XMLParser xmlInfo = null;
    private static Encrypter encrypt = null;
    private static BandwidthMonitor bandwidth = null;
    private long startTime = 0L;
    private static String loadBalancerType = "";

    public static String returnLoadBalancerType() {
        return loadBalancerType;
    }

    public static PropertyHandler getPropertyHandler() {
        return props;
    }

    public static WMSLogger getLogger() {
        return logger;
    }

    public static Encrypter getEncrypter() {
        return encrypt;
    }

    public static XMLParser getXMLInfo() {
        return xmlInfo;
    }

    public void onServerConfigLoaded(IServer iServer) {
    }

    public void onServerCreate(IServer iServer) {
    }

    public void onServerInit(IServer iServer) {
        boolean bl;
        if (logger == null) {
            logger = WMSLoggerFactory.getLogger(LoadBalancerServer.class);
        }
        this.logInfo("onServerInit() Version: " + LoadBalancerReleaseInfo.getVersion() + " Build " + LoadBalancerReleaseInfo.getBuildNumber() + " Start");
        iServer.getProperties().setProperty("registration", (Object)"https://www.wowza.com/");
        this.startTime = System.currentTimeMillis() / 1000L;
        iServer.getProperties().setProperty("StartTime", (Object)this.startTime);
        iServer.getProperties().setProperty("com.wowza.wms.server", (Object)String.valueOf(this.startTime));
        try {
            props = new PropertyHandler(logger, iServer.getProperties());
        }
        catch (Exception exception) {
            this.logError("onServerInit() " + exception.toString());
            this.logError("onServerInit() Load Balance functionality disabled.");
            return;
        }
        encrypt = new Encrypter(logger);
        xmlInfo = new XMLParser(LoadBalancerServer.props.debugEnabled, encrypt, logger);
        props.setXMLParser(xmlInfo);
        urlHandler = new URLHandler(LoadBalancerServer.props.debugEnabled, xmlInfo, encrypt, logger);
        props.setURLHandler(urlHandler);
        bandwidth = new BandwidthMonitor(props, logger);
        urlHandler.setPropertyHandler(props);
        if (iServer.getVersion().matches(".*[Dd]eveloper.*")) {
            developmentTimer = System.currentTimeMillis() / 1000L + 600L;
            LoadBalancerServer.props.developmentTimer = developmentTimer;
            this.logInfo("onServerInit() Development license in use, limited time applied.");
        }
        encrypt.initEncrypt(MD5DigestUtils.generateHash((String)LoadBalancerServer.props.encryptionKey), LoadBalancerServer.props.debugEncrypter);
        String string = "";
        VHostList vHostList = iServer.getVHostList();
        List list = vHostList.getVHostNames();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = string + (String)iterator.next() + ",";
        }
        LoadBalancerServer.props.vHostNames = string = string.substring(0, string.length() - 1);
        this.logDebug("onServerInit() Looking for VHosts '" + string + "'");
        if (LoadBalancerServer.props.serverType.contains("Client")) {
            this.logInfo("onServerInit() loadbalanceGeoUsageLoadBalancerURL: " + LoadBalancerServer.props.loadBalancerURL);
            bl = props.clientRegistrationLogic();
            this.logDebug("onServerInit() Client: Geo Registration is '" + bl + "'");
            clientMonitor = new LoadBalanceBandwidthMonitorClient(bandwidth, xmlInfo, urlHandler, props, logger);
            clientMonitor.setDaemon(true);
            clientMonitor.setSleepTime(LoadBalancerServer.props.sleepTimer);
            clientMonitor.start();
            props.updateStartClient(true);
            this.logDebug("onServerInit() Client: Worker Thread started");
            this.logDebug("onServerInit() Client: Bandwidth filtering is " + LoadBalancerServer.props.useBandwidth);
            this.logDebug("onServerInit() Client: Connection filtering is " + LoadBalancerServer.props.useConnection);
            this.logDebug("onServerInit() Client: Country filtering is " + LoadBalancerServer.props.useCountry + " using " + LoadBalancerServer.props.geoCountryList);
        }
        if (LoadBalancerServer.props.serverType.contains("Server")) {
            if (LoadBalancerServer.props.usageOrder.contains("Geographic")) {
                this.logDebug("onServerInit() Server: Geo database type '" + LoadBalancerServer.props.geoDataType + "'");
                this.logDebug("onServerInit() Server: Geo database file '" + LoadBalancerServer.props.geoDataFile + "'");
                if (LoadBalancerServer.props.geoDataType.equalsIgnoreCase("maxmind")) {
                    bl = props.initMaxMind(LoadBalancerServer.props.geoDataFile, LoadBalancerServer.props.debugEnabled);
                    if (bl) {
                        this.logDebug("onServerInit() Server: MaxMind Geo Data File loaded from '" + LoadBalancerServer.props.geoDataFile + "'");
                    }
                    if (!bl) {
                        if (LoadBalancerServer.props.debugServerMessages.booleanValue() || LoadBalancerServer.props.debugEnabled.booleanValue()) {
                            this.logInfo("onServerInit() Server: Geographic load balancing disabled, no GeoDatabase loaded");
                        }
                        LoadBalancerServer.props.useCountry = false;
                    }
                }
            }
            serverMonitor = new LoadBalanceMonitorServer(props, logger);
            serverMonitor.setDaemon(true);
            serverMonitor.start();
            props.setStartServer(true);
            this.logDebug("onServerInit() Server: Worker Thread starting");
        }
        this.logInfo("Started ");
    }

    public void onServerShutdownStart(IServer iServer) {
        HashMap<String, String> hashMap;
        if (LoadBalancerServer.props.serverType.contains("Client") && props.getClientState() && xmlInfo.getAttributeValue(hashMap = urlHandler.managementURL("Stop", LoadBalancerServer.props.debugURL), "PLACEHOLDER").equals("OK")) {
            this.logInfo("onServerShutDownStart() Placeholder handler for server shutdown");
        }
        if (clientMonitor != null) {
            clientMonitor.quit();
            this.logDebug("onServerShutDownStart() client monitor thread stopped for VHosts '" + LoadBalancerServer.props.vHostNames + "'");
            props.updateStartClient(false);
            clientMonitor = null;
        }
        if (serverMonitor != null) {
            serverMonitor.quit();
            this.logDebug("onServerShutDownStart() server monitor thread stopped for VHosts '" + LoadBalancerServer.props.vHostNames + "'");
            props.setStartServer(false);
            serverMonitor = null;
        }
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    private void logError(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            logger.error("LoadBalancerServer:" + string2);
        }
    }

    private void logError(String string, Exception exception) {
        String[] stringArray = string.split(System.getProperty("line.separator"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == stringArray.length - 1) {
                logger.error("LoadBalancerServer:" + stringArray[i], (Throwable)exception);
                continue;
            }
            logger.error("LoadBalancerServer:" + stringArray[i]);
        }
    }

    private void logInfo(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            logger.info("LoadBalancerServer:" + string2);
        }
    }

    private void logDebug(String string) {
        if (LoadBalancerServer.props.debugEnabled.booleanValue()) {
            this.logInfo(string);
        }
    }
}

