/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.general;

import com.maxmind.geoip.LookupService;
import com.wowza.util.MD5DigestUtils;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.general.URLHandler;
import com.wowza.wms.plugin.loadbalancer.general.XMLParser;
import com.wowza.wms.vhost.IVHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;

public class PropertyHandler {
    public static final String LOADBALANCE_PROPERTY_TYPE = "loadbalanceType";
    public static final String LOADBALANCE_PROPERTY_KEY = "loadbalanceKey";
    public static final String LOADBALANCE_PROPERTY_SERVER_IP = "loadbalanceServerIP";
    public static final String LOADBALANCE_PROPERTY_SERVER_PORT = "loadbalanceServerPort";
    public static final String LOADBALANCE_PROPERTY_CLIENT_NAME = "loadbalanceClientName";
    public static final String LOADBALANCE_PROPERTY_CLIENT_FORCE_IP = "loadbalanceClientForceIP";
    public static final String LOADBALANCE_PROPERTY_CLIENT_FORCE_PORT = "loadbalanceClientForcePort";
    public static final String LOADBALANCE_PROPERTY_BANDWIDTH_ENABLE = "loadbalanceBandwidthEnable";
    public static final String LOADBALANCE_PROPERTY_CONNNECTION_ENABLE = "loadbalanceConnectionEnable";
    public static final String LOADBALANCE_PROPERTY_COUNTRY_ENABLE = "loadbalanceCountryEnable";
    public static final String LOADBALANCE_PROPERTY_GEO_DATA_FILE = "loadbalanceGeoDataFile";
    public static final String LOADBALANCE_PROPERTY_GEO_DATA_TYPE = "loadbalanceGeoDataType";
    public static final String LOADBALANCE_PROPERTY_BANDWITDH_LIMIT = "loadbalanceBandwidthLimit";
    public static final String LOADBALANCE_PROPERTY_CONNECTION_LIMIT = "loadbalanceConnectionLimit";
    public static final String LOADBALANCE_PROPERTY_COUNTRY_LIST = "loadbalanceCountryList";
    public static final String LOADBALANCE_PROPERTY_COUNTRY_BLOCK_LIST = "loadbalanceCountryBlockList";
    public static final String LOADBALANCE_PROPERTY_DECISION_ORDER = "loadbalanceDecisionOrder";
    public static final String LOADBALANCE_PROPERTY_APPLICATIONS_INCLUDE = "loadbalanceApplicationsInclude";
    public static final String LOADBALANCE_PROPERTY_APPLICATIONS_EXCLUDE = "loadbalanceApplicationsExclude";
    public static final String LOADBALANCE_PROPERTY_IGNORE_CLIENTS = "loadbalanceIgnoreClients";
    public static final String LOADBALANCE_PROPERTY_ALLOW_REMOTE_CLIENT_SHUTDOWN = "loadbalanceAllowRemoteClientShutdown";
    public static final String LOADBALANCE_PROPERTY_DEBUG_SERVER_DECISION = "loadbalanceDebugServerDecision";
    public static final String LOADBALANCE_PROPERTY_SERVER_PATH = "loadbalanceServerPath";
    public static final String LOADBALANCE_PROPERTY_DEBUG_ENABLED = "loadbalanceDebugEnabled";
    public static final String LOADBALANCE_PROPERTY_DEBUG_ENCRYPTER = "loadbalanceDebugEncrypter";
    public static final String LOADBALANCE_PROPERTY_DEBUG_URL = "loadbalanceDebugURL";
    public static final String LOADBALANCE_PROPERTY_DEBUG_HTTP_INTERFACE = "loadbalanceDebugHTTPInterface";
    public static final String LOADBALANCE_PROPERTY_DEBUG_SERVER_MESSAGES = "loadbalanceDebugServerMessages";
    public static final String LOADBALANCE_PROPERTY_CLIENT_EXPIRY_TIMER = "loadbalanceClientExpiryTimer";
    public static final String LOADBALANCE_PROPERTY_SLEEP_TIMER = "loadbalanceClientSleepTimer";
    public static final String LOADBALANCE_PROPERTY_COUNT_SOURCE_STREAMS = "loadbalanceCountSourceStreams";
    public static final String LOADBALANCE_PROPERTY_DESCISION_ON_ALL_FULL = "loadbalanceDescisionOnAllFull";
    public static final String LOADBALANCE_SERVER_TYPE_SERVER = "Server";
    public static final String LOADBALANCE_SERVER_TYPE_CLIENT = "Client";
    public Boolean debugEnabled = false;
    public Boolean debugEncrypter = false;
    public Boolean debugURL = false;
    public Boolean debugHTTPInterface = false;
    public Boolean debugServerDecision = false;
    public Boolean debugServerMessages = false;
    public String serverType = null;
    public String encryptionKey = null;
    public Boolean allowShutdownClient = false;
    public Long expiryTimer = 60L;
    public Integer sleepTimer = 10;
    public String loadBalancerIP = null;
    public Integer loadBalancerPort = -1;
    public String loadBalancerServerPath = "loadbalancerInterface";
    public String clientName = "";
    public String clientForceIP = "";
    public String clientForcePort = "";
    public Boolean useBandwidth = false;
    public Boolean useConnection = false;
    public Boolean useCountry = false;
    public String geoDataFile = "";
    public String geoDataType = "maxmind";
    public Long bandwidthLimit = 0L;
    public Integer connectionCountLimit = Integer.MAX_VALUE;
    public String geoCountryList = "";
    public String geoCountryBlockList = "";
    public String usageOrder = "";
    public String ignoreClientsList = "NONE";
    public String applicationsInclude = "ANY";
    public String applicationsExclude = "";
    public Boolean countSourceStreams = false;
    public Boolean descisionOnAllFull = false;
    public String loadBalancerURL = null;
    public String vHostNames = "";
    private String clientID = "";
    public Long developmentTimer = Long.MIN_VALUE;
    public Integer connectionCurrent = 0;
    public Double bandwidthCurrent = new Double(0.0);
    private HashMap<String, String> applicationProperties = new HashMap();
    private Random generator = new Random();
    private LookupService maxMindGeoIPObject = null;
    private boolean geoIPLoaded = false;
    private int serverId = this.generator.nextInt(200000);
    private boolean startedClient = false;
    private boolean startedServer = false;
    private WMSLogger logger = null;
    private URLHandler urlHandler = null;
    private XMLParser xmlInfo = null;
    private ArrayList<LBServerClient> clientList = new ArrayList();
    private Object clientListLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayList<LBServerClient> getClientList() {
        Object object = this.clientListLock;
        synchronized (object) {
            return this.clientList;
        }
    }

    public PropertyHandler(WMSLogger wMSLogger, WMSProperties wMSProperties) throws Exception {
        this.logger = wMSLogger;
        String string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DEBUG_ENABLED);
        if (string != null) {
            this.debugEnabled = string.equals("On");
            this.logDebug("() Property 'loadbalanceDebugEnabled' value is '" + this.debugEnabled + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DEBUG_ENCRYPTER)) != null) {
            this.debugEncrypter = string.equals("On");
            this.logDebug("() Property 'loadbalanceDebugEncrypter' value is '" + this.debugEncrypter + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DEBUG_URL)) != null) {
            this.debugURL = string.equals("On");
            this.logDebug("() Property 'loadbalanceDebugURL' value is '" + this.debugURL + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DEBUG_HTTP_INTERFACE)) != null) {
            this.debugHTTPInterface = string.equals("On");
            this.logDebug("() Property 'loadbalanceDebugHTTPInterface' value is '" + this.debugHTTPInterface + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DEBUG_SERVER_DECISION)) != null) {
            this.debugServerDecision = string.equals("On");
            this.logDebug("() Property 'loadbalanceDebugServerDecision' value is '" + this.debugServerDecision + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DEBUG_SERVER_MESSAGES)) != null) {
            this.debugServerMessages = string.equals("On");
            this.logDebug("() Property 'loadbalanceDebugServerMessages' value is '" + this.debugServerMessages + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_TYPE)) != null) {
            this.serverType = string;
            this.logDebug("() Property 'loadbalanceType' value is '" + this.serverType + "'");
        }
        if (this.serverType == null || !this.serverType.contains(LOADBALANCE_SERVER_TYPE_SERVER) && !this.serverType.contains(LOADBALANCE_SERVER_TYPE_CLIENT)) {
            this.logError("() Property 'loadbalanceType' is '" + (this.serverType == null ? "" : this.serverType) + "' and must be contain '" + LOADBALANCE_SERVER_TYPE_SERVER + "' or '" + LOADBALANCE_SERVER_TYPE_CLIENT + "'.");
            throw new Exception("() Invalid 'loadbalanceType' setting: " + (this.serverType == null ? "" : this.serverType));
        }
        string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_KEY);
        if (string != null) {
            this.encryptionKey = string;
            this.logDebug("() Property 'loadbalanceKey' value is '" + this.encryptionKey + "'");
        }
        if (this.encryptionKey == null || this.encryptionKey.length() < 8) {
            this.logError("() Property 'loadbalanceKey' is too short or unset. Must be 8 characters or more.  Stopping Load Balancer functionality.");
            throw new Exception("() Invalid loadbalanceKey length.");
        }
        string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_ALLOW_REMOTE_CLIENT_SHUTDOWN);
        if (string != null) {
            this.allowShutdownClient = string.equals("On");
            this.logDebug("() Property 'loadbalanceAllowRemoteClientShutdown' value is '" + this.allowShutdownClient + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_CLIENT_EXPIRY_TIMER)) != null) {
            try {
                this.expiryTimer = Long.parseLong(string);
                this.logDebug("() Property 'loadbalanceClientExpiryTimer' value is '" + this.expiryTimer + "'");
            }
            catch (Exception exception) {
                this.logError("() Property 'loadbalanceClientExpiryTimer' must be a number. '" + string + "' is not a number.");
            }
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_SLEEP_TIMER)) != null) {
            try {
                this.sleepTimer = Integer.parseInt(string);
                if (this.sleepTimer < 5) {
                    this.sleepTimer = 5;
                }
                this.logDebug("() Property 'loadbalanceClientSleepTimer' value is '" + this.sleepTimer + "'");
            }
            catch (Exception exception) {
                this.logError("() Property 'loadbalanceClientSleepTimer' must be a number. '" + string + "' is not a number.");
            }
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_SERVER_IP)) != null) {
            this.loadBalancerIP = string;
            this.logDebug("() Property 'loadbalanceServerIP' value is '" + this.loadBalancerIP + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_SERVER_PORT)) != null) {
            try {
                this.loadBalancerPort = Integer.parseInt(string);
                this.logDebug("() Property 'loadbalanceServerPort' value is '" + this.loadBalancerPort + "'");
            }
            catch (Exception exception) {
                this.logError("() Property 'loadbalanceServerPort' must be a number. '" + string + "' is not a number.");
            }
        }
        if (this.serverType.contains(LOADBALANCE_SERVER_TYPE_CLIENT)) {
            Exception exception = null;
            if (this.loadBalancerIP == null || this.loadBalancerIP.length() < 4) {
                exception = new Exception("() 'loadbalanceServerIP' is invalid.");
            }
            if (this.loadBalancerPort <= 0 || this.loadBalancerPort >= 65535) {
                exception = new Exception("() 'loadbalanceServerPort' is invalid.");
            }
            if (exception != null) {
                this.logError("() Client Load Balancer configurations require a valid IP and Port to the Load Balance server.");
                throw exception;
            }
            this.loadBalancerURL = "http://" + this.loadBalancerIP + ":" + this.loadBalancerPort + "/" + this.loadBalancerServerPath;
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_SERVER_PATH)) != null) {
            if (string.length() >= 4) {
                this.loadBalancerServerPath = string;
                this.logDebug("() Property 'loadbalanceServerPath' value is '" + this.loadBalancerServerPath + "'");
            } else {
                this.logError("() Property 'loadbalanceServerPath' value " + string + " is too short, ignoring.");
            }
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_CLIENT_NAME)) != null) {
            this.clientName = string;
            this.logDebug("() Property 'loadbalanceClientName' value is '" + this.clientName + "'");
        } else {
            this.clientName = MD5DigestUtils.generateHash((String)String.valueOf(System.currentTimeMillis()));
        }
        string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_CLIENT_FORCE_IP);
        if (string != null) {
            this.clientForceIP = string;
            this.logDebug("() Property 'loadbalanceClientForceIP' value is '" + this.clientForceIP + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_CLIENT_FORCE_PORT)) != null) {
            this.clientForcePort = string;
            this.logDebug("() Property 'loadbalanceClientForcePort' value is '" + this.clientForcePort + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_BANDWIDTH_ENABLE)) != null) {
            this.useBandwidth = string.equals("On");
            this.logDebug("() Property 'loadbalanceBandwidthEnable' value is '" + this.useBandwidth + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_CONNNECTION_ENABLE)) != null) {
            this.useConnection = string.equals("On");
            this.logDebug("() Property 'loadbalanceConnectionEnable' value is '" + this.useConnection + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_COUNTRY_ENABLE)) != null) {
            this.useCountry = string.equals("On");
            this.logDebug("() Property 'loadbalanceCountryEnable' value is '" + this.useCountry + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_GEO_DATA_FILE)) != null) {
            this.geoDataFile = string;
            this.logDebug("() Property 'loadbalanceGeoDataFile' value is '" + this.geoDataFile + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_GEO_DATA_TYPE)) != null) {
            this.geoDataType = string;
            this.logDebug("() Property 'loadbalanceGeoDataType' value is '" + this.geoDataType + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_BANDWITDH_LIMIT)) != null) {
            try {
                this.bandwidthLimit = Long.parseLong(string);
                this.logDebug("() Property 'loadbalanceBandwidthLimit' value is '" + this.bandwidthLimit + "'");
            }
            catch (Exception exception) {
                this.logError("() Property 'loadbalanceBandwidthLimit' must be a number. '" + string + "' is not a number.");
            }
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_CONNECTION_LIMIT)) != null) {
            try {
                this.connectionCountLimit = Integer.parseInt(string);
                this.logDebug("() Property 'loadbalanceConnectionLimit' value is '" + this.connectionCountLimit + "'");
            }
            catch (Exception exception) {
                this.logError("() Property 'loadbalanceConnectionLimit' must be a number. '" + string + "' is not a number.");
            }
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_COUNTRY_LIST)) != null) {
            this.geoCountryList = string;
            this.logDebug("() Property 'loadbalanceCountryList' value is '" + this.geoCountryList + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_COUNTRY_BLOCK_LIST)) != null) {
            this.geoCountryBlockList = string;
            this.logDebug("() Property 'loadbalanceCountryBlockList' value is '" + this.geoCountryBlockList + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DECISION_ORDER)) != null) {
            this.usageOrder = string;
            this.logDebug("() Property 'loadbalanceDecisionOrder' value is '" + this.usageOrder + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_IGNORE_CLIENTS)) != null) {
            this.ignoreClientsList = string;
            this.logDebug("() Property 'loadbalanceIgnoreClients' value is '" + this.ignoreClientsList + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_APPLICATIONS_INCLUDE)) != null) {
            this.applicationsInclude = string;
            this.logDebug("() Property 'loadbalanceApplicationsInclude' value is '" + this.applicationsInclude + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_APPLICATIONS_EXCLUDE)) != null) {
            this.applicationsExclude = string;
            this.logDebug("() Property 'loadbalanceApplicationsExclude' value is '" + this.applicationsExclude + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_COUNT_SOURCE_STREAMS)) != null) {
            this.countSourceStreams = string.equals("On");
            this.logDebug("() Property 'loadbalanceCountSourceStreams' value is '" + this.countSourceStreams + "'");
        }
        if ((string = wMSProperties.getPropertyStr(LOADBALANCE_PROPERTY_DESCISION_ON_ALL_FULL)) != null) {
            this.descisionOnAllFull = string.equals("BestFit");
            this.logDebug("() Property 'loadbalanceDescisionOnAllFull' value is '" + string + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientID() {
        String string = this.clientID;
        synchronized (string) {
            return this.clientID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientID(String string) {
        String string2 = string;
        synchronized (string2) {
            this.clientID = string;
        }
    }

    public void setXMLParser(XMLParser xMLParser) {
        this.xmlInfo = xMLParser;
    }

    public void setURLHandler(URLHandler uRLHandler) {
        this.urlHandler = uRLHandler;
    }

    public boolean clientRegistrationLogic() {
        this.logDebug("clientRegistrationLogic() start");
        HashMap<String, String> hashMap = this.urlHandler.managementURL("Start", this.debugURL);
        if (this.xmlInfo.getAttributeValue(hashMap, "Confirm").equals("OK")) {
            this.setClientID(this.xmlInfo.getAttributeValue(hashMap, "ServerID"));
            this.logInfo("clientRegistrationLogic() Server ID set to " + this.getClientID());
        }
        if (this.xmlInfo.getAttributeValue(hashMap, "ServerID").length() > 0) {
            boolean bl;
            String string = MD5DigestUtils.generateHash((String)(this.encryptionKey + this.xmlInfo.getAttributeValue(hashMap, "ServerID")));
            string = this.clientName;
            this.logInfo("clientRegistrationLogic() registered with load balancer, id is '" + string + "'");
            if (this.debugEnabled.booleanValue()) {
                this.logInfo("clientRegistrationLogic() bandwidth monitoring '" + this.useBandwidth + "'");
                this.logInfo("clientRegistrationLogic() connection monitoring '" + this.useConnection + "'");
                this.logInfo("clientRegistrationLogic() country handling '" + this.useCountry + "'");
            }
            if (this.useBandwidth.booleanValue()) {
                bl = true;
                try {
                    long l = this.bandwidthLimit;
                    if (l > 100000000L) {
                        this.logError("clientRegistrationLogic() Property 'loadbalanceBandwidthLimit' is set too high.  Disabling Bandwidth.");
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    this.logError("clientRegistrationLogic() 'loadbalanceBandwidthLimit' should be a number.  Disabling Bandwitdh.", exception);
                    bl = false;
                }
                if (bl) {
                    HashMap<String, String> hashMap2 = this.urlHandler.clientBandwidthURL("Start", this.debugURL);
                    if (this.xmlInfo.getAttributeValue(hashMap2, "Confirm").equals("OK") && this.xmlInfo.getAttributeValue(hashMap2, "ServerID").equals(this.getClientID())) {
                        this.logInfo("clientRegistrationLogic() '" + string + "' Bandwidth balancing registration completed");
                    } else {
                        this.logError("clientRegistrationLogic() '" + string + "' Bandwidth balancing registration failed with main load balancer");
                        this.logError("clientRegistrationLogic() '" + string + "' Bandwidth balancing Possible reason '" + this.xmlInfo.getAttributeValue(hashMap2, "Failed") + "'");
                    }
                } else {
                    this.logInfo("clientRegistrationLogic() '" + string + "' Bandwidth balancing disabled.");
                    this.useBandwidth = false;
                }
            }
            if (this.useConnection.booleanValue()) {
                bl = true;
                try {
                    int n = this.connectionCountLimit;
                    if (n > 60000) {
                        this.logError("clientRegistrationLogic() 'loadbalanceConnectionLimit' is set too high.  Disabling connection count.");
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    this.logError("clientRegistrationLogic() 'loadbalanceConnectionLimit' should be a number.  Disabling connection counts", exception);
                    bl = false;
                }
                if (bl) {
                    HashMap<String, String> hashMap3 = this.urlHandler.clientConnectionURL("Start", this.debugURL);
                    if (this.xmlInfo.getAttributeValue(hashMap3, "Confirm").equals("OK")) {
                        this.logInfo("clientRegistrationLogic() '" + string + "' Connection balancing registration completed");
                    } else {
                        this.logError("clientRegistrationLogic() '" + string + "' Connection balancing registration failed with main load balancer");
                        this.logError("clientRegistrationLogic() '" + string + "' Connection balancing Possible reason '" + this.xmlInfo.getAttributeValue(hashMap3, "Failed") + "'");
                    }
                } else {
                    this.logInfo("clientRegistrationLogic() '" + string + "' Connection balancing disabled.");
                    this.useConnection = false;
                }
            }
            if (this.useCountry.booleanValue()) {
                HashMap<String, String> hashMap4 = this.urlHandler.clientCountryURL("Start", this.debugURL);
                if (this.xmlInfo.getAttributeValue(hashMap4, "Confirm").equals("OK")) {
                    this.logInfo("clientRegistrationLogic() '" + string + "' Geographic balancing registration completed");
                } else {
                    this.logError("clientRegistrationLogic() '" + string + "' Geographic balancing registration failed with main load balancer");
                    this.logError("clientRegistrationLogic() '" + string + "' Geographic balancing Possible reason '" + this.xmlInfo.getAttributeValue(hashMap4, "Failed") + "'");
                }
            }
            return true;
        }
        return false;
    }

    public void updateStartClient(boolean bl) {
        this.startedClient = bl;
    }

    public boolean getServerState() {
        return this.startedServer;
    }

    public void setStartServer(boolean bl) {
        this.startedServer = bl;
    }

    public boolean getClientState() {
        return this.startedClient;
    }

    public void checkConnectedClients(IVHost iVHost) {
        String[] stringArray;
        String[] stringArray2;
        String string = "";
        String string2 = "";
        String string3 = "";
        Set<String> set = this.applicationProperties.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            IClient iClient;
            IApplication iApplication;
            String string4;
            stringArray2 = iterator.next().toString();
            if (stringArray2.startsWith("BANDWIDTHRTP_")) {
                string4 = stringArray2.substring(9, stringArray2.length());
                stringArray = new String[]{};
                try {
                    stringArray = string4.split(":");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (stringArray.length == 3) {
                    iApplication = null;
                    try {
                        iApplication = iVHost.getApplication(stringArray[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (iApplication != null && (iClient = iVHost.getClient(Integer.parseInt(stringArray[1]))) == null) {
                        string = string + stringArray[0] + ":" + stringArray[1] + ",";
                    }
                }
            }
            if (stringArray2.startsWith("BANDWIDTHRTP_")) {
                string4 = stringArray2.substring(9, stringArray2.length());
                stringArray = new String[]{};
                try {
                    stringArray = string4.split(":");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (stringArray.length == 3) {
                    iApplication = null;
                    try {
                        iApplication = iVHost.getApplication(stringArray[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (iApplication != null && (iClient = iVHost.getRTPContext().getSessions().getSession(stringArray[1])) == null) {
                        string2 = string2 + stringArray[0] + ":" + stringArray[1] + ",";
                    }
                }
            }
            if (!stringArray2.startsWith("BANDWIDTHHTTP_")) continue;
            string4 = stringArray2.substring(9, stringArray2.length());
            stringArray = new String[]{};
            try {
                stringArray = string4.split(":");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringArray.length != 3) continue;
            iApplication = null;
            try {
                iApplication = iVHost.getApplication(stringArray[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (iApplication == null || (iClient = iVHost.getHTTPStreamerContext().getSessions().getSession(stringArray[1])) != null) continue;
            string3 = string3 + stringArray[0] + ":" + stringArray[1] + ",";
        }
        try {
            stringArray2 = string.split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = stringArray2[i].split(":");
                if (stringArray[0] == null) continue;
                this.removeProperty(stringArray[1] + ":time");
                this.removeProperty(stringArray[1] + ":bytes");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray2 = string2.split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = stringArray2[i].split(":");
                if (stringArray[0] == null) continue;
                this.removeProperty(stringArray[1] + ":time");
                this.removeProperty(stringArray[1] + ":bytes");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            stringArray2 = string3.split(",");
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = stringArray2[i].split(":");
                if (stringArray[0] == null) continue;
                this.removeProperty(stringArray[1] + ":time");
                this.removeProperty(stringArray[1] + ":bytes");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean initMaxMind(String string, boolean bl) {
        try {
            this.maxMindGeoIPObject = new LookupService(this.geoDataFile, 1);
            this.geoIPLoaded = true;
        }
        catch (Exception exception) {
            if (bl) {
                this.logError("initMaxMind() MaxMind Geo Data File failed to load due to '" + exception.toString() + "'");
            }
            this.geoIPLoaded = false;
        }
        return this.geoIPLoaded;
    }

    public boolean reloadGeoDatabase(String string, boolean bl) {
        if (this.maxMindGeoIPObject != null && this.geoIPLoaded) {
            this.maxMindGeoIPObject.close();
            this.maxMindGeoIPObject = null;
            this.geoIPLoaded = false;
        }
        this.geoIPLoaded = this.initMaxMind(string, bl);
        return this.geoIPLoaded;
    }

    public LBServerClient getCorrectLBServerClient(String string, String string2, String string3, String string4) {
        if (this.debugEnabled.booleanValue()) {
            this.logInfo("getCorrectLBServerClient() Application name balancing for name '" + string3 + "'");
        }
        String[] stringArray = null;
        ArrayList<LBServerClient> arrayList = this.getValidLBServerClients();
        if (arrayList.size() == 0) {
            if (this.debugServerDecision.booleanValue()) {
                this.logWarn("getCorrectLBServerClient() ServerDecision: No Load Balancing Servers, returning NONE");
            }
            return null;
        }
        if (arrayList.size() >= 1) {
            try {
                stringArray = string.split(",");
            }
            catch (Exception exception) {
                stringArray[0] = string;
            }
            for (String string5 : stringArray) {
                LBServerClient lBServerClient;
                ListIterator<LBServerClient> listIterator;
                if (this.debugServerDecision.booleanValue()) {
                    this.logInfo("getCorrectLBServerClient() ServerDecision: Order choice is '" + string5 + "'");
                }
                if (string5.equals("Geographic")) {
                    if (this.geoIPLoaded) {
                        block25: {
                            listIterator = "";
                            try {
                                listIterator = this.maxMindGeoIPObject.getCountry(string2).getCode();
                                if (this.debugServerDecision.booleanValue()) {
                                    this.logInfo("getCorrectLBServerClient() clientCountry is: " + listIterator);
                                }
                            }
                            catch (Exception exception) {
                                if (!this.debugServerDecision.booleanValue()) break block25;
                                this.logError("getCorrectLBServerClient() ServerDecision: Geo failed with '" + exception.toString() + "'");
                            }
                        }
                        if (listIterator == null && this.debugServerDecision.booleanValue()) {
                            this.logWarn("getCorrectLBServerClient() ServerDecision: No Country available for '" + string2 + "'");
                        }
                        arrayList = this.getLBServerClientsByCountry(arrayList, (String)((Object)listIterator));
                    }
                } else if (string5.equals("Bandwidth")) {
                    Collections.sort(arrayList, new clientsByBWComparator());
                    listIterator = arrayList.listIterator();
                    while (listIterator.hasNext()) {
                        lBServerClient = (LBServerClient)listIterator.next();
                        if (!(lBServerClient.bandwidth > arrayList.get((int)0).bandwidth) || !(lBServerClient.maxBandwidth > 0.0)) continue;
                        listIterator.remove();
                    }
                } else if (string5.equals("Connection")) {
                    Collections.sort(arrayList, new clientsByConnectCountComparator());
                    listIterator = arrayList.listIterator();
                    while (listIterator.hasNext()) {
                        lBServerClient = (LBServerClient)listIterator.next();
                        if (lBServerClient.connectionCount <= arrayList.get((int)0).connectionCount || lBServerClient.maxconnectionCount <= 0) continue;
                        listIterator.remove();
                    }
                } else if (string5.equals("ApplicationName")) {
                    listIterator = arrayList.listIterator();
                    while (listIterator.hasNext()) {
                        lBServerClient = (LBServerClient)listIterator.next();
                        if (lBServerClient.applications.contains(string3) || lBServerClient.applications.contains("*")) continue;
                        listIterator.remove();
                    }
                }
                if (arrayList.size() == 1) break;
            }
        }
        if (arrayList.size() > 0) {
            if (this.debugServerDecision.booleanValue()) {
                this.logInfo("Returning client connectioncount '" + arrayList.get((int)0).connectionCount + "' max '" + arrayList.get((int)0).maxconnectionCount + "'");
                this.logInfo("Returning client bandwidth '" + arrayList.get((int)0).bandwidth + "' max '" + arrayList.get((int)0).maxBandwidth + "'");
                this.logInfo("Returning client '" + arrayList.get((int)0).externalReference + "'");
            }
            return arrayList.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<LBServerClient> getValidLBServerClients() {
        ArrayList<LBServerClient> arrayList = new ArrayList<LBServerClient>();
        Object object = this.clientListLock;
        synchronized (object) {
            for (LBServerClient lBServerClient : this.clientList) {
                if (!lBServerClient.getState().equals("OK") || lBServerClient.timer <= System.currentTimeMillis() / 1000L - 20L) continue;
                if (!this.descisionOnAllFull.booleanValue()) {
                    boolean bl = true;
                    if (lBServerClient.maxBandwidth > 0.0 && lBServerClient.bandwidth >= lBServerClient.maxBandwidth) {
                        bl = false;
                    }
                    if (lBServerClient.maxconnectionCount > 0 && lBServerClient.connectionCount >= lBServerClient.maxconnectionCount) {
                        bl = false;
                    }
                    if (!bl) continue;
                    arrayList.add(lBServerClient);
                    continue;
                }
                arrayList.add(lBServerClient);
            }
        }
        return arrayList;
    }

    private ArrayList<LBServerClient> getLBServerClientsByCountry(ArrayList<LBServerClient> arrayList, String string) {
        String string2;
        ArrayList<LBServerClient> arrayList2 = new ArrayList<LBServerClient>();
        for (LBServerClient lBServerClient : arrayList) {
            string2 = "";
            string2 = lBServerClient.country;
            if (string2 == null || !string2.contains(string) || this.geoCountryBlockList.contains(string)) continue;
            arrayList2.add(lBServerClient);
            if (!this.debugServerDecision.booleanValue()) continue;
            this.logInfo("getLBServerClientsByCountry() ServerDecision: LbServerClient Country Search found '" + lBServerClient.externalReference + "' for country '" + string + "' CountryList '" + string2 + "'");
        }
        if (arrayList2.size() == 0) {
            for (LBServerClient lBServerClient : arrayList) {
                string2 = lBServerClient.country;
                if (string2 == null || !string2.contains("*") || this.geoCountryBlockList.contains(string)) continue;
                if (this.debugServerDecision.booleanValue()) {
                    this.logInfo("getLBServerClientsByCountry() ServerDecision: LbServerClient Country Search found '" + lBServerClient.externalReference + "' for country '" + string + "' CountryList '" + string2 + "'");
                }
                arrayList2.add(lBServerClient);
            }
        }
        if (this.debugServerDecision.booleanValue()) {
            this.logInfo("getLBServerClientsByCountry()  Country Search found '" + arrayList2.size() + "'");
        }
        return arrayList2;
    }

    public int getServerId() {
        ++this.serverId;
        return this.serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientBandwidth(String string, String string2, String string3) {
        Object object = this.clientListLock;
        synchronized (object) {
            for (LBServerClient lBServerClient : this.clientList) {
                if (!lBServerClient.serverID.equals(string)) continue;
                LBServerClient lBServerClient2 = lBServerClient;
                synchronized (lBServerClient2) {
                    lBServerClient.bandwidth = Double.parseDouble(string3);
                    lBServerClient.maxBandwidth = Double.parseDouble(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientConnection(String string, String string2, String string3) {
        Object object = this.clientListLock;
        synchronized (object) {
            for (LBServerClient lBServerClient : this.clientList) {
                if (!lBServerClient.serverID.equals(string)) continue;
                LBServerClient lBServerClient2 = lBServerClient;
                synchronized (lBServerClient2) {
                    lBServerClient.connectionCount = Integer.parseInt(string3);
                    lBServerClient.maxconnectionCount = Integer.parseInt(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientApplications(String string, String string2) {
        Object object = this.clientListLock;
        synchronized (object) {
            for (LBServerClient lBServerClient : this.clientList) {
                if (!lBServerClient.serverID.equals(string)) continue;
                LBServerClient lBServerClient2 = lBServerClient;
                synchronized (lBServerClient2) {
                    lBServerClient.applications = string2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientCountry(String string, String string2) {
        LBServerClient lBServerClient = this.getClient(string);
        if (lBServerClient != null) {
            LBServerClient lBServerClient2 = lBServerClient;
            synchronized (lBServerClient2) {
                lBServerClient.country = string2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientTimer(String string, Long l) {
        LBServerClient lBServerClient = this.getClient(string);
        if (lBServerClient != null) {
            LBServerClient lBServerClient2 = lBServerClient;
            synchronized (lBServerClient2) {
                lBServerClient.timer = l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getClientTimer(String string) {
        LBServerClient lBServerClient = this.getClient(string);
        if (lBServerClient != null) {
            LBServerClient lBServerClient2 = lBServerClient;
            synchronized (lBServerClient2) {
                return lBServerClient.timer;
            }
        }
        return 0L;
    }

    public void updateClientState(String string, String string2) {
        LBServerClient lBServerClient = this.getClient(string);
        if (lBServerClient != null) {
            lBServerClient.setState(string2);
        }
    }

    public String getClientState(String string) {
        LBServerClient lBServerClient = this.getClient(string);
        if (lBServerClient != null) {
            return lBServerClient.getState();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClient(String string, String string2, String string3, String string4) {
        LBServerClient lBServerClient = this.getClient(string2);
        if (lBServerClient == null) {
            lBServerClient = new LBServerClient();
            Object object = lBServerClient;
            synchronized (object) {
                lBServerClient.serverID = string2;
                lBServerClient.externalReference = string3 + ":" + string4;
                lBServerClient.timer = System.currentTimeMillis() / 1000L;
                lBServerClient.name = string;
            }
            object = this.clientListLock;
            synchronized (object) {
                this.clientList.add(lBServerClient);
            }
        }
        assert (false);
        this.updateClientState(string2, "OK");
    }

    public String getExternalReference(String string) {
        LBServerClient lBServerClient = this.getClient(string);
        if (lBServerClient != null) {
            return lBServerClient.externalReference;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClient(String string) {
        LBServerClient lBServerClient = this.getClient(string);
        if (lBServerClient != null) {
            Object object = this.clientListLock;
            synchronized (object) {
                this.clientList.remove(lBServerClient);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProperty(String string, String string2) {
        HashMap<String, String> hashMap = this.applicationProperties;
        synchronized (hashMap) {
            this.applicationProperties.remove(string);
            this.applicationProperties.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String string) {
        HashMap<String, String> hashMap = this.applicationProperties;
        synchronized (hashMap) {
            this.applicationProperties.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePropertyValue(String string, Double d) {
        HashMap<String, String> hashMap = this.applicationProperties;
        synchronized (hashMap) {
            this.applicationProperties.put(string, String.valueOf(d));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePropertyValueLong(String string, Long l) {
        HashMap<String, String> hashMap = this.applicationProperties;
        synchronized (hashMap) {
            this.applicationProperties.put(string, String.valueOf(l));
        }
    }

    public String getProperty(String string) {
        String string2 = "";
        try {
            string2 = this.applicationProperties.get(string);
        }
        catch (Exception exception) {
            return "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public Double getPropertyValue(String string) {
        Double d = new Double(0.0);
        try {
            d = Double.valueOf(this.applicationProperties.get(string));
        }
        catch (Exception exception) {
            return new Double(0.0);
        }
        return d;
    }

    public Long getPropertyValueLong(String string) {
        Long l = new Long(0L);
        try {
            l = Long.valueOf(this.applicationProperties.get(string));
        }
        catch (Exception exception) {
            return new Long(0L);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LBServerClient getClient(String string) {
        Object object = this.clientListLock;
        synchronized (object) {
            for (LBServerClient lBServerClient : this.clientList) {
                if (!lBServerClient.serverID.equals(string)) continue;
                return lBServerClient;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LBServerClient getReferenceClient(String string) {
        Object object = this.clientListLock;
        synchronized (object) {
            for (LBServerClient lBServerClient : this.clientList) {
                String string2 = MD5DigestUtils.generateHash((String)(this.encryptionKey + lBServerClient.serverID));
                if (!string2.equals(string)) continue;
                return lBServerClient;
            }
        }
        return null;
    }

    private void logError(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.error("LB PropertyHandler: " + string2);
        }
    }

    private void logError(String string, Exception exception) {
        String[] stringArray = string.split(System.getProperty("line.separator"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == stringArray.length - 1) {
                this.logger.error("LB PropertyHandler: " + stringArray[i], (Throwable)exception);
                continue;
            }
            this.logger.error("LB PropertyHandler: " + stringArray[i]);
        }
    }

    private void logWarn(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.warn("LB PropertyHandler: " + string2);
        }
    }

    private void logInfo(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.info("LB PropertyHandler: " + string2);
        }
    }

    private void logDebug(String string) {
        if (this.debugEnabled.booleanValue()) {
            this.logInfo(string);
        }
    }

    public class clientsByConnectCountComparator
    implements Comparator<LBServerClient> {
        @Override
        public int compare(LBServerClient lBServerClient, LBServerClient lBServerClient2) {
            return Double.compare(lBServerClient.connectionCount, lBServerClient2.connectionCount);
        }
    }

    public class clientsByBWComparator
    implements Comparator<LBServerClient> {
        @Override
        public int compare(LBServerClient lBServerClient, LBServerClient lBServerClient2) {
            return Double.compare(lBServerClient.bandwidth, lBServerClient2.bandwidth);
        }
    }

    public class LBServerClient {
        public static final String STATE_OK = "OK";
        public static final String STATE_STOPPED = "STOP";
        public String serverID = "";
        public String externalReference = "";
        public Double bandwidth = new Double(0.0);
        public Double maxBandwidth = new Double(0.0);
        public String country = "";
        public String name = "";
        public String applications = "";
        public int connectionCount = 0;
        public int maxconnectionCount = 0;
        public int redirectCount;
        public long timer;
        private String state = "";

        LBServerClient() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(String string) {
            LBServerClient lBServerClient = this;
            synchronized (lBServerClient) {
                this.state = string;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getState() {
            LBServerClient lBServerClient = this;
            synchronized (lBServerClient) {
                return this.state;
            }
        }

        public String toString() {
            return String.format("ID: %s Ref: %s Name: %s BW (Cur: %d Limit: %d) Conn (Cur: %d Limit: %d) Country: %s", this.serverID, this.externalReference, this.name, this.bandwidth, this.maxBandwidth, this.connectionCount, this.maxconnectionCount, this.country);
        }
    }
}

