/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.general;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.encoders.Encrypter;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import com.wowza.wms.plugin.loadbalancer.general.URLEncoder;
import com.wowza.wms.plugin.loadbalancer.general.XMLParser;
import java.util.HashMap;

public class URLHandler {
    private PropertyHandler properties = null;
    private WMSLogger logger = null;
    private XMLParser xmlinfo = null;
    private Encrypter encrypter = null;
    private boolean debugEnabled = false;

    public URLHandler(boolean bl, XMLParser xMLParser, Encrypter encrypter, WMSLogger wMSLogger) {
        this.debugEnabled = bl;
        this.xmlinfo = xMLParser;
        this.encrypter = encrypter;
        this.logger = wMSLogger;
    }

    public void setPropertyHandler(PropertyHandler propertyHandler) {
        this.properties = propertyHandler;
    }

    public HashMap<String, String> managementURL(String string, boolean bl) {
        if (bl) {
            this.logDebug("managementURL() '" + this.properties.clientName + "'");
        }
        String string2 = this.managementRequest(string, this.properties.clientName, this.properties.clientForceIP, this.properties.clientForcePort, this.properties.getClientID());
        String string3 = this.properties.loadBalancerURL;
        string3 = string3 + "?command=" + URLEncoder.encode(this.encrypter.encrypt(string2, this.properties.debugEncrypter));
        if (bl || this.debugEnabled) {
            this.logInfo("managementURL() LoadBalancerURL is '" + string3 + "'");
        }
        return this.xmlinfo.xmlParse(string3, "");
    }

    public HashMap<String, String> clientBandwidthURL(String string, boolean bl) {
        String string2 = URLHandler.clientBandwidthXMLTemplate(this.properties.getClientID(), this.properties.bandwidthLimit, this.properties.bandwidthCurrent, string);
        String string3 = this.properties.loadBalancerURL;
        string3 = string3 + "?command=" + URLEncoder.encode(this.encrypter.encrypt(string2, this.properties.debugEncrypter));
        if (bl || this.debugEnabled) {
            this.logInfo("clientBandwidthURL() ClientbandwidthURL is '" + string3 + "'");
        }
        return this.xmlinfo.xmlParse(string3, "");
    }

    public HashMap<String, String> clientConnectionURL(String string, boolean bl) {
        String string2 = URLHandler.clientConnectionXMLTemplate(this.properties.getClientID(), this.properties.connectionCountLimit, this.properties.connectionCurrent, string);
        if (bl || this.debugEnabled) {
            this.logInfo("clientConnectionURL() ConnectionURL Attempt");
            this.logInfo("clientConnectionURL() ClientConnectionXML is '" + string2 + "'");
        }
        String string3 = this.properties.loadBalancerURL;
        string3 = string3 + "?command=" + URLEncoder.encode(this.encrypter.encrypt(string2, this.properties.debugEncrypter));
        if (bl || this.debugEnabled) {
            this.logInfo("clientConnectionURL() ClientConnectionURL is '" + string3 + "'");
        }
        return this.xmlinfo.xmlParse(string3, "");
    }

    public HashMap<String, String> clientCountryURL(String string, boolean bl) {
        String string2 = URLHandler.clientCountryXMLTemplate(this.properties.getClientID(), this.properties.geoCountryList, string);
        String string3 = this.properties.loadBalancerURL;
        string3 = string3 + "?command=" + URLEncoder.encode(this.encrypter.encrypt(string2, this.properties.debugEncrypter));
        if (bl || this.debugEnabled) {
            this.logInfo("clientCountryURL() ClientCountryURL is '" + string3 + "'");
        }
        return this.xmlinfo.xmlParse(string3, "");
    }

    public static String clientBandwidthXMLTemplate(String string, Long l, Double d, String string2) {
        String string3 = "<result>";
        string3 = string3 + "<Type>Bandwidth</Type>";
        string3 = string3 + "<ServerID>" + string + "</ServerID>";
        string3 = string3 + "<BandwidthLimit>" + l + "</BandwidthLimit>";
        string3 = string3 + "<BandwidthCurrent>" + d + "</BandwidthCurrent>";
        string3 = string3 + "<Action>" + string2 + "</Action>";
        string3 = string3 + "</result>";
        return string3;
    }

    public static String clientConnectionXMLTemplate(String string, Integer n, Integer n2, String string2) {
        String string3 = "<result>";
        string3 = string3 + "<Type>Connection</Type>";
        string3 = string3 + "<ServerID>" + string + "</ServerID>";
        string3 = string3 + "<ConnectionLimit>" + n + "</ConnectionLimit>";
        string3 = string3 + "<ConnectionCurrent>" + n2 + "</ConnectionCurrent>";
        string3 = string3 + "<Action>" + string2 + "</Action>";
        string3 = string3 + "</result>";
        return string3;
    }

    public static String clientCountryXMLTemplate(String string, String string2, String string3) {
        String string4 = "<result>";
        string4 = string4 + "<Type>Country</Type>";
        string4 = string4 + "<ServerID>" + string + "</ServerID>";
        string4 = string4 + "<CountryList>" + string2 + "</CountryList>";
        string4 = string4 + "<Action>" + string3 + "</Action>";
        string4 = string4 + "</result>";
        return string4;
    }

    public String managementRequest(String string, String string2, String string3, String string4, String string5) {
        String string6 = "<result>";
        string6 = string6 + "<Type>Management</Type>";
        string6 = string6 + "<Action>" + string + "</Action>";
        if (string.equals("Start")) {
            if (string3 != null && string3.length() > 0) {
                string6 = string6 + "<ClientIP>" + string3 + "</ClientIP>";
            }
            if (string4 != null && string4.length() > 0) {
                string6 = string6 + "<ClientPort>" + string4 + "</ClientPort>";
            }
            if (string2 != null && string2.length() > 0) {
                string6 = string6 + "<ClientName>" + string2 + "</ClientName>";
            }
        }
        if (string.equals("Stop")) {
            string6 = string6 + "<ServerID>" + string5 + "</ServerID>";
        }
        string6 = string6 + "</result>";
        return string6;
    }

    private void logInfo(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.info("LB URLHandler: " + string2);
        }
    }

    private void logDebug(String string) {
        if (this.debugEnabled) {
            this.logInfo(string);
        }
    }
}

