/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.util.MD5DigestUtils;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.general.LoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.util.Date;

public class LoadBalancerInformation
extends HTTProvider2Base {
    public void addHeader(StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
        stringBuffer.append("<loadbalanceGeoUsage>\n");
    }

    public void addFooter(StringBuffer stringBuffer) {
        stringBuffer.append("</loadbalanceGeoUsage>\n");
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        String string;
        Object object;
        boolean bl;
        if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = iHTTPRequest.getRequestURI();
        PropertyHandler propertyHandler = LoadBalancerServer.getPropertyHandler();
        WMSLogger wMSLogger = LoadBalancerServer.getLogger();
        String string3 = iHTTPRequest.getParameter("command");
        String string4 = iHTTPRequest.getParameter("client");
        String string5 = iHTTPRequest.getParameter("format");
        if (string5 == null) {
            string5 = "form";
        }
        if (string3 == null) {
            string3 = "statistics";
        }
        if (string5.equalsIgnoreCase("xml")) {
            this.addHeader(stringBuffer);
        }
        if (!(bl = propertyHandler.getServerState())) {
            string3 = "DEAD";
        }
        if (propertyHandler.debugEnabled.booleanValue()) {
            wMSLogger.info("LoadBalancerInformation.onHTTPRequest() HTTP Stats Interface Full decode was '" + string3 + "'");
        }
        if (string3.equalsIgnoreCase("removeclient") && propertyHandler.allowShutdownClient.booleanValue()) {
            object = propertyHandler.getReferenceClient(string4);
            if (object != null) {
                ((PropertyHandler.LBServerClient)object).setState("STOP");
            }
            string3 = "statistics";
        }
        if (string3.equalsIgnoreCase("statistics") && propertyHandler.serverType.contains("Server") && string5.equalsIgnoreCase("xml")) {
            for (PropertyHandler.LBServerClient iterator : propertyHandler.getClientList()) {
                stringBuffer.append("<Server>\n");
                String string6 = MD5DigestUtils.generateHash((String)(propertyHandler.encryptionKey + iterator.serverID));
                stringBuffer.append("<ServerReference>" + string6 + "</ServerReference>\n");
                stringBuffer.append("<ServerLocation>" + iterator.externalReference + "</ServerLocation>\n");
                stringBuffer.append("<ServerBandwidthLimit>" + iterator.maxBandwidth + "</ServerBandwidthLimit>\n");
                stringBuffer.append("<ServerBandwidthCurrent>" + iterator.bandwidth + "</ServerBandwidthCurrent>\n");
                stringBuffer.append("<ServerBandwidthGauge>kbps</ServerBandwidthGauge>\n");
                stringBuffer.append("<ServerConnectionLimit>" + iterator.maxconnectionCount + "</ServerConnectionLimit>\n");
                stringBuffer.append("<ServerConnectionCurrent>" + iterator.connectionCount + "</ServerConnectionCurrent>\n");
                string = iterator.country;
                if (string != null) {
                    stringBuffer.append("<ServerCountry>" + string + "</ServerCountry>\n");
                }
                stringBuffer.append("</Server>\n");
            }
        }
        if (string5.equalsIgnoreCase("form")) {
            stringBuffer.append("<title>" + string2 + "</title>\n");
            stringBuffer.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\" width=\"80%\">\n");
            stringBuffer.append("<tr align=\"center\">\n");
            stringBuffer.append("<td bgcolor=\"#B0B0B0\">Reference/State</td>\n");
            stringBuffer.append("<td bgcolor=\"#B0B0B0\">Location</td>\n");
            stringBuffer.append("<td bgcolor=\"#B0B0B0\">LastReported</td>\n");
            stringBuffer.append("<td bgcolor=\"#B0B0B0\">Bandwidth<br />Current/Limit</td>\n");
            stringBuffer.append("<td bgcolor=\"#B0B0B0\">Connection<br />Current/Limit</td>\n");
            stringBuffer.append("<td bgcolor=\"#B0B0B0\">Country</td>\n");
            if (propertyHandler.allowShutdownClient.booleanValue()) {
                stringBuffer.append("<td bgcolor=\"#B0B0B0\">Action</td>\n");
            }
            stringBuffer.append("</tr>\n");
            object = "";
            for (PropertyHandler.LBServerClient lBServerClient : propertyHandler.getClientList()) {
                string = MD5DigestUtils.generateHash((String)(propertyHandler.encryptionKey + lBServerClient.serverID));
                if (lBServerClient.timer <= System.currentTimeMillis() / 1000L - 60L) continue;
                object = (String)object + "<tr align=\"center\">\n";
                object = (String)object + "<td>" + lBServerClient.name + "<br />" + lBServerClient.getState() + "</td>\n";
                object = (String)object + "<td>" + lBServerClient.externalReference + "</td>\n";
                Date date = new Date(lBServerClient.timer * 1000L);
                object = (String)object + "<td>" + date.toString() + "</td>\n";
                object = (String)object + "<td>" + String.format("%.2f", lBServerClient.bandwidth) + " kbps/";
                object = (String)object + lBServerClient.maxBandwidth + "</td>\n";
                object = (String)object + "<td>" + lBServerClient.connectionCount + "/";
                object = (String)object + lBServerClient.maxconnectionCount + "</td>\n";
                String string7 = lBServerClient.country;
                object = string7 != null ? (String)object + "<td>" + string7 + "</td>\n" : (String)object + "<td>N/A</td>\n";
                if (propertyHandler.allowShutdownClient.booleanValue()) {
                    object = (String)object + "<td>\n";
                    object = (String)object + "<form action=\"" + string2 + "\" method=\"GET\">\n";
                    object = (String)object + "<input type=\"hidden\" name=\"client\" value=\"" + string + "\">\n";
                    object = (String)object + "<input type=\"hidden\" name=\"command\" value=\"removeclient\">\n";
                    object = (String)object + "<input type=\"submit\" value=\"Remove Client\">\n";
                    object = (String)object + "</form>\n";
                    object = (String)object + "</td>\n";
                }
                object = (String)object + "</tr>\n";
            }
            if (((String)object).length() == 0) {
                object = (String)object + "<tr align=\"center\">\n";
                object = (String)object + "<td colspan=\"9\">None</td>\n";
                object = (String)object + "</tr>\n";
            }
            object = (String)object + "</table>\n";
            stringBuffer.append((String)object);
        }
        if (string5.equalsIgnoreCase("xml")) {
            this.addFooter(stringBuffer);
        }
        try {
            if (string5.equalsIgnoreCase("xml")) {
                iHTTPResponse.setHeader("Content-Type", "text/xml");
            } else {
                iHTTPResponse.setHeader("Content-Type", "text/html");
            }
            object = iHTTPResponse.getOutputStream();
            byte[] byArray = stringBuffer.toString().getBytes();
            ((OutputStream)object).write(byArray);
        }
        catch (Exception exception) {
            wMSLogger.error("LoadBalancerInformation.onHTTPRequest() Error: ", (Throwable)exception);
        }
    }
}

