/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.util.HTTPUtils;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.general.LoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;

public class LoadBalancerPublicInterface
extends HTTProvider2Base {
    public void addHeader(StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
        stringBuffer.append("<smil>\n");
    }

    public void addFooter(StringBuffer stringBuffer) {
        stringBuffer.append("</smil>\n");
    }

    public String getLoadBalancedDomainName(String string) {
        try {
            string = string.split("/")[2];
        }
        catch (Exception exception) {
            return "";
        }
        int n = string.indexOf(".");
        try {
            string = string.substring(n, string.length() - n);
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public String[] getLoadBalancedPath(String string) {
        String[] stringArray = new String[5];
        String[] stringArray2 = new String[]{};
        try {
            stringArray2 = string.split("/");
        }
        catch (Exception exception) {
            stringArray2[0] = string;
        }
        String string2 = null;
        String string3 = "";
        if (stringArray2.length < 2) {
            return stringArray2;
        }
        int n = 1;
        if (string.endsWith("/loadbalancer.smil")) {
            n = 2;
        }
        string2 = stringArray2[stringArray2.length - n];
        if (stringArray2.length <= 4 || stringArray2[2].contains(":")) {
            for (int i = 2; i < stringArray2.length - n; ++i) {
                string3 = string3 + stringArray2[i] + "/";
            }
            stringArray[0] = stringArray2[1] + "/_definst_";
        } else {
            for (int i = 3; i < stringArray2.length - n; ++i) {
                string3 = string3 + stringArray2[i] + "/";
            }
            stringArray[0] = stringArray2[1] + "/" + stringArray2[2];
        }
        if (string3.length() > 0) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        stringArray[1] = string3;
        stringArray[2] = this.transformFormatFile(string3, string2);
        return stringArray;
    }

    private String transformFormatFile(String string, String string2) {
        String[] stringArray;
        if (string2.contains(":")) {
            return string2;
        }
        try {
            stringArray = string.split(":");
            if (stringArray.length > 1) {
                return string2;
            }
        }
        catch (Exception exception) {
            return string2;
        }
        try {
            stringArray = string2.split("\\.");
            if (stringArray.length == 1) {
                return string2;
            }
            String[] stringArray2 = new String[]{"flv", "mp4", "mov"};
            boolean bl = false;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equalsIgnoreCase(stringArray[1])) continue;
                bl = true;
            }
            if (bl) {
                return stringArray[1] + ":" + stringArray[0] + "." + stringArray[1];
            }
            return string2;
        }
        catch (Exception exception) {
            return "mp4:" + string2 + ".mp4";
        }
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Object[] objectArray;
        String[] stringArray;
        boolean bl;
        String[] stringArray2;
        String string4;
        Object object;
        if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
            return;
        }
        boolean bl2 = false;
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        PropertyHandler propertyHandler = LoadBalancerServer.getPropertyHandler();
        WMSLogger wMSLogger = LoadBalancerServer.getLogger();
        if (propertyHandler == null || wMSLogger == null) {
            return;
        }
        String string3 = Server.getInstance().getProperties().getPropertyStr("httpUserHTTPHeaders", null);
        if (string3 != null) {
            object = HTTPUtils.expandHTTPHeadersStr((String)string3);
            for (String string4 : object.keySet()) {
                iHTTPResponse.setHeader(string4, (String)object.get(string4));
            }
        }
        if (propertyHandler.debugHTTPInterface.booleanValue()) {
            wMSLogger.info("LoadBalancerPublicInterface.onHTTPRequest() Start");
        }
        object = iHTTPRequest.getParameter("scheme");
        Object object2 = iHTTPRequest.getParameter("request");
        string4 = iHTTPRequest.getParameter("IP");
        String string5 = iHTTPRequest.getParameter("assets");
        String string6 = iHTTPRequest.getParameter("bitrates");
        String string7 = iHTTPRequest.getRequestURL();
        String string8 = iHTTPRequest.getQueryString();
        String string9 = iHTTPRequest.getRemoteAddr();
        if (object2 == null) {
            object2 = "";
        }
        if (object == null) {
            object = "rtmp";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        if (string6 == null) {
            string6 = "";
        }
        if (string7.endsWith("/loadbalancer.smil")) {
            object = "rtmp";
        }
        if (propertyHandler.debugHTTPInterface.booleanValue()) {
            wMSLogger.info("LoadBalancerPublicInterface.onHTTPRequest() IP Address used was :" + string9);
            wMSLogger.info("LoadBalancerPublicInterface.onHTTPRequest() QueryString is      :" + string8);
        }
        if (((String)object2).equalsIgnoreCase("server") && string4.length() > 0) {
            string9 = string4;
        }
        if (string7.endsWith(".xml")) {
            string7 = string7.substring(0, string7.length() - 4);
        }
        if ((stringArray2 = this.getLoadBalancedPath(string7)).length < 2 && !((String)object2).equalsIgnoreCase("server")) {
            this.addHeader(stringBuffer);
            stringBuffer.append("<ERROR>Invalid Content Requested</ERROR>\n");
            wMSLogger.warn("LoadBalancerPublicInterface.onHTTPRequest() Invalid Content requested " + string7);
            this.addFooter(stringBuffer);
            bl2 = true;
        }
        String string10 = "";
        if (stringArray2.length > 2 && !bl2) {
            if (stringArray2[1].length() > 0 && !bl2) {
                stringArray2[1] = stringArray2[1] + "/";
            }
            string10 = stringArray2[0];
        }
        PropertyHandler.LBServerClient lBServerClient = propertyHandler.getCorrectLBServerClient(propertyHandler.usageOrder, string9, string10, this.getLoadBalancedDomainName(iHTTPRequest.getHeader("Host")));
        if (propertyHandler.debugHTTPInterface.booleanValue()) {
            if (lBServerClient != null) {
                wMSLogger.info("LoadBalancerPublicInterface.onHTTPRequest() found Client is " + lBServerClient.serverID);
            } else {
                wMSLogger.info("LoadBalancerPublicInterface.onHTTPRequest() found no clients");
            }
        }
        if (!(bl = propertyHandler.getServerState())) {
            lBServerClient = null;
            bl2 = true;
        }
        if (((String)object2).equalsIgnoreCase("server") && lBServerClient != null) {
            bl2 = true;
            stringBuffer.append(lBServerClient.externalReference);
        }
        if (lBServerClient == null) {
            this.addHeader(stringBuffer);
            stringBuffer.append("<ERROR>No Load Balanced servers available</ERROR>\n");
            wMSLogger.warn("LoadBalancerPublicInterface.onHTTPRequest() No Load Balancers found when requesting " + string7);
            this.addFooter(stringBuffer);
            bl2 = true;
        } else {
            if (((String)object).length() == 0) {
                object = "rtmp";
            }
            if (!bl2) {
                string8 = string8.length() == 0 ? "" : "?" + string8;
                string8 = this.removetriggerParameters(string8, "assets");
                string8 = this.removetriggerParameters(string8, "bitrates");
                string8 = this.removetriggerParameters(string8, "scheme");
                if ((string8 = this.removetriggerParameters(string8, "request")).startsWith("&")) {
                    string8 = string8.substring(1, string8.length());
                    string8 = "?" + string8;
                }
                if (((String)object).startsWith("rtmp")) {
                    this.addHeader(stringBuffer);
                    stringBuffer.append("<head>\n");
                    stringBuffer.append("<meta base=\"" + (String)object + "://" + lBServerClient.externalReference + "/" + stringArray2[0] + "\" />\n");
                    stringBuffer.append("</head>\n");
                    stringBuffer.append("<body>\n");
                    stringBuffer.append("<switch>\n");
                    if (string5.length() != 0) {
                        stringArray = new String[]{};
                        try {
                            stringArray = string5.split(",");
                        }
                        catch (Exception exception) {
                            stringArray[0] = string5;
                        }
                        objectArray = new String[0];
                        try {
                            objectArray = string6.split(",");
                        }
                        catch (Exception exception) {
                            objectArray[0] = (byte)string6;
                        }
                        if (stringArray.length == objectArray.length) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringBuffer.append("<video src=\"" + stringArray2[1] + stringArray[i]);
                                stringBuffer.append(string8);
                                stringBuffer.append("\" system-bitrate=\"" + (String)objectArray[i] + "\"/>\n");
                            }
                        }
                    } else {
                        stringBuffer.append("<video src=\"" + stringArray2[1] + stringArray2[2]);
                        stringBuffer.append(string8);
                        stringBuffer.append("\" />\n");
                    }
                    stringBuffer.append("</switch>\n");
                    stringBuffer.append("</body>\n");
                    this.addFooter(stringBuffer);
                }
                if (((String)object).equalsIgnoreCase("m3u8")) {
                    string2 = "http://" + lBServerClient.externalReference + "/" + stringArray2[0] + "/" + stringArray2[1] + stringArray2[2] + "/playlist.m3u8";
                }
                if (((String)object).equalsIgnoreCase("Manifest")) {
                    string2 = "http://" + lBServerClient.externalReference + "/" + stringArray2[0] + "/" + stringArray2[1] + stringArray2[2] + "/Manifest";
                }
                if (((String)object).equalsIgnoreCase("f4m")) {
                    string2 = "http://" + lBServerClient.externalReference + "/" + stringArray2[0] + "/" + stringArray2[1] + stringArray2[2] + "/manifest.f4m";
                }
                if (string2.length() > 0) {
                    string2 = string2 + string8;
                }
            }
        }
        try {
            if ((((String)object).equals("m3u8") || ((String)object).equals("Manifest") || ((String)object).equals("f4m")) && !bl2) {
                iHTTPResponse.setResponseCode(302);
                iHTTPResponse.setHeader("Location", string2);
            } else if (bl2 && ((String)object2).equalsIgnoreCase("server")) {
                iHTTPResponse.setHeader("Content-Type", "text/html");
            } else {
                iHTTPResponse.setHeader("Content-Type", "text/xml");
            }
            stringArray = iHTTPResponse.getOutputStream();
            objectArray = stringBuffer.toString().getBytes();
            stringArray.write((byte[])objectArray);
        }
        catch (Exception exception) {
            wMSLogger.error("LoadBalancerPublicInterface.onHTTPRequest() Error: ", (Throwable)exception);
        }
    }

    public String removetriggerParameters(String string, String string2) {
        if (string.contains(string2)) {
            String string3 = string.substring(0, string.indexOf(string2) - 1);
            string = string.substring(string3.length() + 1, string.length());
            String string4 = "";
            if (string.indexOf("&") > 0) {
                String string5 = string.substring(0, string.indexOf("&"));
                string4 = string.substring(string5.length(), string.length());
            }
            return string3 + string4;
        }
        return string;
    }
}

