/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.monitors;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import com.wowza.wms.rtp.model.RTPSession;
import java.util.Iterator;
import java.util.List;

public class BandwidthMonitor {
    private PropertyHandler properties = null;
    private WMSLogger logger = null;

    public BandwidthMonitor(PropertyHandler propertyHandler, WMSLogger wMSLogger) {
        this.properties = propertyHandler;
        this.logger = wMSLogger;
    }

    public String bandwidthRate(String string, IApplicationInstance iApplicationInstance, boolean bl) {
        List list;
        double d;
        IOPerformanceCounter iOPerformanceCounter;
        List list2;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 10;
        double d2 = 0.0;
        int n2 = 0;
        List list3 = iApplicationInstance.getClients();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            try {
                list2 = (IClient)iterator.next();
                if (list2 == null || !this.properties.countSourceStreams.booleanValue() && list2.getIp().equalsIgnoreCase("127.0.0.1")) continue;
                iOPerformanceCounter = list2.getMediaIOPerformanceCounter();
                double d3 = list2.getTimeRunningSeconds();
                if (d3 < (double)n) continue;
                string2 = String.valueOf(list2.getClientId()) + "_RTMP";
                string3 = string2 + ":time";
                string4 = string2 + ":bytes";
                d = 0.0;
                long l = iOPerformanceCounter.getMessagesOutBytes();
                if (l < 0L) {
                    l = 0L;
                }
                if (bl) {
                    this.logInfo("bandwidthRate() Checking Bitrate grace timer is '" + n + "' for client '" + list2.getClientId() + "'");
                }
                if (d3 <= (double)n) {
                    if (bl) {
                        this.logInfo("bandwidthRate() LbServerClient '" + list2.getClientId() + "' running time is '" + d3 + "' lower than '" + n + "'");
                    }
                    d = 0.0;
                }
                if (this.properties.getPropertyValue(string3) == 0.0 && d3 >= (double)n) {
                    this.properties.updatePropertyValue(string3, d3);
                    this.properties.updatePropertyValueLong(string4, l);
                    if (bl) {
                        this.logInfo("bandwidthRate() Updating client properties bytes '" + String.valueOf(l) + "' at time '" + String.valueOf(d3) + "'");
                        this.logInfo("bandwidthRate() Running time is higher than grace period");
                    }
                    d = 0.0;
                } else {
                    if ((d3 -= this.properties.getPropertyValue(string3).doubleValue()) < 0.0 || (l -= this.properties.getPropertyValueLong(string4).longValue()) < 0L) {
                        l = iOPerformanceCounter.getMessagesOutBytes();
                        d3 = list2.getTimeRunningSeconds();
                        this.properties.updatePropertyValue(string3, d3);
                        this.properties.updatePropertyValueLong(string4, l);
                        l = 1L;
                        d3 = 1.0;
                    }
                    d = (double)l / d3 * 8.0 / 1000.0;
                    if (bl) {
                        this.logInfo("bandwidthRate() Client bandwidth rate avg '" + String.valueOf(d) + "' based on time '" + String.valueOf(d3) + "' and bytes '" + l + "'");
                    }
                }
                d2 += d;
                ++n2;
            }
            catch (Exception exception) {}
        }
        list2 = iApplicationInstance.getHTTPStreamerSessions();
        iOPerformanceCounter = list2.iterator();
        while (iOPerformanceCounter.hasNext()) {
            try {
                IHTTPStreamerSession iHTTPStreamerSession = (IHTTPStreamerSession)iOPerformanceCounter.next();
                if (iHTTPStreamerSession == null || !this.properties.countSourceStreams.booleanValue() && iHTTPStreamerSession.getIpAddress().equalsIgnoreCase("127.0.0.1")) continue;
                list = iHTTPStreamerSession.getIOPerformanceCounter();
                d = iHTTPStreamerSession.getTimeRunningSeconds();
                if (d < (double)n) continue;
                string2 = String.valueOf(iHTTPStreamerSession.getSessionId()) + "_HTTP";
                string3 = string2 + ":time";
                string4 = string2 + ":bytes";
                double d4 = 0.0;
                long l = list.getMessagesOutBytes();
                if (l < 0L) {
                    l = 0L;
                }
                if (bl) {
                    this.logInfo("bandwidthRate() Checking Bitrate grace timer is '" + n + "' for client '" + iHTTPStreamerSession.getSessionId() + "'");
                }
                if (d <= (double)n) {
                    if (bl) {
                        this.logInfo("bandwidthRate() LbServerClient '" + iHTTPStreamerSession.getSessionId() + "' running time is '" + d + "' lower than '" + n + "'");
                    }
                    d4 = 0.0;
                }
                if (this.properties.getPropertyValue(string3) == 0.0 && d >= (double)n) {
                    this.properties.updatePropertyValue(string3, d);
                    this.properties.updatePropertyValueLong(string4, l);
                    if (bl) {
                        this.logInfo("bandwidthRate() Updating client properties bytes '" + String.valueOf(l) + "' at time '" + String.valueOf(d) + "'");
                        this.logInfo("bandwidthRate() Running time is higher than grace period");
                    }
                    d4 = 0.0;
                } else {
                    if ((d -= this.properties.getPropertyValue(string3).doubleValue()) < 0.0 || (l -= this.properties.getPropertyValueLong(string4).longValue()) < 0L) {
                        l = list.getMessagesOutBytes();
                        d = iHTTPStreamerSession.getTimeRunningSeconds();
                        this.properties.updatePropertyValue(string3, d);
                        this.properties.updatePropertyValueLong(string4, l);
                        l = 1L;
                        d = 1.0;
                    }
                    d4 = (double)l / d * 8.0 / 1000.0;
                    if (bl) {
                        this.logInfo("bandwidthRate() Client bandwidth rate avg '" + String.valueOf(d4) + "' based on time '" + String.valueOf(d) + "' and bytes '" + l + "'");
                    }
                }
                d2 += d4;
                ++n2;
            }
            catch (Exception exception) {}
        }
        list = iApplicationInstance.getRTPSessions();
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            try {
                RTPSession rTPSession = (RTPSession)iterator2.next();
                if (rTPSession == null || !this.properties.countSourceStreams.booleanValue() && rTPSession.getIp().equalsIgnoreCase("127.0.0.1")) continue;
                IOPerformanceCounter iOPerformanceCounter2 = rTPSession.getIOPerformanceCounter();
                double d5 = rTPSession.getTimeRunningSeconds();
                if (d5 < (double)n) continue;
                string2 = String.valueOf(rTPSession.getSessionId()) + "_RTP";
                string3 = string2 + ":time";
                string4 = string2 + ":bytes";
                double d6 = 0.0;
                long l = iOPerformanceCounter2.getMessagesOutBytes();
                if (l < 0L) {
                    l = 0L;
                }
                if (bl) {
                    this.logInfo("bandwidthRate() Checking Bitrate grace timer is '" + n + "' for client '" + rTPSession.getSessionId() + "'");
                }
                if (d5 <= (double)n) {
                    if (bl) {
                        this.logInfo("bandwidthRate() LbServerClient '" + rTPSession.getSessionId() + "' running time is '" + d5 + "' lower than '" + n + "'");
                    }
                    d6 = 0.0;
                }
                if (this.properties.getPropertyValue(string3) == 0.0 && d5 >= (double)n) {
                    this.properties.updatePropertyValue(string3, d5);
                    this.properties.updatePropertyValueLong(string4, l);
                    if (bl) {
                        this.logInfo("bandwidthRate() Updating client properties bytes '" + String.valueOf(l) + "' at time '" + String.valueOf(d5) + "'");
                        this.logInfo("bandwidthRate() Running time is higher than grace period");
                    }
                    d6 = 0.0;
                } else {
                    if ((d5 -= this.properties.getPropertyValue(string3).doubleValue()) < 0.0 || (l -= this.properties.getPropertyValueLong(string4).longValue()) < 0L) {
                        l = iOPerformanceCounter2.getMessagesOutBytes();
                        d5 = rTPSession.getTimeRunningSeconds();
                        this.properties.updatePropertyValue(string3, d5);
                        this.properties.updatePropertyValueLong(string4, l);
                        l = 1L;
                        d5 = 1.0;
                    }
                    d6 = (double)l / d5 * 8.0 / 1000.0;
                    if (bl) {
                        this.logInfo("bandwidthRate() Client bandwidth rate avg '" + String.valueOf(d6) + "' based on time '" + String.valueOf(d5) + "' and bytes '" + l + "'");
                    }
                }
                d2 += d6;
                ++n2;
            }
            catch (Exception exception) {}
        }
        return Double.toString(d2) + ":" + Integer.toString(n2);
    }

    private void logInfo(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.info("LB BandwidthMonitor: " + string2);
        }
    }
}

