/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.monitors;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import com.wowza.wms.plugin.loadbalancer.general.URLHandler;
import com.wowza.wms.plugin.loadbalancer.general.XMLParser;
import com.wowza.wms.plugin.loadbalancer.monitors.BandwidthMonitor;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class LoadBalanceBandwidthMonitorClient
extends Thread {
    private WMSLogger logger = null;
    private PropertyHandler properties = null;
    private URLHandler urlHandler = null;
    private XMLParser xmlInfo = null;
    private BandwidthMonitor bandwidthMonitor = null;
    private boolean running = true;
    private boolean quit = false;
    private int sleepTime = 10000;
    private Double serverTotalBandwidthInUse = new Double(0.0);
    private int serverTotalConnectionsInUse = 0;

    public LoadBalanceBandwidthMonitorClient(BandwidthMonitor bandwidthMonitor, XMLParser xMLParser, URLHandler uRLHandler, PropertyHandler propertyHandler, WMSLogger wMSLogger) {
        this.bandwidthMonitor = bandwidthMonitor;
        this.xmlInfo = xMLParser;
        this.urlHandler = uRLHandler;
        this.properties = propertyHandler;
        this.logger = wMSLogger;
    }

    public synchronized boolean running() {
        return this.running;
    }

    public synchronized void quit() {
        this.quit = true;
        this.notify();
    }

    public synchronized void setSleepTime(int n) {
        this.sleepTime = n *= 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            long l;
            if (this.properties.developmentTimer != Long.MIN_VALUE && (l = System.currentTimeMillis() / 1000L) > this.properties.developmentTimer) {
                this.logInfo("WorkerThread() Development Timer Expired, shutting down client.");
                this.quit = true;
            }
            String string = this.properties.vHostNames;
            String[] stringArray = null;
            try {
                stringArray = string.split(",");
            }
            catch (Exception exception) {
                stringArray[0] = string;
            }
            this.serverTotalBandwidthInUse = new Double(0.0);
            this.serverTotalConnectionsInUse = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                IVHost iVHost = VHostSingleton.getInstance((String)string2);
                List list = iVHost.getApplicationNames();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    try {
                        String string3 = (String)iterator.next();
                        List list2 = iVHost.getApplication(string3).getAppInstanceNames();
                        for (String string4 : list2) {
                            if (this.properties.applicationsExclude.contains(string3) || !this.properties.applicationsInclude.contains(string3) && !this.properties.applicationsInclude.contains("ANY")) continue;
                            IApplicationInstance iApplicationInstance = iVHost.getApplication(string3).getAppInstance(string4);
                            String string5 = this.bandwidthMonitor.bandwidthRate(string3, iApplicationInstance, this.properties.debugEnabled);
                            String[] stringArray2 = string5.split(":");
                            double d = Double.parseDouble(stringArray2[0]);
                            int n = Integer.parseInt(stringArray2[1]);
                            LoadBalanceBandwidthMonitorClient loadBalanceBandwidthMonitorClient = this;
                            Double.valueOf(loadBalanceBandwidthMonitorClient.serverTotalBandwidthInUse + d);
                            loadBalanceBandwidthMonitorClient.serverTotalBandwidthInUse = loadBalanceBandwidthMonitorClient.serverTotalBandwidthInUse;
                            this.serverTotalConnectionsInUse += n;
                            this.logDebug("WorkerThread() Bandwidth for '" + string3 + "' is '" + d + "' client count is '" + n + "'");
                        }
                    }
                    catch (Exception exception) {
                    }
                }
                this.properties.checkConnectedClients(iVHost);
            }
            if (this.properties.useConnection.booleanValue()) {
                this.properties.connectionCurrent = this.serverTotalConnectionsInUse;
                HashMap<String, String> hashMap = this.urlHandler.clientConnectionURL("Update", this.properties.debugURL);
                if (this.xmlInfo.getAttributeValue(hashMap, "Confirm").equals("OK")) {
                    this.logDebug("WorkerThread() Client - Connection balancing update completed");
                }
                if (this.xmlInfo.getAttributeValue(hashMap, "Confirm").equals("REREGISTER")) {
                    this.logDebug("WorkerThread() Thread asked to re-register. Probably main load balancer restart");
                    this.properties.updateStartClient(false);
                    boolean bl = this.properties.clientRegistrationLogic();
                    this.properties.updateStartClient(bl);
                }
                if (this.xmlInfo.getAttributeValue(hashMap, "Confirm").equals("STOP")) {
                    this.logDebug("WorkerThread() Thread asked to close remotely");
                    this.quit = true;
                }
            }
            if (this.properties.useBandwidth.booleanValue()) {
                this.properties.bandwidthCurrent = this.serverTotalBandwidthInUse >= 0.0 ? this.serverTotalBandwidthInUse : Double.valueOf(Double.MAX_VALUE);
                HashMap<String, String> hashMap = this.urlHandler.clientBandwidthURL("Update", this.properties.debugURL);
                if (this.xmlInfo.getAttributeValue(hashMap, "Confirm").equals("OK")) {
                    this.logDebug("WorkerThread() Client - Bandwidth balancing update completed");
                }
                if (this.xmlInfo.getAttributeValue(hashMap, "Confirm").equals("REREGISTER")) {
                    this.logDebug("WorkerThread() Thread asked to re-register. Probably main load balancer restart");
                    this.properties.updateStartClient(false);
                    boolean bl = this.properties.clientRegistrationLogic();
                    this.properties.updateStartClient(bl);
                }
                if (this.xmlInfo.getAttributeValue(hashMap, "Confirm").equals("STOP")) {
                    this.logDebug("WorkerThread() Thread asked to close remotely");
                    this.quit = true;
                }
            }
            LoadBalanceBandwidthMonitorClient loadBalanceBandwidthMonitorClient = this;
            synchronized (loadBalanceBandwidthMonitorClient) {
                try {
                    Thread.currentThread().wait(this.sleepTime);
                }
                catch (Exception exception) {
                    this.logError("WorkerThread() wait: " + exception.toString());
                }
            }
            loadBalanceBandwidthMonitorClient = this;
            synchronized (loadBalanceBandwidthMonitorClient) {
                if (this.quit) {
                    this.logDebug("WorkerThread() stopping due to quit signaled");
                    this.running = false;
                    this.properties.updateStartClient(false);
                    break;
                }
            }
        }
    }

    private void logError(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.error("LoadBalancerBandwitdhMonitorClient: " + string2);
        }
    }

    private void logInfo(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.info("LoadBalancerBandwitdhMonitorClient: " + string2);
        }
    }

    private void logDebug(String string) {
        if (this.properties.debugEnabled.booleanValue()) {
            this.logInfo(string);
        }
    }
}

