/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.monitors;

import com.wowza.util.MD5DigestUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import java.io.File;

public class LoadBalanceMonitorServer
extends Thread {
    private WMSLogger logger = null;
    private PropertyHandler properties = null;
    private boolean running = true;
    private boolean quit = false;
    private int sleepTime = 10000;
    private boolean geoReloadFind = false;
    private long lastModifiedLoad = 0L;

    public LoadBalanceMonitorServer(PropertyHandler propertyHandler, WMSLogger wMSLogger) {
        this.properties = propertyHandler;
        this.logger = wMSLogger;
    }

    public synchronized boolean running() {
        return this.running;
    }

    public synchronized void quit() {
        this.quit = true;
        this.notify();
    }

    public synchronized void setSleepTimeA(int n) {
        this.sleepTime = n *= 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (true) {
            String[] stringArray;
            long l;
            long string2;
            long l3;
            if (this.properties.developmentTimer != Long.MIN_VALUE && (l3 = System.currentTimeMillis() / 1000L) > this.properties.developmentTimer) {
                this.logInfo("WorkerThread() Development Timer Expired, shutting down server.\n");
                this.properties.setStartServer(false);
                this.quit = true;
            }
            String string = "";
            long l4 = System.currentTimeMillis() / 1000L;
            for (PropertyHandler.LBServerClient lBServerClient : this.properties.getClientList()) {
                string2 = this.properties.expiryTimer;
                if (string2 == 0L) {
                    string2 = 60L;
                }
                if (l4 <= (l = lBServerClient.timer + 60L)) continue;
                this.logDebug("WorkerThread() Removing client '" + MD5DigestUtils.generateHash((String)(this.properties.encryptionKey + lBServerClient.serverID)) + "' timer expired.");
                string = string + lBServerClient.serverID + ",";
            }
            if (string.length() > 0) {
                void var5_9;
                this.logDebug("WorkerThread() Clients to remove are '" + string + "'");
                stringArray = string.split(",");
                boolean bl = false;
                while (var5_9 < stringArray.length) {
                    String string3 = stringArray[var5_9];
                    if (string3.length() > 0) {
                        this.logDebug("WorkerThread() Expiring client '" + string3 + "'");
                        String string4 = MD5DigestUtils.generateHash((String)(this.properties.encryptionKey + string3));
                        this.logInfo("WorkerThread() LbServerClient UnRegistered '" + string4 + "'");
                        this.properties.unregisterClient(string3);
                    }
                    ++var5_9;
                }
                string = "";
            }
            stringArray = this.properties.geoDataFile;
            File object2 = new File((String)stringArray);
            string2 = object2.lastModified();
            l = System.currentTimeMillis() / 1000L;
            long l2 = l - (long)(this.sleepTime / 1000 * 6);
            if (this.geoReloadFind && (string2 /= 1000L) == this.lastModifiedLoad) {
                this.properties.reloadGeoDatabase(this.properties.geoDataFile, this.properties.debugEnabled);
            }
            if (this.geoReloadFind) {
                this.geoReloadFind = false;
            }
            if (string2 > l2) {
                this.lastModifiedLoad = string2;
                this.geoReloadFind = true;
            }
            LoadBalanceMonitorServer loadBalanceMonitorServer = this;
            synchronized (loadBalanceMonitorServer) {
                try {
                    Thread.currentThread().wait(this.sleepTime);
                }
                catch (Exception exception) {
                    this.logError("WorkerThread() wait got an Error: ", exception);
                }
            }
            loadBalanceMonitorServer = this;
            synchronized (loadBalanceMonitorServer) {
                if (this.quit) {
                    this.running = false;
                    this.properties.setStartServer(false);
                    break;
                }
            }
        }
    }

    private void logError(String string, Exception exception) {
        String[] stringArray = string.split(System.getProperty("line.separator"));
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == stringArray.length - 1) {
                this.logger.error("LoadBalancerMonitorServer: " + stringArray[i], (Throwable)exception);
                continue;
            }
            this.logger.error("LoadBalancerMonitorServer: " + stringArray[i]);
        }
    }

    private void logInfo(String string) {
        for (String string2 : string.split(System.getProperty("line.separator"))) {
            this.logger.info("LoadBalancerMonitorServer: " + string2);
        }
    }

    private void logDebug(String string) {
        if (this.properties.debugEnabled.booleanValue()) {
            this.logInfo(string);
        }
    }
}

