/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.redirect;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.http.HTTPServerVersion;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.model.MediaCodecInfoAudio;
import com.wowza.wms.media.model.MediaCodecInfoVideo;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.loadbalancer.general.LoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.general.PropertyHandler;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify2;
import com.wowza.wms.stream.IMediaStreamActionNotify3;

public class ClientConnections
extends ModuleBase {
    private String clientTransparent = "";
    private PropertyHandler properties = null;
    private WMSLogger logger = WMSLoggerFactory.getLogger(HTTPServerVersion.class);

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.properties = LoadBalancerServer.getPropertyHandler();
        this.clientTransparent = this.properties.ignoreClientsList;
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        this.properties = null;
        this.logger = null;
        this.clientTransparent = "";
    }

    public void onHTTPCupertinoStreamingSessionCreate(HTTPStreamerSessionCupertino hTTPStreamerSessionCupertino) {
        hTTPStreamerSessionCupertino.rejectSession();
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        PropertyHandler.LBServerClient lBServerClient;
        if (rTPSession.getProperties().getPropertyDouble("connectliveRepeaterCapabilities", 0.0) == 1.0 && rTPSession.getProperties().getPropertyStr("connectpageUrl") == null && rTPSession.getProperties().getPropertyStr("connectflashVer").equals("WIN 10,0,12,36") && rTPSession.getProperties().getPropertyStr("connectswfUrl").equals("WowzaProLiveRepeater")) {
            return;
        }
        if (rTPSession.getProperties().getPropertyStr("connectflashVer", "").contains(this.clientTransparent)) {
            this.logger.info("No redirection, found a match with '" + this.clientTransparent + "'");
            this.logger.info("LbServerClient was '" + rTPSession.getProperties().getPropertyStr("connectflashVer") + "'");
            return;
        }
        if (!this.properties.getServerState()) {
            this.logger.info("Load Balancer Not Running (server), connection refused.");
            this.logger.info("This module should only be entered on the load balancer, not the clients.");
            rTPSession.rejectSession();
            rTPSession.shutdown();
        }
        if (this.properties.usageOrder.length() == 0) {
            this.logger.info("No decision can be made as usage order not set.");
            this.logger.info("No redirection performed.");
            return;
        }
        String string = "";
        String string2 = rTPSession.getUri();
        String[] stringArray = this.getLoadBalancedPath(string2 = string2.replace("rtsp://", ""));
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        if ((lBServerClient = this.properties.getCorrectLBServerClient(this.properties.usageOrder, rTPSession.getIp(), string, this.getLoadBalancedDomainName(rTPSession.getUri()))) == null) {
            this.logger.info("No load balancing clients connected, no redirection");
            rTPSession.shutdown();
            rTPSession.rejectSession();
            return;
        }
        String string3 = "rtsp://" + lBServerClient.externalReference + "/" + stringArray[1] + "/" + stringArray[2];
        String string4 = rTPSession.getQueryStr() == "" ? "" : "?" + rTPSession.getQueryStr();
        string3 = string3 + string4;
        try {
            rTPSession.redirectSession(string3, 301);
            rTPSession.shutdown();
        }
        catch (Exception exception) {
            this.logger.info("loadbalanceGeoUsage Exception: " + exception.toString());
        }
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String[] stringArray;
        if (iClient.getProperties().getPropertyDouble("connectliveRepeaterCapabilities", 0.0) == 1.0 && iClient.getProperties().getPropertyStr("connectpageUrl") == null && iClient.getProperties().getPropertyStr("connectflashVer").equals("WIN 10,0,12,36") && iClient.getProperties().getPropertyStr("connectswfUrl").equals("WowzaProLiveRepeater")) {
            return;
        }
        if (iClient.getProperties().getPropertyStr("connectflashVer", "").contains(this.clientTransparent)) {
            this.logger.info("No redirection, found a match with '" + this.clientTransparent + "'");
            this.logger.info("LbServerClient was '" + iClient.getProperties().getPropertyStr("connectflashVer") + "'");
            return;
        }
        if (!this.properties.getServerState()) {
            this.logger.info("Load Balancer Not Running (server), connection refused.");
            this.logger.info("This module should only be entered on the load balancer, not the clients.");
            iClient.rejectConnection();
            iClient.shutdownClient();
        }
        if (this.properties.usageOrder.length() == 0) {
            this.logger.info("No decision can be made as usage order not set.");
            this.logger.info("No redirection performed.");
            return;
        }
        String string = "";
        String string2 = iClient.getUri();
        String string3 = "rtmp";
        if (string2.startsWith("rtmpe://")) {
            string3 = "rtmpe";
        }
        if (string2.startsWith("rtmps://")) {
            string3 = "rtmps";
        }
        if ((stringArray = this.getLoadBalancedPath(string2 = string2.replace(string3 + "://", ""))).length > 0) {
            string = stringArray[0];
        }
        stringArray[1] = stringArray[1] + "/";
        PropertyHandler.LBServerClient lBServerClient = this.properties.getCorrectLBServerClient(this.properties.usageOrder, iClient.getIp(), string, this.getLoadBalancedDomainName(iClient.getUri()));
        if (lBServerClient == null) {
            this.logger.info("No load balancing clients connected, no redirection");
            iClient.shutdownClient();
            iClient.rejectConnection();
            return;
        }
        String string4 = lBServerClient.externalReference + "/" + stringArray[1] + stringArray[2];
        string4 = string4.replace("//", "/");
        string4 = string3 + "://" + string4;
        if (this.properties.debugServerDecision.booleanValue()) {
            this.logger.info("Query string is '" + iClient.getQueryStr() + "'");
        }
        String string5 = iClient.getQueryStr() == "" ? "" : "?" + iClient.getQueryStr();
        string4 = string4 + string5;
        try {
            if (this.properties.debugServerDecision.booleanValue()) {
                this.logger.info("Final is '" + string4 + "'");
            }
            iClient.redirectConnection(string4);
        }
        catch (Exception exception) {
            this.logger.info("loadbalanceGeoUsage Exception: " + exception.toString());
        }
    }

    public void onConnectAccept(IClient iClient) {
    }

    public void onConnectReject(IClient iClient) {
    }

    public void onDisconnect(IClient iClient) {
    }

    public String getLoadBalancedDomainName(String string) {
        String string2 = "";
        try {
            string2 = string.split("/")[2];
        }
        catch (Exception exception) {
            return "";
        }
        int n = string.indexOf(".");
        try {
            string2 = string.substring(n, string.length() - n);
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    public String[] getLoadBalancedPath(String string) {
        String[] stringArray = new String[5];
        String[] stringArray2 = new String[]{};
        try {
            stringArray2 = string.split("/");
        }
        catch (Exception exception) {
            stringArray2[0] = string;
        }
        String string2 = null;
        String string3 = "";
        if (stringArray2.length < 2) {
            return stringArray2;
        }
        string2 = stringArray2[stringArray2.length - 1];
        for (int i = 2; i < stringArray2.length - 1; ++i) {
            string3 = string3 + stringArray2[i] + "/";
        }
        if (string3.length() > 0) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        stringArray[0] = stringArray2[1];
        stringArray[1] = string3;
        stringArray[2] = this.transformFormatFile(string2);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamCreate(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        StreamListener streamListener = new StreamListener();
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            wMSProperties.put((Object)"streamActionNotifier", (Object)streamListener);
        }
        iMediaStream.addClientListener((IMediaStreamActionNotify2)streamListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamDestroy(IMediaStream iMediaStream) {
        WMSProperties wMSProperties;
        IMediaStreamActionNotify2 iMediaStreamActionNotify2 = null;
        WMSProperties wMSProperties2 = wMSProperties = iMediaStream.getProperties();
        synchronized (wMSProperties2) {
            iMediaStreamActionNotify2 = (IMediaStreamActionNotify2)iMediaStream.getProperties().get((Object)"streamActionNotifier");
        }
        if (iMediaStreamActionNotify2 != null) {
            iMediaStream.removeClientListener(iMediaStreamActionNotify2);
        }
    }

    private String transformFormatFile(String string) {
        if (string.endsWith("flv")) {
            return string;
        }
        try {
            String[] stringArray = string.split("\\.");
            return stringArray[0] + "." + stringArray[1];
        }
        catch (Exception exception) {
            return string;
        }
    }

    class StreamListener
    implements IMediaStreamActionNotify3 {
        StreamListener() {
        }

        public void onMetaData(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        }

        public void onPauseRaw(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
        }

        public void onCodecInfoAudio(IMediaStream iMediaStream, MediaCodecInfoAudio mediaCodecInfoAudio) {
        }

        public void onCodecInfoVideo(IMediaStream iMediaStream, MediaCodecInfoVideo mediaCodecInfoVideo) {
        }
    }
}

