/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip;

import com.maxmind.geoip.Country;
import com.maxmind.geoip.DatabaseInfo;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.Region;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class LookupService {
    private RandomAccessFile file = null;
    private File databaseFile = null;
    private DatabaseInfo databaseInfo = null;
    byte databaseType = 1;
    int[] databaseSegments;
    int recordLength;
    String licenseKey;
    int dnsService = 0;
    int dboptions;
    byte[] dbbuffer;
    byte[] index_cache;
    long mtime;
    int last_netmask;
    private static final int US_OFFSET = 1;
    private static final int CANADA_OFFSET = 677;
    private static final int WORLD_OFFSET = 1353;
    private static final int FIPS_RANGE = 360;
    private static final int COUNTRY_BEGIN = 0xFFFF00;
    private static final int STATE_BEGIN_REV0 = 16700000;
    private static final int STATE_BEGIN_REV1 = 16000000;
    private static final int STRUCTURE_INFO_MAX_SIZE = 20;
    private static final int DATABASE_INFO_MAX_SIZE = 100;
    public static final int GEOIP_STANDARD = 0;
    public static final int GEOIP_MEMORY_CACHE = 1;
    public static final int GEOIP_CHECK_CACHE = 2;
    public static final int GEOIP_INDEX_CACHE = 4;
    public static final int GEOIP_UNKNOWN_SPEED = 0;
    public static final int GEOIP_DIALUP_SPEED = 1;
    public static final int GEOIP_CABLEDSL_SPEED = 2;
    public static final int GEOIP_CORPORATE_SPEED = 3;
    private static final int SEGMENT_RECORD_LENGTH = 3;
    private static final int STANDARD_RECORD_LENGTH = 3;
    private static final int ORG_RECORD_LENGTH = 4;
    private static final int MAX_RECORD_LENGTH = 4;
    private static final int MAX_ORG_RECORD_LENGTH = 300;
    private static final int FULL_RECORD_LENGTH = 60;
    private final Country UNKNOWN_COUNTRY = new Country("--", "N/A");
    private static final HashMap hashmapcountryCodetoindex = new HashMap(512);
    private static final HashMap hashmapcountryNametoindex = new HashMap(512);
    private static final String[] countryCode = new String[]{"--", "AP", "EU", "AD", "AE", "AF", "AG", "AI", "AL", "AM", "CW", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "SX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TL", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "RS", "ZA", "ZM", "ME", "ZW", "A1", "A2", "O1", "AX", "GG", "IM", "JE", "BL", "MF", "BQ", "SS", "O1"};
    private static final String[] countryName = new String[]{"N/A", "Asia/Pacific Region", "Europe", "Andorra", "United Arab Emirates", "Afghanistan", "Antigua and Barbuda", "Anguilla", "Albania", "Armenia", "Curacao", "Angola", "Antarctica", "Argentina", "American Samoa", "Austria", "Australia", "Aruba", "Azerbaijan", "Bosnia and Herzegovina", "Barbados", "Bangladesh", "Belgium", "Burkina Faso", "Bulgaria", "Bahrain", "Burundi", "Benin", "Bermuda", "Brunei Darussalam", "Bolivia", "Brazil", "Bahamas", "Bhutan", "Bouvet Island", "Botswana", "Belarus", "Belize", "Canada", "Cocos (Keeling) Islands", "Congo, The Democratic Republic of the", "Central African Republic", "Congo", "Switzerland", "Cote D'Ivoire", "Cook Islands", "Chile", "Cameroon", "China", "Colombia", "Costa Rica", "Cuba", "Cape Verde", "Christmas Island", "Cyprus", "Czech Republic", "Germany", "Djibouti", "Denmark", "Dominica", "Dominican Republic", "Algeria", "Ecuador", "Estonia", "Egypt", "Western Sahara", "Eritrea", "Spain", "Ethiopia", "Finland", "Fiji", "Falkland Islands (Malvinas)", "Micronesia, Federated States of", "Faroe Islands", "France", "Sint Maarten (Dutch part)", "Gabon", "United Kingdom", "Grenada", "Georgia", "French Guiana", "Ghana", "Gibraltar", "Greenland", "Gambia", "Guinea", "Guadeloupe", "Equatorial Guinea", "Greece", "South Georgia and the South Sandwich Islands", "Guatemala", "Guam", "Guinea-Bissau", "Guyana", "Hong Kong", "Heard Island and McDonald Islands", "Honduras", "Croatia", "Haiti", "Hungary", "Indonesia", "Ireland", "Israel", "India", "British Indian Ocean Territory", "Iraq", "Iran, Islamic Republic of", "Iceland", "Italy", "Jamaica", "Jordan", "Japan", "Kenya", "Kyrgyzstan", "Cambodia", "Kiribati", "Comoros", "Saint Kitts and Nevis", "Korea, Democratic People's Republic of", "Korea, Republic of", "Kuwait", "Cayman Islands", "Kazakhstan", "Lao People's Democratic Republic", "Lebanon", "Saint Lucia", "Liechtenstein", "Sri Lanka", "Liberia", "Lesotho", "Lithuania", "Luxembourg", "Latvia", "Libya", "Morocco", "Monaco", "Moldova, Republic of", "Madagascar", "Marshall Islands", "Macedonia", "Mali", "Myanmar", "Mongolia", "Macau", "Northern Mariana Islands", "Martinique", "Mauritania", "Montserrat", "Malta", "Mauritius", "Maldives", "Malawi", "Mexico", "Malaysia", "Mozambique", "Namibia", "New Caledonia", "Niger", "Norfolk Island", "Nigeria", "Nicaragua", "Netherlands", "Norway", "Nepal", "Nauru", "Niue", "New Zealand", "Oman", "Panama", "Peru", "French Polynesia", "Papua New Guinea", "Philippines", "Pakistan", "Poland", "Saint Pierre and Miquelon", "Pitcairn Islands", "Puerto Rico", "Palestinian Territory", "Portugal", "Palau", "Paraguay", "Qatar", "Reunion", "Romania", "Russian Federation", "Rwanda", "Saudi Arabia", "Solomon Islands", "Seychelles", "Sudan", "Sweden", "Singapore", "Saint Helena", "Slovenia", "Svalbard and Jan Mayen", "Slovakia", "Sierra Leone", "San Marino", "Senegal", "Somalia", "Suriname", "Sao Tome and Principe", "El Salvador", "Syrian Arab Republic", "Swaziland", "Turks and Caicos Islands", "Chad", "French Southern Territories", "Togo", "Thailand", "Tajikistan", "Tokelau", "Turkmenistan", "Tunisia", "Tonga", "Timor-Leste", "Turkey", "Trinidad and Tobago", "Tuvalu", "Taiwan", "Tanzania, United Republic of", "Ukraine", "Uganda", "United States Minor Outlying Islands", "United States", "Uruguay", "Uzbekistan", "Holy See (Vatican City State)", "Saint Vincent and the Grenadines", "Venezuela", "Virgin Islands, British", "Virgin Islands, U.S.", "Vietnam", "Vanuatu", "Wallis and Futuna", "Samoa", "Yemen", "Mayotte", "Serbia", "South Africa", "Zambia", "Montenegro", "Zimbabwe", "Anonymous Proxy", "Satellite Provider", "Other", "Aland Islands", "Guernsey", "Isle of Man", "Jersey", "Saint Barthelemy", "Saint Martin", "Bonaire, Saint Eustatius and Saba", "South Sudan", "Other"};

    public LookupService(String string, String string2) throws IOException {
        this(new File(string));
        this.licenseKey = string2;
        this.dnsService = 1;
    }

    public LookupService(File file, String string) throws IOException {
        this(file);
        this.licenseKey = string;
        this.dnsService = 1;
    }

    public LookupService(int n, String string) throws IOException {
        this.licenseKey = string;
        this.dnsService = 1;
        this.init();
    }

    public LookupService(String string) throws IOException {
        this(new File(string));
    }

    public LookupService(File file) throws IOException {
        this.databaseFile = file;
        this.file = new RandomAccessFile(file, "r");
        this.init();
    }

    public LookupService(String string, int n) throws IOException {
        this(new File(string), n);
    }

    public LookupService(File file, int n) throws IOException {
        this.databaseFile = file;
        this.file = new RandomAccessFile(file, "r");
        this.dboptions = n;
        this.init();
    }

    private void init() throws IOException {
        int n;
        byte[] byArray = new byte[3];
        byte[] byArray2 = new byte[3];
        if (this.file == null) {
            return;
        }
        if ((this.dboptions & 2) != 0) {
            this.mtime = this.databaseFile.lastModified();
        }
        this.file.seek(this.file.length() - 3L);
        for (int i = 0; i < 20; ++i) {
            this.file.readFully(byArray);
            if (byArray[0] == -1 && byArray[1] == -1 && byArray[2] == -1) {
                this.databaseType = this.file.readByte();
                if (this.databaseType >= 106) {
                    this.databaseType = (byte)(this.databaseType - 105);
                }
                if (this.databaseType == 7) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16700000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType == 3) {
                    this.databaseSegments = new int[1];
                    this.databaseSegments[0] = 16000000;
                    this.recordLength = 3;
                    break;
                }
                if (this.databaseType != 6 && this.databaseType != 2 && this.databaseType != 5 && this.databaseType != 23 && this.databaseType != 4 && this.databaseType != 22 && this.databaseType != 11 && this.databaseType != 24 && this.databaseType != 9 && this.databaseType != 21 && this.databaseType != 32 && this.databaseType != 33 && this.databaseType != 31 && this.databaseType != 30) break;
                this.databaseSegments = new int[1];
                this.databaseSegments[0] = 0;
                this.recordLength = this.databaseType == 6 || this.databaseType == 2 || this.databaseType == 21 || this.databaseType == 32 || this.databaseType == 33 || this.databaseType == 31 || this.databaseType == 30 || this.databaseType == 9 ? 3 : 4;
                this.file.readFully(byArray2);
                for (int j = 0; j < 3; ++j) {
                    this.databaseSegments[0] = this.databaseSegments[0] + (LookupService.unsignedByteToInt(byArray2[j]) << j * 8);
                }
                break;
            }
            this.file.seek(this.file.getFilePointer() - 4L);
        }
        if (this.databaseType == 1 || this.databaseType == 12 || this.databaseType == 8 || this.databaseType == 10) {
            this.databaseSegments = new int[1];
            this.databaseSegments[0] = 0xFFFF00;
            this.recordLength = 3;
        }
        if ((this.dboptions & 1) == 1) {
            n = (int)this.file.length();
            this.dbbuffer = new byte[n];
            this.file.seek(0L);
            this.file.readFully(this.dbbuffer, 0, n);
            this.databaseInfo = this.getDatabaseInfo();
            this.file.close();
        }
        if ((this.dboptions & 4) != 0) {
            n = this.databaseSegments[0] * this.recordLength * 2;
            this.index_cache = new byte[n];
            if (this.index_cache != null) {
                this.file.seek(0L);
                this.file.readFully(this.index_cache, 0, n);
            }
        } else {
            this.index_cache = null;
        }
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
            this.file = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Country getCountryV6(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = Inet6Address.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return this.UNKNOWN_COUNTRY;
        }
        return this.getCountryV6(inetAddress);
    }

    public Country getCountry(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return this.UNKNOWN_COUNTRY;
        }
        return this.getCountry(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public synchronized Country getCountry(InetAddress inetAddress) {
        return this.getCountry(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public Country getCountryV6(InetAddress inetAddress) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        int n = this.seekCountryV6(inetAddress) - 0xFFFF00;
        if (n == 0) {
            return this.UNKNOWN_COUNTRY;
        }
        return new Country(countryCode[n], countryName[n]);
    }

    public Country getCountry(long l) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        int n = this.seekCountry(l) - 0xFFFF00;
        if (n == 0) {
            return this.UNKNOWN_COUNTRY;
        }
        return new Country(countryCode[n], countryName[n]);
    }

    public int getID(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return 0;
        }
        return this.getID(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public int getID(InetAddress inetAddress) {
        return this.getID(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public synchronized int getID(long l) {
        if (this.file == null && (this.dboptions & 1) == 0) {
            throw new IllegalStateException("Database has been closed.");
        }
        int n = this.seekCountry(l) - this.databaseSegments[0];
        return n;
    }

    public int last_netmask() {
        return this.last_netmask;
    }

    public void netmask(int n) {
        this.last_netmask = n;
    }

    public synchronized DatabaseInfo getDatabaseInfo() {
        if (this.databaseInfo != null) {
            return this.databaseInfo;
        }
        try {
            int n;
            this._check_mtime();
            boolean bl = false;
            byte[] byArray = new byte[3];
            this.file.seek(this.file.length() - 3L);
            for (n = 0; n < 20; ++n) {
                int n2 = this.file.read(byArray);
                if (n2 == 3 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 255 && (byArray[2] & 0xFF) == 255) {
                    bl = true;
                    break;
                }
                this.file.seek(this.file.getFilePointer() - 4L);
            }
            if (bl) {
                this.file.seek(this.file.getFilePointer() - 6L);
            } else {
                this.file.seek(this.file.length() - 3L);
            }
            for (n = 0; n < 100; ++n) {
                this.file.readFully(byArray);
                if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0) {
                    byte[] byArray2 = new byte[n];
                    this.file.readFully(byArray2);
                    this.databaseInfo = new DatabaseInfo(new String(byArray2));
                    return this.databaseInfo;
                }
                this.file.seek(this.file.getFilePointer() - 4L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new DatabaseInfo("");
    }

    synchronized void _check_mtime() {
        try {
            long l;
            if ((this.dboptions & 2) != 0 && (l = this.databaseFile.lastModified()) != this.mtime) {
                this.close();
                this.file = new RandomAccessFile(this.databaseFile, "r");
                this.databaseInfo = null;
                this.init();
            }
        }
        catch (IOException iOException) {
            System.out.println("file not found");
        }
    }

    public Location getLocationV6(String string) {
        if (this.dnsService == 0) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
            return this.getLocationV6(inetAddress);
        }
        String string2 = this.getDnsAttributes(string);
        return this.getLocationwithdnsservice(string2);
    }

    public Location getLocation(InetAddress inetAddress) {
        return this.getLocation(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public Location getLocation(String string) {
        if (this.dnsService == 0) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                return null;
            }
            return this.getLocation(inetAddress);
        }
        String string2 = this.getDnsAttributes(string);
        return this.getLocationwithdnsservice(string2);
    }

    String getDnsAttributes(String string) {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            hashtable.put("java.naming.provider.url", "dns://ws1.maxmind.com/");
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            Attributes attributes = initialDirContext.getAttributes(this.licenseKey + "." + string + ".s.maxmind.com", new String[]{"txt"});
            String string2 = attributes.get("txt").get().toString();
            return string2;
        }
        catch (NamingException namingException) {
            System.out.println("DNS error");
            return null;
        }
    }

    public Location getLocationwithdnsservice(String string) {
        Location location = new Location();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=\"");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            if (string2.equals("co")) {
                Integer n = (Integer)hashmapcountryCodetoindex.get(string3);
                location.countryCode = string3;
                location.countryName = countryName[n];
            }
            if (string2.equals("ci")) {
                location.city = string3;
            }
            if (string2.equals("re")) {
                location.region = string3;
            }
            if (string2.equals("zi")) {
                location.postalCode = string3;
            }
            if (string2.equals("la")) {
                try {
                    location.latitude = Float.parseFloat(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    location.latitude = 0.0f;
                }
            }
            if (string2.equals("lo")) {
                try {
                    location.longitude = Float.parseFloat(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    location.latitude = 0.0f;
                }
            }
            if (string2.equals("dm") || string2.equals("me")) {
                try {
                    location.metro_code = location.dma_code = Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    location.dma_code = 0;
                    location.metro_code = 0;
                }
            }
            if (!string2.equals("ac")) continue;
            try {
                location.area_code = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                location.area_code = 0;
            }
        }
        return location;
    }

    public synchronized Region getRegion(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return this.getRegion(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public synchronized Region getRegion(long l) {
        Region region = new Region();
        int n = 0;
        if (this.databaseType == 7) {
            n = this.seekCountry(l) - 16700000;
            char[] cArray = new char[2];
            if (n >= 1000) {
                region.countryCode = "US";
                region.countryName = "United States";
                cArray[0] = (char)((n - 1000) / 26 + 65);
                cArray[1] = (char)((n - 1000) % 26 + 65);
                region.region = new String(cArray);
            } else {
                region.countryCode = countryCode[n];
                region.countryName = countryName[n];
                region.region = "";
            }
        } else if (this.databaseType == 3) {
            n = this.seekCountry(l) - 16000000;
            char[] cArray = new char[2];
            if (n < 1) {
                region.countryCode = "";
                region.countryName = "";
                region.region = "";
            } else if (n < 677) {
                region.countryCode = "US";
                region.countryName = "United States";
                cArray[0] = (char)((n - 1) / 26 + 65);
                cArray[1] = (char)((n - 1) % 26 + 65);
                region.region = new String(cArray);
            } else if (n < 1353) {
                region.countryCode = "CA";
                region.countryName = "Canada";
                cArray[0] = (char)((n - 677) / 26 + 65);
                cArray[1] = (char)((n - 677) % 26 + 65);
                region.region = new String(cArray);
            } else {
                region.countryCode = countryCode[(n - 1353) / 360];
                region.countryName = countryName[(n - 1353) / 360];
                region.region = "";
            }
        }
        return region;
    }

    public synchronized Location getLocationV6(InetAddress inetAddress) {
        byte[] byArray = new byte[60];
        int n = 0;
        Location location = new Location();
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        try {
            int n3;
            int n4 = this.seekCountryV6(inetAddress);
            if (n4 == this.databaseSegments[0]) {
                return null;
            }
            int n5 = n4 + (2 * this.recordLength - 1) * this.databaseSegments[0];
            if ((this.dboptions & 1) == 1) {
                System.arraycopy(this.dbbuffer, n5, byArray, 0, Math.min(this.dbbuffer.length - n5, 60));
            } else {
                this.file.seek(n5);
                this.file.readFully(byArray);
            }
            location.countryCode = countryCode[LookupService.unsignedByteToInt(byArray[0])];
            location.countryName = countryName[LookupService.unsignedByteToInt(byArray[0])];
            ++n;
            while (byArray[n + n2] != 0) {
                ++n2;
            }
            if (n2 > 0) {
                location.region = new String(byArray, n, n2);
            }
            n += n2 + 1;
            n2 = 0;
            while (byArray[n + n2] != 0) {
                ++n2;
            }
            if (n2 > 0) {
                location.city = new String(byArray, n, n2, "ISO-8859-1");
            }
            n += n2 + 1;
            n2 = 0;
            while (byArray[n + n2] != 0) {
                ++n2;
            }
            if (n2 > 0) {
                location.postalCode = new String(byArray, n, n2);
            }
            n += n2 + 1;
            for (n3 = 0; n3 < 3; ++n3) {
                d += (double)(LookupService.unsignedByteToInt(byArray[n + n3]) << n3 * 8);
            }
            location.latitude = (float)d / 10000.0f - 180.0f;
            n += 3;
            for (n3 = 0; n3 < 3; ++n3) {
                d2 += (double)(LookupService.unsignedByteToInt(byArray[n + n3]) << n3 * 8);
            }
            location.longitude = (float)d2 / 10000.0f - 180.0f;
            location.metro_code = 0;
            location.dma_code = 0;
            location.area_code = 0;
            if (this.databaseType == 2) {
                int n6 = 0;
                if (location.countryCode == "US") {
                    n += 3;
                    for (n3 = 0; n3 < 3; ++n3) {
                        n6 += LookupService.unsignedByteToInt(byArray[n + n3]) << n3 * 8;
                    }
                    location.metro_code = location.dma_code = n6 / 1000;
                    location.area_code = n6 % 1000;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("IO Exception while seting up segments");
        }
        return location;
    }

    public synchronized Location getLocation(long l) {
        byte[] byArray = new byte[60];
        int n = 0;
        Location location = new Location();
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        try {
            int n3;
            int n4 = this.seekCountry(l);
            if (n4 == this.databaseSegments[0]) {
                return null;
            }
            int n5 = n4 + (2 * this.recordLength - 1) * this.databaseSegments[0];
            if ((this.dboptions & 1) == 1) {
                System.arraycopy(this.dbbuffer, n5, byArray, 0, Math.min(this.dbbuffer.length - n5, 60));
            } else {
                this.file.seek(n5);
                this.file.readFully(byArray);
            }
            location.countryCode = countryCode[LookupService.unsignedByteToInt(byArray[0])];
            location.countryName = countryName[LookupService.unsignedByteToInt(byArray[0])];
            ++n;
            while (byArray[n + n2] != 0) {
                ++n2;
            }
            if (n2 > 0) {
                location.region = new String(byArray, n, n2);
            }
            n += n2 + 1;
            n2 = 0;
            while (byArray[n + n2] != 0) {
                ++n2;
            }
            if (n2 > 0) {
                location.city = new String(byArray, n, n2, "ISO-8859-1");
            }
            n += n2 + 1;
            n2 = 0;
            while (byArray[n + n2] != 0) {
                ++n2;
            }
            if (n2 > 0) {
                location.postalCode = new String(byArray, n, n2);
            }
            n += n2 + 1;
            for (n3 = 0; n3 < 3; ++n3) {
                d += (double)(LookupService.unsignedByteToInt(byArray[n + n3]) << n3 * 8);
            }
            location.latitude = (float)d / 10000.0f - 180.0f;
            n += 3;
            for (n3 = 0; n3 < 3; ++n3) {
                d2 += (double)(LookupService.unsignedByteToInt(byArray[n + n3]) << n3 * 8);
            }
            location.longitude = (float)d2 / 10000.0f - 180.0f;
            location.metro_code = 0;
            location.dma_code = 0;
            location.area_code = 0;
            if (this.databaseType == 2) {
                int n6 = 0;
                if (location.countryCode == "US") {
                    n += 3;
                    for (n3 = 0; n3 < 3; ++n3) {
                        n6 += LookupService.unsignedByteToInt(byArray[n + n3]) << n3 * 8;
                    }
                    location.metro_code = location.dma_code = n6 / 1000;
                    location.area_code = n6 % 1000;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("IO Exception while seting up segments");
        }
        return location;
    }

    public String getOrg(InetAddress inetAddress) {
        return this.getOrg(LookupService.bytesToLong(inetAddress.getAddress()));
    }

    public String getOrg(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return this.getOrg(inetAddress);
    }

    public synchronized String getOrg(long l) {
        int n = 0;
        byte[] byArray = new byte[300];
        try {
            int n2 = this.seekCountry(l);
            if (n2 == this.databaseSegments[0]) {
                return null;
            }
            int n3 = n2 + (2 * this.recordLength - 1) * this.databaseSegments[0];
            if ((this.dboptions & 1) == 1) {
                System.arraycopy(this.dbbuffer, n3, byArray, 0, Math.min(this.dbbuffer.length - n3, 300));
            } else {
                this.file.seek(n3);
                try {
                    this.file.readFully(byArray);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            while (byArray[n] != 0) {
                ++n;
            }
            String string = new String(byArray, 0, n, "ISO-8859-1");
            return string;
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            return null;
        }
    }

    public String getOrgV6(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return this.getOrgV6(inetAddress);
    }

    public synchronized String getOrgV6(InetAddress inetAddress) {
        int n = 0;
        byte[] byArray = new byte[300];
        try {
            int n2 = this.seekCountryV6(inetAddress);
            if (n2 == this.databaseSegments[0]) {
                return null;
            }
            int n3 = n2 + (2 * this.recordLength - 1) * this.databaseSegments[0];
            if ((this.dboptions & 1) == 1) {
                System.arraycopy(this.dbbuffer, n3, byArray, 0, Math.min(this.dbbuffer.length - n3, 300));
            } else {
                this.file.seek(n3);
                this.file.readFully(byArray);
            }
            while (byArray[n] != 0) {
                ++n;
            }
            String string = new String(byArray, 0, n, "ISO-8859-1");
            return string;
        }
        catch (IOException iOException) {
            System.out.println("IO Exception");
            return null;
        }
    }

    private synchronized int seekCountryV6(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        byte[] byArray2 = new byte[8];
        int[] nArray = new int[2];
        int n = 0;
        this._check_mtime();
        for (int i = 127; i >= 0; --i) {
            int n2;
            int n3;
            int n4;
            if ((this.dboptions & 1) == 1) {
                for (n4 = 0; n4 < 8; ++n4) {
                    byArray2[n4] = this.dbbuffer[2 * this.recordLength * n + n4];
                }
            } else if ((this.dboptions & 4) != 0) {
                for (n4 = 0; n4 < 8; ++n4) {
                    byArray2[n4] = this.index_cache[2 * this.recordLength * n + n4];
                }
            } else {
                try {
                    this.file.seek(2 * this.recordLength * n);
                    this.file.readFully(byArray2);
                }
                catch (IOException iOException) {
                    System.out.println("IO Exception");
                }
            }
            for (n4 = 0; n4 < 2; ++n4) {
                nArray[n4] = 0;
                for (n3 = 0; n3 < this.recordLength; ++n3) {
                    n2 = byArray2[n4 * this.recordLength + n3];
                    if (n2 < 0) {
                        n2 += 256;
                    }
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + (n2 << n3 * 8);
                }
            }
            n4 = 127 - i;
            n3 = n4 >> 3;
            n2 = 1 << (n4 & 7 ^ 7);
            if ((byArray[n3] & n2) > 0) {
                if (nArray[1] >= this.databaseSegments[0]) {
                    this.last_netmask = 128 - i;
                    return nArray[1];
                }
                n = nArray[1];
                continue;
            }
            if (nArray[0] >= this.databaseSegments[0]) {
                this.last_netmask = 128 - i;
                return nArray[0];
            }
            n = nArray[0];
        }
        System.err.println("Error seeking country while seeking " + inetAddress.getHostAddress());
        return 0;
    }

    private synchronized int seekCountry(long l) {
        byte[] byArray = new byte[8];
        int[] nArray = new int[2];
        int n = 0;
        this._check_mtime();
        for (int i = 31; i >= 0; --i) {
            int n2;
            if ((this.dboptions & 1) == 1) {
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray[n2] = this.dbbuffer[2 * this.recordLength * n + n2];
                }
            } else if ((this.dboptions & 4) != 0) {
                for (n2 = 0; n2 < 8; ++n2) {
                    byArray[n2] = this.index_cache[2 * this.recordLength * n + n2];
                }
            } else {
                try {
                    this.file.seek(2 * this.recordLength * n);
                    this.file.readFully(byArray);
                }
                catch (IOException iOException) {
                    System.out.println("IO Exception");
                }
            }
            for (n2 = 0; n2 < 2; ++n2) {
                nArray[n2] = 0;
                for (int j = 0; j < this.recordLength; ++j) {
                    int n3 = byArray[n2 * this.recordLength + j];
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    int n4 = n2;
                    nArray[n4] = nArray[n4] + (n3 << j * 8);
                }
            }
            if ((l & (long)(1 << i)) > 0L) {
                if (nArray[1] >= this.databaseSegments[0]) {
                    this.last_netmask = 32 - i;
                    return nArray[1];
                }
                n = nArray[1];
                continue;
            }
            if (nArray[0] >= this.databaseSegments[0]) {
                this.last_netmask = 32 - i;
                return nArray[0];
            }
            n = nArray[0];
        }
        System.err.println("Error seeking country while seeking " + l);
        return 0;
    }

    private static long bytesToLong(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < 4; ++i) {
            long l2 = byArray[i];
            if (l2 < 0L) {
                l2 += 256L;
            }
            l += l2 << (3 - i) * 8;
        }
        return l;
    }

    private static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    static {
        if (countryCode.length != countryName.length) {
            throw new AssertionError((Object)"countryCode.length!=countryName.length");
        }
        for (int i = 0; i < countryCode.length; ++i) {
            hashmapcountryCodetoindex.put(countryCode[i], i);
            hashmapcountryNametoindex.put(countryName[i], i);
        }
    }
}

