/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.mediacasterstreammanager;

import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamManager;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.vhost.IVHost;
import java.util.TreeSet;

public class ModuleMediaCasterStreamManager
extends ModuleBase {
    String mediaCasterStreamManagerPassword = null;
    IApplicationInstance appInstance = null;

    public void onAppStart(IApplicationInstance appInstance) {
        this.appInstance = appInstance;
        WMSProperties props = appInstance.getProperties();
        this.mediaCasterStreamManagerPassword = props.getPropertyStr("mediaCasterStreamManagerPassword", this.mediaCasterStreamManagerPassword);
        if (this.mediaCasterStreamManagerPassword == null) {
            ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.onAppStart: The mediaCasterStreamManagerPassword property is missing. This property must be set in Application.xml");
        }
    }

    public void getMediaCasterStreamList(IClient client, RequestFunction function, AMFDataList params) {
        AMFDataArray ret = new AMFDataArray();
        try {
            int param = 3;
            if (ModuleUtils.checkModulePassword((AMFDataList)params, (int)param, (String)this.mediaCasterStreamManagerPassword)) {
                IApplicationInstance appInstance = client.getAppInstance();
                MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
                MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
                TreeSet sortedNames = new TreeSet(mediaCasterStreamManager.getStreamList());
                for (String streamName : sortedNames) {
                    ret.add((AMFData)new AMFDataItem(streamName));
                }
            }
        }
        catch (Exception e) {
            ModuleMediaCasterStreamManager.getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: " + e.toString());
        }
        ModuleMediaCasterStreamManager.sendResult((IClient)client, (AMFDataList)params, (AMFData)ret);
    }

    public boolean startMediaCasterStream(String streamName, String mediaCasterType) {
        boolean success = false;
        try {
            MediaCasterStreamMap mediaCasterMap = this.appInstance.getMediaCasterStreams();
            IVHost vhost = this.appInstance.getVHost();
            MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
            MediaCasterList mediaCasterList = vhost.getMediaCasterList();
            MediaCasterItem mediaCasterDef = mediaCasterList.getMediaCasterDef(mediaCasterType);
            if (mediaCasterDef == null) {
                ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster type not found: " + mediaCasterType);
            } else {
                MediaCasterStreamItem mediaCasterStream = mediaCasterMap.getMediaCaster(streamName);
                if (mediaCasterStream != null) {
                    ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster already exists[mediacaster]: " + streamName);
                } else {
                    success = mediaCasterStreamManager.startStream(streamName, mediaCasterType);
                    if (success) {
                        ModuleMediaCasterStreamManager.getLogger().info("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream started: " + streamName);
                    } else {
                        ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream start failed: " + streamName);
                    }
                }
            }
        }
        catch (Exception e) {
            ModuleMediaCasterStreamManager.getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: " + e.toString());
        }
        return success;
    }

    public void startMediaCasterStream(IClient client, RequestFunction function, AMFDataList params) {
        AMFDataObj resultObj = new AMFDataObj();
        resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Success");
        try {
            String streamName = null;
            String mediaCasterType = null;
            int param = 3;
            if (!ModuleUtils.checkModulePassword((AMFDataList)params, (int)param, (String)this.mediaCasterStreamManagerPassword)) {
                resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
                resultObj.put("description", "Security failure.");
            } else {
                if (++param < params.size()) {
                    streamName = params.getString(param);
                }
                if (streamName == null) {
                    ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream name not specified: " + streamName);
                    resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
                    resultObj.put("description", "Stream name not specified: " + streamName);
                } else {
                    if (++param < params.size()) {
                        mediaCasterType = params.getString(param).trim();
                    }
                    if (mediaCasterType == null) {
                        ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster type not specified: " + mediaCasterType);
                        resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
                        resultObj.put("description", "MediaCaster type not specified: " + mediaCasterType);
                    } else {
                        ModuleMediaCasterStreamManager.getLogger().info("ModuleMediaCasterStreamManager.startMediaCasterStream[" + mediaCasterType + "]: " + streamName);
                        IApplicationInstance appInstance = client.getAppInstance();
                        MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
                        IVHost vhost = appInstance.getVHost();
                        MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
                        MediaCasterList mediaCasterList = vhost.getMediaCasterList();
                        MediaCasterItem mediaCasterDef = mediaCasterList.getMediaCasterDef(mediaCasterType);
                        if (mediaCasterDef == null) {
                            ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster type not found: " + mediaCasterType);
                            resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
                            resultObj.put("description", "MediaCaster type not found: " + mediaCasterType);
                        } else {
                            MediaCasterStreamItem mediaCasterStream = mediaCasterMap.getMediaCaster(streamName);
                            if (mediaCasterStream != null) {
                                ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster already exists[mediacaster]: " + streamName);
                                resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
                                resultObj.put("description", "MediaCaster already exists[mediacaster]: " + streamName);
                            } else {
                                boolean success = mediaCasterStreamManager.startStream(streamName, mediaCasterType);
                                if (success) {
                                    ModuleMediaCasterStreamManager.getLogger().info("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream started: " + streamName);
                                    resultObj.put("description", "Stream started: " + streamName);
                                } else {
                                    resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
                                    resultObj.put("description", "MediaCaster could not be started: " + streamName);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ModuleMediaCasterStreamManager.getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: " + e.toString());
            resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
            resultObj.put("description", e.toString());
        }
        ModuleMediaCasterStreamManager.sendResult((IClient)client, (AMFDataList)params, (AMFData)resultObj);
    }

    public void stopMediaCasterStream(String streamName) {
        try {
            MediaCasterStreamMap mediaCasterMap = this.appInstance.getMediaCasterStreams();
            MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
            boolean success = mediaCasterStreamManager.stopStream(streamName);
            if (success) {
                ModuleMediaCasterStreamManager.getLogger().info("ModuleStreamStarter.stopMediaCasterStream: Stream stopped: " + streamName);
            } else {
                ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.stopMediaCasterStream: Stream not found: " + streamName);
            }
        }
        catch (Exception e) {
            ModuleMediaCasterStreamManager.getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: " + e.toString());
        }
    }

    public void stopMediaCasterStream(IClient client, RequestFunction function, AMFDataList params) {
        AMFDataObj resultObj = new AMFDataObj();
        resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Success");
        try {
            String streamName = null;
            int param = 3;
            if (!ModuleUtils.checkModulePassword((AMFDataList)params, (int)param, (String)this.mediaCasterStreamManagerPassword)) {
                resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
                resultObj.put("description", "Security failure.");
            } else {
                if (++param < params.size()) {
                    streamName = params.getString(param).trim();
                }
                if (streamName == null) {
                    ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.stopMediaCasterStream: Stream name not specified: " + streamName);
                    resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
                    resultObj.put("description", "Stream name not specified: " + streamName);
                } else {
                    ModuleMediaCasterStreamManager.getLogger().info("ModuleMediaCasterStreamManager.stopMediaCasterStream: " + streamName);
                    IApplicationInstance appInstance = client.getAppInstance();
                    MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
                    MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
                    boolean success = mediaCasterStreamManager.stopStream(streamName);
                    if (success) {
                        ModuleMediaCasterStreamManager.getLogger().info("ModuleStreamStarter.stopMediaCasterStream: Stream stopped: " + streamName);
                        resultObj.put("description", "Stream stopped: " + streamName);
                    } else {
                        ModuleMediaCasterStreamManager.getLogger().warn("ModuleMediaCasterStreamManager.stopMediaCasterStream: Stream not found: " + streamName);
                        resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
                        resultObj.put("description", "Stream not found: " + streamName);
                    }
                }
            }
        }
        catch (Exception e) {
            ModuleMediaCasterStreamManager.getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: " + e.toString());
            resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
            resultObj.put("description", e.toString());
        }
        ModuleMediaCasterStreamManager.sendResult((IClient)client, (AMFDataList)params, (AMFData)resultObj);
    }
}

