package com.wowza.wms.plugin.mediacasterstreammanager;

import java.util.*;

import com.wowza.wms.amf.*;
import com.wowza.wms.client.*;
import com.wowza.wms.module.*;
import com.wowza.wms.mediacaster.*;
import com.wowza.wms.request.*;
import com.wowza.wms.vhost.*;
import com.wowza.wms.application.*;
import com.wowza.wms.util.*;

public class ModuleMediaCasterStreamManager extends ModuleBase
{
	String mediaCasterStreamManagerPassword = null;
	IApplicationInstance appInstance = null;
	
	public void onAppStart(IApplicationInstance appInstance)
	{
		this.appInstance = appInstance;

		WMSProperties props = appInstance.getProperties();
		this.mediaCasterStreamManagerPassword = props.getPropertyStr("mediaCasterStreamManagerPassword", this.mediaCasterStreamManagerPassword);
		if (this.mediaCasterStreamManagerPassword == null)
			getLogger().warn("ModuleMediaCasterStreamManager.onAppStart: The mediaCasterStreamManagerPassword property is missing. This property must be set in Application.xml");
	}
	
	public void getMediaCasterStreamList(IClient client, RequestFunction function, AMFDataList params)
	{
		AMFDataArray ret = new AMFDataArray();
		try
		{
			while(true)
			{				
				int param = PARAM1;
				if (!ModuleUtils.checkModulePassword(params, param, mediaCasterStreamManagerPassword))
					break;
				
				IApplicationInstance appInstance = client.getAppInstance();
				MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
				MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
				
				SortedSet<String> sortedNames = new TreeSet(mediaCasterStreamManager.getStreamList());
				Iterator<String> iter = sortedNames.iterator();
				while(iter.hasNext())
				{
					String streamName = iter.next();
					ret.add(new AMFDataItem(streamName));
				}
				break;
			}
		}
		catch (Exception e)
		{
			getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: "+e.toString());
		}
		
		sendResult(client, params, ret);
	}
	
	public boolean startMediaCasterStream(String streamName, String mediaCasterType)
	{
		boolean success = false;
		try
		{
			while(true)
			{
				MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
				IVHost vhost = appInstance.getVHost();
				MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
				
				MediaCasterList mediaCasterList = vhost.getMediaCasterList();
				MediaCasterItem mediaCasterDef = mediaCasterList.getMediaCasterDef(mediaCasterType);
				
				if (mediaCasterDef == null)
				{
					getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster type not found: "+mediaCasterType);
					break;
				}
				
				MediaCasterStreamItem mediaCasterStream = mediaCasterMap.getMediaCaster(streamName);
				if (mediaCasterStream != null)
				{
					getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster already exists[mediacaster]: "+streamName);
					break;
				}
				
				success = mediaCasterStreamManager.startStream(streamName, mediaCasterType);
				if (success)
					getLogger().info("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream started: "+streamName);
				else
					getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream start failed: "+streamName);
				break;
			}
		}
		catch (Exception e)
		{
			getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: "+e.toString());
		}
		
		return success;
	}
		
	public void startMediaCasterStream(IClient client, RequestFunction function, AMFDataList params)
	{
		AMFDataObj resultObj = new AMFDataObj();
		resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Success");
				
		try
		{
			while(true)
			{
				
				String streamName = null;
				String mediaCasterType = null;
				
				int param = PARAM1;
				if (!ModuleUtils.checkModulePassword(params, param, mediaCasterStreamManagerPassword))
				{
					resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
					resultObj.put("description", "Security failure.");
					break;
				}
				
				param++;
				if (param < params.size())
				{
					streamName = params.getString(param);
				}

				if (streamName == null)
				{
					getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream name not specified: "+streamName);
					resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
					resultObj.put("description", "Stream name not specified: "+streamName);
					break;
				}

				param++;
				if (param < params.size())
				{
					mediaCasterType = params.getString(param).trim();
				}

				if (mediaCasterType == null)
				{
					getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster type not specified: "+mediaCasterType);
					resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
					resultObj.put("description", "MediaCaster type not specified: "+mediaCasterType);
					break;
				}

				getLogger().info("ModuleMediaCasterStreamManager.startMediaCasterStream["+mediaCasterType+"]: "+streamName);
		
				IApplicationInstance appInstance = client.getAppInstance();
				MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
				IVHost vhost = appInstance.getVHost();
				MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();
				
				MediaCasterList mediaCasterList = vhost.getMediaCasterList();
				MediaCasterItem mediaCasterDef = mediaCasterList.getMediaCasterDef(mediaCasterType);
				
				if (mediaCasterDef == null)
				{
					getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster type not found: "+mediaCasterType);
					resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
					resultObj.put("description", "MediaCaster type not found: "+mediaCasterType);
					break;
				}
				
				MediaCasterStreamItem mediaCasterStream = mediaCasterMap.getMediaCaster(streamName);
				if (mediaCasterStream != null)
				{
					getLogger().warn("ModuleMediaCasterStreamManager.startMediaCasterStream: MediaCaster already exists[mediacaster]: "+streamName);
					resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
					resultObj.put("description", "MediaCaster already exists[mediacaster]: "+streamName);
					break;
				}
				
				boolean success = mediaCasterStreamManager.startStream(streamName, mediaCasterType);
				if (success)
				{
					getLogger().info("ModuleMediaCasterStreamManager.startMediaCasterStream: Stream started: "+streamName);
					resultObj.put("description", "Stream started: "+streamName);
				}
				else
				{
					resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
					resultObj.put("description", "MediaCaster could not be started: "+streamName);
				}
				break;
			}
		}
		catch (Exception e)
		{
			getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: "+e.toString());
			resultObj.put("code", "ModuleMediaCasterStreamManager.StartStream.Failed");
			resultObj.put("description", e.toString());
		}
		sendResult(client, params, resultObj);
	}
	
	public void stopMediaCasterStream(String streamName)
	{
		try
		{
			while(true)
			{
				MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
				MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();

				boolean success = mediaCasterStreamManager.stopStream(streamName);
				if (success)
				{
					getLogger().info("ModuleStreamStarter.stopMediaCasterStream: Stream stopped: "+streamName);
				}
				else
				{
					getLogger().warn("ModuleMediaCasterStreamManager.stopMediaCasterStream: Stream not found: "+streamName);
				}
				break;
			}
		}
		catch (Exception e)
		{
			getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: "+e.toString());
		}
	}
	
	public void stopMediaCasterStream(IClient client, RequestFunction function, AMFDataList params)
	{
		AMFDataObj resultObj = new AMFDataObj();
		resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Success");
		
		try
		{
			while(true)
			{
				
				String streamName = null;
				
				int param = PARAM1;
				if (!ModuleUtils.checkModulePassword(params, param, mediaCasterStreamManagerPassword))
				{
					resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
					resultObj.put("description", "Security failure.");
					break;
				}
				
				param++;
				if (param < params.size())
				{
					streamName = params.getString(param).trim();
				}

				if (streamName == null)
				{
					getLogger().warn("ModuleMediaCasterStreamManager.stopMediaCasterStream: Stream name not specified: "+streamName);
					resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
					resultObj.put("description", "Stream name not specified: "+streamName);
					break;
				}

				getLogger().info("ModuleMediaCasterStreamManager.stopMediaCasterStream: "+streamName);
						
				IApplicationInstance appInstance = client.getAppInstance();
				MediaCasterStreamMap mediaCasterMap = appInstance.getMediaCasterStreams();
				MediaCasterStreamManager mediaCasterStreamManager = mediaCasterMap.getStreamManager();

				boolean success = mediaCasterStreamManager.stopStream(streamName);
				if (success)
				{
					getLogger().info("ModuleStreamStarter.stopMediaCasterStream: Stream stopped: "+streamName);
					resultObj.put("description", "Stream stopped: "+streamName);
				}
				else
				{
					getLogger().warn("ModuleMediaCasterStreamManager.stopMediaCasterStream: Stream not found: "+streamName);
					resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
					resultObj.put("description", "Stream not found: "+streamName);
				}
				break;
			}
		}
		catch (Exception e)
		{
			getLogger().error("ModuleMediaCasterStreamManager.startMediaCasterStream: "+e.toString());
			resultObj.put("code", "ModuleMediaCasterStreamManager.StopStream.Failed");
			resultObj.put("description", e.toString());
		}
		sendResult(client, params, resultObj);
	}
}
