/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.stream.live;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerRunner
implements Runnable {
    public static final int COMMAND_PACKET = 1;
    public static final int COMMAND_RESETSTREAM = 2;
    private ThreadPool threadPool = null;
    private Map<String, ILiveStreamPacketizer> liveStreamPacektizers = null;
    private List<PacketHolder> packets = new ArrayList<PacketHolder>();
    private boolean isRunning = false;
    private Object lock = new Object();
    private int maxCycleCount = 20;
    private IMediaStream stream = null;
    private List<String> names = new ArrayList<String>();
    private boolean sendAudioCodecConfig = true;
    private boolean sendVideoCodecConfig = true;

    public LiveStreamPacketizerRunner(IMediaStream iMediaStream, ThreadPool threadPool) {
        this.threadPool = threadPool;
        this.stream = iMediaStream;
    }

    public void setLiveStreamPacketizers(Map<String, ILiveStreamPacketizer> map) {
        this.liveStreamPacektizers = map;
        this.names.clear();
        this.names.addAll(map.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimecodes() {
        Object object = this.lock;
        synchronized (object) {
            this.packets.add(new PacketHolder(2));
            if (!this.isRunning) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePacket(AMFPacket aMFPacket) {
        Object object = this.lock;
        synchronized (object) {
            this.packets.add(new PacketHolder(aMFPacket));
            if (!this.isRunning) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kickIt() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning && this.packets.size() > 0) {
                this.isRunning = true;
                this.threadPool.execute((Runnable)this);
            }
        }
    }

    public int getMaxCycleCount() {
        return this.maxCycleCount;
    }

    public void setMaxCycleCount(int n) {
        this.maxCycleCount = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        boolean bl = false;
        while (true) {
            try {
                do {
                    PacketHolder packetHolder = null;
                    Object object = this.lock;
                    synchronized (object) {
                        if (++n > this.maxCycleCount) {
                            bl = true;
                        } else if (this.packets.size() > 0) {
                            packetHolder = this.packets.remove(0);
                        } else {
                            bl = true;
                        }
                    }
                    object = this.stream.getName();
                    MediaStreamMap mediaStreamMap = this.stream.getStreams();
                    if (packetHolder == null) continue;
                    for (String string : this.names) {
                        ILiveStreamPacketizer iLiveStreamPacketizer = this.liveStreamPacektizers.get(string);
                        ILiveStreamPacketizer iLiveStreamPacketizer2 = mediaStreamMap.getLiveStreamPacketizer((String)object, string, true);
                        if (iLiveStreamPacketizer2 == null) continue;
                        if (iLiveStreamPacketizer2 != iLiveStreamPacketizer) {
                            iLiveStreamPacketizer2.startStream(this.stream);
                            this.liveStreamPacektizers.put(string, iLiveStreamPacketizer2);
                            this.sendAudioCodecConfig = true;
                            this.sendVideoCodecConfig = true;
                        }
                        if (packetHolder.command == 1) {
                            AMFPacket aMFPacket = null;
                            if (this.sendAudioCodecConfig || this.sendVideoCodecConfig) {
                                int n2;
                                int n3 = packetHolder.packet.getType();
                                if (this.sendAudioCodecConfig && n3 == 8) {
                                    this.sendAudioCodecConfig = false;
                                    if (packetHolder.packet.getSize() <= 0) {
                                        this.sendAudioCodecConfig = true;
                                    } else {
                                        n2 = FLVUtils.getAudioCodec((AMFPacket)packetHolder.packet);
                                        if (n2 == 10 && !FLVUtils.isAudioCodecConfig((AMFPacket)packetHolder.packet) && (aMFPacket = this.stream.getAudioCodecConfigPacket(packetHolder.packet.getAbsTimecode())) == null) {
                                            this.sendAudioCodecConfig = true;
                                        }
                                    }
                                } else if (this.sendVideoCodecConfig && n3 == 9) {
                                    this.sendVideoCodecConfig = false;
                                    if (packetHolder.packet.getSize() <= 0) {
                                        this.sendVideoCodecConfig = true;
                                    } else {
                                        n2 = FLVUtils.getVideoCodec((AMFPacket)packetHolder.packet);
                                        if (n2 == 7 && !FLVUtils.isVideoCodecConfig((AMFPacket)packetHolder.packet) && (aMFPacket = this.stream.getVideoCodecConfigPacket(packetHolder.packet.getAbsTimecode())) == null) {
                                            this.sendVideoCodecConfig = true;
                                        }
                                    }
                                }
                            }
                            if (aMFPacket != null) {
                                AMFPacket aMFPacket2 = new AMFPacket(aMFPacket.getType(), aMFPacket.getSrc(), aMFPacket.getSize());
                                aMFPacket2.setAbsTimecode(packetHolder.packet.getAbsTimecode());
                                aMFPacket2.addData(aMFPacket.getData(), 0, aMFPacket.getSize());
                                iLiveStreamPacketizer2.handlePacket(this.stream, aMFPacket2);
                            }
                            iLiveStreamPacketizer2.handlePacket(this.stream, packetHolder.packet);
                            continue;
                        }
                        if (packetHolder.command != 2) continue;
                        this.sendAudioCodecConfig = true;
                        this.sendVideoCodecConfig = true;
                        iLiveStreamPacketizer2.resetStream(this.stream);
                    }
                } while (!bl);
                Object object = this.lock;
                synchronized (object) {
                    this.isRunning = false;
                    this.kickIt();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerRunner.class).error("LiveStreamPacketizerRunner.run: " + exception.toString());
                continue;
            }
            break;
        }
    }

    class PacketHolder {
        AMFPacket packet = null;
        int command = 1;

        public PacketHolder(int n) {
            this.command = n;
        }

        public PacketHolder(AMFPacket aMFPacket) {
            this.packet = aMFPacket;
            this.command = 1;
        }
    }
}

