/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class TelnetAppender
extends AppenderSkeleton {
    private SocketHandler sh;
    private int port = 23;

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            this.sh = new SocketHandler(this.port);
            this.sh.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        super.activateOptions();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void close() {
        if (this.sh != null) {
            this.sh.close();
            try {
                this.sh.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void append(LoggingEvent loggingEvent) {
        String[] stringArray;
        this.sh.send(this.layout.format(loggingEvent));
        if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                this.sh.send(stringArray[i]);
                this.sh.send(Layout.LINE_SEP);
            }
        }
    }

    protected class SocketHandler
    extends Thread {
        private Vector writers = new Vector();
        private Vector connections = new Vector();
        private ServerSocket serverSocket;
        private int MAX_CONNECTIONS = 20;

        public void finalize() {
            this.close();
        }

        public void close() {
            Enumeration enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((Socket)enumeration.nextElement()).close();
                }
                catch (Exception exception) {}
            }
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void send(String string) {
            Enumeration enumeration = this.connections.elements();
            Enumeration enumeration2 = this.writers.elements();
            while (enumeration2.hasMoreElements()) {
                Socket socket = (Socket)enumeration.nextElement();
                PrintWriter printWriter = (PrintWriter)enumeration2.nextElement();
                printWriter.print(string);
                if (!printWriter.checkError()) continue;
                this.connections.remove(socket);
                this.writers.remove(printWriter);
            }
        }

        public void run() {
            while (!this.serverSocket.isClosed()) {
                try {
                    Socket socket = this.serverSocket.accept();
                    PrintWriter printWriter = new PrintWriter(socket.getOutputStream());
                    if (this.connections.size() < this.MAX_CONNECTIONS) {
                        this.connections.addElement(socket);
                        this.writers.addElement(printWriter);
                        printWriter.print("TelnetAppender v1.0 (" + this.connections.size() + " active connections)\r\n\r\n");
                        printWriter.flush();
                        continue;
                    }
                    printWriter.print("Too many connections.\r\n");
                    printWriter.flush();
                    socket.close();
                }
                catch (Exception exception) {
                    if (this.serverSocket.isClosed()) break;
                    LogLog.error("Encountered error while in SocketHandler loop.", exception);
                    break;
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public SocketHandler(int n) throws IOException {
            this.serverSocket = new ServerSocket(n);
            this.setName("TelnetAppender-" + this.getName() + "-" + n);
        }
    }
}

