/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragment;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragmentHeader;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingFragments;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoAudio;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaInfoVideo;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingMediaPacket;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingPacketHandler;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingPendingFragment;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingRepeaterHolder;
import com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer.SmoothStreamingRepeaterList;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerBase;
import com.wowza.wms.stream.livepacketizer.LiveStreamPacketizerItem;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamPacketizerSmoothStreaming
extends LiveStreamPacketizerBase {
    public static final int MILLISTOSILVERLIGHT = 10000;
    protected SmoothStreamingFragments videoFragments = new SmoothStreamingFragments(9);
    protected SmoothStreamingFragments audioFragments = new SmoothStreamingFragments(8);
    protected Map<Long, SmoothStreamingPendingFragment> pendingVideoFragments = new HashMap<Long, SmoothStreamingPendingFragment>();
    protected Map<Long, SmoothStreamingPendingFragment> pendingAudioFragments = new HashMap<Long, SmoothStreamingPendingFragment>();
    protected String xmlISMC = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<SmoothStreamingMedia></SmoothStreamingMedia>";
    protected String xmlSmoothStreamingMedia = "";
    protected boolean xmlIsVideo = false;
    protected String xmlStreamIndexVideo = "";
    protected String xmlQualityLevelVideo = "";
    protected String xmlSamplesVideo = "";
    protected boolean xmlIsAudio = false;
    protected String xmlStreamIndexAudio = "";
    protected String xmlQualityLevelAudio = "";
    protected String xmlSamplesAudio = "";
    protected Object ismcXMLLock = new Object();
    protected SmoothStreamingPacketHandler packetHandler = new SmoothStreamingPacketHandler();
    protected int readAheadSize = 2;
    protected int smoothStreamingMediaMajorVersion = 2;
    protected int smoothStreamingMediaMinorVersion = 0;
    protected int smoothBufferTargetDuration = 30000;
    protected int smoothBufferMinFragmentCount = 3;
    protected int smoothManifestTargetDuration = 20000;
    protected int smoothManifestMinFragmentCount = 3;
    protected int smoothRepeaterTargetDuration = 20000;
    protected int smoothRepeaterMinFragmentCount = 3;
    protected int smoothFragmentTargetAudioDuration = 2000;
    protected long nextFragmentIdVideo = 0L;
    protected long nextFragmentIdAudio = 0L;
    protected Object reapeaterItemsLock = new Object();
    protected long repeaterSeq = 0L;
    protected SmoothStreamingRepeaterList repeaterListAudio = null;
    protected SmoothStreamingRepeaterList repeaterListVideo = null;

    public LiveStreamPacketizerSmoothStreaming() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS((byte[])bigInteger.toByteArray(), (String)string);
            if (string2.indexOf(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN((String)ModuleConnect.getN((int)0)));
        }
        this.repeaterListAudio = new SmoothStreamingRepeaterList(this.reapeaterItemsLock, 8);
        this.repeaterListVideo = new SmoothStreamingRepeaterList(this.reapeaterItemsLock, 9);
    }

    public void init(String string, String string2, IApplicationInstance iApplicationInstance, LiveStreamPacketizerItem liveStreamPacketizerItem) {
        super.init(string, string2, iApplicationInstance, liveStreamPacketizerItem);
        WMSProperties wMSProperties = this.getProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        this.readAheadSize = wMSProperties.getPropertyInt("readAheadSize", this.readAheadSize);
        this.smoothBufferTargetDuration = wMSProperties.getPropertyInt("smoothBufferTargetDuration", this.smoothBufferTargetDuration);
        this.smoothManifestTargetDuration = wMSProperties.getPropertyInt("smoothManifestTargetDuration", this.smoothManifestTargetDuration);
        this.smoothRepeaterTargetDuration = wMSProperties.getPropertyInt("smoothRepeaterTargetDuration", this.smoothRepeaterTargetDuration);
        this.smoothBufferMinFragmentCount = wMSProperties.getPropertyInt("smoothBufferMinFragmentCount", this.smoothBufferMinFragmentCount);
        this.smoothManifestMinFragmentCount = wMSProperties.getPropertyInt("smoothManifestMinFragmentCount", this.smoothManifestMinFragmentCount);
        this.smoothRepeaterMinFragmentCount = wMSProperties.getPropertyInt("smoothRepeaterMinFragmentCount", this.smoothRepeaterMinFragmentCount);
        this.smoothFragmentTargetAudioDuration = wMSProperties.getPropertyInt("smoothFragmentTargetAudioDuration", this.smoothFragmentTargetAudioDuration);
        this.videoFragments.setSmoothBufferTargetDuration(this.smoothBufferTargetDuration);
        this.videoFragments.setSmoothManifestTargetDuration(this.smoothManifestTargetDuration);
        this.videoFragments.setSmoothBufferMinFragmentCount(this.smoothBufferMinFragmentCount);
        this.videoFragments.setSmoothManifestMinFragmentCount(this.smoothManifestMinFragmentCount);
        this.audioFragments.setSmoothBufferTargetDuration(this.smoothBufferTargetDuration);
        this.audioFragments.setSmoothManifestTargetDuration(this.smoothManifestTargetDuration);
        this.audioFragments.setSmoothBufferMinFragmentCount(this.smoothBufferMinFragmentCount);
        this.audioFragments.setSmoothManifestMinFragmentCount(this.smoothManifestMinFragmentCount);
        this.smoothStreamingMediaMajorVersion = wMSProperties.getPropertyInt("smoothStreamingMediaMajorVersion", this.smoothStreamingMediaMajorVersion);
        this.smoothStreamingMediaMinorVersion = wMSProperties.getPropertyInt("smoothStreamingMediaMinorVersion", this.smoothStreamingMediaMinorVersion);
        this.smoothStreamingMediaMajorVersion = wMSProperties2.getPropertyInt("smoothStreamingMediaMajorVersion", this.smoothStreamingMediaMajorVersion);
        this.smoothStreamingMediaMinorVersion = wMSProperties2.getPropertyInt("smoothStreamingMediaMinorVersion", this.smoothStreamingMediaMinorVersion);
        this.packetHandler.init(this);
    }

    public void internalStartStream(IMediaStream iMediaStream) {
        this.packetHandler.startStream(iMediaStream);
    }

    public void internalResetStream(IMediaStream iMediaStream) {
        this.packetHandler.resetStream(iMediaStream);
    }

    public void internalHandlePacket(IMediaStream iMediaStream, AMFPacket aMFPacket) {
        long l = System.currentTimeMillis();
        this.touch(l);
        this.packetHandler.handlePacket(l, iMediaStream, aMFPacket);
    }

    public long getRepeaterAudioLastSeqence() {
        return this.repeaterListAudio.getRepeaterLastSeqence();
    }

    public void getRepeaterAudioItems(List<SmoothStreamingRepeaterHolder> list, long l) {
        this.repeaterListAudio.getRepeaterItems(list, l);
    }

    public long getRepeaterVideoLastSeqence() {
        return this.repeaterListVideo.getRepeaterLastSeqence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRepeaterLastSeqence() {
        long l = -1L;
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            l = this.repeaterSeq;
        }
        return l;
    }

    public void getRepeaterVideoItems(List<SmoothStreamingRepeaterHolder> list, long l) {
        this.repeaterListVideo.getRepeaterItems(list, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepeaterItemAudio(SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder, boolean bl) {
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            this.repeaterListAudio.addRepeaterItem(smoothStreamingRepeaterHolder);
            ++this.repeaterSeq;
            if (bl) {
                this.repeaterListAudio.trim(this.smoothRepeaterMinFragmentCount, this.smoothRepeaterTargetDuration, this.getLastStartTimecode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepeaterItemVideo(SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder, boolean bl) {
        Object object = this.reapeaterItemsLock;
        synchronized (object) {
            this.repeaterListVideo.addRepeaterItem(smoothStreamingRepeaterHolder);
            ++this.repeaterSeq;
            if (bl) {
                this.repeaterListVideo.trim(this.smoothRepeaterMinFragmentCount, this.smoothRepeaterTargetDuration, this.getLastStartTimecode());
            }
        }
    }

    private void addFragment(SmoothStreamingFragments smoothStreamingFragments, SmoothStreamingPendingFragment smoothStreamingPendingFragment, SmoothStreamingFragmentHeader smoothStreamingFragmentHeader, long l) {
        SmoothStreamingFragment smoothStreamingFragment = new SmoothStreamingFragment();
        smoothStreamingFragment.setStartTimecode(smoothStreamingPendingFragment.startTime);
        smoothStreamingFragment.setStopTimecode(smoothStreamingPendingFragment.startTime + smoothStreamingPendingFragment.duration);
        smoothStreamingFragment.setMediaInfoAudio(smoothStreamingPendingFragment.mediaInfoAudio);
        smoothStreamingFragment.setMediaInfoVideo(smoothStreamingPendingFragment.mediaInfoVideo);
        RTPPacketFragmentList rTPPacketFragmentList = smoothStreamingFragment.getFragmentList();
        rTPPacketFragmentList.addPacketFragment(smoothStreamingFragmentHeader.getHeaderData());
        for (SmoothStreamingMediaPacket smoothStreamingMediaPacket : smoothStreamingPendingFragment.frames) {
            rTPPacketFragmentList.addPacketFragments(smoothStreamingMediaPacket.getFragmentList());
        }
        smoothStreamingFragments.addFragment(smoothStreamingFragment.getStartTimecode(), smoothStreamingFragment);
        smoothStreamingFragments.trim(l);
        this.updateISMCXML();
    }

    public void clearFragmentAudio() {
        this.pendingAudioFragments.clear();
        this.audioFragments.clear();
        this.updateISMCXML();
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setType(8);
        smoothStreamingRepeaterHolder.setRepeaterType(5);
        this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
    }

    public void startFragmentAudio(long l) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = new SmoothStreamingPendingFragment();
        smoothStreamingPendingFragment.startTime = l;
        smoothStreamingPendingFragment.fragmentId = this.nextFragmentIdAudio++;
        this.pendingAudioFragments.put(new Long(l), smoothStreamingPendingFragment);
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
        smoothStreamingRepeaterHolder.setType(8);
        smoothStreamingRepeaterHolder.setRepeaterType(1);
        smoothStreamingRepeaterHolder.setStartTime(l);
        this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
    }

    public void addFragmentAudioMediaPacket(long l, SmoothStreamingMediaPacket smoothStreamingMediaPacket) {
        if (smoothStreamingMediaPacket != null) {
            SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingAudioFragments.get(new Long(l));
            if (smoothStreamingPendingFragment != null) {
                smoothStreamingPendingFragment.frames.add(smoothStreamingMediaPacket);
                SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
                smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
                smoothStreamingRepeaterHolder.setType(8);
                smoothStreamingRepeaterHolder.setRepeaterType(2);
                smoothStreamingRepeaterHolder.setStartTime(l);
                smoothStreamingRepeaterHolder.setMediaPacket(smoothStreamingMediaPacket);
                this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
            } else {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.addFragmentAudioMediaPacket[" + this.getContextStr() + "]: Timecode missing: " + l);
            }
        }
    }

    private long getLastStopTimecode() {
        long l = this.audioFragments.getLastStopTimecode();
        long l2 = this.videoFragments.getLastStopTimecode();
        if (l > 0L && l2 > 0L) {
            return Math.min(l, l2);
        }
        if (l > 0L) {
            return l;
        }
        if (l2 > 0L) {
            return l2;
        }
        return -1L;
    }

    private long getLastStartTimecode() {
        long l = this.audioFragments.getLastStartTimecode();
        long l2 = this.videoFragments.getLastStartTimecode();
        if (l > 0L && l2 > 0L) {
            return Math.min(l, l2);
        }
        if (l > 0L) {
            return l;
        }
        if (l2 > 0L) {
            return l2;
        }
        return -1L;
    }

    public void setFragmentAudioHeader(long l, SmoothStreamingFragmentHeader smoothStreamingFragmentHeader, SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingAudioFragments.remove(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.mediaInfoAudio = smoothStreamingMediaInfoAudio;
            this.addFragment(this.audioFragments, smoothStreamingPendingFragment, smoothStreamingFragmentHeader, this.getLastStartTimecode());
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(8);
            smoothStreamingRepeaterHolder.setRepeaterType(3);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setFragmentHeader(smoothStreamingFragmentHeader);
            smoothStreamingRepeaterHolder.setMediaInfoAudio(smoothStreamingMediaInfoAudio);
            this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, false);
        }
    }

    public void endFragmentAudio(long l, long l2) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingAudioFragments.get(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.duration = l2 - l;
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(8);
            smoothStreamingRepeaterHolder.setRepeaterType(4);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setEndTime(l2);
            this.addRepeaterItemAudio(smoothStreamingRepeaterHolder, true);
        } else {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.endFragmentAudio[" + this.getContextStr() + "]: Timecode missing: " + l);
        }
    }

    public void clearFragmentVideo() {
        this.pendingVideoFragments.clear();
        this.videoFragments.clear();
        this.updateISMCXML();
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setType(9);
        smoothStreamingRepeaterHolder.setRepeaterType(5);
        this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
    }

    public void startFragmentVideo(long l) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = new SmoothStreamingPendingFragment();
        smoothStreamingPendingFragment.startTime = l;
        smoothStreamingPendingFragment.fragmentId = this.nextFragmentIdVideo++;
        this.pendingVideoFragments.put(new Long(l), smoothStreamingPendingFragment);
        SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
        smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
        smoothStreamingRepeaterHolder.setType(9);
        smoothStreamingRepeaterHolder.setRepeaterType(1);
        smoothStreamingRepeaterHolder.setStartTime(l);
        this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
    }

    public void addFragmentVideoMediaPacket(long l, SmoothStreamingMediaPacket smoothStreamingMediaPacket) {
        if (smoothStreamingMediaPacket != null) {
            SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingVideoFragments.get(new Long(l));
            if (smoothStreamingPendingFragment != null) {
                smoothStreamingPendingFragment.frames.add(smoothStreamingMediaPacket);
                SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
                smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
                smoothStreamingRepeaterHolder.setType(9);
                smoothStreamingRepeaterHolder.setRepeaterType(2);
                smoothStreamingRepeaterHolder.setStartTime(l);
                smoothStreamingRepeaterHolder.setMediaPacket(smoothStreamingMediaPacket);
                this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
            } else {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.addFragmentVideoMediaPacket[" + this.getContextStr() + "]: Timecode missing: " + l);
            }
        }
    }

    public void setFragmentVideoHeader(long l, SmoothStreamingFragmentHeader smoothStreamingFragmentHeader, SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingVideoFragments.remove(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.mediaInfoVideo = smoothStreamingMediaInfoVideo;
            this.addFragment(this.videoFragments, smoothStreamingPendingFragment, smoothStreamingFragmentHeader, this.getLastStartTimecode());
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(9);
            smoothStreamingRepeaterHolder.setRepeaterType(3);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setFragmentHeader(smoothStreamingFragmentHeader);
            smoothStreamingRepeaterHolder.setMediaInfoVideo(smoothStreamingMediaInfoVideo);
            this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, false);
        }
    }

    public void endFragmentVideo(long l, long l2) {
        SmoothStreamingPendingFragment smoothStreamingPendingFragment = this.pendingVideoFragments.get(new Long(l));
        if (smoothStreamingPendingFragment != null) {
            smoothStreamingPendingFragment.duration = l2 - l;
            SmoothStreamingRepeaterHolder smoothStreamingRepeaterHolder = new SmoothStreamingRepeaterHolder();
            smoothStreamingRepeaterHolder.setFragmentId(smoothStreamingPendingFragment.fragmentId);
            smoothStreamingRepeaterHolder.setType(9);
            smoothStreamingRepeaterHolder.setRepeaterType(4);
            smoothStreamingRepeaterHolder.setStartTime(l);
            smoothStreamingRepeaterHolder.setEndTime(l2);
            this.addRepeaterItemVideo(smoothStreamingRepeaterHolder, true);
        } else {
            WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).warn("LiveStreamPacketizerSmoothStreaming.endFragmentVideo[" + this.getContextStr() + "]: Timecode missing: " + l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateISMCXML() {
        block45: {
            try {
                Object object;
                String string = "";
                String string2 = "";
                String string3 = "";
                StringBuffer stringBuffer = new StringBuffer();
                String string4 = "";
                String string5 = "";
                StringBuffer stringBuffer2 = new StringBuffer();
                int n = this.videoFragments.size();
                int n2 = this.audioFragments.size();
                if (n <= 0 && n2 <= 0) break block45;
                long[] lArray = this.audioFragments.getStartStopTimecodes();
                long[] lArray2 = this.videoFragments.getStartStopTimecodes();
                long l = -1L;
                long l2 = -1L;
                long l3 = this.smoothManifestTargetDuration * 10000;
                if (lArray != null && lArray2 != null) {
                    long l4 = Math.max(lArray[0], lArray2[0]);
                    long l5 = Math.min(lArray[1], lArray2[1]);
                    long l6 = l5 - l4;
                    if (l6 >= l3) {
                        l2 = l5;
                        l = l2 - l3;
                        if (l < 0L) {
                            l = 0L;
                            l2 = l + l3;
                        }
                    } else if (l6 > 0L) {
                        l = l4;
                        l2 = l + l3;
                        if (l2 > Math.max(lArray[1], lArray2[1]) && (l = (l2 = Math.max(lArray[1], lArray2[1])) - l3) < 0L) {
                            l = 0L;
                            l2 = l + l3;
                        }
                    } else {
                        l2 = Math.max(lArray[1], lArray2[1]);
                        l = l2 - l3;
                        if (l < 0L) {
                            l = 0L;
                            l2 = l + l3;
                        }
                    }
                } else if (lArray != null) {
                    l2 = lArray[1];
                    l = l2 - l3;
                    if (l < 0L) {
                        l = 0L;
                        l2 = l + l3;
                    }
                } else if (lArray2 != null && (l = (l2 = lArray2[1]) - l3) < 0L) {
                    l = 0L;
                    l2 = l + l3;
                }
                if (this.smoothStreamingMediaMajorVersion >= 2) {
                    String string6;
                    string = "<SmoothStreamingMedia MajorVersion=\"" + this.smoothStreamingMediaMajorVersion + "\" MinorVersion=\"" + this.smoothStreamingMediaMinorVersion + "\" Duration=\"0\" LookAheadFragmentCount=\"" + this.readAheadSize + "\" IsLive=\"True\">" + "\n";
                    if (n > 0) {
                        Object object2;
                        object = object2 = this.videoFragments.getLock();
                        synchronized (object) {
                            SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = this.videoFragments.getMediaInfoVideo();
                            string2 = "<StreamIndex Type=\"video\" Chunks=\"0\" QualityLevels=\"1\" MaxWidth=\"" + smoothStreamingMediaInfoVideo.getVideoWidth() + "\" MaxHeight=\"" + smoothStreamingMediaInfoVideo.getVideoHeight() + "\" DisplayWidth=\"" + smoothStreamingMediaInfoVideo.getVideoWidth() + "\" DisplayHeight=\"" + smoothStreamingMediaInfoVideo.getVideoHeight() + "\" Url=\"v_w" + "{sessionid}" + "_b{bitrate}_s{start time}.ismv\">" + "\n";
                            string6 = "";
                            if (smoothStreamingMediaInfoVideo.getVideoCodecPrivateData() != null) {
                                string6 = " CodecPrivateData=\"" + BufferUtils.encodeHexString((byte[])smoothStreamingMediaInfoVideo.getVideoCodecPrivateData()) + "\"";
                            }
                            string3 = "<QualityLevel Index=\"0\" Bitrate=\"{videobitrate}\" FourCC=\"" + smoothStreamingMediaInfoVideo.getVideoFourCC() + "\" MaxWidth=\"" + smoothStreamingMediaInfoVideo.getVideoWidth() + "\" MaxHeight=\"" + smoothStreamingMediaInfoVideo.getVideoHeight() + "\"" + string6 + " />" + "\n";
                            List<long[]> list = this.videoFragments.getTimeInfo(l, l2);
                            for (long[] lArray3 : list) {
                                stringBuffer.append("<c t=\"" + lArray3[0] + "\" d=\"" + (lArray3[1] - lArray3[0]) + "\"/>" + "\n");
                            }
                        }
                    }
                    if (n2 > 0) {
                        Object object3;
                        object = object3 = this.audioFragments.getLock();
                        synchronized (object) {
                            SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = this.audioFragments.getMediaInfoAudio();
                            string4 = "<StreamIndex Type=\"audio\" Index=\"0\" FourCC=\"WmaPro\" Chunks=\"0\" QualityLevels=\"1\" Url=\"a_w{sessionid}_b{bitrate}_s{start time}.ismv\">\n";
                            string6 = "";
                            if (smoothStreamingMediaInfoAudio.getAudioWaveFormatEx() != null) {
                                string6 = " CodecPrivateData=\"" + BufferUtils.encodeHexString((byte[])smoothStreamingMediaInfoAudio.getAudioWaveFormatEx()) + "\"";
                            }
                            string5 = "<QualityLevel Bitrate=\"{audiobitrate}\" SamplingRate=\"" + smoothStreamingMediaInfoAudio.getAudioSamplingRate() + "\" Channels=\"" + smoothStreamingMediaInfoAudio.getAudioChannels() + "\" BitsPerSample=\"" + smoothStreamingMediaInfoAudio.getAudioBitsPerSample() + "\" PacketSize=\"" + smoothStreamingMediaInfoAudio.getAudioPacketSize() + "\" AudioTag=\"" + smoothStreamingMediaInfoAudio.getAudioTag() + "\"" + string6 + " />" + "\n";
                            List<long[]> list = this.audioFragments.getTimeInfo(l, l2);
                            for (long[] lArray3 : list) {
                                stringBuffer2.append("<c t=\"" + lArray3[0] + "\" d=\"" + (lArray3[1] - lArray3[0]) + "\"/>" + "\n");
                            }
                        }
                    }
                } else {
                    Object object4;
                    Object object5;
                    string = "<SmoothStreamingMedia MajorVersion=\"" + this.smoothStreamingMediaMajorVersion + "\" MinorVersion=\"" + this.smoothStreamingMediaMinorVersion + "\" Duration=\"0\" LookAheadFragmentCount=\"" + this.readAheadSize + "\" IsLive=\"TRUE\">" + "\n";
                    if (n > 0) {
                        Object object6;
                        object = object6 = this.videoFragments.getLock();
                        synchronized (object) {
                            SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = this.videoFragments.getMediaInfoVideo();
                            string2 = "<StreamIndex Type=\"video\" Subtype=\"" + smoothStreamingMediaInfoVideo.getVideoFourCC() + "\" Chunks=\"0\" Url=\"v_w" + "{sessionid}" + "_b{bitrate}_s{start time}.ismv\">" + "\n";
                            object5 = "";
                            if (smoothStreamingMediaInfoVideo.getVideoCodecPrivateData() != null) {
                                object5 = " CodecPrivateData=\"" + BufferUtils.encodeHexString((byte[])smoothStreamingMediaInfoVideo.getVideoCodecPrivateData()) + "\"";
                            }
                            string3 = "<QualityLevel Bitrate=\"{videobitrate}\" FourCC=\"" + smoothStreamingMediaInfoVideo.getVideoFourCC() + "\" Width=\"" + smoothStreamingMediaInfoVideo.getVideoWidth() + "\" Height=\"" + smoothStreamingMediaInfoVideo.getVideoHeight() + "\"" + (String)object5 + " />" + "\n";
                            List<long[]> list = this.videoFragments.getTimeInfo(l, l2);
                            object4 = list.iterator();
                            while (object4.hasNext()) {
                                long[] lArray4 = (long[])object4.next();
                                stringBuffer.append("<c t=\"" + lArray4[0] + "\" d=\"" + (lArray4[1] - lArray4[0]) + "\"/>" + "\n");
                            }
                        }
                    }
                    if (n2 > 0) {
                        Object object7;
                        object = object7 = this.audioFragments.getLock();
                        synchronized (object) {
                            SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = this.audioFragments.getMediaInfoAudio();
                            string4 = "<StreamIndex Type=\"audio\" Subtype=\"WmaPro\" Chunks=\"0\" Url=\"a_w{sessionid}_b{bitrate}_s{start time}.ismv\">\n";
                            string5 = "<QualityLevel Bitrate=\"{audiobitrate}\" WaveFormatEx=\"" + BufferUtils.encodeHexString((byte[])smoothStreamingMediaInfoAudio.getAudioWaveFormatEx()) + "\"/>" + "\n";
                            object5 = this.audioFragments.getTimeInfo(l, l2);
                            Iterator iterator = object5.iterator();
                            while (iterator.hasNext()) {
                                object4 = (long[])iterator.next();
                                stringBuffer2.append("<c t=\"" + object4[0] + "\" d=\"" + (object4[1] - object4[0]) + "\"/>" + "\n");
                            }
                        }
                    }
                }
                StringBuffer stringBuffer3 = new StringBuffer();
                object = this.ismcXMLLock;
                synchronized (object) {
                    stringBuffer3.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
                    stringBuffer3.append(string);
                    this.xmlSmoothStreamingMedia = string.toString();
                    boolean bl = this.xmlIsVideo = n > 0;
                    if (this.xmlIsVideo) {
                        stringBuffer3.append(string2);
                        stringBuffer3.append(string3);
                        stringBuffer3.append(stringBuffer);
                        stringBuffer3.append("</StreamIndex>\n");
                    }
                    this.xmlStreamIndexVideo = string2.toString();
                    this.xmlQualityLevelVideo = string3.toString();
                    this.xmlSamplesVideo = stringBuffer.toString();
                    boolean bl2 = this.xmlIsAudio = n2 > 0;
                    if (this.xmlIsAudio) {
                        stringBuffer3.append(string4);
                        stringBuffer3.append(string5);
                        stringBuffer3.append(stringBuffer2);
                        stringBuffer3.append("</StreamIndex>\n");
                    }
                    this.xmlStreamIndexAudio = string4.toString();
                    this.xmlQualityLevelAudio = string5.toString();
                    this.xmlSamplesAudio = stringBuffer2.toString();
                    stringBuffer3.append("</SmoothStreamingMedia>\n");
                    this.xmlISMC = stringBuffer3.toString();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveStreamPacketizerSmoothStreaming.class).error("LiveStreamPacketizerSmoothStreaming.updateISMCXML: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVideoBitrate() {
        Object object;
        int n = 0;
        Object object2 = object = this.videoFragments.getLock();
        synchronized (object2) {
            SmoothStreamingMediaInfoVideo smoothStreamingMediaInfoVideo = this.videoFragments.getMediaInfoVideo();
            if (smoothStreamingMediaInfoVideo != null) {
                n = smoothStreamingMediaInfoVideo.getVideoBitrate();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAudioBitrate() {
        Object object;
        int n = 0;
        Object object2 = object = this.audioFragments.getLock();
        synchronized (object2) {
            SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = this.audioFragments.getMediaInfoAudio();
            if (smoothStreamingMediaInfoAudio != null) {
                n = smoothStreamingMediaInfoAudio.getAudioBitrate();
            }
        }
        return n;
    }

    public RTPPacketFragmentList getAudioPacket(long l) {
        return this.audioFragments.getFragmentBytes(l);
    }

    public RTPPacketFragmentList getVideoPacket(long l) {
        return this.getVideoPacket(l, 0);
    }

    public RTPPacketFragmentList getVideoPacket(long l, int n) {
        return this.videoFragments.getFragmentBytes(l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLSmoothStreamingMedia() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlSmoothStreamingMedia;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLIsVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlIsVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLStreamIndexVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlStreamIndexVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLQualityLevelVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlQualityLevelVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLSamplesVideo() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlSamplesVideo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXMLIsAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlIsAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLStreamIndexAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlStreamIndexAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLQualityLevelAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlQualityLevelAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLSamplesAudio() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlSamplesAudio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXMLISMC() {
        Object object = this.ismcXMLLock;
        synchronized (object) {
            return this.xmlISMC;
        }
    }

    public long getPlaylistDuration() {
        return Math.max(this.videoFragments.getDuration(), this.audioFragments.getDuration()) / 10000L;
    }
}

