/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.httpstreamer.smoothstreaming.livestreampacketizer;

import com.wowza.wms.logging.WMSLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class SmoothStreamingMediaInfoAudio {
    private int audioBitrate = -1;
    private long audioTrackDuration = 0L;
    private byte[] audioWaveFormatEx = null;
    private int audioSamplingRate = -1;
    private int audioChannels = -1;
    private int audioBitsPerSample = 16;
    private int audioPacketSize = 4;
    private String audioTag = "5633";
    private String audioFourCC = "";

    public static SmoothStreamingMediaInfoAudio deserialize(byte[] byArray, int n, int n2) {
        SmoothStreamingMediaInfoAudio smoothStreamingMediaInfoAudio = new SmoothStreamingMediaInfoAudio();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            byte by = dataInputStream.readByte();
            smoothStreamingMediaInfoAudio.audioBitrate = dataInputStream.readInt();
            smoothStreamingMediaInfoAudio.audioTrackDuration = dataInputStream.readLong();
            smoothStreamingMediaInfoAudio.audioSamplingRate = dataInputStream.readInt();
            smoothStreamingMediaInfoAudio.audioChannels = dataInputStream.readInt();
            smoothStreamingMediaInfoAudio.audioBitsPerSample = dataInputStream.readInt();
            smoothStreamingMediaInfoAudio.audioPacketSize = dataInputStream.readInt();
            smoothStreamingMediaInfoAudio.audioTag = dataInputStream.readUTF();
            smoothStreamingMediaInfoAudio.audioFourCC = dataInputStream.readUTF();
            short s = dataInputStream.readShort();
            if (s > 0) {
                smoothStreamingMediaInfoAudio.audioWaveFormatEx = new byte[s];
                dataInputStream.read(smoothStreamingMediaInfoAudio.audioWaveFormatEx);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamingMediaInfoAudio.class).error("SmoothStreamingMediaInfoAudio.deserialize: " + exception.toString());
        }
        return smoothStreamingMediaInfoAudio;
    }

    public byte[] serialize() {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(this.audioBitrate);
            dataOutputStream.writeLong(this.audioTrackDuration);
            dataOutputStream.writeInt(this.audioSamplingRate);
            dataOutputStream.writeInt(this.audioChannels);
            dataOutputStream.writeInt(this.audioBitsPerSample);
            dataOutputStream.writeInt(this.audioPacketSize);
            dataOutputStream.writeUTF(this.audioTag);
            dataOutputStream.writeUTF(this.audioFourCC);
            if (this.audioWaveFormatEx != null) {
                dataOutputStream.writeShort((short)this.audioWaveFormatEx.length);
                dataOutputStream.write(this.audioWaveFormatEx);
            } else {
                dataOutputStream.writeShort(0);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(SmoothStreamingMediaInfoAudio.class).error("SmoothStreamingMediaInfoAudio.serialize: " + exception.toString());
        }
        return byArray;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(int n) {
        this.audioBitrate = n;
    }

    public String getAudioFourCC() {
        return this.audioFourCC;
    }

    public void setAudioFourCC(String string) {
        this.audioFourCC = string;
    }

    public long getAudioTrackDuration() {
        return this.audioTrackDuration;
    }

    public void setAudioTrackDuration(long l) {
        this.audioTrackDuration = l;
    }

    public byte[] getAudioWaveFormatEx() {
        return this.audioWaveFormatEx;
    }

    public void setAudioWaveFormatEx(byte[] byArray) {
        this.audioWaveFormatEx = byArray;
    }

    public int getAudioSamplingRate() {
        return this.audioSamplingRate;
    }

    public void setAudioSamplingRate(int n) {
        this.audioSamplingRate = n;
    }

    public int getAudioChannels() {
        return this.audioChannels;
    }

    public void setAudioChannels(int n) {
        this.audioChannels = n;
    }

    public int getAudioBitsPerSample() {
        return this.audioBitsPerSample;
    }

    public void setAudioBitsPerSample(int n) {
        this.audioBitsPerSample = n;
    }

    public int getAudioPacketSize() {
        return this.audioPacketSize;
    }

    public void setAudioPacketSize(int n) {
        this.audioPacketSize = n;
    }

    public String getAudioTag() {
        return this.audioTag;
    }

    public void setAudioTag(String string) {
        this.audioTag = string;
    }
}

