/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.io;

import com.wowza.io.FileChunk;
import com.wowza.io.IIOTarget;
import com.wowza.io.IORequest;
import com.wowza.io.IOScheduler;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.IRandomAccessWriter;
import com.wowza.util.IFasterByteArrayOutputStream;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.Client;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.IOException;

public class ScheduledRandomAccessReaderWrapper
implements IIOTarget,
IRandomAccessReader,
IRandomAccessWriter {
    public static final int DEFAULT_BUFFERSIZE = 65536;
    public static final int DEFAULT_READAHEADTRIGGER = 32768;
    public static final int BUFFERPADDING = 0;
    private long pos = 0L;
    private int bufferSize = 65536;
    private int readAheadTrigger = 32768;
    private int direction = 1;
    private IRandomAccessReader fileStream = null;
    private IMediaStream stream = null;
    private long fileLength = 0L;
    private IORequest ioRequest = null;
    private FileChunk fileChunk = null;
    private byte[] buffer = null;
    private int bufferLength = 0;
    private long bufferPos = -1L;
    private boolean bufferDidReadAheadRequest = false;
    private FileChunk pendingReq = null;
    private FileChunk completedReq = null;
    private IOScheduler ioScheduler = null;
    private boolean isOpen = false;

    public ScheduledRandomAccessReaderWrapper(IMediaStream iMediaStream, IRandomAccessReader iRandomAccessReader, int n, int n2) {
        this.fileStream = iRandomAccessReader;
        this.stream = iMediaStream;
        this.fileLength = iRandomAccessReader.length();
        this.ioRequest = new IORequest(this);
        if (iMediaStream != null) {
            this.ioScheduler = iMediaStream.getStreams().getVHost().getIOScheduler();
        }
        this.bufferSize = n;
        this.readAheadTrigger = n2;
        this.fileChunk = new FileChunk(0L, this.bufferSize);
        this.fileChunk.allocate();
        this.buffer = new byte[this.bufferSize];
    }

    public void open() throws IOException {
        this.isOpen = true;
        this.waitRequests(-1L);
        this.fileChunk.setPos(0L);
        this.pendingReq = this.fileChunk;
        this.ioScheduler.execute(this.ioRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean bl = false;
        IORequest iORequest = this.ioRequest;
        synchronized (iORequest) {
            if (this.ioRequest.getState() != 2) {
                this.isOpen = false;
                bl = true;
            }
        }
        if (!bl) {
            this.waitRequests(-1L);
            iORequest = this.ioRequest;
            synchronized (iORequest) {
                this.isOpen = false;
            }
        }
    }

    public void executeIORequest() {
        if (!this.isOpen) {
            return;
        }
        if (this.fileStream == null) {
            return;
        }
        FileChunk fileChunk = this.pendingReq;
        int n = 0;
        if (fileChunk != null) {
            byte[] byArray = fileChunk.getBuffer();
            int n2 = byArray.length;
            try {
                long l = fileChunk.getPos();
                this.fileStream.seek(l);
                n = this.fileStream.read(byArray, 0, n2);
                fileChunk.setLength(n);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ScheduledRandomAccessReaderWrapper.class).error("ScheduledRandomAccessReaderWrapper.executeIORequest: " + exception.toString());
                exception.printStackTrace();
            }
            if (n > 0) {
                this.completedReq = fileChunk;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitRequests(long l) {
        IORequest iORequest;
        if (l >= 0L) {
            iORequest = this.ioRequest;
            synchronized (iORequest) {
                if (this.ioRequest.getState() == 1 && this.pendingReq != null) {
                    this.pendingReq.setPos(l);
                    return true;
                }
            }
        }
        try {
            iORequest = this.ioRequest;
            synchronized (iORequest) {
                if (this.ioRequest.getState() != 0) {
                    Client client = null;
                    if (this.stream != null) {
                        client = (Client)this.stream.getClient();
                    }
                    if (client != null) {
                        client.touch();
                        client.incWaitingForIOCount();
                    }
                    this.ioRequest.wait();
                    if (client != null) {
                        client.touch();
                        client.decWaitingForIOCount();
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ScheduledRandomAccessReaderWrapper.class).error("ScheduledRandomAccessReader.request: sleep: " + exception.toString());
        }
        return false;
    }

    private boolean bufferMiss(long l, int n) {
        FileChunk fileChunk;
        boolean bl = false;
        while (true) {
            long l2;
            this.waitRequests(-1L);
            fileChunk = this.completedReq;
            if (fileChunk != null) {
                l2 = fileChunk.getPos();
                long l3 = fileChunk.getLength();
                if (l < l2 || l >= l2 + l3) {
                    fileChunk = null;
                }
                this.completedReq = null;
            }
            if (fileChunk != null) break;
            if (bl) {
                WMSLoggerFactory.getLogger(ScheduledRandomAccessReaderWrapper.class).error("ScheduledRandomAccessReader.bufferMiss[" + this.fileStream.getMediaName() + "]: Request failed: " + l + ":" + n);
                return false;
            }
            l2 = l;
            if (l < this.bufferPos) {
                l2 = this.bufferPos - (long)this.bufferSize;
                if (l < l2) {
                    l2 = l;
                }
            } else {
                l2 = this.bufferPos + (long)this.bufferSize;
                if (l >= l2 + (long)this.bufferSize) {
                    l2 = l;
                }
            }
            if (l2 < 0L) {
                l2 = 0L;
            }
            if (l2 + (long)this.bufferSize > this.fileLength) {
                l2 = this.fileLength - (long)this.bufferSize;
            }
            this.fileChunk.setPos(l2);
            this.pendingReq = this.fileChunk;
            this.ioScheduler.execute(this.ioRequest);
            bl = true;
        }
        this.bufferLength = fileChunk.getLength();
        this.bufferPos = fileChunk.getPos();
        byte[] byArray = this.buffer;
        this.buffer = fileChunk.getBuffer();
        fileChunk.setBuffer(byArray);
        this.bufferDidReadAheadRequest = false;
        return true;
    }

    public long getFilePointer() {
        return this.pos;
    }

    private void checkReadAhead(long l) {
        long l2 = -1L;
        if (this.direction == 1) {
            if (l > this.bufferPos + (long)this.readAheadTrigger) {
                l2 = this.bufferPos + (long)this.bufferSize - 0L;
            }
        } else if (l < this.bufferPos + (long)this.readAheadTrigger) {
            l2 = this.bufferPos - (long)this.bufferSize + 0L;
        }
        if (l2 != -1L) {
            boolean bl;
            if (l2 < 0L) {
                l2 = 0L;
            }
            if (l2 + (long)this.bufferSize > this.fileLength) {
                l2 = this.fileLength - (long)this.bufferSize;
            }
            if (l2 < 0L) {
                l2 = 0L;
            }
            if (l2 != this.bufferPos && !(bl = this.waitRequests(l2))) {
                this.fileChunk.setPos(l2);
                this.pendingReq = this.fileChunk;
                this.ioScheduler.execute(this.ioRequest);
            }
            this.bufferDidReadAheadRequest = true;
        }
    }

    public int getDirecton() {
        return this.direction;
    }

    public void setDirecton(int n) {
        boolean bl = this.direction != n;
        this.direction = n;
        if (bl) {
            this.bufferDidReadAheadRequest = false;
        }
        if (!this.bufferDidReadAheadRequest) {
            this.checkReadAhead(this.pos);
        }
    }

    public void seek(long l) {
        this.pos = l;
    }

    public int write(IFasterByteArrayOutputStream iFasterByteArrayOutputStream, int n, int n2, int n3, int n4) {
        int n5;
        block9: {
            if (this.fileStream == null || this.fileLength <= 0L || this.pos >= this.fileLength) {
                return -1;
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.pos + (long)n2 > this.fileLength) {
                n2 = (int)(this.fileLength - this.pos);
            }
            if (this.bufferPos < 0L) {
                this.waitRequests(-1L);
            }
            n5 = 0;
            while (true) {
                if (this.bufferPos >= 0L && this.pos >= this.bufferPos && this.pos + (long)n2 <= this.bufferPos + (long)this.bufferLength) {
                    n5 += iFasterByteArrayOutputStream.write(this.buffer, (int)(this.pos - this.bufferPos), n2, n, n3, n4);
                    this.pos += (long)n2;
                    n += n2;
                    break block9;
                }
                if (this.pos >= this.bufferPos && this.pos + 1L <= this.bufferPos + (long)this.bufferLength) {
                    int n6 = this.bufferLength - (int)(this.pos - this.bufferPos);
                    n5 += iFasterByteArrayOutputStream.write(this.buffer, (int)(this.pos - this.bufferPos), n6, n, n3, n4);
                    this.pos += (long)n6;
                    n2 -= n6;
                    n += n6;
                    continue;
                }
                if (!this.bufferMiss(this.pos, n2)) break;
            }
            if (n5 == 0) {
                n5 = -1;
            }
        }
        if (!this.bufferDidReadAheadRequest) {
            this.checkReadAhead(this.pos);
        }
        return n5;
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3;
        block9: {
            if (this.fileStream == null || this.fileLength <= 0L || this.pos >= this.fileLength) {
                return -1;
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.pos + (long)n2 > this.fileLength) {
                n2 = (int)(this.fileLength - this.pos);
            }
            int n4 = n2;
            n3 = 0;
            if (this.bufferPos < 0L) {
                this.waitRequests(-1L);
            }
            while (true) {
                if (this.bufferPos >= 0L && this.pos >= this.bufferPos && this.pos + (long)n2 <= this.bufferPos + (long)this.bufferLength) {
                    System.arraycopy(this.buffer, (int)(this.pos - this.bufferPos), byArray, n, n2);
                    this.pos += (long)n2;
                    n3 += n2;
                    break block9;
                }
                if (this.pos >= this.bufferPos && this.pos + 1L <= this.bufferPos + (long)this.bufferLength) {
                    int n5 = this.bufferLength - (int)(this.pos - this.bufferPos);
                    System.arraycopy(this.buffer, (int)(this.pos - this.bufferPos), byArray, n, n5);
                    this.pos += (long)n5;
                    n2 -= n5;
                    n += n5;
                    n3 += n5;
                    continue;
                }
                if (!this.bufferMiss(this.pos, n2)) break;
            }
            if (n3 == 0) {
                n3 = -1;
            }
        }
        if (!this.bufferDidReadAheadRequest) {
            this.checkReadAhead(this.pos);
        }
        return n3;
    }

    public boolean exists() {
        return this.fileStream.exists();
    }

    public String getBasePath() {
        return this.fileStream.getBasePath();
    }

    public String getMediaExtension() {
        return this.fileStream.getMediaExtension();
    }

    public String getMediaName() {
        return this.fileStream.getMediaName();
    }

    public String getPath() {
        return this.fileStream.getPath();
    }

    public boolean isOpen() {
        return this.fileStream.isOpen();
    }

    public long length() {
        return this.fileStream.length();
    }

    public long lastModified() {
        return this.fileStream.lastModified();
    }

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
    }
}

