/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.authentication;

import com.wowza.util.HTTPUtils;
import com.wowza.util.MD5DigestUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.authentication.AuthenticationItem;
import com.wowza.wms.authentication.IAuthenticate;
import com.wowza.wms.authentication.IAuthenticateHTTPProvider;
import com.wowza.wms.authentication.IAuthenticateRTSP;
import com.wowza.wms.authentication.IAuthenticateUsernamePasswordProvider;
import com.wowza.wms.authentication.file.AuthenticationPasswordFile;
import com.wowza.wms.authentication.file.AuthenticationPasswordFiles;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtsp.RTSPRequestMessage;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import com.wowza.wms.rtsp.RTSPResponseMessages;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.util.AuthenticationUtils;
import com.wowza.wms.vhost.IVHost;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AuthenticateDigest
implements IAuthenticate,
IAuthenticateRTSP,
IAuthenticateHTTPProvider,
Runnable {
    public static final int HTTPPROVIDERTIMEOUT = 600000;
    public static final int TRIMTIME = 5000;
    public static final String NOUNCEKEY = "WowzaMediaServerPro";
    private AuthenticationItem authenticationItem = null;
    private boolean isAuthenticated = false;
    private String realm = null;
    private File passwordFile = null;
    private String savedNonce = null;
    private Map<String, HTTPProviderSessions> httpProviderSessions = new HashMap<String, HTTPProviderSessions>();
    private long lastTrimTime = -1L;
    private String usernamePasswordProviderClass = null;

    public void init(IApplicationInstance iApplicationInstance, AuthenticationItem authenticationItem) {
        this.authenticationItem = authenticationItem;
        this.realm = this.authenticationItem.getProperties().getPropertyStr("realm", this.realm);
        this.usernamePasswordProviderClass = this.authenticationItem.getProperties().getPropertyStr("usernamePasswordProviderClass", this.usernamePasswordProviderClass);
        String string = this.authenticationItem.getProperties().getPropertyStr("passwordFile", null);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            IVHost iVHost = iApplicationInstance.getVHost();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
            hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
            string = SystemUtils.expandEnvironmentVariables(string, hashMap);
            this.passwordFile = new File(string);
        }
    }

    public void init(IVHost iVHost, AuthenticationItem authenticationItem) {
        this.authenticationItem = authenticationItem;
        this.realm = this.authenticationItem.getProperties().getPropertyStr("realm", this.realm);
        String string = this.authenticationItem.getProperties().getPropertyStr("passwordFile", null);
        if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.wowza.wms.context.VHost", iVHost.getName());
            hashMap.put("com.wowza.wms.context.VHostConfigHome", iVHost.getHomePath());
            string = SystemUtils.expandEnvironmentVariables(string, hashMap);
            this.passwordFile = new File(string);
        }
    }

    private String getAuthString(String string) {
        String string2 = "Digest";
        String string3 = "";
        if (this.realm != null) {
            if (string3.length() > 0) {
                string3 = string3 + ", ";
            }
            string3 = string3 + " realm=\"" + this.realm + "\"";
        }
        if (string3.length() > 0) {
            string3 = string3 + ", ";
        }
        this.savedNonce = MD5DigestUtils.generateHash(string + ":" + System.currentTimeMillis() + ":" + NOUNCEKEY);
        string3 = string3 + " nonce=\"" + this.savedNonce + "\"";
        string2 = string2 + string3;
        return string2;
    }

    private String removeQuotes(String string) {
        return this.removeQuotes(string, false);
    }

    private String removeQuotes(String string, boolean bl) {
        if (string.length() > 0 && string.charAt(0) != '\"' && !bl) {
            return string;
        }
        if (string.length() > 2) {
            return string.substring(1, string.length() - 1);
        }
        return new String();
    }

    public boolean authenticateRTSP(RTPSession rTPSession, RTSPRequestMessage rTSPRequestMessage, RTSPResponseMessages rTSPResponseMessages) {
        Object object;
        String[] stringArray;
        if (this.isAuthenticated) {
            return true;
        }
        boolean bl = false;
        String string = rTSPRequestMessage.getHeader("authorization");
        if (string != null) {
            String string2;
            if ((string = string.trim()).toLowerCase().startsWith("digest ")) {
                string = string.substring(7);
            }
            string = string.trim();
            stringArray = HTTPUtils.splitPragmas(string);
            object = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = rTSPRequestMessage.getHeader("method");
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (string2.length() == 0) continue;
                int n = string2.indexOf(61);
                if (n < 0) break;
                String string11 = string2.substring(0, n).trim();
                String string12 = string2.substring(n + 1).trim();
                if ("username".equals(string11)) {
                    object = this.removeQuotes(string12);
                }
                if ("realm".equals(string11)) {
                    string3 = this.removeQuotes(string12, true);
                }
                if ("nonce".equals(string11)) {
                    string4 = this.removeQuotes(string12);
                }
                if ("nc".equals(string11)) {
                    string5 = this.removeQuotes(string12);
                }
                if ("cnonce".equals(string11)) {
                    string6 = this.removeQuotes(string12);
                }
                if ("qop".equals(string11)) {
                    string7 = this.removeQuotes(string12);
                }
                if ("uri".equals(string11)) {
                    string8 = this.removeQuotes(string12);
                }
                if (!"response".equals(string11)) continue;
                string9 = this.removeQuotes(string12);
            }
            IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
            if (this.usernamePasswordProviderClass != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationUtils.createUsernamePasswordProvider(this.usernamePasswordProviderClass);
            } else if (this.passwordFile != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile);
            }
            if (iAuthenticateUsernamePasswordProvider != null) {
                iAuthenticateUsernamePasswordProvider.setRTPSession(rTPSession);
                if (string10 != null && string8 != null && object != null && (string2 = iAuthenticateUsernamePasswordProvider.getPassword((String)object)) != null) {
                    String string13;
                    String string14 = string3 = string3 != null ? string3 : this.realm;
                    if (string3 != null && string4 != null && this.savedNonce != null && string4.equals(this.savedNonce) && (string13 = MD5DigestUtils.generateAuth(string10, string8, (String)object, string2, string3, string4, string7, string5, string6)) != null && string13.equals(string9)) {
                        bl = true;
                        this.isAuthenticated = true;
                    }
                }
            } else {
                WMSLoggerFactory.getLogger(AuthenticationPasswordFile.class).warn("AuthenticateDigest.authenticateRTSP: Password file not found: " + this.passwordFile);
            }
        }
        if (!bl) {
            stringArray = new RTPRequestStatus();
            RTSPStatics.setStatus((RTPRequestStatus)stringArray, 401);
            object = new RTSPResponseMessage();
            ((RTSPResponseMessage)object).setResponseCode(stringArray.getResponseCode());
            ((RTSPResponseMessage)object).setResponseMessage(stringArray.getResponseMessage());
            ((RTSPResponseMessage)object).setHeader("WWW-Authenticate", this.getAuthString(rTSPRequestMessage.getWMSSessionInfo().getIpAddress()));
            ((RTSPResponseMessage)object).setCSeq(rTSPRequestMessage.getCSeq());
            ((RTSPResponseMessage)object).setSession(rTPSession.getSessionId());
            rTSPResponseMessages.addMessage((RTSPResponseMessage)object);
        }
        return bl;
    }

    private String[] getHTTProviderAuthString() {
        String[] stringArray = new String[2];
        stringArray[1] = "Digest";
        String string = "";
        if (this.realm != null) {
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + " realm=\"" + this.realm + "\"";
        }
        stringArray[0] = MD5DigestUtils.generateHash(this.realm + ":" + System.currentTimeMillis() + ":" + NOUNCEKEY);
        if (string.length() > 0) {
            string = string + ", ";
        }
        string = string + " nonce=\"" + stringArray[0] + "\"";
        string = string + ", algorithm=MD5";
        string = string + ", qop=\"auth\"";
        stringArray[1] = stringArray[1] + string;
        return stringArray;
    }

    private void trim(IVHost iVHost) {
        long l = System.currentTimeMillis();
        if (this.lastTrimTime >= 0L) {
            if (l - this.lastTrimTime > 5000L) {
                iVHost.getHandlerThreadPool().execute(this);
                this.lastTrimTime = l;
            }
        } else {
            this.lastTrimTime = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, HTTPProviderSessions> map = this.httpProviderSessions;
        synchronized (map) {
            arrayList.addAll(this.httpProviderSessions.keySet());
        }
        for (String string : arrayList) {
            HTTPProviderSessions hTTPProviderSessions = null;
            Map<String, HTTPProviderSessions> map2 = this.httpProviderSessions;
            synchronized (map2) {
                hTTPProviderSessions = this.httpProviderSessions.get(string);
                if (hTTPProviderSessions == null) {
                    continue;
                }
                if (hTTPProviderSessions.isTimeout()) {
                    this.httpProviderSessions.remove(string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateHTTPProvider(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        String[] stringArray;
        boolean bl = false;
        this.trim(iVHost);
        String string = iHTTPRequest.getHeader("authorization");
        if (string != null) {
            Object object;
            String string2;
            if ((string = string.trim()).toLowerCase().startsWith("digest ")) {
                string = string.substring(7);
            }
            string = string.trim();
            stringArray = HTTPUtils.splitPragmas(string);
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = iHTTPRequest.getHeader("method").toUpperCase();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i];
                if (string2.length() == 0) continue;
                int n = string2.indexOf(61);
                if (n < 0) break;
                object = string2.substring(0, n).trim();
                String string12 = string2.substring(n + 1).trim();
                if ("username".equals(object)) {
                    string3 = this.removeQuotes(string12);
                }
                if ("realm".equals(object)) {
                    string4 = this.removeQuotes(string12, true);
                }
                if ("nonce".equals(object)) {
                    string5 = this.removeQuotes(string12);
                }
                if ("nc".equals(object)) {
                    string6 = this.removeQuotes(string12);
                }
                if ("cnonce".equals(object)) {
                    string7 = this.removeQuotes(string12);
                }
                if ("qop".equals(object)) {
                    string8 = this.removeQuotes(string12);
                }
                if ("uri".equals(object)) {
                    string9 = this.removeQuotes(string12);
                }
                if (!"response".equals(object)) continue;
                string10 = this.removeQuotes(string12);
            }
            IAuthenticateUsernamePasswordProvider iAuthenticateUsernamePasswordProvider = null;
            if (this.usernamePasswordProviderClass != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationUtils.createUsernamePasswordProvider(this.usernamePasswordProviderClass);
            } else if (this.passwordFile != null) {
                iAuthenticateUsernamePasswordProvider = AuthenticationPasswordFiles.getInstance().getPasswordFile(this.passwordFile);
            }
            if (iAuthenticateUsernamePasswordProvider != null) {
                iAuthenticateUsernamePasswordProvider.setVHost(iVHost);
                if (string11 != null && string9 != null && string3 != null && (string2 = iAuthenticateUsernamePasswordProvider.getPassword(string3)) != null) {
                    String string13 = string4 = string4 != null ? string4 : this.realm;
                    if (string4 != null && string5 != null) {
                        HTTPProviderSessions hTTPProviderSessions = null;
                        object = this.httpProviderSessions;
                        synchronized (object) {
                            hTTPProviderSessions = this.httpProviderSessions.get(string5);
                        }
                        if (hTTPProviderSessions != null) {
                            hTTPProviderSessions.touch();
                            object = MD5DigestUtils.generateAuthHTTP(string11, string9, string3, string2, string4, string5, string8, string6, string7);
                            if (object != null && ((String)object).equals(string10)) {
                                hTTPProviderSessions.setCNonce(string7);
                                bl = true;
                            }
                        }
                    }
                }
            } else {
                WMSLoggerFactory.getLogger(AuthenticationPasswordFile.class).warn("AuthenticateDigest.authenticateRTSP: Password file not found: " + this.passwordFile);
            }
        }
        if (!bl) {
            iHTTPResponse.setResponseCode(401);
            stringArray = this.getHTTProviderAuthString();
            iHTTPResponse.setHeader("WWW-Authenticate", stringArray[1]);
            this.httpProviderSessions.put(stringArray[0], new HTTPProviderSessions(stringArray[0]));
        }
        return bl;
    }

    class HTTPProviderSessions {
        long lastTouch = -1L;
        String nonce = "";
        String cnonce = "";

        public HTTPProviderSessions(String string) {
            this.nonce = string;
            this.touch();
        }

        public void setCNonce(String string) {
            this.cnonce = string;
        }

        public void touch() {
            this.lastTouch = System.currentTimeMillis();
        }

        public boolean isTimeout() {
            long l = System.currentTimeMillis();
            return l - this.lastTouch > 600000L;
        }
    }
}

