/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.media.h264;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragmentList;

public class H264Utils {
    public static final int[][] pixel_aspect = new int[][]{{0, 1}, {1, 1}, {12, 11}, {10, 11}, {16, 11}, {40, 33}, {24, 11}, {20, 11}, {32, 11}, {80, 33}, {18, 11}, {15, 11}, {64, 33}, {160, 99}, {4, 3}, {3, 2}, {2, 1}};
    public static final byte[][] default_scaling4 = new byte[][]{{6, 13, 20, 28, 13, 20, 28, 32, 20, 28, 32, 37, 28, 32, 37, 42}, {10, 14, 20, 24, 14, 20, 24, 27, 20, 24, 27, 30, 24, 27, 30, 34}};
    public static final byte[][] default_scaling8 = new byte[][]{{6, 10, 13, 16, 18, 23, 25, 27, 10, 11, 16, 18, 23, 25, 27, 29, 13, 16, 18, 23, 25, 27, 29, 31, 16, 18, 23, 25, 27, 29, 31, 33, 18, 23, 25, 27, 29, 31, 33, 36, 23, 25, 27, 29, 31, 33, 36, 38, 25, 27, 29, 31, 33, 36, 38, 40, 27, 29, 31, 33, 36, 38, 40, 42}, {9, 13, 15, 17, 19, 21, 22, 24, 13, 13, 17, 19, 21, 22, 24, 25, 15, 17, 19, 21, 22, 24, 25, 27, 17, 19, 21, 22, 24, 25, 27, 28, 19, 21, 22, 24, 25, 27, 28, 30, 21, 22, 24, 25, 27, 28, 30, 32, 22, 24, 25, 27, 28, 30, 32, 33, 24, 25, 27, 28, 30, 32, 33, 35}};
    public static final byte[] zigzag_scan = new byte[]{0, 1, 4, 8, 5, 2, 3, 6, 9, 12, 13, 10, 7, 11, 14, 15};
    public static final byte[] zigzag_scan8x8 = new byte[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public static H264CodecConfigInfo decodeAVCC(byte[] byArray) {
        return H264Utils.decodeAVCC(byArray, 0);
    }

    static String levelIDCToString(int n) {
        String string = n / 10 + "." + n % 10;
        if (n == 27) {
            string = "1b";
        }
        return string;
    }

    static String profileIDCToString(int n) {
        String string = "" + n;
        switch (n) {
            case 66: {
                string = "Baseline";
                break;
            }
            case 77: {
                string = "Main";
                break;
            }
            case 88: {
                string = "Extended";
                break;
            }
            case 100: {
                string = "High";
                break;
            }
            case 110: {
                string = "High 10 or High 10 Intra";
                break;
            }
            case 122: {
                string = "High 4:2:2 or High 4:2:2 Intra";
                break;
            }
            case 244: {
                string = "High 4:4:4 predictive or High 4:4:4 Intra";
                break;
            }
            case 44: {
                string = "CAVLC 4:4:4 Intra";
            }
        }
        return string;
    }

    public static H264CodecConfigInfo decodeAVCC(byte[] byArray, int n) {
        H264CodecConfigInfo h264CodecConfigInfo = new H264CodecConfigInfo();
        try {
            int n2 = n + 6;
            int n3 = BufferUtils.byteArrayToInt(byArray, n2, 2);
            BitReader bitReader = new BitReader(byArray);
            bitReader.skip((n2 += 2) * 8);
            bitReader.skip(8);
            h264CodecConfigInfo.profileIDC = bitReader.getInt(8);
            bitReader.skip(4);
            bitReader.skip(4);
            h264CodecConfigInfo.levelIDC = bitReader.getInt(8);
            h264CodecConfigInfo.spsID = bitReader.readExpGolomb();
            if (h264CodecConfigInfo.profileIDC >= 100) {
                h264CodecConfigInfo.chromaFormatIDC = bitReader.readExpGolomb();
                h264CodecConfigInfo.residualColorTransformFlag = 0;
                if (h264CodecConfigInfo.chromaFormatIDC == 3) {
                    h264CodecConfigInfo.residualColorTransformFlag = bitReader.getInt(1);
                }
                h264CodecConfigInfo.bitDepthLumaMinus8 = bitReader.readExpGolomb();
                h264CodecConfigInfo.bitDepthChromaMinus8 = bitReader.readExpGolomb();
                h264CodecConfigInfo.transformBypass = bitReader.getInt(1);
                h264CodecConfigInfo.scalingMatrixFlag = bitReader.getInt(1);
                if (h264CodecConfigInfo.scalingMatrixFlag == 1) {
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[0]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    H264Utils.decode_scaling_list(bitReader, 16, default_scaling4[1]);
                    if (h264CodecConfigInfo.profileIDC >= 100) {
                        H264Utils.decode_scaling_list(bitReader, 64, default_scaling8[0]);
                        H264Utils.decode_scaling_list(bitReader, 64, default_scaling8[1]);
                    }
                }
            }
            h264CodecConfigInfo.log2MaxFrameNum = bitReader.readExpGolomb() + 4;
            h264CodecConfigInfo.pocType = bitReader.readExpGolomb();
            h264CodecConfigInfo.log2MaxPocLSB = 0;
            if (h264CodecConfigInfo.pocType == 0) {
                h264CodecConfigInfo.log2MaxPocLSB = bitReader.readExpGolomb() + 4;
            } else if (h264CodecConfigInfo.pocType == 1) {
                h264CodecConfigInfo.deltaPicOrderAlwaysZeroFlag = bitReader.getInt(1);
                h264CodecConfigInfo.offsetForNonRefPic = bitReader.readExpGolombSigned();
                h264CodecConfigInfo.offsetForTopToBottomField = bitReader.readExpGolombSigned();
                h264CodecConfigInfo.pocCycleLength = bitReader.readExpGolomb();
                h264CodecConfigInfo.offsetForRefFrame = new int[h264CodecConfigInfo.pocCycleLength];
                for (int i = 0; i < h264CodecConfigInfo.pocCycleLength; ++i) {
                    h264CodecConfigInfo.offsetForRefFrame[i] = bitReader.readExpGolombSigned();
                }
            } else if (h264CodecConfigInfo.pocType != 2) {
                // empty if block
            }
            h264CodecConfigInfo.refFrameCount = bitReader.readExpGolomb();
            h264CodecConfigInfo.gapsInFrameNumAllowedFlag = bitReader.getInt(1);
            h264CodecConfigInfo.mbWidth = bitReader.readExpGolomb() + 1;
            h264CodecConfigInfo.mbHeight = bitReader.readExpGolomb() + 1;
            h264CodecConfigInfo.frameMBSOnlyFlag = bitReader.getInt(1);
            h264CodecConfigInfo.mbAFF = 0;
            if (h264CodecConfigInfo.frameMBSOnlyFlag == 0) {
                h264CodecConfigInfo.mbAFF = bitReader.getInt(1);
            }
            h264CodecConfigInfo.adjWidth = h264CodecConfigInfo.mbWidth;
            h264CodecConfigInfo.adjHeight = h264CodecConfigInfo.mbHeight * (2 - h264CodecConfigInfo.frameMBSOnlyFlag);
            h264CodecConfigInfo.direct8x8InferenceFlag = bitReader.getInt(1);
            h264CodecConfigInfo.crop = bitReader.getInt(1);
            h264CodecConfigInfo.cropLeft = 0;
            h264CodecConfigInfo.cropRight = 0;
            h264CodecConfigInfo.cropTop = 0;
            h264CodecConfigInfo.cropBottom = 0;
            if (h264CodecConfigInfo.crop != 0) {
                h264CodecConfigInfo.cropLeft = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropRight = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropTop = bitReader.readExpGolomb();
                h264CodecConfigInfo.cropBottom = bitReader.readExpGolomb();
            }
            h264CodecConfigInfo.vuiParametersPresentFlag = bitReader.getInt(1);
            if (h264CodecConfigInfo.vuiParametersPresentFlag != 0) {
                h264CodecConfigInfo.sarNum = 0;
                h264CodecConfigInfo.sarDen = 0;
                h264CodecConfigInfo.aspectRatioIDC = 0;
                h264CodecConfigInfo.aspectRatioInfoPresentFlag = bitReader.getInt(1);
                if (h264CodecConfigInfo.aspectRatioInfoPresentFlag != 0) {
                    h264CodecConfigInfo.aspectRatioIDC = bitReader.getInt(8);
                    if (h264CodecConfigInfo.aspectRatioIDC == 255) {
                        h264CodecConfigInfo.sarNum = bitReader.getInt(16);
                        h264CodecConfigInfo.sarDen = bitReader.getInt(16);
                    } else if (h264CodecConfigInfo.aspectRatioIDC < pixel_aspect.length) {
                        h264CodecConfigInfo.sarNum = pixel_aspect[h264CodecConfigInfo.aspectRatioIDC][0];
                        h264CodecConfigInfo.sarDen = pixel_aspect[h264CodecConfigInfo.aspectRatioIDC][1];
                    }
                }
            }
            h264CodecConfigInfo.height = 0;
            h264CodecConfigInfo.width = 16 * h264CodecConfigInfo.mbWidth - 2 * (h264CodecConfigInfo.cropLeft + h264CodecConfigInfo.cropRight);
            h264CodecConfigInfo.height = h264CodecConfigInfo.frameMBSOnlyFlag != 0 ? 16 * h264CodecConfigInfo.adjHeight - 2 * (h264CodecConfigInfo.cropTop + h264CodecConfigInfo.cropBottom) : 16 * h264CodecConfigInfo.adjHeight - 4 * (h264CodecConfigInfo.cropTop + h264CodecConfigInfo.cropBottom);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(H264Utils.class).error("H264CodecConfigInfo.decodeAVCC: " + exception.toString());
            exception.printStackTrace();
        }
        return h264CodecConfigInfo;
    }

    static void decode_scaling_list(BitReader bitReader, int n, byte[] byArray) {
        byte[] byArray2 = n == 16 ? zigzag_scan : zigzag_scan8x8;
        int n2 = bitReader.getInt(1);
        if (n2 == 1) {
            int n3 = 8;
            int n4 = 8;
            for (int i = 0; i < n; ++i) {
                if (n3 != 0) {
                    int n5 = bitReader.readExpGolombSigned();
                    n3 = n4 + n5 & 0xFF;
                }
                if (i == 0 && n3 == 0) break;
                byte by = (byte)(n3 != 0 ? n3 : n4);
                byArray[byArray2[i]] = by;
                n4 = by;
            }
        }
    }

    public static H264CodecConfigParts breakApartAVCC(byte[] byArray, int n, int n2) {
        H264CodecConfigParts h264CodecConfigParts;
        block4: {
            h264CodecConfigParts = new H264CodecConfigParts();
            try {
                int n3 = 1;
                if (n3 + 3 > n2) break block4;
                h264CodecConfigParts.profileLevel = new byte[3];
                System.arraycopy(byArray, n + n3, h264CodecConfigParts.profileLevel, 0, h264CodecConfigParts.profileLevel.length);
                n3 += h264CodecConfigParts.profileLevel.length;
                if ((n3 += 2) + 2 > n2) break block4;
                int n4 = BufferUtils.byteArrayToInt(byArray, n + n3, 2);
                if (n4 <= 0 || n4 > n2 - (n3 += 2)) break block4;
                h264CodecConfigParts.sps = new byte[n4];
                System.arraycopy(byArray, n + n3, h264CodecConfigParts.sps, 0, h264CodecConfigParts.sps.length);
                if ((n3 += h264CodecConfigParts.sps.length) + 1 > n2) break block4;
                int n5 = BufferUtils.byteArrayToInt(byArray, n + n3, 1);
                ++n3;
                for (int i = 0; i < n5 && n3 + 2 <= n2; ++i) {
                    int n6 = BufferUtils.byteArrayToInt(byArray, n + n3, 2);
                    if (n6 > 0 && n6 <= n2 - (n3 += 2)) {
                        byte[] byArray2 = new byte[n6];
                        System.arraycopy(byArray, n + n3, byArray2, 0, byArray2.length);
                        n3 += byArray2.length;
                        h264CodecConfigParts.addPPS(byArray2);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return h264CodecConfigParts;
    }

    public static RTPPacketFragmentList breakH264PacketIntoDelimitedNALUnits(byte[] byArray, int n, int n2, int n3, H264CodecConfigParts h264CodecConfigParts) {
        int n4;
        RTPPacketFragmentList rTPPacketFragmentList = new RTPPacketFragmentList();
        int n5 = n2;
        byte[] byArray2 = new byte[4];
        byArray2[3] = 1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (n8 + 4 <= n5 && (n4 = BufferUtils.byteArrayToInt(byArray, n + n8, 4)) > 0 && (n8 += 4) + n4 <= n5) {
            int n9 = byArray[n + n8] & 0x1F;
            if (n9 == 7) {
                bl = true;
            } else if (n9 == 8) {
                bl2 = true;
            } else if (n9 == 9) {
                bl3 = true;
            }
            rTPPacketFragmentList.addPacketFragment(new RTPPacketFragment(byArray2, 0, byArray2.length));
            rTPPacketFragmentList.addPacketFragment(new RTPPacketFragment(byArray, n + n8, n4));
            n6 += n4 + byArray2.length;
            ++n7;
            if ((n8 += n4) < n5) continue;
            break;
        }
        n4 = 0;
        if (!bl3 && !bl3) {
            byte[] byArray3 = new byte[6];
            byArray3[3] = 1;
            byArray3[4] = 9;
            byArray3[5] = n3 == 1 ? 16 : (n3 == 3 ? 80 : 48);
            rTPPacketFragmentList.addPacketFragment(n4, new RTPPacketFragment(byArray3, 0, byArray3.length));
            ++n4;
            n6 += byArray3.length;
            ++n7;
        }
        if (!(n3 != 1 || bl2 && bl3)) {
            if (n3 == 1 && !bl && h264CodecConfigParts != null && h264CodecConfigParts.sps != null) {
                byte[] byArray4 = new byte[4];
                byArray4[3] = 1;
                rTPPacketFragmentList.addPacketFragment(n4, new RTPPacketFragment(byArray4, 0, byArray4.length));
                rTPPacketFragmentList.addPacketFragment(++n4, new RTPPacketFragment(h264CodecConfigParts.sps, 0, h264CodecConfigParts.sps.length));
                ++n4;
                n6 += h264CodecConfigParts.sps.length + byArray4.length;
                ++n7;
            }
            if (n3 == 1 && !bl2 && h264CodecConfigParts != null && h264CodecConfigParts.ppss != null) {
                for (byte[] byArray5 : h264CodecConfigParts.ppss) {
                    byte[] byArray6 = new byte[4];
                    byArray6[3] = 1;
                    rTPPacketFragmentList.addPacketFragment(n4, new RTPPacketFragment(byArray6, 0, byArray6.length));
                    rTPPacketFragmentList.addPacketFragment(++n4, new RTPPacketFragment(byArray5, 0, byArray5.length));
                    ++n4;
                    n6 += byArray5.length + byArray6.length;
                    ++n7;
                }
            }
        }
        return rTPPacketFragmentList;
    }

    public static final byte[] configPartsToSmoothPrivateData(H264CodecConfigParts h264CodecConfigParts) {
        Object object;
        int n = 0;
        n += h264CodecConfigParts.sps != null ? 4 + h264CodecConfigParts.sps.length : 0;
        if (h264CodecConfigParts.ppss != null) {
            object = h264CodecConfigParts.ppss.iterator();
            while (object.hasNext()) {
                byte[] byArray = (byte[])object.next();
                n += 4 + byArray.length;
            }
        }
        object = new byte[n];
        int n2 = 0;
        if (h264CodecConfigParts.sps != null) {
            object[n2 + 3] = true;
            System.arraycopy(h264CodecConfigParts.sps, 0, object, n2 += 4, h264CodecConfigParts.sps.length);
            n2 += h264CodecConfigParts.sps.length;
        }
        if (h264CodecConfigParts.ppss != null) {
            for (byte[] byArray : h264CodecConfigParts.ppss) {
                object[n2 + 3] = true;
                System.arraycopy(byArray, 0, object, n2 += 4, byArray.length);
                n2 += byArray.length;
            }
        }
        return object;
    }
}

