/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaCasterStreamManager {
    private MediaCasterStreamMap mediaCasterStreamMap = null;
    Map<String, MediaCasterHolder> streams = new HashMap<String, MediaCasterHolder>();

    public MediaCasterStreamManager(MediaCasterStreamMap mediaCasterStreamMap) {
        this.mediaCasterStreamMap = mediaCasterStreamMap;
    }

    public String[] getStreamArray() {
        List<String> list = this.getStreamList();
        return list.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStreamList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        WMSReadWriteLock wMSReadWriteLock = this.mediaCasterStreamMap.getLock();
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList.addAll(this.streams.keySet());
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamManager.streamExists: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean streamExists(String string) {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.mediaCasterStreamMap.getLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.streams.containsKey(string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamManager.streamExists: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopStream(String string) {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.mediaCasterStreamMap.getLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            MediaCasterHolder mediaCasterHolder = this.streams.remove(string);
            if (mediaCasterHolder == null) {
                WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).warn("MediaCasterStreamManager.stopStream: Stream does not exist: " + string);
            } else {
                mediaCasterHolder.mediaCasterStreamItem.setShutdownOnRelease(true);
                this.mediaCasterStreamMap.release(mediaCasterHolder.mediaCasterStreamItem, true);
                bl = true;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamManager.stopStream: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startStream(String string, String string2) {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.mediaCasterStreamMap.getLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            IApplicationInstance iApplicationInstance = this.mediaCasterStreamMap.getApplicationInstance();
            IVHost iVHost = iApplicationInstance.getVHost();
            MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
            if (mediaCasterList == null) {
            } else {
                MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string2);
                if (mediaCasterItem == null) {
                    WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).warn("MediaCasterStreamManager.startStream: mediaCasterType not found: " + string2);
                } else {
                    MediaCasterStreamItem mediaCasterStreamItem = this.mediaCasterStreamMap.getMediaCaster(string);
                    if (mediaCasterStreamItem != null) {
                        WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).warn("MediaCasterStreamManager.startStream: Stream name already exists: " + string);
                    } else {
                        mediaCasterStreamItem = this.mediaCasterStreamMap.acquire(string, mediaCasterItem);
                        if (mediaCasterStreamItem == null) {
                            WMSLoggerFactory.getLogger(MediaCasterStreamManager.class).warn("MediaCasterStreamManager.startStream: Unknown error starting stream: " + string);
                        } else {
                            this.streams.put(string, new MediaCasterHolder(mediaCasterStreamItem));
                            bl = true;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(MediaCasterStreamMap.class).error("MediaCasterStreamManager.startStream: " + exception.toString());
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
        return bl;
    }

    class MediaCasterHolder {
        MediaCasterStreamItem mediaCasterStreamItem = null;

        public MediaCasterHolder(MediaCasterStreamItem mediaCasterStreamItem) {
            this.mediaCasterStreamItem = mediaCasterStreamItem;
        }
    }
}

