/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.rtp;

import com.wowza.util.HTTPUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCaster;
import com.wowza.wms.mediacaster.rtp.IRTPSessionDescriptionDataProvider;
import com.wowza.wms.mediacaster.rtp.IRTPSessionDescriptionSessionHandler;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionData;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasicRTSPRequest;
import com.wowza.wms.mediacaster.rtp.RTPSessionDescriptionDataProviderBasicRTSPWorker;
import com.wowza.wms.rtp.model.RTPSession;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class RTPSessionDescriptionDataProviderBasic
implements IRTPSessionDescriptionDataProvider {
    public static final long MAXSDPFILESIZE = 25600L;
    private RTPSessionDescriptionDataProviderBasicRTSPWorker rtspWorker = null;
    private Object rtspLock = new Object();
    private int rtspSessionTimeout = 8000;
    private int rtspConnectionTimeout = 8000;
    private int sdpFileCheckFrequency = 0;
    private int sdpHTTPCheckFrequency = 0;
    private long sdpHTTPLastCheck = -1L;
    private String sdpHTTPURL = null;
    private Checksum sdpHTTPChecksum = null;
    private boolean sdpHTTPRunning = false;
    private boolean sdpHTTPNeedsReset = false;
    private String sdpFilePath = null;
    private long sdpFileLastCheck = -1L;
    private long sdpFileLastMod = -1L;
    private long sdpFileSize = -1L;

    public void init(MediaCaster mediaCaster) {
        this.rtspSessionTimeout = mediaCaster.getProperties().getPropertyInt("rtspSessionTimeout", this.rtspSessionTimeout);
        this.rtspConnectionTimeout = mediaCaster.getProperties().getPropertyInt("rtspConnectionTimeout", this.rtspConnectionTimeout);
        this.sdpFileCheckFrequency = mediaCaster.getProperties().getPropertyInt("sdpFileCheckFreqency", this.sdpFileCheckFrequency);
        this.sdpFileCheckFrequency = mediaCaster.getProperties().getPropertyInt("sdpFileCheckFrequency", this.sdpFileCheckFrequency);
        this.sdpHTTPCheckFrequency = mediaCaster.getProperties().getPropertyInt("sdpHTTPCheckFreqency", this.sdpHTTPCheckFrequency);
        this.sdpHTTPCheckFrequency = mediaCaster.getProperties().getPropertyInt("sdpHTTPCheckFrequency", this.sdpHTTPCheckFrequency);
        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).debug("RTPSessionDescriptionDataProviderBasic.rtspSessionTimeout: " + this.rtspSessionTimeout);
        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).debug("RTPSessionDescriptionDataProviderBasic.rtspConnectionTimeout: " + this.rtspConnectionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPSessionDescriptionData getSessionDescriptionData(IApplicationInstance iApplicationInstance, String string, int n, IRTPSessionDescriptionSessionHandler iRTPSessionDescriptionSessionHandler) {
        byte[] byArray;
        boolean bl;
        boolean bl2;
        String string2;
        RTPSessionDescriptionData rTPSessionDescriptionData;
        block62: {
            rTPSessionDescriptionData = new RTPSessionDescriptionData();
            string2 = null;
            bl2 = false;
            bl = false;
            byArray = null;
            string = iApplicationInstance.getStreamNameAliasProvider().resolveStreamAlias(iApplicationInstance, string);
            if (string != null) {
                String string3;
                if (string.indexOf("udp://") >= 0) {
                    Serializable serializable;
                    bl = true;
                    if (n == 0) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("RTPSessionDescriptionDataProviderBasic.getStreamInfo: URI: " + string);
                    }
                    string3 = string;
                    String string4 = null;
                    String string5 = null;
                    int n2 = -1;
                    try {
                        serializable = new URI(string3);
                        if (serializable != null) {
                            string4 = ((URI)serializable).getHost();
                            n2 = ((URI)serializable).getPort();
                            string5 = ((URI)serializable).getQuery();
                        }
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).error("RTPSessionDescriptionDataProviderBasic.getStreamInfo: MPEG-TS: " + exception.toString());
                    }
                    if (string4 != null) {
                        string2 = "";
                        serializable = new Random(System.currentTimeMillis());
                        int n3 = ((Random)serializable).nextInt();
                        string2 = string2 + "v=0\n";
                        string2 = string2 + "o=- " + n3 + " " + n3 + " IN IP4 127.0.0.1\n";
                        string2 = string2 + "s=WowzaMediaServerPro MPEG-TS\n";
                        string2 = string2 + "t=0 0\n";
                        string2 = string2 + "a=range:npt=now-\n";
                        string2 = string2 + "c=IN IP4 " + string4 + "\n";
                        string2 = string2 + "m=mpegts-transport " + n2 + " RTP/AVP 96\n";
                        string2 = string2 + "a=rtpmap:96 MP2T/90000\n";
                        string2 = string2 + "a=control:mpegts\n";
                        String string6 = null;
                        String string7 = null;
                        if (string5 != null) {
                            String[] stringArray = string5.split("[&]");
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string8 = stringArray[i].trim();
                                if (string8.length() <= 0) continue;
                                String string9 = string8;
                                String string10 = null;
                                int n4 = string8.indexOf("=");
                                if (n4 >= 0) {
                                    string9 = string8.substring(0, n4).trim();
                                    string10 = string8.substring(n4 + 1).trim();
                                }
                                if (string9.equalsIgnoreCase("audioPID")) {
                                    string6 = string10;
                                }
                                if (!string9.equalsIgnoreCase("videoPID")) continue;
                                string7 = string10;
                            }
                        }
                        if (string6 != null) {
                            string2 = string2 + "a=audioPID:" + string6 + "\n";
                        }
                        if (string7 != null) {
                            string2 = string2 + "a=videoPID:" + string7 + "\n";
                        }
                    } else if (n == 0) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).warn("RTPSessionDescriptionDataProviderBasic.getStreamInfo: Invalid URI: " + string);
                    }
                } else {
                    if (string.indexOf("rtsp://") >= 0) {
                        bl2 = true;
                        string3 = string;
                        boolean bl3 = false;
                        Object object = this.rtspLock;
                        synchronized (object) {
                            if (this.rtspWorker != null) {
                                this.rtspWorker.close();
                            }
                            this.rtspWorker = null;
                            this.rtspWorker = new RTPSessionDescriptionDataProviderBasicRTSPWorker(this, iApplicationInstance);
                            bl3 = this.rtspWorker.doConnect(string3, this.rtspConnectionTimeout);
                        }
                        if (!bl3) {
                            if (n == 0) {
                                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).warn("RTPSessionDescriptionDataProviderBasic.getStreamInfo: RTSP/RTP re-streaming. Cannot connect to server: " + string);
                            }
                            object = this.rtspLock;
                            synchronized (object) {
                                if (this.rtspWorker != null) {
                                    this.rtspWorker.close();
                                }
                                this.rtspWorker = null;
                            }
                        }
                        long l = System.currentTimeMillis();
                        while (true) {
                            String string11 = null;
                            Object object2 = this.rtspLock;
                            synchronized (object2) {
                                string11 = this.rtspWorker.getSDPData();
                            }
                            if (string11 != null) {
                                string2 = string11;
                                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("RTPSessionDescriptionDataProviderBasic.getStreamInfo: RTSP/RTP re-streaming. Success, received SDP data.");
                                break block62;
                            }
                            if (System.currentTimeMillis() - l > (long)this.rtspSessionTimeout) {
                                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).warn("RTPSessionDescriptionDataProviderBasic.getStreamInfo: RTSP/RTP re-streaming timeout.");
                                break block62;
                            }
                            try {
                                Thread.currentThread();
                                Thread.sleep(250L);
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).error("RTPSessionDescriptionDataProviderBasic.getStreamInfo: Sleep: " + exception.toString());
                                break block62;
                            }
                        }
                    }
                    if (string.indexOf("http://") >= 0) {
                        string3 = string;
                        if (n == 0) {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("RTPSessionDescriptionDataProviderBasic.getStreamInfo: URL: " + string);
                        }
                        byArray = HTTPUtils.HTTPRequestToByteArray(string3, "GET", null, null, null, 25600L);
                        Object object = this.rtspLock;
                        synchronized (object) {
                            this.sdpHTTPURL = null;
                            if (byArray != null) {
                                this.sdpHTTPURL = string;
                                this.sdpHTTPChecksum = new CRC32();
                                this.sdpHTTPChecksum.update(byArray, 0, byArray.length);
                                this.sdpHTTPLastCheck = System.currentTimeMillis();
                            }
                        }
                        if (byArray != null) {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).debug("RTPSessionDescriptionDataProviderBasic.getStreamInfo: HTTPRequest: got result: " + byArray.length);
                        } else {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).warn("RTPSessionDescriptionDataProviderBasic.getStreamInfo: HTTPRequest: return: null");
                        }
                    } else {
                        File file;
                        string3 = iApplicationInstance.getStreamStoragePath() + "/" + string;
                        if (n == 0) {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("RTPSessionDescriptionDataProviderBasic.getStreamInfo: " + string3.replace("\\", "/"));
                        }
                        if ((file = new File(string3)).exists()) {
                            int n5 = (int)file.length();
                            if (n5 <= 0x200000) {
                                BufferedInputStream bufferedInputStream = null;
                                try {
                                    int n6;
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                                    int n7 = 4096;
                                    byte[] byArray2 = new byte[n7];
                                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                                    while ((n6 = bufferedInputStream.read(byArray2, 0, n7)) > 0) {
                                        dataOutputStream.write(byArray2, 0, n6);
                                    }
                                    byArray = byteArrayOutputStream.toByteArray();
                                    Object object = this.rtspLock;
                                    synchronized (object) {
                                        this.sdpFilePath = string3;
                                        this.sdpFileLastMod = file.lastModified();
                                        this.sdpFileSize = file.length();
                                        this.sdpFileLastCheck = System.currentTimeMillis();
                                    }
                                }
                                catch (Exception exception) {
                                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).error("RTPSessionDescriptionDataProviderBasic.getStreamInfo[1]: Problem reading SDP file (" + string3 + "): " + exception.toString());
                                }
                                try {
                                    if (bufferedInputStream != null) {
                                        bufferedInputStream.close();
                                    }
                                    bufferedInputStream = null;
                                }
                                catch (Exception exception) {
                                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).error("RTPSessionDescriptionDataProviderBasic.getStreamInfo[2]: Problem reading SDP file (" + string3 + "): " + exception.toString());
                                }
                            } else {
                                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).warn("RTPSessionDescriptionDataProviderBasic.getStreamInfo[3]: SDP file too large. Limit is 2MB. (" + string3 + "): " + n5);
                            }
                        } else if (n == 0) {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).warn("RTPSessionDescriptionDataProviderBasic.getStreamInfo: SDP file missing: " + string3.replace("\\", "/"));
                        }
                    }
                }
            }
        }
        if (byArray != null) {
            try {
                string2 = new String(byArray);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).error("RTPSessionDescriptionDataProviderBasic.getStreamInfo: Problem reading SDP data (" + string + "): " + exception.toString());
            }
        }
        string2 = this.filterSessionDescriptionData(string2);
        rTPSessionDescriptionData.setSessionDescriptionData(string2);
        rTPSessionDescriptionData.setPortsNegotiated(bl2);
        rTPSessionDescriptionData.setSinglePort(bl);
        return rTPSessionDescriptionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIdle(MediaCaster mediaCaster) {
        boolean bl = false;
        long l = System.currentTimeMillis();
        Object object = this.rtspLock;
        synchronized (object) {
            if (this.sdpFilePath != null && this.sdpFileCheckFrequency > 0 && l - this.sdpFileLastCheck > (long)this.sdpFileCheckFrequency) {
                try {
                    File file = new File(this.sdpFilePath);
                    if (file.exists()) {
                        long l2 = file.lastModified();
                        long l3 = file.length();
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).debug("RTPSessionDescriptionDataProviderBasic.doIdle: Check SDP file (" + file.getAbsolutePath() + "): date:" + this.sdpFileLastMod + "=" + l2 + " size:" + this.sdpFileSize + "=" + l3);
                        if (this.sdpFileLastMod != l2 || this.sdpFileSize != l3) {
                            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("RTPSessionDescriptionDataProviderBasic.doIdle: Check SDP file (" + file.getAbsolutePath() + "): Reset: date:" + this.sdpFileLastMod + "=" + l2 + " size:" + this.sdpFileSize + "=" + l3);
                            this.sdpFilePath = null;
                            bl = true;
                        }
                    } else {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("RTPSessionDescriptionDataProviderBasic.doIdle: Check SDP file (" + file.getAbsolutePath() + "): Reset: File missing.");
                        this.sdpFilePath = null;
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sdpFileLastCheck = l;
            }
            if (this.sdpHTTPURL != null) {
                if (this.sdpHTTPNeedsReset) {
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("RTPSessionDescriptionDataProviderBasic.doIdle: Check SDP URL (" + this.sdpHTTPURL + "): Reset.");
                    this.sdpHTTPURL = null;
                    bl = true;
                } else if (this.sdpHTTPCheckFrequency > 0 && l - this.sdpHTTPLastCheck > (long)this.sdpHTTPCheckFrequency && !this.sdpHTTPRunning) {
                    mediaCaster.getAppInstance().getVHost().getThreadPool().execute(new SDPHTTPCheck(this.sdpHTTPURL, this.sdpHTTPChecksum));
                    this.sdpHTTPLastCheck = l;
                }
            }
            if (!bl && this.rtspWorker != null) {
                this.rtspWorker.doIdle();
            }
        }
        if (bl) {
            mediaCaster.forceReset();
        }
        return bl;
    }

    protected String filterSessionDescriptionData(String string) {
        return string;
    }

    protected void rtspMessageHook(RTPSessionDescriptionDataProviderBasicRTSPRequest rTPSessionDescriptionDataProviderBasicRTSPRequest) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class);
        if (wMSLogger.isDebugEnabled()) {
            wMSLogger.debug("*** RTSPMessageSend ***\n" + rTPSessionDescriptionDataProviderBasicRTSPRequest.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStart(RTPSession rTPSession) {
        Object object = this.rtspLock;
        synchronized (object) {
            if (this.rtspWorker != null) {
                this.rtspWorker.sessionStart(rTPSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStop(RTPSession rTPSession) {
        Object object = this.rtspLock;
        synchronized (object) {
            if (this.rtspWorker != null) {
                this.rtspWorker.close();
            }
            this.rtspWorker = null;
            this.sdpFilePath = null;
            this.sdpFileLastCheck = -1L;
            this.sdpFileLastMod = -1L;
            this.sdpFileSize = -1L;
            this.sdpHTTPURL = null;
            this.sdpHTTPLastCheck = -1L;
            this.sdpHTTPChecksum = null;
            this.sdpHTTPNeedsReset = false;
        }
    }

    class SDPHTTPCheck
    implements Runnable {
        private String sdpHTTPURL = null;
        private Checksum sdpHTTPChecksum = null;

        public SDPHTTPCheck(String string, Checksum checksum) {
            this.sdpHTTPURL = string;
            this.sdpHTTPChecksum = checksum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            boolean bl = false;
            try {
                object = HTTPUtils.HTTPRequestToByteArray(this.sdpHTTPURL, "GET", null, null);
                if (object != null) {
                    CRC32 cRC32 = new CRC32();
                    cRC32.update((byte[])object, 0, ((byte[])object).length);
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).debug("SDPHTTPCheck.run: Check SDP URL (" + this.sdpHTTPURL + "): checksum:" + cRC32.getValue() + "=" + this.sdpHTTPChecksum.getValue());
                    if (cRC32.getValue() != this.sdpHTTPChecksum.getValue()) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("SDPHTTPCheck.run: Check SDP URL (" + this.sdpHTTPURL + "): checksum:" + cRC32.getValue() + "=" + this.sdpHTTPChecksum.getValue());
                        bl = true;
                    }
                } else {
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasic.class).info("SDPHTTPCheck.run: Check SDP URL (" + this.sdpHTTPURL + "): Can't connect url.");
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object2 = RTPSessionDescriptionDataProviderBasic.this.rtspLock;
            object = object2;
            synchronized (object2) {
                if (bl) {
                    RTPSessionDescriptionDataProviderBasic.this.sdpHTTPNeedsReset = true;
                }
                RTPSessionDescriptionDataProviderBasic.this.sdpHTTPRunning = false;
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                return;
            }
        }
    }
}

