/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.rtp;

import com.wowza.util.DebugUtils;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPSessionDescriptionDataProviderBasicRTSPResponse {
    private Map<String, List<String>> headerMap = new HashMap<String, List<String>>();
    private int headerLength = 0;
    private int contentLength = 0;
    private String userAgent = "";
    private String contentType = "";
    private String reqURI = "";
    private byte[] body = null;
    String protocol = "RTSP/1.0";
    String status = "200";
    String response = "OK";

    public void parseMessage(byte[] byArray, int n, int n2) {
        try {
            this.parseHeader(byArray, n, n2);
            if (this.contentLength > 0) {
                this.body = new byte[this.contentLength];
                System.arraycopy(byArray, n + this.headerLength, this.body, 0, this.body.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTPSessionDescriptionDataProviderBasicRTSPResponse.parseMessage: " + exception.toString());
        }
    }

    public boolean containsHeader(String string) {
        return this.headerMap.containsKey(string.toLowerCase());
    }

    public int getCSeq() {
        int n = -1;
        String string = this.getHeader("cseq");
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTPSessionDescriptionDataProviderBasicRTSPResponse.getCSeq: " + exception.toString());
        }
        return n;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyAsString() {
        String string = null;
        try {
            if (this.body != null) {
                string = new String(this.body, "UTF-8");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTPSessionDescriptionDataProviderBasicRTSPResponse.getBodyAsString: " + exception.toString());
        }
        return string;
    }

    private void safeHeaderPut(String string, String string2) {
        List<String> list = this.headerMap.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.headerMap.put(string, list);
        }
        list.add(string2);
    }

    private String safeHeaderGet(String string) {
        List<String> list = this.headerMap.get(string);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    private String safeHeaderGet(String string, int n) {
        List<String> list = this.headerMap.get(string);
        if (list != null && n < list.size()) {
            return list.get(n);
        }
        return null;
    }

    private int safeHeaderGetSize(String string) {
        List<String> list = this.headerMap.get(string);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public String getSessionId() {
        String[] stringArray;
        String string = null;
        String string2 = this.safeHeaderGet("session");
        if (string2 != null && (stringArray = string2.split("[;]")).length > 0) {
            string = stringArray[0].trim();
        }
        return string;
    }

    public int getSessionTimeout() {
        String[] stringArray;
        int n = 0;
        String string = this.safeHeaderGet("session");
        if (string != null && (stringArray = string.split("[;]")).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (!string2.toLowerCase().startsWith("timeout")) continue;
                int n2 = string2.indexOf("=");
                if (n2 < 0) break;
                String string3 = string2.substring(n2 + 1).trim();
                try {
                    n = Integer.parseInt(string3) * 1000;
                }
                catch (Exception exception) {}
                break;
            }
        }
        return n;
    }

    public int getHeaderCount(String string) {
        return this.safeHeaderGetSize(string);
    }

    public String getHeader(String string) {
        return this.safeHeaderGet(string.toLowerCase());
    }

    public String getHeader(String string, int n) {
        return this.safeHeaderGet(string.toLowerCase(), n);
    }

    public List<String> getHeaderList(String string) {
        return this.headerMap.get(string);
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getReqURI() {
        return this.reqURI;
    }

    public int getStatus() {
        int n = 0;
        try {
            n = Integer.parseInt(this.status);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.protocol + " " + this.status + " " + this.response + "\n");
        for (String string : this.headerMap.keySet()) {
            List<String> list = this.headerMap.get(string);
            for (String string2 : list) {
                stringBuffer.append(string + ": " + string2 + "\n");
            }
        }
        return stringBuffer.toString();
    }

    private void parseHeader(byte[] byArray, int n, int n2) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        this.headerLength = 0;
        this.contentLength = 0;
        for (int i = 0; i < n2 - 3; ++i) {
            if (byArray[n + i] != 13 || byArray[n + i] != 13 || byArray[n + i + 1] != 10 || byArray[n + i + 2] != 13 || byArray[n + i + 3] != 10) continue;
            this.headerLength = i + 4;
            break;
        }
        if (this.headerLength <= 0) {
            return;
        }
        String string = null;
        String[] stringArray = null;
        int n3 = 0;
        while (byArray[n + n3] == 0) {
            ++n3;
        }
        byte[] byArray2 = new byte[this.headerLength - n3];
        System.arraycopy(byArray, n + n3, byArray2, 0, byArray2.length);
        try {
            string = new String(byArray2, "UTF-8");
            string = string.replace("\r\n", "\n").replace("\r", "\n");
            stringArray = string.split("\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTPSessionDescriptionDataProviderBasicRTSPResponse.parseHeader: convert: " + exception.toString() + "\n" + DebugUtils.formatBytes(byArray2));
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                if (stringArray[i].length() == 0) continue;
                if (i == 0) {
                    try {
                        stringArray2 = stringArray[i].split(" ");
                        if (stringArray2.length >= 3) {
                            String string2 = stringArray2[0];
                            String string3 = stringArray2[1];
                            String string4 = stringArray2[2];
                            this.safeHeaderPut("uri", stringArray[i]);
                            this.safeHeaderPut("protocol", string2);
                            this.safeHeaderPut("status", string3);
                            this.safeHeaderPut("response", string4);
                            this.protocol = string2;
                            this.status = string3;
                            this.response = string4;
                            if (wMSLogger != null) {
                                wMSLogger.debug("  uri: " + stringArray[i]);
                                wMSLogger.debug("  protocol: " + string2);
                                wMSLogger.debug("  status: " + string3);
                                wMSLogger.debug("  response: " + string4);
                            }
                            this.reqURI = stringArray2[1];
                            continue;
                        }
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTSPRequestMessage.parseHeader: missing parameters: " + stringArray[i]);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTSPRequestMessage.parseHeader: context (" + stringArray[i] + "): " + exception.toString());
                    }
                    continue;
                }
                try {
                    stringArray2 = stringArray[i].split(": ");
                    if (stringArray2.length != 2) {
                        stringArray2 = stringArray[i].split(":");
                    }
                    if (stringArray2.length != 2) continue;
                    this.safeHeaderPut(stringArray2[0].toLowerCase(), stringArray2[1]);
                    if (wMSLogger != null) {
                        wMSLogger.debug("  " + stringArray2[0].toLowerCase() + ": " + stringArray2[1]);
                    }
                    if (stringArray2[0].equalsIgnoreCase("Content-Length")) {
                        this.contentLength = Integer.parseInt(stringArray2[1]);
                        continue;
                    }
                    if (stringArray2[0].equalsIgnoreCase("User-Agent")) {
                        this.userAgent = stringArray2[1];
                        continue;
                    }
                    if (!stringArray2[0].equalsIgnoreCase("Content-Type")) continue;
                    this.contentType = stringArray2[1];
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTSPRequestMessage.parseHeader: token (" + stringArray[i] + "): " + exception.toString());
                }
            }
        }
    }

    public static int getResponseLength(byte[] byArray, int n, int n2) {
        WMSLogger wMSLogger = WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class);
        if (!wMSLogger.isDebugEnabled()) {
            wMSLogger = null;
        }
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2 - 3; ++i) {
            if (byArray[n + i] != 13 || byArray[n + i] != 13 || byArray[n + i + 1] != 10 || byArray[n + i + 2] != 13 || byArray[n + i + 3] != 10) continue;
            n3 = i + 4;
            break;
        }
        if (n3 <= 0) {
            return 0;
        }
        String string = null;
        String[] stringArray = null;
        int n5 = 0;
        while (byArray[n + n5] == 0) {
            ++n5;
        }
        byte[] byArray2 = new byte[n3 - n5];
        System.arraycopy(byArray, n + n5, byArray2, 0, byArray2.length);
        try {
            string = new String(byArray2, "UTF-8");
            stringArray = string.split("\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTPSessionDescriptionDataProviderBasicRTSPResponse.parseHeader: convert: " + exception.toString() + "\n" + DebugUtils.formatBytes(byArray2));
        }
        if (stringArray != null) {
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].length() == 0) continue;
                try {
                    String[] stringArray2 = stringArray[i].split(": ");
                    if (stringArray2.length != 2) {
                        stringArray2 = stringArray[i].split(":");
                    }
                    if (stringArray2.length != 2) continue;
                    if (wMSLogger != null) {
                        wMSLogger.debug("  " + stringArray2[0].toLowerCase() + ": " + stringArray2[1]);
                    }
                    if (!stringArray2[0].equalsIgnoreCase("Content-Length")) continue;
                    n4 = Integer.parseInt(stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPSessionDescriptionDataProviderBasicRTSPResponse.class).error("RTPSessionDescriptionDataProviderBasicRTSPResponse.parseHeader: token (" + stringArray[i] + "): " + exception.toString());
                }
            }
        }
        return n3 + n4;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getResponse() {
        return this.response;
    }
}

