/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.shoutcast;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.mp3.MP3Utils;
import com.wowza.wms.mediacaster.shoutcast.IShoutCastFrameReceiver;
import com.wowza.wms.mediacaster.shoutcast.ShoutCastReceiver;
import java.util.HashMap;
import java.util.Map;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class ShoutCastDecoder {
    public static final int LARGEST_FRAMESIZE = 2889;
    public static final int SYNCBLOCKSIZE = 10240;
    public static final int SOUNDFORMAT_MP3 = 1;
    public static final int SOUNDFORMAT_AAC = 2;
    private boolean gotHeader = false;
    private byte[] headerLeftOver = null;
    private byte[] headerBytes = null;
    private byte[] bodyBuffer = null;
    private long bodyLimit = 0L;
    private long bodyPos = 0L;
    private MP3HeaderData headerData = new MP3HeaderData();
    private IShoutCastFrameReceiver frameReceiver = null;
    private ShoutCastReceiver shoutCastReceiver = null;
    private byte[] headerBuf = new byte[4];
    private Object lock = new Object();
    private boolean isFirstChunk = true;
    private Map headerMap = new HashMap();
    private int metaInterval = 0;
    private int dataSize = 0;
    private boolean isFirstHeader = true;
    private int soundFormat = 1;
    private boolean isFirstAACFrame = true;
    private long lastWarningReport = -1L;
    private int outOfSyncCount = 0;
    private int metaDataSize = -1;
    private byte[] metaDataBytes = null;
    private int metaDataOffset = 0;

    public ShoutCastDecoder(ShoutCastReceiver shoutCastReceiver, IShoutCastFrameReceiver iShoutCastFrameReceiver) {
        this.frameReceiver = iShoutCastFrameReceiver;
        this.shoutCastReceiver = shoutCastReceiver;
    }

    public boolean sendWarningReport(long l) {
        boolean bl = false;
        if (this.lastWarningReport == -1L) {
            bl = true;
            this.lastWarningReport = l;
        } else if (l - this.lastWarningReport > 5000L) {
            bl = true;
            this.lastWarningReport = l;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.gotHeader = false;
            this.headerBytes = null;
            this.headerLeftOver = null;
            this.bodyBuffer = null;
            this.bodyLimit = 0L;
            this.bodyPos = 0L;
            this.soundFormat = 1;
            this.isFirstAACFrame = true;
            this.headerData = new MP3HeaderData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(byte[] byArray, int n, int n2) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            try {
                int n3 = 0;
                do {
                    if (!this.gotHeader) {
                        if (this.isFirstHeader) {
                            n3 += this.addHeaderData(byArray, n + n3, n2 - n3);
                            if (this.gotHeader) {
                                this.processFirstHeader(this.headerBytes);
                                this.isFirstHeader = false;
                                this.resetHeaderData();
                            }
                        } else {
                            n3 += this.addMetaData(byArray, n + n3, n2 - n3);
                            if (this.gotHeader) {
                                this.processMetaHeader(this.headerBytes);
                                this.resetMetaData();
                            }
                        }
                    }
                    if (n3 >= n2) continue;
                    if (this.metaInterval > 0) {
                        int n4 = n2 - n3;
                        if (n4 >= this.metaInterval - this.dataSize) {
                            n4 = this.metaInterval - this.dataSize;
                        }
                        if (n4 > 0) {
                            switch (this.soundFormat) {
                                case 1: {
                                    if (this.addChunkDataMP3(byArray, n + n3, n4)) break;
                                    bl = true;
                                    break;
                                }
                                case 2: {
                                    if (this.addChunkDataAAC(byArray, n + n3, n4)) break;
                                    bl = true;
                                }
                            }
                            n3 += n4;
                            this.dataSize += n4;
                        }
                        if (this.dataSize != this.metaInterval) continue;
                        this.gotHeader = false;
                        this.dataSize = 0;
                        continue;
                    }
                    switch (this.soundFormat) {
                        case 1: {
                            if (this.addChunkDataMP3(byArray, n + n3, n2 - n3)) break;
                            bl = true;
                            break;
                        }
                        case 2: {
                            if (this.addChunkDataAAC(byArray, n + n3, n2 - n3)) break;
                            bl = true;
                        }
                    }
                    n3 += n2 - n3;
                } while (n3 != n2);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ShoutCastDecoder.class).error("ShoutCastDecoder.addData: " + exception.toString());
                exception.printStackTrace();
            }
        }
        if (bl) {
            if (this.sendWarningReport(System.currentTimeMillis())) {
                WMSLoggerFactory.getLogger(ShoutCastDecoder.class).warn("ShoutCastDecoder.addData[" + this.shoutCastReceiver.getStream().getName() + "]: Problem reading stream. Resetting stream.");
            }
            this.shoutCastReceiver.getAppInstance().getVHost().getHandlerThreadPool().execute(new ForceReset());
        }
    }

    private void resetMetaData() {
        this.metaDataSize = -1;
        this.metaDataBytes = null;
        this.metaDataOffset = 0;
    }

    private int addMetaData(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.metaDataSize == -1) {
            this.metaDataSize = 0xFF & byArray[n];
            this.metaDataSize *= 16;
            this.metaDataBytes = new byte[this.metaDataSize];
            this.metaDataOffset = 0;
            ++n4;
            ++n;
            --n2;
        }
        if ((n3 = n2) > this.metaDataSize - this.metaDataOffset) {
            n3 = this.metaDataSize - this.metaDataOffset;
        }
        if (n3 > 0) {
            System.arraycopy(byArray, n, this.metaDataBytes, this.metaDataOffset, n3);
            this.metaDataOffset += n3;
            n4 += n3;
        }
        if (this.metaDataOffset == this.metaDataSize) {
            this.gotHeader = true;
        }
        return n4;
    }

    private void processMetaHeader(byte[] byArray) {
        if (this.metaDataBytes != null && this.metaDataBytes.length > 0) {
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String string = new String(this.metaDataBytes, this.shoutCastReceiver.getCharacterEncoding());
                String[] stringArray = string.split("[;]");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    String string2 = stringArray[i].trim();
                    if (string2.length() <= 0 || (n = string2.indexOf("=")) <= 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    if (string4.length() >= 2 && string4.charAt(0) == '\'' && string4.charAt(string4.length() - 1) == '\'') {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    hashMap.put(string3, string4);
                }
                if (hashMap.size() > 0 && this.frameReceiver != null) {
                    this.frameReceiver.onMetaData(hashMap);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ShoutCastDecoder.class).error("ShoutCastDecoder.processMetaHeader: " + exception.toString());
            }
        }
    }

    private void resetHeaderData() {
        this.headerBytes = null;
        this.dataSize = 0;
    }

    private int addHeaderData(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2;
        int n4 = 0;
        if (this.headerLeftOver != null) {
            n4 = this.headerLeftOver.length;
            byArray2 = new byte[this.headerLeftOver.length + n2];
            System.arraycopy(this.headerLeftOver, 0, byArray2, 0, this.headerLeftOver.length);
            System.arraycopy(byArray, n, byArray2, this.headerLeftOver.length, n2);
            this.headerLeftOver = null;
        } else {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        for (n3 = 0; n3 <= byArray2.length - 4; ++n3) {
            if (!(byArray2[n3] == 13 && byArray2[n3 + 1] == 10 && byArray2[n3 + 2] == 13 && byArray2[n3 + 3] == 10 || byArray2[n3] == 10 && byArray2[n3 + 1] == 10 && byArray2[n3 + 2] == 10 && byArray2[n3 + 3] == 10) && (byArray2[n3] != 13 || byArray2[n3 + 1] != 13 || byArray2[n3 + 2] != 13 || byArray2[n3 + 3] != 13)) continue;
            this.gotHeader = true;
            break;
        }
        if (!this.gotHeader) {
            this.headerLeftOver = byArray2;
            --n3;
        } else {
            this.headerLeftOver = null;
            this.headerBytes = new byte[n3];
            System.arraycopy(byArray2, 0, this.headerBytes, 0, n3);
        }
        return n3 + 4 - n4;
    }

    private void processFirstHeader(byte[] byArray) {
        Map map = this.decodeHeader(byArray);
        String string = (String)map.get("protocol");
        String string2 = (String)map.get("status");
        String string3 = (String)this.headerMap.get("content-type");
        this.soundFormat = 1;
        if (string3 != null && string3.toLowerCase().startsWith("audio/aac")) {
            this.soundFormat = 2;
        }
        this.metaInterval = 0;
        String string4 = (String)map.get("icy-metaint");
        if (string4 != null) {
            try {
                this.metaInterval = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string != null && string2 != null) {
            if (string.toLowerCase().startsWith("http")) {
                if (string2.equals("302")) {
                    String string5 = (String)map.get("location");
                    if (string5 != null) {
                        WMSLoggerFactory.getLogger(ShoutCastDecoder.class).info("ShoutCastDecoder.checkHeader[" + this.shoutCastReceiver.getStream().getName() + "]: HTTP redirect: " + string5);
                        this.shoutCastReceiver.doRedirect(string5);
                    }
                } else if (string2.equals("200")) {
                    WMSLoggerFactory.getLogger(ShoutCastDecoder.class).info("ShoutCastDecoder.checkHeader[" + this.shoutCastReceiver.getStream().getName() + "]: HTTP OK");
                    if (this.frameReceiver != null) {
                        this.frameReceiver.onHeaderData(map);
                    }
                } else {
                    WMSLoggerFactory.getLogger(ShoutCastDecoder.class).warn("ShoutCastDecoder.checkHeader[" + this.shoutCastReceiver.getStream().getName() + "]: HTTP response: " + string2);
                }
            } else {
                WMSLoggerFactory.getLogger(ShoutCastDecoder.class).info("ShoutCastDecoder.checkHeader[" + this.shoutCastReceiver.getStream().getName() + "]: ICY response: " + map.get("uri"));
                if (string2.startsWith("2") && this.frameReceiver != null) {
                    this.frameReceiver.onHeaderData(map);
                }
            }
        }
    }

    private Map decodeHeader(byte[] byArray) {
        this.headerMap.clear();
        String string = null;
        String[] stringArray = null;
        try {
            string = new String(byArray, this.shoutCastReceiver.getCharacterEncoding());
            string = string.replace("\r\n", "\n").replace("\r", "\n");
            stringArray = string.split("\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ShoutCastDecoder.class).error("ShoutCastDecoder: parseHeader: convert: " + exception.toString());
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                if (stringArray[i].length() == 0) continue;
                if (i == 0) {
                    try {
                        stringArray2 = stringArray[i].split(" ");
                        this.headerMap.put("uri", stringArray[i]);
                        this.headerMap.put("protocol", stringArray2[0]);
                        this.headerMap.put("status", stringArray2[1]);
                        this.headerMap.put("msg", stringArray2[2]);
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(ShoutCastDecoder.class).error("ShoutCastDecoder: parseHeader: context: " + exception.toString());
                    }
                    continue;
                }
                try {
                    stringArray2 = stringArray[i].split(": ");
                    if (stringArray2.length != 2) {
                        stringArray2 = stringArray[i].split(":");
                    }
                    if (stringArray2.length != 2) continue;
                    this.headerMap.put(stringArray2[0].toLowerCase(), stringArray2[1]);
                    continue;
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(ShoutCastDecoder.class).error("ShoutCastDecoder: parseHeader: token: " + exception.toString());
                }
            }
        }
        return this.headerMap;
    }

    private void read(byte[] byArray, int n, int n2) {
        System.arraycopy(this.bodyBuffer, (int)this.bodyPos, byArray, n, n2);
        this.bodyPos += (long)n2;
    }

    private long getFilePointer() {
        return this.bodyPos;
    }

    private void seek(long l) {
        this.bodyPos = l;
    }

    private long available() {
        return this.bodyLimit - this.bodyPos;
    }

    private void readFrame(MP3HeaderData mP3HeaderData, int n, int n2) {
        int n3 = 0;
        int n4 = MP3BufferedDecoder.frequency((MP3HeaderData)mP3HeaderData);
        int n5 = MP3BufferedDecoder.samples_per_frame((MP3HeaderData)mP3HeaderData);
        switch (mP3HeaderData.h_mode) {
            case 0: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 1;
            }
        }
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[]{34};
        byArray2[0] = (byte)(byArray2[0] + (n3 - 1));
        if (n4 > 22050) {
            byArray2[0] = (byte)(byArray2[0] | 0xC);
        } else if (n4 > 11025) {
            byArray2[0] = (byte)(byArray2[0] | 8);
        } else if (n4 > 8000) {
            byArray2[0] = (byte)(byArray2[0] | 4);
        }
        byArray[3] = (byte)(0xFF & n);
        byArray[2] = (byte)(0xFF & n >> 8);
        byArray[1] = (byte)(0xFF & n >> 16);
        byArray[0] = (byte)(0xFF & n >> 24);
        byte[] byArray3 = new byte[n2];
        this.read(byArray3, 0, n2);
        if (this.frameReceiver != null) {
            this.frameReceiver.onFrameMP3(n4, n5, n3, byArray, byArray2, byArray3);
        }
    }

    private boolean addChunkDataAAC(byte[] byArray, int n, int n2) {
        boolean bl = true;
        try {
            long l;
            int n3;
            if (this.bodyBuffer == null) {
                this.bodyBuffer = new byte[n2];
            }
            if (this.bodyBuffer.length < (n3 = (int)(this.bodyLimit + (long)n2))) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(this.bodyBuffer, 0, byArray2, 0, (int)this.bodyLimit);
                this.bodyBuffer = byArray2;
            }
            System.arraycopy(byArray, n, this.bodyBuffer, (int)this.bodyLimit, n2);
            this.bodyLimit += (long)n2;
            if (this.isFirstChunk) {
                if (this.bodyLimit >= 10240L) {
                    int n4 = AACUtils.decodeFirstChunkAACP(this.bodyBuffer, 0, this.bodyLimit);
                    this.seek(n4);
                    this.isFirstChunk = false;
                } else {
                    return bl;
                }
            }
            int n5 = 0;
            while ((l = this.available()) >= 7L) {
                AACFrame aACFrame = AACUtils.decodeFrame(this.bodyBuffer, this.getFilePointer());
                if (aACFrame == null) {
                    this.isFirstChunk = true;
                    ++this.outOfSyncCount;
                    if (this.outOfSyncCount > 5) {
                        if (this.sendWarningReport(System.currentTimeMillis())) {
                            WMSLoggerFactory.getLogger(ShoutCastDecoder.class).warn("ShoutCastDecoder.addChunkDataAAC[" + this.shoutCastReceiver.getStream().getName() + "]: Out of sync. Resetting stream.");
                        }
                        bl = false;
                        break;
                    }
                    if (!this.sendWarningReport(System.currentTimeMillis())) break;
                    WMSLoggerFactory.getLogger(ShoutCastDecoder.class).warn("ShoutCastDecoder.addChunkDataAAC[" + this.shoutCastReceiver.getStream().getName() + "]: Out of sync. Resyncing stream.");
                    break;
                }
                if (l < (long)aACFrame.getSize()) break;
                if (this.isFirstAACFrame) {
                    if (this.frameReceiver != null) {
                        this.frameReceiver.onCodecConfigAAC(aACFrame, this.bodyBuffer, this.getFilePointer());
                    }
                    this.isFirstAACFrame = false;
                }
                if (this.frameReceiver != null) {
                    this.frameReceiver.onFrameAAC(aACFrame, this.bodyBuffer, this.getFilePointer());
                }
                this.seek(this.getFilePointer() + (long)aACFrame.getSize());
                ++n5;
            }
            if (n5 > 0 && this.frameReceiver != null) {
                this.frameReceiver.onTrim();
            }
            System.arraycopy(this.bodyBuffer, (int)this.bodyPos, this.bodyBuffer, 0, (int)(this.bodyLimit - this.bodyPos));
            this.bodyLimit -= this.bodyPos;
            this.bodyPos = 0L;
        }
        catch (Exception exception) {
            if (this.sendWarningReport(System.currentTimeMillis())) {
                WMSLoggerFactory.getLogger(ShoutCastDecoder.class).error("ShoutCastDecoder.addChunkDataAAC: offset:" + n + " size:" + n2 + " error:" + exception.toString());
            }
            exception.printStackTrace();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addChunkDataMP3(byte[] byArray, int n, int n2) {
        boolean bl = true;
        try {
            int n3;
            int n4;
            if (this.bodyBuffer == null) {
                this.bodyBuffer = new byte[n2];
            }
            if (this.bodyBuffer.length < (n4 = (int)(this.bodyLimit + (long)n2))) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(this.bodyBuffer, 0, byArray2, 0, (int)this.bodyLimit);
                this.bodyBuffer = byArray2;
            }
            System.arraycopy(byArray, n, this.bodyBuffer, (int)this.bodyLimit, n2);
            this.bodyLimit += (long)n2;
            if (this.isFirstChunk) {
                if (this.bodyLimit < 10240L) return bl;
                int n5 = -1;
                String string = (String)this.headerMap.get("icy-br");
                if (string != null) {
                    try {
                        n5 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        n5 = -1;
                        WMSLoggerFactory.getLogger(ShoutCastDecoder.class).debug("ShoutCastDecoder.decodeFirstChunkMP3: funky headerBitrateStr: " + string);
                    }
                }
                if ((n3 = MP3Utils.decodeFirstChunkMP3(this.bodyBuffer, 0, this.bodyLimit, n5)) < 0) {
                    n3 = 0;
                }
                this.seek(n3);
                this.isFirstChunk = false;
            }
            long l = this.available();
            n3 = 0;
            if (l >= 4L) {
                this.read(this.headerBuf, 0, 4);
                l -= 4L;
                while (true) {
                    block20: {
                        int n6;
                        if ((n6 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])this.headerBuf, (MP3HeaderData)this.headerData)) != 0) {
                            MP3BufferedDecoder.decodeHeader((int)n6, (int)0, (MP3HeaderData)this.headerData);
                            int n7 = MP3BufferedDecoder.calculateFrameSize((MP3HeaderData)this.headerData);
                            int n8 = MP3BufferedDecoder.samples_per_frame((MP3HeaderData)this.headerData);
                            int n9 = this.headerData.bitrate_instant();
                            if (n7 > 0 && n7 <= 2889 && n9 > 0 && n8 > 0) {
                                if ((long)(n7 + 4) > l) {
                                    this.seek(this.getFilePointer() - 4L);
                                    break;
                                }
                                this.readFrame(this.headerData, n6, n7);
                                ++n3;
                                this.read(this.headerBuf, 1, 3);
                                l -= (long)(n7 + 3);
                                break block20;
                            } else {
                                this.isFirstChunk = true;
                                ++this.outOfSyncCount;
                                if (this.outOfSyncCount > 5) {
                                    if (this.sendWarningReport(System.currentTimeMillis())) {
                                        WMSLoggerFactory.getLogger(ShoutCastDecoder.class).warn("ShoutCastDecoder.addChunkDataMP3[" + this.shoutCastReceiver.getStream().getName() + "]: Out of sync. Resetting stream.");
                                    }
                                    bl = false;
                                    break;
                                }
                                if (!this.sendWarningReport(System.currentTimeMillis())) break;
                                WMSLoggerFactory.getLogger(ShoutCastDecoder.class).warn("ShoutCastDecoder.addChunkDataMP3[" + this.shoutCastReceiver.getStream().getName() + "]: Out of sync. Resyncing stream.");
                                break;
                            }
                        }
                        if (this.sendWarningReport(System.currentTimeMillis())) {
                            WMSLoggerFactory.getLogger(ShoutCastDecoder.class).warn("ShoutCastDecoder.addChunkDataMP3[" + this.shoutCastReceiver.getStream().getName() + "]: Hunting.");
                        }
                    }
                    if (l == 0L) break;
                    this.headerBuf[0] = this.headerBuf[1];
                    this.headerBuf[1] = this.headerBuf[2];
                    this.headerBuf[2] = this.headerBuf[3];
                    this.read(this.headerBuf, 3, 1);
                    --l;
                }
            }
            if (n3 > 0 && this.frameReceiver != null) {
                this.frameReceiver.onTrim();
            }
            System.arraycopy(this.bodyBuffer, (int)this.bodyPos, this.bodyBuffer, 0, (int)(this.bodyLimit - this.bodyPos));
            this.bodyLimit -= this.bodyPos;
            this.bodyPos = 0L;
            return bl;
        }
        catch (Exception exception) {
            if (this.sendWarningReport(System.currentTimeMillis())) {
                WMSLoggerFactory.getLogger(ShoutCastDecoder.class).error("ShoutCastDecoder.addChunkDataMP3: offset:" + n + " size:" + n2 + " error:" + exception.toString());
            }
            exception.printStackTrace();
        }
        return bl;
    }

    class ForceReset
    implements Runnable {
        ForceReset() {
        }

        public void run() {
            try {
                if (ShoutCastDecoder.this.shoutCastReceiver != null) {
                    ShoutCastDecoder.this.shoutCastReceiver.forceReset();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

