/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.mediacaster.wowza;

import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCasterNetConnection;
import com.wowza.wms.mediacaster.MediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterStreamId;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.shoutcast.ShoutCastReceiver;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamURL;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.INetConnectionCallResult;
import com.wowza.wms.netconnection.INetConnectionIdle;
import com.wowza.wms.netconnection.INetConnectionPingResult;
import com.wowza.wms.netconnection.NetConnection;
import com.wowza.wms.netconnection.NetConnectionConnection;
import com.wowza.wms.plugin.security.encryption.TEA;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamCallback;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.IMediaStreamTimecodeControl;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHost;
import java.util.List;
import org.apache.mina.common.IoSession;

public class LiveMediaStreamReceiver
extends MediaCaster
implements IMediaCasterNetConnection {
    private boolean tryConnect = false;
    private int tryConnectStart = 0;
    private boolean isReconnectorRunning = false;
    private LiveMediaStreamURL[] liveMediaStreamURL = null;
    private int liveMediaStreamURLIndex = 0;
    private NetConnection netConnection = null;
    private HandshakeResult handshakeResult = new HandshakeResult(this);
    private IdleHandler idleHandler = new IdleHandler(this);
    private long streamTimecodeOffset = 0L;
    private boolean notifyUnpublish = false;
    private String setStreamType = null;
    private boolean callFCSubscribe = false;
    private String contextStr = "unknown";

    public LiveMediaStreamReceiver() {
        WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("LiveMediaStreamHandler.create");
    }

    public void init(MediaCasterStreamItem mediaCasterStreamItem, MediaCasterItem mediaCasterItem, IApplicationInstance iApplicationInstance, String string, String string2) {
        super.init(mediaCasterStreamItem, mediaCasterItem, iApplicationInstance, string, string2);
        WMSProperties wMSProperties = this.getProperties();
        if (wMSProperties != null) {
            this.streamTimeout = wMSProperties.getPropertyInt("streamTimeout", this.streamTimeout);
            this.setStreamType = wMSProperties.getPropertyStr("setStreamType", this.setStreamType);
            this.callFCSubscribe = wMSProperties.getPropertyBoolean("callFCSubscribe", this.callFCSubscribe);
        }
        MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
        int n = mediaStreamMap.getNextStreamIndex();
        String string3 = mediaCasterItem.getStreamType();
        IMediaStream iMediaStream = mediaStreamMap.getStreamClientless(n, string3);
        WMSLoggerFactory.getLogger(null).info(null, iMediaStream, "stream", "create", 200, null);
        iMediaStream.setOpen(true);
        iMediaStream.setPlay(false);
        iMediaStream.setRecord(false);
        iMediaStream.setAppend(iMediaStream.isAppend());
        iMediaStream.setName(string);
        iMediaStream.setExt(string2);
        iMediaStream.setQueryStr("");
        iMediaStream.initLiveStreamRepeating(mediaCasterStreamItem.getLiveStreamPacketizer(), mediaCasterStreamItem.getLiveStreamRepeater());
        this.setStream(iMediaStream);
        WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("LiveMediaStreamHandler.init: " + string + " streamName:" + iMediaStream.getName());
        String string4 = mediaCasterItem.idStringToName(string);
        MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString(string4);
        string4 = mediaCasterStreamId.getName();
        this.connect(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementStartConnectTo() {
        Object object = this.lock;
        synchronized (object) {
            int n = this.liveMediaStreamURLIndex;
            ++n;
            this.tryConnectStart = n %= this.liveMediaStreamURL.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(String string) {
        boolean bl = false;
        string = this.appInstance.getStreamNameAliasProvider().resolveStreamAlias(this.appInstance, string);
        Object object = this.lock;
        synchronized (object) {
            this.liveMediaStreamURL = LiveMediaStreamURL.decodeURL(string);
            if (this.liveMediaStreamURL != null) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.connect: " + string + ":" + this.liveMediaStreamURL[this.liveMediaStreamURLIndex].toLogString());
                this.tryConnect = true;
                this.tryConnectStart = 0;
                bl = true;
                this.tryToConnect();
            } else {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).warn("LiveMediaStreamHandler.connect: failure");
                this.tryConnect = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect() {
        Object object = this.lock;
        synchronized (object) {
            IVHost iVHost = this.getStream().getStreams().getVHost();
            if (!this.isReconnectorRunning && this.tryConnect && !iVHost.isShuttingDown()) {
                this.isReconnectorRunning = true;
                iVHost.getThreadPool().execute(new Reconnector(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoSession internalConnect() {
        Object object = this.lock;
        synchronized (object) {
            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("LiveMediaStreamHandler.internalConnect: " + this.liveMediaStreamURL[this.liveMediaStreamURLIndex].toLogString());
            if (this.liveMediaStreamURL == null) {
                return null;
            }
            VHost vHost = (VHost)this.getStream().getStreams().getVHost();
            NetConnectionConnection netConnectionConnection = vHost.getNetConnectionConnection();
            int n = this.getMediaCasterDef().getConnectionTimeout();
            this.netConnection.connect(this.liveMediaStreamURL[this.liveMediaStreamURLIndex].getDomain(), this.liveMediaStreamURL[this.liveMediaStreamURLIndex].getPort(), n, new HandshakeResult(this));
            return this.netConnection.getSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.tryConnectStart = n;
            IoSession ioSession = this.getLastSession();
            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.resetConnection: " + ioSession);
            if (ioSession != null) {
                this.removeSession(ioSession);
                ioSession.close();
            }
            this.resetStreamTimecodes();
            MediaStreamMap mediaStreamMap = this.getAppInstance().getStreams();
            mediaStreamMap.notifyPlayUnpublish(this.getStream());
            if (this.tryConnect) {
                this.tryToConnect();
            }
        }
    }

    public void forceReset() {
        this.resetConnection(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStreamTimecodes() {
        IMediaStream iMediaStream = this.getStream();
        if (iMediaStream != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                if (iMediaStream instanceof IMediaStreamTimecodeControl) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("LiveMediaStreamHandler.resetStreamTimecodes: ");
                    ((IMediaStreamTimecodeControl)((Object)iMediaStream)).resetTimecodes();
                } else {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).warn("LiveMediaStreamHandler.resetStreamTimecodes: missing interface IMediaStreamTimecodeControl");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStream() {
        IMediaStream iMediaStream = this.getStream();
        this.streamTimecodeOffset = 0L;
        this.notifyUnpublish = false;
        this.streamMissingTime = -1L;
        this.streamLastSeq = -1L;
        this.setStreamRunning(false);
        if (iMediaStream != null) {
            IMediaStream iMediaStream2 = iMediaStream;
            synchronized (iMediaStream2) {
                iMediaStream.close();
                iMediaStream.setOpen(true);
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("LiveMediaStreamHandler.resetStream:  streamName:" + iMediaStream.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            IMediaStream iMediaStream;
            IoSession ioSession = this.getLastSession();
            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.disconnect: " + ioSession);
            this.liveMediaStreamURL = null;
            this.tryConnect = false;
            if (ioSession != null) {
                this.removeSession(ioSession);
                ioSession.close();
            }
            if ((iMediaStream = this.getStream()) != null) {
                MediaStreamMap mediaStreamMap = this.getAppInstance().getStreams();
                int n = this.getStream().getSrc();
                mediaStreamMap.removeStream(n);
                this.setStream(null);
            }
        }
    }

    public void registerPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    public void unregisterPlayer(IMediaStreamPlay iMediaStreamPlay) {
    }

    public void sessionOpened(IoSession ioSession) {
        WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.sessionOpened: ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession ioSession) {
        WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.sessionClosed: ");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.isCurrentSession(ioSession);
            this.removeSession(ioSession);
            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.sessionClosed: reconnect: isCurrentSession:" + bl + " tryConnect:" + this.tryConnect);
            if (bl && this.tryConnect) {
                this.tryToConnect();
            }
        }
    }

    public void shutdown(boolean bl) {
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).info("LiveMediaStreamHandler.shutdown: " + this.liveMediaStreamURL);
        this.disconnect();
    }

    public long getStreamTimecodeOffset() {
        return this.streamTimecodeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetConnection getNetConnection() {
        WMSLoggerFactory.getLogger(ShoutCastReceiver.class).info("LiveMediaStreamHandler.getNetConnection");
        NetConnection netConnection = null;
        Object object = this.lock;
        synchronized (object) {
            netConnection = this.netConnection;
        }
        return netConnection;
    }

    public boolean isTryConnect() {
        return this.tryConnect;
    }

    public void setTryConnect(boolean bl) {
        this.tryConnect = bl;
    }

    public int getTryConnectStart() {
        return this.tryConnectStart;
    }

    public void setTryConnectStart(int n) {
        this.tryConnectStart = n;
    }

    public boolean isReconnectorRunning() {
        return this.isReconnectorRunning;
    }

    public void setReconnectorRunning(boolean bl) {
        this.isReconnectorRunning = bl;
    }

    public int getLiveMediaStreamURLIndex() {
        return this.liveMediaStreamURLIndex;
    }

    public void setLiveMediaStreamURLIndex(int n) {
        this.liveMediaStreamURLIndex = n;
    }

    public String getSetStreamType() {
        return this.setStreamType;
    }

    public void setSetStreamType(String string) {
        this.setStreamType = string;
    }

    public boolean isStreamIsRunning() {
        return this.streamIsRunning;
    }

    public void setStreamIsRunning(boolean bl) {
        this.streamIsRunning = bl;
    }

    public void setStreamTimecodeOffset(long l) {
        this.streamTimecodeOffset = l;
    }

    public long getNetConnectionLastValidateTime() {
        NetConnection netConnection = this.netConnection;
        if (netConnection != null) {
            return netConnection.getLastValidateTime();
        }
        return -2L;
    }

    public long getNetConnectionLastIdlePingTime() {
        NetConnection netConnection = this.netConnection;
        if (netConnection != null) {
            return netConnection.getLastIdlePingTime();
        }
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doWatchdog() {
        try {
            Object object = this.lock;
            synchronized (object) {
                IMediaStream iMediaStream = this.getStream();
                if (iMediaStream == null) {
                } else if (this.netConnection == null) {
                } else {
                    IApplicationInstance iApplicationInstance = this.getAppInstance();
                    if (iApplicationInstance == null) {
                    } else {
                        IOPerformanceCounter iOPerformanceCounter = iApplicationInstance.getIOPerformanceCounter();
                        this.netConnection.addIOPerformance(iOPerformanceCounter);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ShoutCastReceiver.class).warn("LiveMediaStreamReceiver.doWatchdog: " + exception.toString());
        }
        int n = 0;
        long l = System.currentTimeMillis();
        boolean bl = false;
        if (this.streamTimeout <= 0) {
            n = 1;
        } else {
            Object object = this.lock;
            synchronized (object) {
                if (this.isReconnectorRunning) {
                    n = 5;
                } else if (this.liveMediaStreamURL == null) {
                    n = 3;
                } else {
                    IoSession ioSession = this.getLastSession();
                    if (ioSession == null) {
                        n = 2;
                    } else {
                        IMediaStream iMediaStream = this.getStream();
                        if (iMediaStream == null) {
                            n = 4;
                        } else {
                            List<AMFPacket> list;
                            n = 100;
                            boolean bl2 = false;
                            String string = iMediaStream.getLiveStreamRepeater();
                            if (string != null) {
                                String string2;
                                list = iMediaStream.getLiveStreamPacketizer();
                                if (list != null && (string2 = iMediaStream.getName()) != null) {
                                    Object object2;
                                    MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString(string2);
                                    String string3 = mediaCasterStreamId.getName();
                                    Object object3 = string3;
                                    if (string3.indexOf("://") >= 0) {
                                        object2 = LiveMediaStreamURL.decodeURLToStreamName(string3);
                                        if (object2 != null) {
                                            object3 = object2;
                                        }
                                    } else {
                                        object3 = string3;
                                    }
                                    object2 = iMediaStream.getStreams();
                                    ILiveStreamPacketizer iLiveStreamPacketizer = ((MediaStreamMap)object2).getLiveStreamPacketizer((String)object3, (String)((Object)list), false);
                                    if (iLiveStreamPacketizer == null) {
                                        bl2 = true;
                                    } else {
                                        long l2 = iLiveStreamPacketizer.getRepeaterLastSeqence();
                                        if (l2 != this.streamLastSeq) {
                                            this.streamLastSeq = l2;
                                        } else {
                                            bl2 = true;
                                        }
                                    }
                                }
                            } else {
                                list = iMediaStream.getPlayPackets();
                                if (list.size() == 0) {
                                    bl2 = true;
                                } else {
                                    AMFPacket aMFPacket = (AMFPacket)list.get(list.size() - 1);
                                    long l3 = aMFPacket.getSeq();
                                    if (l3 != this.streamLastSeq) {
                                        this.streamLastSeq = l3;
                                    } else {
                                        bl2 = true;
                                    }
                                }
                            }
                            if (bl2) {
                                n = 101;
                                if (this.streamMissingTime == -1L) {
                                    this.streamMissingTime = l;
                                } else if (l - this.streamMissingTime > (long)this.streamTimeout) {
                                    bl = true;
                                }
                            } else {
                                this.streamMissingTime = -1L;
                            }
                            if (bl) {
                                this.setStreamRunning(false);
                                if (this.liveMediaStreamURL.length > 0) {
                                    this.setStreamTimeoutLastReset(l);
                                    int n2 = this.liveMediaStreamURLIndex;
                                    ++n2;
                                    WMSLoggerFactory.getLogger(ShoutCastReceiver.class).warn("LiveMediaStreamReceiver.doWatchdog: streamTimeout: Resetting connection");
                                    this.resetConnection(n2 %= this.liveMediaStreamURL.length);
                                }
                            } else if (!bl2) {
                                this.setStreamRunning(true);
                            }
                        }
                    }
                }
            }
        }
        this.setStreamTimeoutReason(n);
        this.setStreamTimeoutLastTime(l);
        return false;
    }

    class ConnectResult
    extends ModuleBase
    implements INetConnectionCallResult {
        LiveMediaStreamReceiver liveMediaStreamReceiver = null;

        public ConnectResult(LiveMediaStreamReceiver liveMediaStreamReceiver2) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver2;
        }

        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            AMFDataObj aMFDataObj = ConnectResult.getParamObj(aMFDataList, 3);
            if (aMFDataObj != null) {
                int n = 0;
                if (aMFDataObj.containsKey("liveRepeaterCapabilities")) {
                    n = ((Double)aMFDataObj.get("liveRepeaterCapabilities").getValue()).intValue();
                }
                LiveMediaStreamReceiver.this.netConnection.setLiveRepeaterCapabilities(n);
                String string = aMFDataObj.getString("level");
                String string2 = aMFDataObj.getString("code");
                if (MediaCaster.debugLog) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#ConnectResult.connect[" + LiveMediaStreamReceiver.this.contextStr + "]: result: " + string2);
                }
                if (string2.equals("NetConnection.Connect.Success")) {
                    String string3 = "secureToken";
                    String string4 = aMFDataObj.getString(string3);
                    if (string4 != null) {
                        String string5 = LiveMediaStreamReceiver.this.appInstance.getProperties().getPropertyStr("secureTokenOriginSharedSecret");
                        if (string5 == null) {
                            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).warn("LiveMediaStreamReceiver.connect: SecureToken challenge received. Missing application property secureTokenOriginSharedSecret.");
                        } else {
                            String string6 = null;
                            try {
                                string6 = TEA.decrypt((String)string4, (String)string5);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (string6 == null) {
                                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).warn("LiveMediaStreamReceiver.connect: SecureToken challenge received. TEA.decrypt failed. Check to be sure security package is installed.");
                            } else {
                                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver.connect: secureTokenResponse: " + string6);
                                iNetConnection.call("secureTokenResponse", null, new AMFDataItem(string6));
                            }
                        }
                    }
                    int n2 = aMFDataObj.getInt("clientid");
                    iNetConnection.setClientId(n2);
                    if (MediaCaster.debugLog) {
                        WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#ConnectResult.connected[" + LiveMediaStreamReceiver.this.contextStr + "]: " + n2);
                    }
                    if (LiveMediaStreamReceiver.this.setStreamType != null) {
                        WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("setStreamType: " + LiveMediaStreamReceiver.this.setStreamType);
                        iNetConnection.call("setStreamType", null, new AMFDataItem(LiveMediaStreamReceiver.this.setStreamType));
                    }
                    if (MediaCaster.debugLog) {
                        WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#ConnectResult.createStream[" + LiveMediaStreamReceiver.this.contextStr + "]: " + n2);
                    }
                    iNetConnection.call("createStream", new StreamCreateResult(this.liveMediaStreamReceiver), new Object[0]);
                } else {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.onResult: Error Connecting to remote server: code: " + string2);
                    LiveMediaStreamReceiver.this.incrementStartConnectTo();
                    IoSession ioSession = LiveMediaStreamReceiver.this.getLastSession();
                    if (ioSession != null) {
                        ioSession.close();
                    }
                }
            } else {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamHandler.onResult: Error Connecting to remote server: resultObj: null");
                LiveMediaStreamReceiver.this.incrementStartConnectTo();
                IoSession ioSession = LiveMediaStreamReceiver.this.getLastSession();
                if (ioSession != null) {
                    ioSession.close();
                }
            }
        }
    }

    class HandshakeResult
    implements INetConnectionCallResult {
        LiveMediaStreamReceiver liveMediaStreamReceiver = null;

        public HandshakeResult(LiveMediaStreamReceiver liveMediaStreamReceiver2) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            AMFDataObj aMFDataObj = new AMFDataObj();
            LiveMediaStreamReceiver.this.netConnection.setIdleHandler(LiveMediaStreamReceiver.this.idleHandler);
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = "";
            String string5 = "";
            String string6 = "";
            Object object = LiveMediaStreamReceiver.this.lock;
            synchronized (object) {
                string = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getApplication();
                string2 = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getAppInstance();
                if (string2.length() == 0) {
                    string2 = "_definst_";
                }
                string6 = string + "/" + string2;
                string5 = LiveMediaStreamReceiver.this.appInstance.getRepeaterQueryString();
                if (string5 != null) {
                    if ((string5 = string5.trim()).startsWith("?")) {
                        string5 = string5.substring(1);
                    }
                    if (string5.startsWith("&")) {
                        string5 = string5.substring(1);
                    }
                    if (string5.length() > 0) {
                        string4 = "?" + string5;
                    }
                }
                string3 = "rtmp://" + LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getDomain() + ":" + LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getPort() + "/" + string6 + string4;
            }
            aMFDataObj.put("app", new AMFDataItem(string6 + string4));
            aMFDataObj.put("flashVer", new AMFDataItem("WIN 10,0,12,36"));
            aMFDataObj.put("swfUrl", new AMFDataItem("WowzaProLiveRepeater"));
            aMFDataObj.put("tcUrl", new AMFDataItem(string3));
            aMFDataObj.put("fpad", new AMFDataItem(false));
            aMFDataObj.put("audioCodecs", new AMFDataItem(3191.0));
            aMFDataObj.put("videoCodecs", new AMFDataItem(252.0));
            aMFDataObj.put("pageUrl", new AMFDataItem());
            aMFDataObj.put("sendChunkSize", new AMFDataItem(4096.0));
            aMFDataObj.put("liveRepeaterCapabilities", new AMFDataItem(1));
            if (MediaCaster.debugLog) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#HandshakeResult.callConnect[" + LiveMediaStreamReceiver.this.contextStr + "]: " + string6 + string4);
            }
            iNetConnection.callConnect(new ConnectResult(this.liveMediaStreamReceiver), aMFDataObj, new Object[0]);
            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("LiveMediaStreamReceiver.onResult");
        }
    }

    class IdleHandler
    implements INetConnectionIdle {
        private LiveMediaStreamReceiver liveMediaStreamReceiver = null;
        public long lastPing = -1L;
        public boolean inPing = false;

        public IdleHandler(LiveMediaStreamReceiver liveMediaStreamReceiver2) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver2;
        }

        public void onIdle(INetConnection iNetConnection, IoSession ioSession) {
            long l = System.currentTimeMillis();
            long l2 = iNetConnection.getLastValidateTime();
            long l3 = 10000L;
            if (l2 == 0L) {
                iNetConnection.setLastValidateTime(l);
            } else if (!iNetConnection.isValidatingConnection() && l3 > 0L && l - l2 > l3) {
                if (MediaCaster.debugLog) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#IdleHandler.onIdle[" + LiveMediaStreamReceiver.this.contextStr + "]: validate");
                }
                iNetConnection.setValidatingConnection(true);
                long l4 = System.currentTimeMillis();
                iNetConnection.setLastValidateTime(l4);
                iNetConnection.ping(new PingResult(iNetConnection, l4));
            }
        }

        public void onSessionOpened(INetConnection iNetConnection, IoSession ioSession) {
            LiveMediaStreamReceiver.this.sessionOpened(ioSession);
        }

        public void onSessionClosed(INetConnection iNetConnection, IoSession ioSession) {
            LiveMediaStreamReceiver.this.sessionClosed(ioSession);
        }
    }

    class PingResult
    implements INetConnectionPingResult {
        private long startValidateTime = 0L;
        private long startSessionBytesWritten = 0L;
        private long startWriteId = -1L;

        public PingResult(INetConnection iNetConnection, long l) {
            this.startValidateTime = l;
            IoSession ioSession = ((NetConnection)iNetConnection).getSession();
            if (ioSession != null) {
                this.startSessionBytesWritten = ioSession.getWrittenBytes();
                this.startWriteId = ioSession.getFirstWriteRequestId();
            }
        }

        public void onResult(INetConnection iNetConnection, long l, int n, boolean bl) {
            IoSession ioSession = ((NetConnection)iNetConnection).getSession();
            long l2 = 0L;
            long l3 = -1L;
            long l4 = ((NetConnection)iNetConnection).getLastPingWriteId();
            if (ioSession != null) {
                l2 = ioSession.getWrittenBytes();
                l3 = ioSession.getFirstWriteRequestId();
            }
            if (MediaCaster.debugLog) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#PingResult.onResult[" + LiveMediaStreamReceiver.this.contextStr + "]: " + bl);
            }
            if (!(bl || l4 != -1L && l4 == l3)) {
                if (this.startSessionBytesWritten > 0L && l2 > 0L && this.startSessionBytesWritten != l2) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("netconnectionValidation [" + iNetConnection.getClientId() + "] byteWrittenChanged: " + this.startSessionBytesWritten + ":" + l2);
                    bl = true;
                }
                if (this.startValidateTime != iNetConnection.getLastValidateTime()) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("netconnectionValidation [" + iNetConnection.getClientId() + "] validationTimeChanged: " + this.startValidateTime + ":" + iNetConnection.getLastValidateTime());
                    bl = true;
                }
            }
            ((NetConnection)iNetConnection).setLastPingWriteId(l3);
            if (!bl) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).warn("LiveMediaStreamReceiver: ping timeout: reset connection");
                LiveMediaStreamReceiver.this.resetConnection(0);
            } else {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("LiveMediaStreamReceiver: ping OK");
                iNetConnection.setValidatingConnection(false);
                iNetConnection.setLastValidateTime(System.currentTimeMillis());
            }
        }
    }

    class Reconnector
    implements Runnable {
        private LiveMediaStreamReceiver liveMediaStreamReceiver = null;

        public Reconnector(LiveMediaStreamReceiver liveMediaStreamReceiver2) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                Object object;
                LiveMediaStreamReceiver.this.resetStream();
                IApplicationInstance iApplicationInstance = LiveMediaStreamReceiver.this.getAppInstance();
                IMediaStream iMediaStream = LiveMediaStreamReceiver.this.getStream();
                LiveMediaStreamReceiver.this.netConnection = new NetConnection(iApplicationInstance, iApplicationInstance.getVHost().getNextNetConnectionId());
                LiveMediaStreamReceiver.this.netConnection.setHandshakeResult(LiveMediaStreamReceiver.this.handshakeResult);
                LiveMediaStreamReceiver.this.netConnection.setTargetStream(iMediaStream);
                Object object2 = LiveMediaStreamReceiver.this.lock;
                synchronized (object2) {
                    LiveMediaStreamReceiver.this.liveMediaStreamURLIndex = LiveMediaStreamReceiver.this.tryConnectStart;
                    LiveMediaStreamReceiver.this.liveMediaStreamURLIndex %= LiveMediaStreamReceiver.this.liveMediaStreamURL.length;
                    String string = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getApplication();
                    String string2 = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getAppInstance();
                    object = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getStreamName();
                    LiveMediaStreamReceiver.this.contextStr = string + "/" + string2 + "/" + (String)object;
                }
                while (true) {
                    long l = System.currentTimeMillis();
                    int n = LiveMediaStreamReceiver.this.getReconnectDelay(l);
                    WMSLoggerFactory.getLogger(null).debug("LiveMediaStreamReceiver#Reconnector.run: reconnectDelay: " + n);
                    if (n > 0) {
                        Thread.sleep(n);
                    }
                    l = System.currentTimeMillis();
                    LiveMediaStreamReceiver.this.setConnectLastAttempt(l);
                    LiveMediaStreamReceiver.this.resetStreamTimeout();
                    object = LiveMediaStreamReceiver.this.lock;
                    synchronized (object) {
                        if (LiveMediaStreamReceiver.this.liveMediaStreamURL == null) {
                            LiveMediaStreamReceiver.this.isReconnectorRunning = false;
                            return;
                        }
                        ((ApplicationInstance)iApplicationInstance).notifyMediaCasterConnectStart(this.liveMediaStreamReceiver);
                        IoSession ioSession = LiveMediaStreamReceiver.this.internalConnect();
                        if (ioSession != null) {
                            LiveMediaStreamReceiver.this.setConnectLastSuccess(l);
                            LiveMediaStreamReceiver.this.addSession(ioSession);
                            LiveMediaStreamReceiver.this.isReconnectorRunning = false;
                            ((ApplicationInstance)iApplicationInstance).notifyMediaCasterConnectSuccess(this.liveMediaStreamReceiver);
                            return;
                        }
                        ((ApplicationInstance)iApplicationInstance).notifyMediaCasterConnectFailure(this.liveMediaStreamReceiver);
                        LiveMediaStreamReceiver.this.liveMediaStreamURLIndex++;
                        LiveMediaStreamReceiver.this.liveMediaStreamURLIndex %= LiveMediaStreamReceiver.this.liveMediaStreamURL.length;
                        String string = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getApplication();
                        String string3 = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getAppInstance();
                        String string4 = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getStreamName();
                        LiveMediaStreamReceiver.this.contextStr = string + "/" + string3 + "/" + string4;
                    }
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).error("LiveMediaStreamReceiver.Reconnector: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    class StreamCreateResult
    extends ModuleBase
    implements INetConnectionCallResult {
        LiveMediaStreamReceiver liveMediaStreamReceiver = null;

        public StreamCreateResult(LiveMediaStreamReceiver liveMediaStreamReceiver2) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResult(INetConnection iNetConnection, RequestFunction requestFunction, AMFDataList aMFDataList) {
            int n = aMFDataList.getInt(3);
            MediaStreamMap mediaStreamMap = iNetConnection.getStreams();
            IMediaStream iMediaStream = mediaStreamMap.getStream(iNetConnection, n, true);
            if (MediaCaster.debugLog) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#StreamCreateResult.onResult[" + LiveMediaStreamReceiver.this.contextStr + "]: stream: " + iMediaStream);
            }
            if (iMediaStream != null) {
                iMediaStream.setNetConnection(iNetConnection);
                iMediaStream.registerOnStatus(new StreamOnStatus(this.liveMediaStreamReceiver));
                iMediaStream.registerOnPlayStatus(new StreamOnPlayStatus(this.liveMediaStreamReceiver));
                String string = null;
                Object object = LiveMediaStreamReceiver.this.lock;
                synchronized (object) {
                    string = LiveMediaStreamReceiver.this.liveMediaStreamURL[LiveMediaStreamReceiver.this.liveMediaStreamURLIndex].getStreamName();
                }
                if (LiveMediaStreamReceiver.this.callFCSubscribe) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("call FCSubscribe");
                    iNetConnection.call("FCSubscribe", null, string);
                }
                object = LiveMediaStreamReceiver.this.mediaCasterStreamItem.getLiveStreamPacketizer();
                String string2 = LiveMediaStreamReceiver.this.mediaCasterStreamItem.getLiveStreamRepeater();
                if (object != null) {
                    iNetConnection.call("initLiveStreamRepeating", iMediaStream, null, object, string2);
                }
                if (MediaCaster.debugLog) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#StreamCreateResult.onResult[" + LiveMediaStreamReceiver.this.contextStr + "]: play: " + string);
                }
                iNetConnection.call("play", iMediaStream, null, string);
            }
        }
    }

    class StreamOnPlayStatus
    extends ModuleBase
    implements IMediaStreamCallback {
        LiveMediaStreamReceiver liveMediaStreamReceiver = null;

        public StreamOnPlayStatus(LiveMediaStreamReceiver liveMediaStreamReceiver2) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver2;
        }

        public void onCallback(IMediaStream iMediaStream, RequestFunction requestFunction, AMFDataList aMFDataList) {
            AMFDataObj aMFDataObj = aMFDataList.getObject(1);
            String string = aMFDataObj.getString("code");
            if (MediaCaster.debugLog) {
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#StreamOnPlayStatus.onCallback[" + LiveMediaStreamReceiver.this.contextStr + "]: " + string);
            }
        }
    }

    class StreamOnStatus
    extends ModuleBase
    implements IMediaStreamCallback {
        LiveMediaStreamReceiver liveMediaStreamReceiver = null;

        public StreamOnStatus(LiveMediaStreamReceiver liveMediaStreamReceiver2) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver2;
        }

        public void onCallback(IMediaStream iMediaStream, RequestFunction requestFunction, AMFDataList aMFDataList) {
            int n = aMFDataList.size();
            if (3 < n) {
                AMFDataObj aMFDataObj = aMFDataList.getObject(3);
                String string = aMFDataObj.getString("code");
                if (MediaCaster.debugLog) {
                    WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).info("LiveMediaStreamReceiver#StreamOnStatus.onCallback[" + LiveMediaStreamReceiver.this.contextStr + "]: " + string);
                }
                if (string.equals("NetStream.Play.Start")) {
                    Object object;
                    if (LiveMediaStreamReceiver.this.notifyUnpublish) {
                        LiveMediaStreamReceiver.this.resetStreamTimecodes();
                        MediaStreamMap mediaStreamMap = this.liveMediaStreamReceiver.getAppInstance().getStreams();
                        mediaStreamMap.notifyPlayUnpublish(this.liveMediaStreamReceiver.getStream());
                        LiveMediaStreamReceiver.this.notifyUnpublish = false;
                    }
                    long l = 0L;
                    if (aMFDataObj.containsKey("timecodeOffset")) {
                        try {
                            object = aMFDataObj.getString("timecodeOffset");
                            if (object != null) {
                                if (((String)object).endsWith("L")) {
                                    object = ((String)object).substring(0, ((String)object).length() - 1);
                                }
                                l = Long.parseLong((String)object);
                            }
                            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("StreamOnStatus.onCallback: timecodeOffset: " + l);
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).error("StreamOnStatus: timecodeOffset: " + exception.toString());
                        }
                    }
                    LiveMediaStreamReceiver.this.streamTimecodeOffset = l;
                    object = this.liveMediaStreamReceiver.getAppInstance().getStreams();
                    ((MediaStreamMap)object).notifyPlayPublish(this.liveMediaStreamReceiver.getStream());
                    LiveMediaStreamReceiver.this.notifyUnpublish = true;
                }
                if (string.equals("NetStream.Play.UnpublishNotify")) {
                    LiveMediaStreamReceiver.this.resetStreamTimecodes();
                    MediaStreamMap mediaStreamMap = this.liveMediaStreamReceiver.getAppInstance().getStreams();
                    mediaStreamMap.notifyPlayUnpublish(this.liveMediaStreamReceiver.getStream());
                    LiveMediaStreamReceiver.this.notifyUnpublish = false;
                }
                WMSLoggerFactory.getLogger(LiveMediaStreamReceiver.class).debug("StreamOnStatus: " + string);
            }
        }
    }
}

