/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.netconnection;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.netconnection.INetConnection;
import com.wowza.wms.netconnection.INetConnectionPublisher;
import com.wowza.wms.netconnection.NetConnection;
import com.wowza.wms.netconnection.NetConnectionProcessData;
import com.wowza.wms.request.RequestConnectHandshake;
import com.wowza.wms.response.ResponseFunction;
import com.wowza.wms.response.ResponseFunctions;
import com.wowza.wms.server.RtmpRequestMessage;
import com.wowza.wms.server.RtmpResponseMessage;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.mina.common.ByteBuffer;

public class NetConnectionAdapter {
    public static void service(INetConnection iNetConnection, RtmpRequestMessage rtmpRequestMessage, RtmpResponseMessage rtmpResponseMessage) {
        try {
            INetConnectionPublisher iNetConnectionPublisher;
            Object object;
            Object object2;
            Object object3;
            int n = iNetConnection.getHandshake();
            if (n == 0) {
                OutputStream outputStream = rtmpResponseMessage.getOutputStream();
                byte[] byArray = new byte[1537];
                byArray[0] = 3;
                System.arraycopy(RequestConnectHandshake.clientHandshakeRTMPFLASH10, 0, byArray, 1, RequestConnectHandshake.clientHandshakeRTMPFLASH10.length);
                outputStream.write(byArray);
                iNetConnection.setHandshake(1);
                return;
            }
            int n2 = rtmpRequestMessage.getContentLength();
            int n3 = rtmpRequestMessage.getHeaderLength();
            ByteBuffer byteBuffer = rtmpRequestMessage.getBody();
            ((NetConnection)iNetConnection).incrementTotalInBytes(n2);
            byte[] byArray = null;
            if (n == 1) {
                if (n2 == 0) {
                    return;
                }
                byArray = NetConnectionAdapter.getReqBytes(iNetConnection, byteBuffer, n3, n2);
                if (byArray.length >= 3073) {
                    object3 = rtmpResponseMessage.getOutputStream();
                    object2 = RequestConnectHandshake.generateClientHandshake(byArray, 1);
                    ((OutputStream)object3).write((byte[])object2);
                    iNetConnection.setHandshake(2);
                    n2 = 0;
                    object = iNetConnection.getHandshakeResult();
                    if (object != null) {
                        object.onResult(iNetConnection, null, null);
                    }
                } else {
                    iNetConnection.setLeftOverData(byArray, 0, byArray.length);
                    return;
                }
            }
            if (n2 > 0) {
                iNetConnection.setLastValidateTime(System.currentTimeMillis());
                object3 = new ArrayList();
                NetConnectionProcessData.processNextRequest(iNetConnection, byteBuffer, n3, n2, object3);
                if (object3.size() > 0) {
                    WMSLoggerFactory.getLogger(NetConnectionAdapter.class).error("NetConnectionProcessFunctions: lingering function: " + object3.size());
                }
                iNetConnection.packetComplete();
                iNetConnection.checkPingTimeout();
                iNetConnection.checkLastIdlePing();
                long l = iNetConnection.getTotalInBytes();
                if (l > iNetConnection.getNextConfirmBytesReceived()) {
                    iNetConnection.incrementNextConfirmBytesReceived();
                    long l2 = l;
                    byte[] byArray2 = new byte[]{2, 0, 0, 0, 0, 0, 4, 3, 0, 0, 0, 0, (byte)(0xFFL & l2 >> 24), (byte)(0xFFL & l2 >> 16), (byte)(0xFFL & l2 >> 8), (byte)(0xFFL & l2)};
                    ResponseFunction responseFunction = new ResponseFunction(iNetConnection);
                    responseFunction.addBytes(byArray2);
                    ResponseFunctions responseFunctions = iNetConnection.getRespFunctions();
                    responseFunctions.add(responseFunction);
                }
                iNetConnection.setLastValidateTime(System.currentTimeMillis());
            }
            int n4 = 0;
            object2 = rtmpResponseMessage.getOutputStream();
            object = iNetConnection.getRespFunctions();
            if (((ResponseFunctions)object).isPending()) {
                n4 += ((ResponseFunctions)object).output((OutputStream)object2, iNetConnection.getSendChunkSize());
            }
            if ((iNetConnectionPublisher = iNetConnection.getPublishHandler()) != null) {
                long[] lArray = null;
                lArray = new long[8];
                iNetConnectionPublisher.play(iNetConnection, (OutputStream)object2, lArray);
            }
            ((NetConnection)iNetConnection).incrementTotalOutBytes(n4);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(NetConnectionAdapter.class).error("service: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private static byte[] getReqBytes(INetConnection iNetConnection, ByteBuffer byteBuffer, int n, int n2) {
        byte[] byArray = null;
        byte[] byArray2 = iNetConnection.getLeftOverData();
        iNetConnection.clearLeftOverData();
        if (byArray2 != null) {
            byArray = new byte[byArray2.length + n2];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byteBuffer.position(n);
            byteBuffer.get(byArray, byArray2.length, n2);
        } else {
            byArray = new byte[n2];
            byteBuffer.position(n);
            byteBuffer.get(byArray);
        }
        byteBuffer.release();
        return byArray;
    }
}

