/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTCPEventNotify;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPHandler;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerMPEG4AAC;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class RTPDePacketizerBase
implements IRTPDePacketizer {
    protected static final String RTCPWAITING_WARNING = "Waiting for RTCP packet. See docs for (Application.xml: RTP/AVSyncMethod and RTP/MaxRTCPWaitTime).";
    protected RTPContext rtpContext = null;
    protected RTPDePacketizerItem rtpDePacketizerItem = null;
    private long ssrc = -1L;
    private boolean reportedErrorRTP = false;
    private boolean reportedErrorRTCP = false;
    protected boolean debugLog = false;
    private boolean isFirstRTPSSRCCheck = true;
    private boolean doCheckRTPSSRC = true;
    private String rtpIpAddress = null;
    private boolean isFirstRTCPSSRCCheck = true;
    private boolean doCheckRTCPSSRC = true;
    private String rtcpIpAddress = null;
    protected int rtcpMissingWarningTime = 6000;
    protected long lastRTCPCheckTime = -1L;
    protected WMSProperties properties = new WMSProperties();
    protected RTCPHandler rtcpHandler = new RTCPHandler(this);

    public void setProperties(WMSProperties wMSProperties) {
        this.properties.putAll(wMSProperties);
    }

    public WMSProperties getProperties() {
        return this.properties;
    }

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        this.rtpContext = rTPContext;
        this.rtpDePacketizerItem = rTPDePacketizerItem;
        this.rtcpMissingWarningTime = this.properties.getPropertyInt("rtcpMissingWarningTime", this.rtcpMissingWarningTime);
        this.initDebugLog();
    }

    protected void initDebugLog() {
        this.debugLog = WMSLoggerFactory.getLogger(null).isDebugEnabled();
    }

    public void checkRTCPMissingWarning() {
        if (this.lastRTCPCheckTime == -1L) {
            this.lastRTCPCheckTime = System.currentTimeMillis();
        } else if (this.rtcpMissingWarningTime > 0 && System.currentTimeMillis() - this.lastRTCPCheckTime > (long)this.rtcpMissingWarningTime) {
            WMSLoggerFactory.getLogger(RTPDePacketizerMPEG4AAC.class).warn(RTCPWAITING_WARNING);
            this.lastRTCPCheckTime = System.currentTimeMillis();
        }
    }

    public boolean checkRTPSSRC(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.isFirstRTPSSRCCheck) {
            this.doCheckRTPSSRC = rTPTrack.getRTPStream().isCheckSSRC();
            if (rTPTrack.getRTPStream().isCheckIpAddr() && socketAddress != null && socketAddress instanceof InetSocketAddress) {
                this.rtpIpAddress = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            }
            this.isFirstRTPSSRCCheck = false;
        }
        boolean bl = true;
        if (this.rtpIpAddress != null && socketAddress != null && socketAddress instanceof InetSocketAddress && !((InetSocketAddress)socketAddress).getAddress().getHostAddress().equals(this.rtpIpAddress) && !(bl = false) && !this.reportedErrorRTP) {
            WMSLoggerFactory.getLogger(RTPDePacketizerMPEG4AAC.class).warn("RTPDePacketizerBase.checkRTPSSRC: ipAddress: " + ((InetSocketAddress)socketAddress).getAddress().getHostAddress() + ":" + this.rtpIpAddress);
            this.reportedErrorRTP = true;
        }
        boolean bl2 = true;
        if (this.doCheckRTPSSRC) {
            bl2 = false;
            long l = BufferUtils.byteArrayToLong(byArray, n + 8, 4);
            if (this.ssrc == -1L) {
                this.ssrc = l;
                bl2 = true;
            } else if (l == this.ssrc) {
                bl2 = true;
            }
            if (!bl2 && !this.reportedErrorRTP) {
                WMSLoggerFactory.getLogger(RTPDePacketizerMPEG4AAC.class).warn("RTPDePacketizerBase.checkRTPSSRC: ssrc error: " + Long.toHexString(this.ssrc) + ":" + Long.toHexString(l));
                this.reportedErrorRTP = true;
            }
        }
        return bl && bl2;
    }

    public boolean checkRTCPSSRC(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.isFirstRTCPSSRCCheck) {
            this.doCheckRTCPSSRC = rTPTrack.getRTPStream().isCheckSSRC();
            if (rTPTrack.getRTPStream().isCheckIpAddr() && socketAddress != null && socketAddress instanceof InetSocketAddress) {
                this.rtcpIpAddress = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            }
            this.isFirstRTCPSSRCCheck = false;
        }
        boolean bl = true;
        if (this.rtcpIpAddress != null && socketAddress != null && socketAddress instanceof InetSocketAddress && !((InetSocketAddress)socketAddress).getAddress().getHostAddress().equals(this.rtcpIpAddress) && !(bl = false) && !this.reportedErrorRTP) {
            WMSLoggerFactory.getLogger(RTPDePacketizerMPEG4AAC.class).warn("RTPDePacketizerBase.checkRTCPSSRC: ipAddress: " + ((InetSocketAddress)socketAddress).getAddress().getHostAddress() + ":" + this.rtpIpAddress);
            this.reportedErrorRTP = true;
        }
        boolean bl2 = true;
        if (this.doCheckRTCPSSRC) {
            bl2 = false;
            long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
            if (this.ssrc == -1L) {
                this.ssrc = l;
                bl2 = true;
            } else if (l == this.ssrc) {
                bl2 = true;
            }
            if (!bl2 && !this.reportedErrorRTCP) {
                WMSLoggerFactory.getLogger(RTPDePacketizerMPEG4AAC.class).warn("RTPDePacketizerBase.checkRTCPSSRC: ssrc error: " + Long.toHexString(this.ssrc) + ":" + Long.toHexString(l));
                this.reportedErrorRTCP = true;
            }
        }
        return bl && bl2;
    }

    public void setupAppInstanceRTCPEventHandler(IRTPTimecodeProvider iRTPTimecodeProvider, RTCPHandler rTCPHandler, RTPTrack rTPTrack) {
        String string;
        IApplicationInstance iApplicationInstance = rTPTrack.getStream().getAppInstance();
        if (iApplicationInstance != null && (string = this.properties.getPropertyStr("rtcpEventHandler")) != null) {
            try {
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    IRTCPEventNotify iRTCPEventNotify = (IRTCPEventNotify)clazz.newInstance();
                    if (iRTCPEventNotify != null) {
                        iRTCPEventNotify.setTimecodeProvider(iRTPTimecodeProvider);
                        rTCPHandler.addEventListener(iRTCPEventNotify);
                    } else {
                        WMSLoggerFactory.getLogger(RTPDePacketizerBase.class).warn("RTPDePacketizerBase.setupAppInstanceRTCPEventHandler: Event handler could not be instantiated: " + string);
                    }
                } else {
                    WMSLoggerFactory.getLogger(RTPDePacketizerBase.class).warn("RTPDePacketizerBase.setupAppInstanceRTCPEventHandler: Event handler could not be found: " + string);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPDePacketizerBase.class).error("RTPDePacketizerBase.setupAppInstanceRTCPEventHandler: " + exception.toString());
            }
        }
    }

    public int skipRTPExtensions(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3;
        if ((byArray[n + 0] >> 4 & 1) == 1) {
            int n5 = byArray[n + n4 + 2] & 0xFF;
            n5 <<= 8;
            if ((n4 += ((n5 += byArray[n + n4 + 3] & 0xFF) + 1) * 4) >= n2) {
                n4 = n3;
            }
        }
        return n4;
    }
}

