/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BitReader;
import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerAudioBase;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.util.RTPUtils;
import java.net.SocketAddress;

public class RTPDePacketizerMPEG4AAC
extends RTPDePacketizerAudioBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private boolean isFirstPacket = true;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RTPSequence seq = new RTPSequence();
    private RTPPacket workingPacket = null;
    private boolean gotHeaderSize = false;
    private int auxiliaryDataSizeLength = 0;
    private int auxiliaryDataSizeLengthBytes = 0;
    private int constantSize = 0;
    private int constantDuration = 0;
    private int maxDisplacement = 0;
    private int deinterleaveBufferSize = 0;
    private int sizeLength = 0;
    private int indexLength = 0;
    private int indexDeltaLength = 0;
    private int CTSDeltaLength = 0;
    private int DTSDeltaLength = 0;
    private int randomAccessIndication = 0;
    private int streamStateIndication = 0;
    private long lastTimecode = -1L;
    private RolloverLong timecode = new RolloverLong(32);
    private boolean testAudioAACHeader = false;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerMPEG4AAC.init");
        }
        this.testAudioAACHeader = this.properties.getPropertyBoolean("testAudioAACHeader", this.testAudioAACHeader);
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        return rTPTrack.isAudio();
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    private int getIntValue(RTPTrack rTPTrack, String string, int n) {
        int n2 = n;
        String string2 = rTPTrack.getTrackInfo(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n2 = n;
            }
        }
        return n2;
    }

    private long getLongValue(RTPTrack rTPTrack, String string, long l) {
        long l2 = l;
        String string2 = rTPTrack.getTrackInfo(string);
        if (string2 != null) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (Exception exception) {
                l2 = l;
            }
        }
        return l2;
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        try {
            boolean bl = (byArray[n + 1] >> 7 & 1) == 1;
            int n4 = this.skipRTPExtensions(byArray, n, n2, 12);
            if (!this.gotHeaderSize) {
                this.auxiliaryDataSizeLength = this.getIntValue(rTPTrack, "auxiliarydatasizelength", 0);
                this.constantSize = this.getIntValue(rTPTrack, "constantsize", 0);
                this.constantDuration = this.getIntValue(rTPTrack, "constantduration", 0);
                this.maxDisplacement = this.getIntValue(rTPTrack, "maxdisplacement", 0);
                this.deinterleaveBufferSize = this.getIntValue(rTPTrack, "de-interleavebuffersize", 0);
                this.sizeLength = this.getIntValue(rTPTrack, "sizelength", 0);
                this.indexLength = this.getIntValue(rTPTrack, "indexlength", 0);
                this.indexDeltaLength = this.getIntValue(rTPTrack, "indexdeltalength", 0);
                this.CTSDeltaLength = this.getIntValue(rTPTrack, "ctsdeltalength", 0);
                this.DTSDeltaLength = this.getIntValue(rTPTrack, "dtsdeltalength", 0);
                this.randomAccessIndication = this.getIntValue(rTPTrack, "randomaccessindication", 0);
                this.streamStateIndication = this.getIntValue(rTPTrack, "streamstateindication", 0);
                if (this.auxiliaryDataSizeLength > 0) {
                    this.auxiliaryDataSizeLengthBytes = this.auxiliaryDataSizeLength / 8 + (this.auxiliaryDataSizeLength % 8 > 0 ? 1 : 0) + 2;
                }
                if (this.sizeLength + this.indexLength > 0) {
                    this.gotHeaderSize = true;
                }
                if (this.gotHeaderSize && this.debugLog) {
                    WMSLoggerFactory.getLogger(null).debug("auxiliaryDataSizeLength: " + this.auxiliaryDataSizeLength);
                    WMSLoggerFactory.getLogger(null).debug("constantSize: " + this.constantSize);
                    WMSLoggerFactory.getLogger(null).debug("constantDuration: " + this.constantDuration);
                    WMSLoggerFactory.getLogger(null).debug("maxDisplacement: " + this.maxDisplacement);
                    WMSLoggerFactory.getLogger(null).debug("deinterleaveBufferSize: " + this.deinterleaveBufferSize);
                    WMSLoggerFactory.getLogger(null).debug("sizeLength: " + this.sizeLength);
                    WMSLoggerFactory.getLogger(null).debug("indexLength: " + this.sizeLength);
                    WMSLoggerFactory.getLogger(null).debug("indexDeltaLength: " + this.indexDeltaLength);
                    WMSLoggerFactory.getLogger(null).debug("CTSDeltaLength: " + this.CTSDeltaLength);
                    WMSLoggerFactory.getLogger(null).debug("DTSDeltaLength: " + this.DTSDeltaLength);
                    WMSLoggerFactory.getLogger(null).debug("randomAccessIndication: " + this.randomAccessIndication);
                    WMSLoggerFactory.getLogger(null).debug("streamStateIndication: " + this.streamStateIndication);
                    WMSLoggerFactory.getLogger(null).debug("auxiliaryDataSizeLength: " + this.auxiliaryDataSizeLength);
                }
            }
            if (this.gotHeaderSize) {
                int n5 = 0;
                n5 = byArray[n + n4] & 0xFF;
                n5 <<= 8;
                n5 = byArray[n + n4 + 1] & 0xFF;
                int n6 = n5 / 8 + (n5 % 8 > 0 ? 1 : 0) + 2;
                BitReader bitReader = null;
                if (n6 <= n2 - n4) {
                    byte[] byArray2 = new byte[n6 - 2];
                    System.arraycopy(byArray, n + n4 + 2, byArray2, 0, n6 - 2);
                    bitReader = new BitReader(byArray2);
                }
                int n7 = rTPTrack.getTimescale();
                boolean bl2 = true;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                long l2 = this.timecode.get();
                while (bitReader != null) {
                    int n11;
                    long l3;
                    int n12 = 0;
                    if (this.sizeLength > 0) {
                        if (bitReader.remaining() < this.sizeLength) break;
                        n12 = bitReader.getInt(this.sizeLength);
                    } else if (this.constantSize > 0) {
                        n12 = this.constantSize;
                    }
                    if (bl2 && this.indexLength > 0) {
                        if (bitReader.remaining() < this.indexLength) break;
                        n8 = bitReader.getInt(this.indexLength);
                    } else if (!bl2 && this.indexDeltaLength > 0) {
                        if (bitReader.remaining() < this.indexDeltaLength) break;
                        n8 += bitReader.getInt(this.indexDeltaLength);
                    }
                    int n13 = 0;
                    int n14 = 0;
                    if (this.CTSDeltaLength > 0) {
                        if (bitReader.remaining() < 1) break;
                        n14 = bitReader.getBit();
                        if (n14 > 0) {
                            if (bitReader.remaining() < this.CTSDeltaLength) break;
                            n13 = bitReader.getIntSigned(this.CTSDeltaLength);
                        }
                    }
                    int n15 = 0;
                    int n16 = 0;
                    if (this.DTSDeltaLength > 0) {
                        if (bitReader.remaining() < 1) break;
                        n16 = bitReader.getBit();
                        if (n16 > 0) {
                            if (bitReader.remaining() < this.CTSDeltaLength) break;
                            n15 = bitReader.getIntSigned(this.DTSDeltaLength);
                        }
                    }
                    int n17 = 0;
                    if (this.randomAccessIndication > 0) {
                        if (bitReader.remaining() < 1) break;
                        n17 = bitReader.getBit();
                    }
                    int n18 = 0;
                    if (this.streamStateIndication > 0) {
                        if (bitReader.remaining() < this.streamStateIndication) break;
                        n18 = bitReader.getInt(this.streamStateIndication);
                    }
                    if (!bl2) {
                        l3 = this.timecode.get();
                        l3 = n14 == 0 ? (l3 += (long)(this.constantDuration > 0 ? this.constantDuration : rTPTrack.getSamplesPerFrame())) : (l3 += l2 + (long)n13);
                        this.timecode.setAbs(l3);
                    }
                    if (n16 > 0) {
                        l3 = this.timecode.get() + (long)n15;
                        this.timecode.setAbs(l3);
                    }
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug("  header: end:" + bl + " tc:" + this.timecode.get() + " sz: " + n12 + " idx:" + n8 + " cts:" + n13 + " dts:" + n15 + " rap:" + n17 + " ss:" + n18);
                    }
                    if (n12 > 0 && n + n2 - (n11 = n + n4 + n6 + this.auxiliaryDataSizeLengthBytes + n10) >= n12) {
                        boolean bl3;
                        AACFrame aACFrame;
                        RTPPacketFragment rTPPacketFragment;
                        if (this.workingPacket == null) {
                            this.workingPacket = new RTPPacket();
                            this.workingPacket.setType(8);
                            this.workingPacket.setCodec(10);
                            this.workingPacket.setFrameType(15);
                            this.workingPacket.setTimecode(this.timecode.get());
                        }
                        int n19 = n12;
                        RTPPacketFragment rTPPacketFragment2 = new RTPPacketFragment(byArray, n11, n19);
                        this.workingPacket.addFragment(rTPPacketFragment2);
                        if (this.testAudioAACHeader && (rTPPacketFragment = this.workingPacket.getFragments().get(0)) != null && rTPPacketFragment.getLen() >= 7 && (aACFrame = AACUtils.decodeFrame(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset())) != null) {
                            if (this.debugLog) {
                                WMSLoggerFactory.getLogger(null).info("aacHeader[" + this.workingPacket.getSize() + "]: " + aACFrame.toString());
                            }
                            if (aACFrame.getSize() == this.workingPacket.getSize()) {
                                rTPPacketFragment.setOffset(rTPPacketFragment.getOffset() + 7);
                                rTPPacketFragment.setLen(rTPPacketFragment.getLen() - 7);
                                this.workingPacket.setSize(this.workingPacket.getSize() - 7);
                            }
                        }
                        if (!(bl3 = this.rtcpHandler.isTimeSyncReady(rTPTrack, this.workingPacket.getTimecode()))) {
                            this.workingPacket = null;
                            if (!bl3) {
                                this.checkRTCPMissingWarning();
                            }
                        } else {
                            long l4 = this.rtcpHandler.convertTimeSyncTimecode(this.timecode.get(), n7);
                            if (this.isFirstPacket) {
                                byte[] byArray3 = rTPTrack.getCodecConfig();
                                if (byArray3 != null) {
                                    if (this.debugLog) {
                                        WMSLoggerFactory.getLogger(null).info("  codecConfig: " + DebugUtils.formatBytesShort(byArray3));
                                        AACFrame aACFrame2 = AACUtils.decodeAACCodecConfig(byArray3, 0);
                                        if (aACFrame2 != null) {
                                            WMSLoggerFactory.getLogger(null).info("  codecConfigInfo: " + aACFrame2.toString());
                                        }
                                    }
                                    RTPUtils.writeCodecConfig(rTPTrack, l4, byArray3);
                                }
                                this.isFirstPacket = false;
                            }
                            if (this.debugLog) {
                                this.workingPacket.setDebugLog(true);
                            }
                            this.workingPacket.write(rTPTrack, l4);
                            this.workingPacket = null;
                        }
                    }
                    n10 += n12;
                    ++n9;
                    bl2 = false;
                    if (bitReader.count() < n5) continue;
                    break;
                }
            }
            this.lastTimecode = this.timecode.get();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPDePacketizerMPEG4AAC.class).warn("RTPDePacketizerMPEG4AAC.handleRTPPacket: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

