/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerAudioBase;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class RTPDePacketizerRFC2250MP3
extends RTPDePacketizerAudioBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RTPSequence seq = new RTPSequence();
    private long lastTimecode = -1L;
    private RolloverLong timecode = new RolloverLong(32);
    private RTPPacket workingPacket = null;
    private long lastSeq = -1L;
    private boolean waitForStart = true;
    private int workingPacketTargetSize = -1;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerRFC2250MP3.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isAudio() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("mpa") && rTPTrack.getRTPMapType() == 14;
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    private RTPPacket getWorkingPacket(long l) {
        if (this.workingPacket == null) {
            this.workingPacket = new RTPPacket();
            this.workingPacket.setType(8);
            this.workingPacket.setCodec(2);
            this.workingPacket.setFrameType(15);
            this.workingPacket.setTimecode(l);
        }
        return this.workingPacket;
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).info("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        int n4 = rTPTrack.getTimescale();
        try {
            Object object;
            int n5 = this.skipRTPExtensions(byArray, n, n2, 12);
            int n6 = 0;
            int n7 = BufferUtils.byteArrayToInt(byArray, n + n5 + (n6 += 2), 2);
            n6 += 2;
            RTPPacket rTPPacket = null;
            if (n7 > 0) {
                if (!this.waitForStart) {
                    if (this.seq.longValue() != this.lastSeq + 1L) {
                        this.waitForStart = true;
                    } else {
                        rTPPacket = this.getWorkingPacket(this.timecode.get());
                        object = new RTPPacketFragment(byArray, n + n5 + n6, n2 - (n5 + n6));
                        rTPPacket.addFragment((RTPPacketFragment)object);
                    }
                }
            } else {
                this.waitForStart = false;
                this.workingPacketTargetSize = -1;
                this.workingPacket = null;
                object = new byte[4];
                System.arraycopy(byArray, n + n5 + n6, object, 0, ((byte[])object).length);
                MP3HeaderData mP3HeaderData = new MP3HeaderData();
                int n8 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])object, (MP3HeaderData)mP3HeaderData);
                if (n8 != 0) {
                    MP3BufferedDecoder.decodeHeader((int)n8, (int)0, (MP3HeaderData)mP3HeaderData);
                    int n9 = MP3BufferedDecoder.calculateFrameSize((MP3HeaderData)mP3HeaderData);
                    this.workingPacketTargetSize = n9 + 4;
                    rTPPacket = this.getWorkingPacket(this.timecode.get());
                    RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n + n5 + n6, n2 - (n5 + n6));
                    rTPPacket.addFragment(rTPPacketFragment);
                }
            }
            if (rTPPacket != null && this.workingPacketTargetSize != -1) {
                boolean bl = this.rtcpHandler.isTimeSyncReady(rTPTrack, this.workingPacket.getTimecode());
                if (!bl) {
                    this.workingPacket = null;
                    this.workingPacketTargetSize = -1;
                    if (!bl) {
                        this.checkRTCPMissingWarning();
                    }
                } else if (rTPPacket.getSize() >= this.workingPacketTargetSize) {
                    long l2 = this.rtcpHandler.convertTimeSyncTimecode(this.timecode.get(), n4);
                    if (this.debugLog) {
                        rTPPacket.setDebugLog(true);
                    }
                    rTPPacket.write(rTPTrack, l2);
                    this.workingPacket = null;
                    this.workingPacketTargetSize = -1;
                }
            }
            this.lastSeq = this.seq.longValue();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("RTPDePacketizerRFC2250MP3.handleRTPPacket: " + exception.toString());
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

