/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerQuicktimeH264;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerVideoBase;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.commons.lang.time.FastDateFormat;

public class RTPDePacketizerRFC3984H264
extends RTPDePacketizerVideoBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private RTPSequence seq = new RTPSequence();
    private RTPPacket workingPacket = null;
    private byte[] payloadDescription = null;
    private byte[] avccData = null;
    private Object payloadLock = new Object();
    private long lastTimecode = -1L;
    private long lastSeq = -1L;
    private boolean waitForEnd = false;
    private int waitForDropped = 0;
    private boolean isSendReady = false;
    private int fragmentSize = 0;
    private byte[] fragmentBuffer = null;
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RolloverLong timecode = new RolloverLong(32);
    private boolean isCodecConfig = false;
    private long lastSentTimecode = -1L;
    private RTPPacket saveSendPacket = null;
    private int lateCount = 0;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerRFC3984H264.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        return rTPTrack.isVideo();
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    protected boolean isCodecConfig(RTPTrack rTPTrack) {
        if (!this.isCodecConfig) {
            this.isCodecConfig = rTPTrack.isCodecConfig();
        }
        return this.isCodecConfig;
    }

    protected byte[] getCodecConfig(RTPTrack rTPTrack) {
        return rTPTrack.getCodecConfig();
    }

    private void closeFragment() {
        if (this.fragmentBuffer != null) {
            this.fragmentBuffer[0] = (byte)(this.fragmentSize >> 24 & 0xFF);
            this.fragmentBuffer[1] = (byte)(this.fragmentSize >> 16 & 0xFF);
            this.fragmentBuffer[2] = (byte)(this.fragmentSize >> 8 & 0xFF);
            this.fragmentBuffer[3] = (byte)(this.fragmentSize >> 0 & 0xFF);
        }
        this.fragmentBuffer = null;
        this.fragmentSize = 0;
    }

    private void openPacket(long l) {
        if (this.workingPacket == null) {
            int n = 1;
            this.workingPacket = new RTPPacket();
            this.workingPacket.setType(9);
            this.workingPacket.setCodec(7);
            this.workingPacket.setFrameType(n);
            this.workingPacket.setTimecode(l);
        }
    }

    public static String logTimeContext(RTPTrack rTPTrack) {
        String string = "";
        Date date = new Date();
        FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"HH:mm:ss");
        string = (rTPTrack == null ? "unknown" : rTPTrack.getStream().getStreamName()) + ": " + fastDateFormat.format(date) + ": ";
        return string;
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        block44: {
            if (this.debugLog) {
                int n3 = Math.min(n2, 16);
                WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
            }
            if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
                return;
            }
            this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
            long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
            this.timecode.set(l);
            try {
                int n4;
                boolean bl;
                int n5 = this.skipRTPExtensions(byArray, n, n2, 12);
                boolean bl2 = bl = (byArray[n + 1] >> 7 & 1) == 1;
                if (this.waitForEnd) {
                    if (bl) {
                        this.lastTimecode = this.timecode.get();
                        this.lastSeq = this.seq.longValue();
                        this.waitForEnd = false;
                    }
                    ++this.waitForDropped;
                    this.workingPacket = null;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerRFC3984H264.logTimeContext(rTPTrack) + "  waitforend: dropped:" + this.waitForDropped);
                    }
                    break block44;
                }
                long l2 = this.seq.longValue();
                if (this.lastSeq != -1L && this.lastSeq + 1L != l2) {
                    n4 = 0;
                    ++this.lateCount;
                    if (this.lateCount > 30) {
                        n4 = 1;
                        this.waitForEnd = true;
                        this.waitForDropped = 0;
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerRFC3984H264.logTimeContext(rTPTrack) + "  latecount: curr:" + l2 + " last:" + this.lastSeq + " lateCount:" + this.lateCount);
                        }
                    } else {
                        if (l2 <= this.lastSeq) {
                            if (this.debugLog) {
                                WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerRFC3984H264.logTimeContext(rTPTrack) + "  latepacket: curr:" + l2 + " last:" + this.lastSeq + " lateCount:" + this.lateCount);
                            }
                            break block44;
                        }
                        n4 = 1;
                        this.waitForEnd = true;
                        this.waitForDropped = 0;
                        if (this.debugLog) {
                            WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerRFC3984H264.logTimeContext(rTPTrack) + "  dropmany: curr:" + l2 + " last:" + this.lastSeq + " lateCount:" + this.lateCount);
                        }
                    }
                    if (n4 != 0) {
                        if (this.workingPacket != null) {
                            this.closeFragment();
                            if (this.debugLog) {
                                WMSLoggerFactory.getLogger(null).debug(RTPDePacketizerRFC3984H264.logTimeContext(rTPTrack) + "  sendPartial");
                            }
                            this.sendPacket(rTPTrack, this.workingPacket, true);
                        }
                        this.workingPacket = null;
                    }
                    if (this.waitForEnd) {
                        this.workingPacket = null;
                        this.lastSeq = this.seq.longValue();
                        break block44;
                    }
                }
                this.lastTimecode = this.timecode.get();
                this.lastSeq = this.seq.longValue();
                this.lateCount = 0;
                if (n + n5 + 0 >= n2) break block44;
                n4 = byArray[n + n5 + 0] & 0x1F;
                if (n4 == 30) {
                    n4 = byArray[n + (n5 += 12) + 0] & 0x1F;
                }
                if (n4 >= 1 && n4 <= 23) {
                    int n6 = n2 - n5;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug("  SINGLE: end:" + bl + " tc:" + this.timecode.get() + " sz:" + n6);
                    }
                    if (n6 > 0) {
                        this.openPacket(this.timecode.get());
                        this.closeFragment();
                        byte[] byArray2 = new byte[]{(byte)(n6 >> 24 & 0xFF), (byte)(n6 >> 16 & 0xFF), (byte)(n6 >> 8 & 0xFF), (byte)(n6 >> 0 & 0xFF)};
                        RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray2, 0, byArray2.length);
                        this.workingPacket.addFragment(rTPPacketFragment);
                        rTPPacketFragment = new RTPPacketFragment(byArray, n + n5, n2 - n5);
                        this.workingPacket.addFragment(rTPPacketFragment);
                    }
                } else if (n4 == 24) {
                    int n7;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug("  STAP-A: end:" + bl + " tc:" + this.timecode.get());
                    }
                    int n8 = n2 - n5 - 1;
                    int n9 = n + n5 + 1;
                    int n10 = 0;
                    while (n8 - n10 >= 2 && (n7 = BufferUtils.byteArrayToInt(byArray, n9 + n10, 2)) != 0) {
                        if (n7 > 0 && n7 <= n8 - (n10 += 2)) {
                            int n11 = byArray[n9 + n10] & 0x1F;
                            if (this.debugLog) {
                                WMSLoggerFactory.getLogger(null).debug("    sub: end:" + bl + " tc:" + this.timecode.get() + " sz:" + n7);
                            }
                            if (n11 >= 1 && n11 <= 23 && n11 != 14) {
                                this.openPacket(this.timecode.get());
                                this.closeFragment();
                                byte[] byArray3 = new byte[]{(byte)(n7 >> 24 & 0xFF), (byte)(n7 >> 16 & 0xFF), (byte)(n7 >> 8 & 0xFF), (byte)(n7 >> 0 & 0xFF)};
                                RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray3, 0, byArray3.length);
                                this.workingPacket.addFragment(rTPPacketFragment);
                                rTPPacketFragment = new RTPPacketFragment(byArray, n9 + n10, n7);
                                this.workingPacket.addFragment(rTPPacketFragment);
                            }
                        }
                        if ((n10 += n7) < n8) continue;
                        break;
                    }
                } else if (n4 == 28) {
                    boolean bl3;
                    if (n + n5 + 1 >= n2) break block44;
                    boolean bl4 = bl3 = (byArray[n + n5 + 1] >> 7 & 1) == 1;
                    if (this.debugLog) {
                        WMSLoggerFactory.getLogger(null).debug("  FU-A: end:" + bl + " tc:" + this.timecode.get() + " st:" + bl3);
                    }
                    this.openPacket(this.timecode.get());
                    if (bl3) {
                        this.closeFragment();
                        int n12 = byArray[n + n5 + 0] & 0xFF;
                        int n13 = byArray[n + n5 + 1] & 0xFF;
                        int n14 = n13 & 0x1F;
                        int n15 = 0;
                        n15 = n12 & 0xE0;
                        this.fragmentBuffer = new byte[5];
                        this.fragmentSize = n2 - n5 - 2 + 1;
                        this.fragmentBuffer[4] = (byte)((n15 |= n14) & 0xFF);
                        RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(this.fragmentBuffer, 0, this.fragmentBuffer.length);
                        this.workingPacket.addFragment(rTPPacketFragment);
                    } else {
                        this.fragmentSize += n2 - n5 - 2;
                    }
                    RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n + n5 + 2, n2 - n5 - 2);
                    this.workingPacket.addFragment(rTPPacketFragment);
                } else if (n4 == 25) {
                    WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).warn("RTPDePacketizerRFC3984H264.handleRTPPacket: Unsupported packet type: STAP-B");
                } else if (n4 == 26) {
                    WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).warn("RTPDePacketizerRFC3984H264.handleRTPPacket: Unsupported packet type: MTAP-16");
                } else if (n4 == 27) {
                    WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).warn("RTPDePacketizerRFC3984H264.handleRTPPacket: Unsupported packet type: MTAP-24");
                } else if (n4 == 29) {
                    WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).warn("RTPDePacketizerRFC3984H264.handleRTPPacket: Unsupported packet type: FU-B");
                }
                if (bl) {
                    if (this.workingPacket != null) {
                        this.closeFragment();
                        this.sendPacket(rTPTrack, this.workingPacket, false);
                    }
                    this.workingPacket = null;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPDePacketizerQuicktimeH264.class).error("RTPDePacketizerRFC3984H264.handleRTPPacket: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.waitForEnd = rTPTrack.isWaitForFirstEnd();
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }

    protected void sendPacket(RTPTrack rTPTrack, RTPPacket rTPPacket, boolean bl) {
        RTPPacket rTPPacket2 = null;
        if (this.saveSendPacket != null) {
            rTPPacket2 = this.saveSendPacket;
            long l = rTPPacket2.getTimecode();
            long l2 = rTPPacket.getTimecode();
            if (l2 < l) {
                long l3 = l2;
                long l4 = l;
                if (this.lastSentTimecode != -1L) {
                    l3 = (this.lastSentTimecode + l2) / 2L;
                }
                int n = rTPTrack.getTimescale();
                long l5 = this.rtcpHandler.convertTimeSyncTimecode(l3, n);
                long l6 = this.rtcpHandler.convertTimeSyncTimecode(l4, n);
                rTPPacket2.setTimecode(l3);
                rTPPacket2.setTimeoffset(l6 - l5);
            }
        }
        this.saveSendPacket = rTPPacket;
        if (rTPPacket2 != null) {
            this.lastSentTimecode = rTPPacket2.getTimecode();
            super.sendPacket(rTPTrack, rTPPacket2, bl);
        }
    }
}

