/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.depacketizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.DebugUtils;
import com.wowza.util.RolloverLong;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.depacketizer.RTCPEventHandlerGeneric;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerAudioBase;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPPacket;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.depacketizer.RTPSequence;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPTrack;
import java.net.SocketAddress;

public class RTPDePacketizerSpeex
extends RTPDePacketizerAudioBase
implements IRTPDePacketizer,
IRTPTimecodeProvider {
    private RTCPEventHandlerGeneric rtcpEventHandler = new RTCPEventHandlerGeneric();
    private RTPSequence seq = new RTPSequence();
    private long lastTimecode = -1L;
    private RolloverLong timecode = new RolloverLong(32);
    private RTPPacket workingPacket = null;
    private int packetCount = 0;
    private boolean bitrateWarning = true;

    public void init(RTPContext rTPContext, RTPDePacketizerItem rTPDePacketizerItem) {
        super.init(rTPContext, rTPDePacketizerItem);
        if (this.debugLog) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerSpeex.init");
        }
    }

    public boolean canHandle(RTPTrack rTPTrack) {
        String string;
        return rTPTrack.isAudio() && (string = rTPTrack.getSampleType()) != null && string.toLowerCase().startsWith("speex");
    }

    public void handleRTCPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtcp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTCPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.rtcpHandler.handleRTCPPacket(socketAddress, rTPTrack, byArray, n, n2);
    }

    public void handleRTPPacket(SocketAddress socketAddress, RTPTrack rTPTrack, byte[] byArray, int n, int n2) {
        if (this.debugLog) {
            int n3 = Math.min(n2, 16);
            WMSLoggerFactory.getLogger(null).debug("rtp[" + rTPTrack.getTrackId() + ":" + n2 + "] {" + DebugUtils.formatBytesShort(byArray, n, n3) + "}");
        }
        if (!this.checkRTPSSRC(socketAddress, rTPTrack, byArray, n, n2)) {
            return;
        }
        this.seq.handleRTPPacket(rTPTrack, byArray, n, n2);
        long l = BufferUtils.byteArrayToLong(byArray, n + 4, 4);
        this.timecode.set(l);
        int n4 = rTPTrack.getTimescale();
        int n5 = rTPTrack.getChannelCount();
        try {
            int n6;
            int n7 = this.skipRTPExtensions(byArray, n, n2, 12);
            int n8 = 0;
            if (this.workingPacket == null) {
                this.workingPacket = new RTPPacket();
                this.workingPacket.setType(8);
                this.workingPacket.setCodec(11);
                n6 = 2;
                n6 += n5 - 1;
                if (n4 != 16000 && this.bitrateWarning) {
                    WMSLoggerFactory.getLogger(null).warn("RTPDePacketizerSpeex.handleRTPPacket: Flash only supports SPEEX at a bitrate of 16000");
                    this.bitrateWarning = false;
                }
                this.workingPacket.setFrameType(n6);
                this.workingPacket.setTimecode(this.timecode.get());
            }
            n6 = 0;
            for (int i = 1; i < 3 && (byArray[n + n2 - i] == -1 || byArray[n + n2 - i] == 127); ++i) {
                ++n6;
                if (byArray[n + n2 - i] == 127) break;
            }
            RTPPacketFragment rTPPacketFragment = new RTPPacketFragment(byArray, n + n7 + n8, n2 - (n7 + n8 + n6));
            this.workingPacket.addFragment(rTPPacketFragment);
            ++this.packetCount;
            boolean bl = this.rtcpHandler.isTimeSyncReady(rTPTrack, this.workingPacket.getTimecode());
            if (!bl) {
                if (!bl) {
                    this.checkRTCPMissingWarning();
                }
            } else {
                long l2 = this.rtcpHandler.convertTimeSyncTimecode(this.timecode.get(), n4);
                if (this.debugLog) {
                    this.workingPacket.setDebugLog(true);
                }
                this.workingPacket.write(rTPTrack, l2);
            }
            this.workingPacket = null;
            this.packetCount = 0;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).debug("RTPDePacketizerSpeex.handleRTPPacket: " + exception.toString());
        }
    }

    public void startup(RTPTrack rTPTrack) {
        this.rtcpEventHandler.setTimecodeProvider(this);
        this.rtcpHandler.addEventListener(this.rtcpEventHandler);
        this.setupAppInstanceRTCPEventHandler(this, this.rtcpHandler, rTPTrack);
    }

    public void shutdown(RTPTrack rTPTrack) {
    }

    public long getAdjTimecode(RTPTrack rTPTrack) {
        if (this.lastTimecode != -1L && this.rtcpHandler.isTimeSyncReady(rTPTrack, this.lastTimecode)) {
            long l = this.rtcpHandler.convertTimeSyncTimecode(this.lastTimecode, rTPTrack.getTimescale());
            return l;
        }
        return -1L;
    }
}

