/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtp.depacketizer.IRTCPEventNotify;
import com.wowza.wms.rtp.depacketizer.IRTPTimecodeProvider;
import com.wowza.wms.rtp.model.IRTPMetadataProvider;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.stream.IMediaStream;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPMetadataProviderOrbanOpticodec
implements IRTPMetadataProvider,
IRTCPEventNotify {
    private IRTPTimecodeProvider timecodeProvider = null;
    private RTPStream rtpStream = null;
    private OnMetaDataData metaDataData = new OnMetaDataData();
    private Date creationDate = new Date();

    private AMFDataList objectizeMetadataData(OnMetaDataData onMetaDataData) {
        AMFDataList aMFDataList = new AMFDataList();
        try {
            AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
            aMFDataMixedArray.put("audiodatarate", new AMFDataItem(onMetaDataData.audiodatarate));
            aMFDataMixedArray.put("audiocodecid", new AMFDataItem(onMetaDataData.audiocodecid));
            aMFDataMixedArray.put("audioinputvolume", new AMFDataItem(onMetaDataData.audioinputvolume));
            aMFDataMixedArray.put("audiochannels", new AMFDataItem(onMetaDataData.audiochannels));
            aMFDataMixedArray.put("audiosamplerate", new AMFDataItem(onMetaDataData.audiosamplerate));
            aMFDataMixedArray.put("audiodevice", new AMFDataItem(onMetaDataData.audiodevice));
            aMFDataMixedArray.put("creationdate", new AMFDataItem(this.creationDate));
            aMFDataMixedArray.put("presetname", new AMFDataItem(onMetaDataData.presetname));
            aMFDataMixedArray.put("title", new AMFDataItem(onMetaDataData.title));
            aMFDataMixedArray.put("rating", new AMFDataItem(onMetaDataData.rating));
            aMFDataMixedArray.put("keywords", new AMFDataItem(onMetaDataData.keywords));
            aMFDataMixedArray.put("description", new AMFDataItem(onMetaDataData.description));
            aMFDataMixedArray.put("copyright", new AMFDataItem(onMetaDataData.copyright));
            aMFDataMixedArray.put("author", new AMFDataItem(onMetaDataData.author));
            aMFDataMixedArray.put("name", new AMFDataItem(onMetaDataData.name));
            aMFDataMixedArray.put("artist", new AMFDataItem(onMetaDataData.artist));
            aMFDataMixedArray.put("url", new AMFDataItem(onMetaDataData.url));
            aMFDataList.add(new AMFDataItem("onMetaData"));
            aMFDataList.add(aMFDataMixedArray);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMetadataProviderOrbanOpticodec.class).error("RTPMetadataProviderOrbanOpticode.objectizeMetadataData: " + exception.toString());
            exception.printStackTrace();
        }
        return aMFDataList;
    }

    private byte[] serializeMetadataData(OnMetaDataData onMetaDataData) {
        byte[] byArray = null;
        try {
            AMFDataList aMFDataList = this.objectizeMetadataData(onMetaDataData);
            byArray = aMFDataList.serialize();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMetadataProviderOrbanOpticodec.class).error("RTPMetadataProviderOrbanOpticode.serializeMetadataData: " + exception.toString());
            exception.printStackTrace();
        }
        return byArray;
    }

    @Override
    public byte[] getMetadataPacket(RTPStream rTPStream) {
        if (this.rtpStream == null) {
            this.rtpStream = rTPStream;
        }
        this.getTrackInfo(this.metaDataData, rTPStream.getAudioTrack());
        return this.serializeMetadataData(this.metaDataData);
    }

    @Override
    public void setTimecodeProvider(IRTPTimecodeProvider iRTPTimecodeProvider) {
        this.timecodeProvider = iRTPTimecodeProvider;
    }

    private void getTrackInfo(OnMetaDataData onMetaDataData, RTPTrack rTPTrack) {
        block7: {
            int n;
            String string;
            String string2;
            RTPStream rTPStream;
            if (rTPTrack == null || (rTPStream = rTPTrack.getRTPStream()) == null) break block7;
            onMetaDataData.audiochannels = rTPTrack.getChannelCount();
            onMetaDataData.audiosamplerate = rTPTrack.getTimescale();
            String string3 = rTPStream.getStreamInfo("name");
            if (string3 != null) {
                onMetaDataData.name = string3;
            }
            if ((string2 = rTPStream.getStreamInfo("information")) != null) {
                onMetaDataData.description = string2;
            }
            if ((string = rTPTrack.getTrackInfo("bandwidth")) == null) {
                string = rTPStream.getStreamInfo("bandwidth");
            }
            if (string != null && (n = string.indexOf(":")) >= 0) {
                String string4 = string.substring(n + 1);
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    n2 = -1;
                }
                if (n2 > 0) {
                    onMetaDataData.audiodatarate = n2;
                }
            }
        }
    }

    @Override
    public void onSDES(RTPTrack rTPTrack, long l, Map<String, String> map) {
        try {
            OnMetaDataData onMetaDataData = this.metaDataData.clone();
            this.getTrackInfo(onMetaDataData, rTPTrack);
            String string = map.get("NOTE");
            if (string != null) {
                String[] stringArray = string.split("[;]");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    String string2 = stringArray[i].trim();
                    if (string2.length() <= 0 || (n = string2.indexOf("=")) < 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    if (string3.equalsIgnoreCase("artist")) {
                        onMetaDataData.artist = string4;
                        continue;
                    }
                    if (string3.equalsIgnoreCase("title")) {
                        onMetaDataData.title = string4;
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("url")) continue;
                    onMetaDataData.url = string4;
                }
            }
            if (!onMetaDataData.equals(this.metaDataData)) {
                this.metaDataData = onMetaDataData;
                this.sendOnMetaDataEvent(rTPTrack, this.metaDataData);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPMetadataProviderOrbanOpticodec.class).error("RTPMetadataProviderOrbanOpticode.onSDES: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendOnMetaDataEvent(RTPTrack rTPTrack, OnMetaDataData onMetaDataData) {
        block7: {
            try {
                long l;
                byte[] byArray = this.serializeMetadataData(onMetaDataData);
                if (byArray == null) break block7;
                IMediaStream iMediaStream = rTPTrack.getRTPStream().getStream();
                long l2 = l = this.timecodeProvider != null ? this.timecodeProvider.getAdjTimecode(rTPTrack) : -1L;
                if (l == -1L || iMediaStream == null || byArray == null) break block7;
                WMSReadWriteLock wMSReadWriteLock = rTPTrack.getRTPStream().getStreamLock();
                wMSReadWriteLock.readLock().lock();
                try {
                    iMediaStream.setDataType(18);
                    iMediaStream.setDataTC(l, true);
                    iMediaStream.setDataSize(byArray.length);
                    iMediaStream.startDataPacket();
                    iMediaStream.addDataData(byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                }
                finally {
                    wMSReadWriteLock.readLock().unlock();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPMetadataProviderOrbanOpticodec.class).error("RTPMetadataProviderOrbanOpticode.sendOnMetaDataEvent: " + exception.toString());
                exception.printStackTrace();
            }
        }
    }

    class OnMetaDataData
    implements Serializable {
        int audiodatarate = 32;
        int audiocodecid = 10;
        int audioinputvolume = 100;
        int audiochannels = 2;
        int audiosamplerate = 44100;
        String audiodevice = "Orban Optimod 1100 (505400065)";
        String presetname = "";
        String title = "";
        String rating = "";
        String keywords = "";
        String description = "";
        String copyright = "";
        String author = "";
        String name = "";
        String artist = "";
        String url = "";

        OnMetaDataData() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{onMetaData: ");
            stringBuffer.append("audiodatarate: " + this.audiodatarate + ",");
            stringBuffer.append("audiocodecid: " + this.audiocodecid + ",");
            stringBuffer.append("audioinputvolume: " + this.audioinputvolume + ",");
            stringBuffer.append("audiochannels: " + this.audiochannels + ",");
            stringBuffer.append("audiosamplerate: " + this.audiosamplerate + ",");
            stringBuffer.append("audiodevice: \"" + this.audiodevice + "\",");
            stringBuffer.append("presetname: \"" + this.presetname + "\",");
            stringBuffer.append("title: \"" + this.title + "\",");
            stringBuffer.append("rating: \"" + this.rating + "\",");
            stringBuffer.append("keywords: \"" + this.keywords + "\",");
            stringBuffer.append("description: \"" + this.description + "\",");
            stringBuffer.append("copyright: \"" + this.copyright + "\",");
            stringBuffer.append("author: \"" + this.author + "\",");
            stringBuffer.append("name: \"" + this.name + "\",");
            stringBuffer.append("artist: \"" + this.artist + "\",");
            stringBuffer.append("url: \"" + this.url + "\"");
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        public OnMetaDataData clone() {
            OnMetaDataData onMetaDataData = new OnMetaDataData();
            onMetaDataData.audiodatarate = this.audiodatarate;
            onMetaDataData.audiocodecid = this.audiocodecid;
            onMetaDataData.audioinputvolume = this.audioinputvolume;
            onMetaDataData.audiochannels = this.audiochannels;
            onMetaDataData.audiosamplerate = this.audiosamplerate;
            onMetaDataData.audiodevice = this.audiodevice;
            onMetaDataData.presetname = this.presetname;
            onMetaDataData.title = this.title;
            onMetaDataData.rating = this.rating;
            onMetaDataData.keywords = this.keywords;
            onMetaDataData.description = this.description;
            onMetaDataData.copyright = this.copyright;
            onMetaDataData.author = this.author;
            onMetaDataData.name = this.name;
            onMetaDataData.artist = this.artist;
            onMetaDataData.url = this.url;
            return onMetaDataData;
        }

        public boolean equals(OnMetaDataData onMetaDataData) {
            if (onMetaDataData.audiodatarate != this.audiodatarate) {
                return false;
            }
            if (onMetaDataData.audiocodecid != this.audiocodecid) {
                return false;
            }
            if (onMetaDataData.audioinputvolume != this.audioinputvolume) {
                return false;
            }
            if (onMetaDataData.audiochannels != this.audiochannels) {
                return false;
            }
            if (onMetaDataData.audiosamplerate != this.audiosamplerate) {
                return false;
            }
            if (!onMetaDataData.audiodevice.equals(this.audiodevice)) {
                return false;
            }
            if (!onMetaDataData.presetname.equals(this.presetname)) {
                return false;
            }
            if (!onMetaDataData.title.equals(this.title)) {
                return false;
            }
            if (!onMetaDataData.rating.equals(this.rating)) {
                return false;
            }
            if (!onMetaDataData.keywords.equals(this.keywords)) {
                return false;
            }
            if (!onMetaDataData.description.equals(this.description)) {
                return false;
            }
            if (!onMetaDataData.copyright.equals(this.copyright)) {
                return false;
            }
            if (!onMetaDataData.author.equals(this.author)) {
                return false;
            }
            if (!onMetaDataData.name.equals(this.name)) {
                return false;
            }
            if (!onMetaDataData.artist.equals(this.artist)) {
                return false;
            }
            return onMetaDataData.url.equals(this.url);
        }
    }
}

