/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.SystemUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataArray;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.amf.AMFDataObj;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.httpstreamer.model.HTTPStreamerSessionBase;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterList;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.MediaCasterStreamMap;
import com.wowza.wms.module.ModuleCore;
import com.wowza.wms.module.ModuleFunctions;
import com.wowza.wms.rtp.model.IRTPMetadataProvider;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPPacketizerItem;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.transport.IUDPTransport;
import com.wowza.wms.rtp.transport.RTPMulticastTransport;
import com.wowza.wms.rtp.transport.RTPUDPTransportMina;
import com.wowza.wms.rtsp.RTSPCore;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.server.RtmpResponseMessage;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.stream.rtp.MediaStreamRTPPlay;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReentrantReadWriteLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPStream {
    public static final int MODE_UNKNOWN = 0;
    public static final int MODE_PLAY = 1;
    public static final int MODE_PUBLISH = 2;
    public static final int AVSYNCMETHODS_UNKNOWN = 0;
    public static final int AVSYNCMETHODS_SENDERREPORT = 1;
    public static final int AVSYNCMETHODS_SYSTEMCLOCK = 2;
    public static final int AVSYNCMETHODS_RTPTIMECODE = 3;
    public static final String STREAMINFO_SESSIONPROTOCOLVERSION = "protocolversion";
    public static final String STREAMINFO_SESSIONPORIGIN = "origin";
    public static final String STREAMINFO_SESSIONNAME = "name";
    public static final String STREAMINFO_SESSIONINFORMATION = "information";
    public static final String STREAMINFO_SESSIONURI = "uri";
    public static final String STREAMINFO_SESSIONEMAILADDRESS = "emailaddress";
    public static final String STREAMINFO_SESSIONPHONENUMBER = "phonenumber";
    public static final String STREAMINFO_SESSIONCONNECTIONDATA = "connectiondata";
    public static final String STREAMINFO_SESSIONBANDWIDTH = "bandwidth";
    public static final String STREAMINFO_SESSIONTIMING = "timing";
    public static final String STREAMINFO_SESSIONREPEATTIMES = "repeattimes";
    public static final String STREAMINFO_SESSIONTIMEZONES = "timezones";
    public static final String STREAMINFO_SESSIONATTRIBUTES = "attributes";
    private Map<String, RTPTrack> tracks = new HashMap<String, RTPTrack>();
    private Map<String, String> seqToTrackId = new HashMap<String, String>();
    private RTPSession session = null;
    private RTPContext context = null;
    private IMediaStream stream = null;
    private String streamId = null;
    private WMSReadWriteLock streamLock = new WMSReentrantReadWriteLock();
    private boolean resyncAudioVideoOnSR = false;
    private Map<String, String> streamInfo = new HashMap<String, String>();
    private Map<String, String> streamAttributes = new HashMap<String, String>();
    private boolean sentMetadata = false;
    private String streamType = null;
    private String host = null;
    private String outHost = null;
    private String appName = "_defapp_";
    private String appInstanceName = "_definst_";
    private String streamName = "unknown";
    private String streamNameLogging = "unknown";
    private String streamExt = "mp4";
    private String streamQueryStr = "";
    private String rtspBindIpAddress = null;
    private long streamSessionId = -1L;
    private long streamSessionVersion = -1L;
    private String streamSessionIp = null;
    private boolean checkSSRC = true;
    private boolean checkIpAddr = false;
    private IUDPTransport udpTransport = null;
    private int avSyncMethod = 1;
    private int maxRTCPWaitTime = 10000;
    private int mpegtsVideoPID = -1;
    private int mpegtsAudioPID = -1;
    private boolean isRTSP = false;
    private int mode = 0;
    private String transportMode = null;
    private long createTime = System.currentTimeMillis();
    private long ntpRTOffset = -1L;
    private List<String> repeaterStreams = new ArrayList<String>();
    private List<MediaCasterStreamItem> repeaterStreamItems = new ArrayList<MediaCasterStreamItem>();
    private boolean repeaterStreamsLocked = false;
    private boolean appInstancePropsInited = false;
    private int streamReadyTimeout = 10000;
    private String rtpMetadataProviderPath = null;
    private boolean isForceMPEGTSOut = false;
    private boolean isMPEGTSOut = false;
    private boolean isForceRTSPInterleaved = false;
    private boolean isMediaCasterAudio = true;
    private boolean isMediaCasterVideo = true;
    private String rtspSessionName = "WowzaMediaServer";
    private boolean sendSDESEvents = true;

    public RTPStream(RTPContext rTPContext, String string) {
        this.context = rTPContext;
        this.streamId = string;
    }

    public RTPContext getRTPContext() {
        return this.context;
    }

    public WMSReadWriteLock getStreamLock() {
        return this.streamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrack(RTPTrack rTPTrack) {
        this.streamLock.writeLock().lock();
        try {
            rTPTrack.setStream(this);
            this.tracks.put(rTPTrack.getTrackId(), rTPTrack);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack removeTrack(String string) {
        RTPTrack rTPTrack = null;
        this.streamLock.writeLock().lock();
        try {
            rTPTrack = this.tracks.remove(string);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTracks() {
        Object var1_1 = null;
        this.streamLock.writeLock().lock();
        try {
            this.tracks.clear();
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementMediaInBytes(long l) {
        Object var3_2 = null;
        this.streamLock.writeLock().lock();
        try {
            if (this.stream != null) {
                this.stream.incrementMediaInBytes(l);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack sloppyGetTrack(String string) {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (string.endsWith(rTPTrack2.getTrackId())) {
                    rTPTrack = rTPTrack2;
                } else if (string.equalsIgnoreCase(rTPTrack2.getTrackId())) {
                    rTPTrack = rTPTrack2;
                }
                if (rTPTrack == null) continue;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getTrack(String string) {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            rTPTrack = this.tracks.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackId(String string, String string2) {
        this.streamLock.writeLock().lock();
        try {
            this.seqToTrackId.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackId(String string) {
        String string2 = null;
        this.streamLock.readLock().lock();
        try {
            string2 = this.seqToTrackId.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTrackNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.streamLock.readLock().lock();
        try {
            arrayList.addAll(this.tracks.keySet());
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return arrayList;
    }

    public RTPSession getSession() {
        return this.session;
    }

    public void setSession(RTPSession rTPSession) {
        this.session = rTPSession;
    }

    public String getStreamId() {
        return this.streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMediaStream getStream() {
        IMediaStream iMediaStream = null;
        this.streamLock.readLock().lock();
        try {
            iMediaStream = this.stream;
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return iMediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getAudioTrack() {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isAudio()) continue;
                RTPTrack rTPTrack3 = rTPTrack2;
                return rTPTrack3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getVideoTrack() {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isVideo()) continue;
                RTPTrack rTPTrack3 = rTPTrack2;
                return rTPTrack3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTrack getStreamTrack() {
        RTPTrack rTPTrack = null;
        this.streamLock.readLock().lock();
        try {
            for (RTPTrack rTPTrack2 : this.tracks.values()) {
                if (!rTPTrack2.isStreamTrack()) continue;
                RTPTrack rTPTrack3 = rTPTrack2;
                return rTPTrack3;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return rTPTrack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamInfo(String string, String string2) {
        WMSReadWriteLock wMSReadWriteLock = this.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.streamInfo.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStreamInfo(String string) {
        String string2 = null;
        WMSReadWriteLock wMSReadWriteLock = this.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string2 = this.streamInfo.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamAttribute(String string, String string2) {
        WMSReadWriteLock wMSReadWriteLock = this.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.streamAttributes.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    public IVHost getVHost() {
        return this.session.getVHost();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public boolean streamExists() {
        return this.stream != null;
    }

    public boolean isPublishStreamReady() {
        boolean bl;
        block1: {
            IMediaStream iMediaStream;
            block2: {
                block0: {
                    bl = false;
                    String string = this.getMediaCasterType();
                    if (string != null) break block0;
                    bl = true;
                    break block1;
                }
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                if (iApplicationInstance == null || (iMediaStream = iApplicationInstance.getStreams().getStream(this.getStreamName())) == null) break block1;
                if (this.streamReadyTimeout <= 0 || iMediaStream.getElapsedTime().getTime() <= (long)this.streamReadyTimeout) break block2;
                bl = true;
                break block1;
            }
            if (!iMediaStream.isPublishStreamReady(this.isMediaCasterAudio, this.isMediaCasterVideo)) break block1;
            AMFPacket[] aMFPacketArray = this.getLastPacketsByType(iMediaStream);
            AMFPacket aMFPacket = aMFPacketArray[0];
            AMFPacket aMFPacket2 = aMFPacketArray[1];
            bl = !(this.isMediaCasterAudio && aMFPacket == null || this.isMediaCasterVideo && aMFPacket2 == null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRepeaterStreams(List<String> list) {
        List<String> list2 = this.repeaterStreams;
        synchronized (list2) {
            if (!this.repeaterStreamsLocked) {
                this.repeaterStreamsLocked = true;
                String string = this.getMediaCasterType();
                if (string != null) {
                    IApplicationInstance iApplicationInstance = this.getAppInstance();
                    IVHost iVHost = iApplicationInstance.getVHost();
                    MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
                    MediaCasterList mediaCasterList = iVHost.getMediaCasterList();
                    MediaCasterItem mediaCasterItem = mediaCasterList.getMediaCasterDef(string);
                    boolean bl = false;
                    bl = mediaCasterItem.getProperties().getPropertyBoolean("isLiveRepeater", bl);
                    if (mediaCasterItem == null) {
                        WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).warn("HTTPStreamerSessionBase.lockRepeaterStreams: MediaCaster type not found: " + string);
                    } else {
                        this.isMediaCasterAudio = mediaCasterItem.getProperties().getPropertyBoolean("isMediaCasterAudio", this.isMediaCasterAudio);
                        this.isMediaCasterAudio = iApplicationInstance.getMediaCasterProperties().getPropertyBoolean("isMediaCasterAudio", this.isMediaCasterAudio);
                        this.isMediaCasterVideo = mediaCasterItem.getProperties().getPropertyBoolean("isMediaCasterVideo", this.isMediaCasterVideo);
                        this.isMediaCasterVideo = iApplicationInstance.getMediaCasterProperties().getPropertyBoolean("isMediaCasterVideo", this.isMediaCasterVideo);
                        WMSReadWriteLock wMSReadWriteLock = mediaCasterStreamMap.getLock();
                        wMSReadWriteLock.writeLock().lock();
                        try {
                            for (String string2 : list) {
                                MediaCasterStreamItem mediaCasterStreamItem;
                                if (bl) {
                                    string2 = MediaStreamMediaCasterUtils.mapMediaCasterName(iApplicationInstance, null, string2);
                                    this.setStreamName(string2);
                                }
                                if ((mediaCasterStreamItem = mediaCasterStreamMap.acquire(string2, mediaCasterItem)) == null) continue;
                                this.repeaterStreamItems.add(mediaCasterStreamItem);
                            }
                        }
                        catch (Exception exception) {
                            WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).error("RTPStream.lockRepeaterStreams: " + exception.toString());
                        }
                        finally {
                            wMSReadWriteLock.writeLock().unlock();
                        }
                        for (String string2 : list) {
                            WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).info("RTPStream.lockRepeaterStreams: repeaterLock: " + string2);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockRepeaterStreams() {
        List<String> list = this.repeaterStreams;
        synchronized (list) {
            IApplicationInstance iApplicationInstance;
            if (this.repeaterStreamsLocked && this.repeaterStreamItems.size() > 0 && (iApplicationInstance = this.getAppInstance()) != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                MediaCasterStreamMap mediaCasterStreamMap = iApplicationInstance.getMediaCasterStreams();
                WMSReadWriteLock wMSReadWriteLock = mediaCasterStreamMap.getLock();
                wMSReadWriteLock.writeLock().lock();
                try {
                    for (MediaCasterStreamItem object : this.repeaterStreamItems) {
                        if (object == null) continue;
                        object.release();
                        arrayList.add(object.getMediaCasterId());
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).error("RTPStream.unlockRepeaterStreams: " + exception.toString());
                }
                finally {
                    wMSReadWriteLock.writeLock().unlock();
                }
                for (String string : arrayList) {
                    WMSLoggerFactory.getLogger(HTTPStreamerSessionBase.class).info("RTPStream.unlockRepeaterStreams: repeaterUnLock: " + string);
                }
            }
        }
    }

    public String getMediaCasterType() {
        String string;
        block2: {
            IVHost iVHost;
            StreamItem streamItem;
            string = null;
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            if (iApplicationInstance == null) break block2;
            String string2 = this.getStreamType();
            if (string2 == null) {
                string2 = iApplicationInstance.getStreamType();
            }
            if ((streamItem = (iVHost = iApplicationInstance.getVHost()).getStreamTypes().getStreamDef(string2)) != null) {
                string = streamItem.getProperties().getPropertyStr("mediaCasterType", string);
                string = iApplicationInstance.getStreamProperties().getPropertyStr("mediaCasterType", string);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStream(RTPRequestStatus rTPRequestStatus) {
        boolean bl = false;
        this.streamLock.writeLock().lock();
        try {
            if (this.stream != null) {
            } else {
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                if (iApplicationInstance == null) {
                } else {
                    this.setAVSyncMethod(iApplicationInstance.getRTPAVSyncMethod());
                    this.setMaxRTCPWaitTime(iApplicationInstance.getRTPMaxRTCPWaitTime());
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    int n = mediaStreamMap.getNextStreamIndex();
                    String string = this.getStreamType();
                    if (string == null) {
                        string = iApplicationInstance.getStreamType();
                    }
                    if (!this.isModePublish()) {
                        string = "rtpout";
                    }
                    this.stream = mediaStreamMap.getStreamClientless(n, string);
                    if (this.stream == null) {
                    } else {
                        this.stream.setRTPStream(this);
                        ModuleFunctions moduleFunctions = iApplicationInstance.getModFunctions();
                        moduleFunctions.onStreamCreate(this.stream);
                        mediaStreamMap.notifyMediaStreamCreate(this.stream);
                        WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                        WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                        WMSLoggerFactory.getLogger(null).info(null, this.stream, "stream", "create", 200, "streamType:" + string + " streamIndex:" + n);
                        bl = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.createStream: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        this.unlockRepeaterStreams();
        this.streamLock.writeLock().lock();
        try {
            for (RTPTrack object : this.tracks.values()) {
                try {
                    object.shutdown(rTPRequestStatus);
                }
                catch (Exception mediaStreamMap) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.shutdown: " + mediaStreamMap.toString());
                }
            }
            this.tracks.clear();
            if (this.stream != null) {
                IApplicationInstance iApplicationInstance = this.getAppInstance();
                if (iApplicationInstance != null) {
                    WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                    WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                    WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                }
                if (this.stream.isPlay()) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "stop", 200, this.stream.getName());
                } else {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "unpublish", 200, this.stream.getName());
                }
                this.stream.close();
                if (!this.stream.isPlay()) {
                    this.stream.publish();
                    this.stream.stopPublishing();
                } else if (iApplicationInstance != null) {
                    iApplicationInstance.removePlayStreamByName(this.stream);
                }
                if (this.stream.isPlay()) {
                    if (this.stream.isSendPlayStopLogEvent()) {
                        this.stream.setSendPlayStopLogEvent(false);
                        this.stream.notifyActionStop();
                    }
                } else {
                    this.stream.notifyActionUnPublish(this.stream.getName(), this.stream.isRecord(), this.stream.isAppend());
                }
                if (iApplicationInstance != null) {
                    MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                    mediaStreamMap.removeStream(this.stream.getSrc());
                }
            }
            this.stream = null;
            if (this.udpTransport != null) {
                this.udpTransport.unbindAll();
            }
            this.udpTransport = null;
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.shutdown: " + exception.toString());
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IApplicationInstance getAppInstance() {
        Object object;
        IApplication iApplication = null;
        IApplicationInstance iApplicationInstance = null;
        if (this.appName != null && this.appInstanceName != null) {
            object = this.getVHost();
            WMSReadWriteLock wMSReadWriteLock = object.getApplicationLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                iApplication = object.getApplication(this.appName);
                if (iApplication != null) {
                    iApplicationInstance = iApplication.getAppInstance(this.appInstanceName);
                } else {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("Application folder ([install-location]/applications/" + this.appName + ") is missing");
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPStream.class).error("RTPStream.getAppInstance: " + exception.toString());
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
        }
        if (iApplicationInstance != null && !this.appInstancePropsInited) {
            this.streamLock.writeLock().lock();
            try {
                if (!this.appInstancePropsInited) {
                    object = iApplicationInstance.getRTPProperties();
                    this.streamReadyTimeout = ((WMSProperties)object).getPropertyInt("streamReadyTimeout", this.streamReadyTimeout);
                    this.rtpMetadataProviderPath = ((WMSProperties)object).getPropertyStr("rtpMetadataProvider", this.rtpMetadataProviderPath);
                    this.isForceMPEGTSOut = ((WMSProperties)object).getPropertyBoolean("forceMPEGTSOut", this.isForceMPEGTSOut);
                    this.isForceRTSPInterleaved = ((WMSProperties)object).getPropertyBoolean("forceRTSPInterleaved", this.isForceRTSPInterleaved);
                    this.rtspBindIpAddress = ((WMSProperties)object).getPropertyStr("rtspBindIpAddress", this.rtspBindIpAddress);
                    this.rtspSessionName = ((WMSProperties)object).getPropertyStr("rtspSessionName", this.rtspSessionName);
                    this.sendSDESEvents = ((WMSProperties)object).getPropertyBoolean("sendSDESEvents", this.sendSDESEvents);
                    this.appInstancePropsInited = true;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
                exception.printStackTrace();
            }
            finally {
                this.streamLock.writeLock().unlock();
            }
        }
        return iApplicationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStream(RTPRequestStatus rTPRequestStatus, int n) {
        if (this.stream == null) {
            return;
        }
        this.streamLock.writeLock().lock();
        try {
            if (this.mode == 0) {
                this.mode = n;
            }
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
            RTPSession rTPSession = this.getSession();
            boolean bl = false;
            boolean bl2 = this.stream.isAppend();
            String string = null;
            IMediaStream iMediaStream = this.stream;
            synchronized (iMediaStream) {
                if (this.isModePublish()) {
                    this.stream.setOpen(true);
                    this.stream.setRecord(bl);
                    this.stream.setAppend(bl2);
                    this.stream.setName(this.streamName);
                    this.stream.setExt(this.streamExt);
                    this.stream.setQueryStr(this.streamQueryStr);
                    mediaStreamMap.notifyPlayPublish(this.stream);
                    this.stream.startPublishing();
                } else {
                    this.stream.setOpen(true);
                    this.stream.setPlay(true);
                    this.stream.setName(this.streamName, string, this.streamExt, this.streamQueryStr, 0.0, -1.0, 1);
                    this.stream.setIsPlaying(true);
                    IMediaStreamPlay object = this.stream.getPlayer();
                    if (object != null) {
                        object.reset(true);
                        object.interruptPlay();
                        object.startPlay();
                    }
                }
                WMSLoggerFactory.putGlobalLogValue("x-vhost", iApplicationInstance.getVHost().getName());
                WMSLoggerFactory.putGlobalLogValue("x-app", iApplicationInstance.getApplication().getName());
                WMSLoggerFactory.putGlobalLogValue("x-appinst", iApplicationInstance.getName());
                if (this.isModePublish()) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "publish", 200, this.streamName);
                    if (bl) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "record", 200, this.streamName);
                    }
                    this.stream.notifyActionPublish(this.streamName, bl, bl2);
                } else {
                    WMSLoggerFactory.getLogger(ModuleCore.class).info(null, this.stream, "stream", "play", 200, this.streamName);
                    if (rTPSession != null) {
                        iApplicationInstance.registerPlayRTPSession(rTPSession);
                    }
                    this.stream.notifyActionPlay(this.streamName, 0.0, -1.0, 1);
                }
            }
            if (this.tracks.size() <= 1) {
                this.setAVSyncMethod(2);
            }
            for (RTPTrack rTPTrack : this.tracks.values()) {
                rTPTrack.record(rTPRequestStatus);
                if (rTPRequestStatus.isGood()) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    public void record(RTPRequestStatus rTPRequestStatus) {
        this.startStream(rTPRequestStatus, 2);
    }

    public void play(RTPRequestStatus rTPRequestStatus) {
        this.startStream(rTPRequestStatus, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        this.streamLock.writeLock().lock();
        try {
            for (RTPTrack rTPTrack : this.tracks.values()) {
                rTPTrack.attachToWMSSession(rtmpSessionInfo);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFromWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        this.streamLock.writeLock().lock();
        try {
            for (RTPTrack rTPTrack : this.tracks.values()) {
                rTPTrack.detachFromWMSSession(rtmpSessionInfo);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(RTPRequestStatus rTPRequestStatus) {
        this.streamLock.writeLock().lock();
        try {
            boolean bl = true;
            for (RTPTrack rTPTrack : this.tracks.values()) {
                rTPTrack.pause(rTPRequestStatus);
                if (rTPRequestStatus.isGood()) continue;
                break;
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.doRecord: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    public void announce(RTPRequestStatus rTPRequestStatus) {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.announce(rTPRequestStatus);
            if (rTPRequestStatus.isGood()) continue;
            break;
        }
    }

    public void touch() {
    }

    public boolean isResyncAudioVideoOnSR() {
        return this.resyncAudioVideoOnSR;
    }

    public void setResyncAudioVideoOnSR(boolean bl) {
        this.resyncAudioVideoOnSR = bl;
    }

    public byte[] getMetadataPacket() {
        byte[] byArray = null;
        try {
            AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
            AMFDataArray aMFDataArray = new AMFDataArray();
            for (RTPTrack object32 : this.tracks.values()) {
                Iterator<String> iterator = new AMFDataObj();
                ((AMFDataObj)((Object)iterator)).put("timescale", new AMFDataItem(object32.getTimescale()));
                ((AMFDataObj)((Object)iterator)).put("language", new AMFDataItem("eng"));
                AMFDataArray aMFDataArray2 = new AMFDataArray();
                AMFDataObj aMFDataObj = new AMFDataObj();
                aMFDataObj.put("sampletype", new AMFDataItem(object32.getSampleType()));
                aMFDataArray2.add(aMFDataObj);
                ((AMFDataObj)((Object)iterator)).put("sampledescription", aMFDataArray2);
                if (object32.isAudio()) {
                    aMFDataMixedArray.put("audiochannels", new AMFDataItem(object32.getChannelCount()));
                    aMFDataMixedArray.put("audiosamplerate", new AMFDataItem(object32.getTimescale()));
                    aMFDataMixedArray.put("audiocodecid", new AMFDataItem("mp4a"));
                }
                if (object32.isVideo()) {
                    aMFDataMixedArray.put("width", new AMFDataItem(object32.getWidth()));
                    aMFDataMixedArray.put("height", new AMFDataItem(object32.getHeight()));
                    aMFDataMixedArray.put("videocodecid", new AMFDataItem("avc1"));
                }
                aMFDataArray.add((AMFData)((Object)iterator));
            }
            aMFDataMixedArray.put("trackinfo", aMFDataArray);
            AMFDataObj aMFDataObj = new AMFDataObj();
            for (String string : this.streamInfo.keySet()) {
                String string2 = this.streamInfo.get(string);
                if (string2 == null) continue;
                aMFDataObj.put(string, new AMFDataItem(string2));
            }
            AMFDataObj aMFDataObj2 = new AMFDataObj();
            for (String string : this.streamAttributes.keySet()) {
                String string3 = this.streamAttributes.get(string);
                if (string3 == null) continue;
                aMFDataObj2.put(string, new AMFDataItem(string3));
            }
            aMFDataObj.put(STREAMINFO_SESSIONATTRIBUTES, aMFDataObj2);
            aMFDataMixedArray.put("rtpsessioninfo", aMFDataObj);
            AMFDataList aMFDataList = new AMFDataList();
            aMFDataList.add(new AMFDataItem("onMetaData"));
            aMFDataList.add(aMFDataMixedArray);
            byArray = aMFDataList.serialize();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.getMetadataPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return byArray;
    }

    private IRTPMetadataProvider getMetadataProvider() {
        IRTPMetadataProvider iRTPMetadataProvider = null;
        IApplicationInstance iApplicationInstance = this.getAppInstance();
        if (iApplicationInstance != null && this.rtpMetadataProviderPath != null) {
            try {
                Class<?> clazz = Class.forName(this.rtpMetadataProviderPath);
                if (clazz != null) {
                    iRTPMetadataProvider = (IRTPMetadataProvider)clazz.newInstance();
                    if (iRTPMetadataProvider == null) {
                        WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.getMetadataProvider: RTP Metadata provider could not be instantiated: " + this.rtpMetadataProviderPath);
                    }
                } else {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPDePacketizerBase.getMetadataProvider: RTP Metadata provider could not be found: " + this.rtpMetadataProviderPath);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTPStream.class).error("RTPDePacketizerBase.getMetadataProvider: " + exception.toString());
            }
        }
        return iRTPMetadataProvider;
    }

    private void sendMetadata(long l) {
        try {
            IRTPMetadataProvider iRTPMetadataProvider = this.getMetadataProvider();
            byte[] byArray = null;
            byArray = iRTPMetadataProvider != null ? iRTPMetadataProvider.getMetadataPacket(this) : this.getMetadataPacket();
            if (byArray != null) {
                this.stream.setDataType(18);
                this.stream.setDataTC(l, true);
                this.stream.setDataSize(byArray.length);
                this.stream.startDataPacket();
                this.stream.addDataData(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPStream.sendMetadata: " + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSendMetadata(long l) {
        Object var3_2 = null;
        this.streamLock.readLock().lock();
        try {
            if (!this.sentMetadata) {
                this.sendMetadata(l);
                this.sentMetadata = true;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
    }

    public void extractCodecConfigFromTrackInfo() {
        for (RTPTrack rTPTrack : this.tracks.values()) {
            rTPTrack.extractCodecConfigFromTrackInfo();
        }
    }

    public String getStreamType() {
        return this.streamType;
    }

    public void setStreamType(String string) {
        this.streamType = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppInstanceName() {
        return this.appInstanceName;
    }

    public void setAppInstanceName(String string) {
        this.appInstanceName = string;
    }

    public String getStreamExt() {
        return this.streamExt;
    }

    public void setStreamExt(String string) {
        this.streamExt = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getStreamNameLogging() {
        return this.streamNameLogging;
    }

    public void setStreamNameLogging(String string) {
        this.streamNameLogging = string;
    }

    public long getStreamSessionId() {
        return this.streamSessionId;
    }

    public void setStreamSessionId(long l) {
        this.streamSessionId = l;
    }

    public long getStreamSessionVersion() {
        return this.streamSessionVersion;
    }

    public void setStreamSessionVersion(long l) {
        this.streamSessionVersion = l;
    }

    public String getStreamSessionIp() {
        return this.streamSessionIp;
    }

    public void setStreamSessionIp(String string) {
        this.streamSessionIp = string;
    }

    public boolean isCheckSSRC() {
        return this.checkSSRC;
    }

    public void setCheckSSRC(boolean bl) {
        this.checkSSRC = bl;
    }

    public boolean isCheckIpAddr() {
        return this.checkIpAddr;
    }

    public void setCheckIpAddr(boolean bl) {
        this.checkIpAddr = bl;
    }

    public IUDPTransport getUDPTransport(boolean bl) {
        if (this.udpTransport == null) {
            String string = null;
            IMediaStream iMediaStream = this.getStream();
            if (iMediaStream != null) {
                string = iMediaStream.getProperties().getPropertyStr(bl ? "multicastTransportBaseClass" : "udpTransportBaseClass", string);
            }
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    if (clazz != null) {
                        this.udpTransport = (IUDPTransport)clazz.newInstance();
                    }
                }
                catch (Exception exception) {
                    WMSLoggerFactory.getLogger(RTPStream.class).error("RTPStream.getUDPTransport: Transport base class could not be instantiated[" + string + "]: " + exception.toString());
                }
                if (this.udpTransport == null) {
                    WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.getUDPTransport: Transport base class could not be instantiated: " + string);
                }
            }
            if (this.udpTransport == null) {
                this.udpTransport = bl ? new RTPMulticastTransport() : new RTPUDPTransportMina();
            }
        }
        return this.udpTransport;
    }

    public int getAVSyncMethod() {
        return this.avSyncMethod;
    }

    public void setAVSyncMethod(int n) {
        this.avSyncMethod = n;
    }

    public boolean isAVSyncNonSR() {
        return this.avSyncMethod == 2 || this.avSyncMethod == 3;
    }

    public int getMaxRTCPWaitTime() {
        return this.maxRTCPWaitTime;
    }

    public void setMaxRTCPWaitTime(int n) {
        this.maxRTCPWaitTime = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getStreamInfo() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.streamLock.readLock().lock();
        try {
            hashMap.putAll(this.streamInfo);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getStreamAttributes() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.streamLock.readLock().lock();
        try {
            hashMap.putAll(this.streamAttributes);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return hashMap;
    }

    public static int avSyncNameToId(String string) {
        int n = 0;
        if (string.toLowerCase().startsWith("senderreport")) {
            n = 1;
        } else if (string.toLowerCase().startsWith("systemclock")) {
            n = 2;
        } else if (string.toLowerCase().startsWith("rtptimecode")) {
            n = 3;
        }
        return n;
    }

    public int getMPEGTSVideoPID() {
        return this.mpegtsVideoPID;
    }

    public void setMPEGTSVideoPID(int n) {
        this.mpegtsVideoPID = n;
    }

    public int getMPEGTSAudioPID() {
        return this.mpegtsAudioPID;
    }

    public void setMPEGTSAudioPID(int n) {
        this.mpegtsAudioPID = n;
    }

    public boolean isRTSP() {
        return this.isRTSP;
    }

    public void setRTSP(boolean bl) {
        this.isRTSP = bl;
    }

    public String getStreamQueryStr() {
        return this.streamQueryStr;
    }

    public void setStreamQueryStr(String string) {
        this.streamQueryStr = string;
    }

    public boolean isModePublish() {
        return this.mode == 2;
    }

    public boolean isModePlay() {
        return this.mode == 1;
    }

    public boolean isModeUknown() {
        return this.mode == 0;
    }

    public String getOutHost() {
        return this.outHost;
    }

    public void setOutHost(String string) {
        this.outHost = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle(RtmpResponseMessage rtmpResponseMessage) {
        this.streamLock.writeLock().lock();
        try {
            if (this.isModePublish()) {
            } else {
                IMediaStream iMediaStream = this.getStream();
                if (iMediaStream == null) {
                } else if (!iMediaStream.isPlaying()) {
                } else {
                    IMediaStreamPlay iMediaStreamPlay = iMediaStream.getPlayer();
                    if (iMediaStreamPlay == null) {
                    } else {
                        long[] lArray = new long[8];
                        int n = iMediaStreamPlay.play(rtmpResponseMessage == null ? null : rtmpResponseMessage.getOutputStream(), null, null, null, lArray);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPStream.class).warn("RTPStream.idle: " + exception.toString());
            exception.printStackTrace();
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    public AMFPacket[] getLastPacketsByType(IMediaStream iMediaStream) {
        AMFPacket[] aMFPacketArray = new AMFPacket[2];
        int n = iMediaStream.getPublishAudioCodecId();
        int n2 = iMediaStream.getPublishVideoCodecId();
        AMFPacket aMFPacket = null;
        AMFPacket aMFPacket2 = null;
        List<AMFPacket> list = iMediaStream.getPlayPackets();
        if (list != null && list.size() > 0) {
            AMFPacket aMFPacket3 = null;
            for (int i = list.size() - 1; i >= 0; --i) {
                int n3;
                aMFPacket3 = list.get(i);
                int n4 = aMFPacket3.getType();
                if (n4 == 8) {
                    if (aMFPacket == null && aMFPacket3.getSize() >= 2) {
                        n3 = aMFPacket3.getSecondByte();
                        if (n != 10 || n3 == 1) {
                            aMFPacket = aMFPacket3;
                        }
                    }
                } else if (n4 == 9 && aMFPacket2 == null && aMFPacket3.getSize() >= 2) {
                    n3 = aMFPacket3.getSecondByte();
                    if (n2 != 7 || n3 == 1) {
                        aMFPacket2 = aMFPacket3;
                    }
                }
                if (aMFPacket2 != null && aMFPacket != null) break;
            }
        }
        aMFPacketArray[0] = aMFPacket;
        aMFPacketArray[1] = aMFPacket2;
        return aMFPacketArray;
    }

    public String describe(RTPSession rTPSession, RTPRequestStatus rTPRequestStatus) {
        return this.describe(rTPSession, 0, rTPRequestStatus);
    }

    private String getSessionName(IApplicationInstance iApplicationInstance) {
        String string = this.rtspSessionName;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.wowza.wms.context.VHost", iApplicationInstance.getVHost().getName());
        hashMap.put("com.wowza.wms.context.VHostConfigHome", iApplicationInstance.getVHost().getHomePath());
        hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
        hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
        hashMap.put("com.wowza.wms.context.StreamName", this.getStreamName());
        string = SystemUtils.expandEnvironmentVariables(string, hashMap);
        return string;
    }

    public void switchSetupToMPEGTS() {
        block5: {
            IApplicationInstance iApplicationInstance = this.getAppInstance();
            if (iApplicationInstance == null) break block5;
            RTPContext rTPContext = iApplicationInstance.getVHost().getRTPContext();
            int n = -1;
            IRTPPacketizer iRTPPacketizer = null;
            if (this.isMPEGTSOut) {
                this.clearTracks();
                int n2 = 0;
                RTPPacketizerItem rTPPacketizerItem = rTPContext.getStreamPacketizerItem(iApplicationInstance, n2);
                if (rTPPacketizerItem == null) {
                    WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No stream packetizer: " + n2);
                } else {
                    iRTPPacketizer = rTPPacketizerItem.getInstance();
                    if (iRTPPacketizer == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create stream packetizer: " + n2);
                    } else {
                        String string = "mpegts-transport";
                        RTPTrack rTPTrack = new RTPTrack("mpegts-transport");
                        this.addTrack(rTPTrack);
                        rTPTrack.setTrackType(0);
                        RTPDescribeInfo rTPDescribeInfo = iRTPPacketizer.getDescribeInfo(rTPTrack, this.stream, null, 0, n);
                        n = rTPDescribeInfo.getTimescale();
                        rTPTrack.setRTPPacketizer(iRTPPacketizer);
                        rTPTrack.setTimescale(n);
                    }
                }
            }
        }
    }

    public String describe(RTPSession rTPSession, int n, RTPRequestStatus rTPRequestStatus) {
        StringBuffer stringBuffer = new StringBuffer();
        IApplicationInstance iApplicationInstance = this.getAppInstance();
        if (iApplicationInstance == null) {
            RTSPStatics.setStatus(rTPRequestStatus, 403);
        } else {
            RTPContext rTPContext = iApplicationInstance.getVHost().getRTPContext();
            this.isMPEGTSOut = n > 0 ? true : (n < 0 ? false : this.isForceMPEGTSOut);
            String string = "RTP/AVP";
            IMediaStream iMediaStream = iApplicationInstance.getStreams().getStream(this.getStreamName());
            if (iMediaStream == null) {
                RTSPStatics.setStatus(rTPRequestStatus, 404);
            } else {
                RTPDescribeInfo rTPDescribeInfo;
                Object object;
                Object object2;
                Object object3;
                RTPPacketizerItem rTPPacketizerItem;
                int n2;
                String string2 = rTPSession.getSessionId();
                String string3 = this.getSessionName(iApplicationInstance);
                stringBuffer.append("v=0\r\n");
                stringBuffer.append("o=- " + string2 + " " + string2 + " IN IP4 127.0.0.0" + "\r\n");
                stringBuffer.append("s=" + string3 + "\r\n");
                stringBuffer.append("c=IN IP4 0.0.0.0\r\n");
                stringBuffer.append("t=0 0\r\n");
                stringBuffer.append("a=range:npt=now-\r\n");
                stringBuffer.append("a=control:*\r\n");
                int n3 = iMediaStream.getPublishAudioCodecId();
                int n4 = iMediaStream.getPublishVideoCodecId();
                AMFPacket[] aMFPacketArray = this.getLastPacketsByType(iMediaStream);
                AMFPacket aMFPacket = aMFPacketArray[0];
                AMFPacket aMFPacket2 = aMFPacketArray[1];
                int n5 = -1;
                IRTPPacketizer iRTPPacketizer = null;
                if (this.isMPEGTSOut) {
                    n2 = 0;
                    rTPPacketizerItem = rTPContext.getStreamPacketizerItem(iApplicationInstance, n2);
                    if (rTPPacketizerItem == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No stream packetizer: " + n2);
                    } else {
                        iRTPPacketizer = rTPPacketizerItem.getInstance();
                        if (iRTPPacketizer == null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create stream packetizer: " + n2);
                        } else {
                            object3 = "mpegts-transport";
                            object2 = new RTPTrack("mpegts-transport");
                            this.addTrack((RTPTrack)object2);
                            ((RTPTrack)object2).setTrackType(0);
                            object = iRTPPacketizer.getDescribeInfo((RTPTrack)object2, iMediaStream, null, 0, n5);
                            n5 = ((RTPDescribeInfo)object).getTimescale();
                            ((RTPTrack)object2).setRTPPacketizer(iRTPPacketizer);
                            ((RTPTrack)object2).setTimescale(n5);
                            stringBuffer.append("m=video 0 " + string + " " + ((RTPDescribeInfo)object).getSDPTypeId() + "\r\n");
                            stringBuffer.append(((RTPDescribeInfo)object).getSDPStr());
                            stringBuffer.append("a=control:" + (String)object3 + "\r\n");
                        }
                    }
                }
                n2 = 1;
                if (!this.isMPEGTSOut && n3 != -1) {
                    rTPPacketizerItem = rTPContext.getAudioPacketizerItem(iApplicationInstance, n3);
                    if (rTPPacketizerItem == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No audio packetizer: " + n3);
                    } else {
                        object3 = rTPPacketizerItem.getInstance();
                        if (object3 == null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create audio packetizer: " + n3);
                        } else {
                            object2 = "trackID=" + n2;
                            ++n2;
                            object = new RTPTrack((String)object2);
                            this.addTrack((RTPTrack)object);
                            ((RTPTrack)object).setTrackType(8);
                            rTPDescribeInfo = object3.getDescribeInfo((RTPTrack)object, iMediaStream, aMFPacket, 0, n5);
                            ((RTPTrack)object).setRTPPacketizer((IRTPPacketizer)(iRTPPacketizer != null ? iRTPPacketizer : object3));
                            ((RTPTrack)object).setTimescale(rTPDescribeInfo.getTimescale());
                            ((RTPTrack)object).setChannelCount(rTPDescribeInfo.getChannels());
                            if (iRTPPacketizer == null) {
                                stringBuffer.append("m=audio 0 " + string + " " + rTPDescribeInfo.getSDPTypeId() + "\r\n");
                                stringBuffer.append(rTPDescribeInfo.getSDPStr());
                                stringBuffer.append("a=control:" + (String)object2 + "\r\n");
                            }
                        }
                    }
                }
                if (!this.isMPEGTSOut && n4 != -1) {
                    rTPPacketizerItem = rTPContext.getVideoPacketizerItem(iApplicationInstance, n4);
                    if (rTPPacketizerItem == null) {
                        WMSLoggerFactory.getLogger(ModuleCore.class).warn("RTPPlayer.describe: No video packetizer: " + n4);
                    } else {
                        object3 = rTPPacketizerItem.getInstance();
                        if (object3 == null) {
                            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.describe: Cannot create video packetizer: " + n4);
                        } else {
                            object2 = "trackID=" + n2;
                            ++n2;
                            object = new RTPTrack((String)object2);
                            this.addTrack((RTPTrack)object);
                            ((RTPTrack)object).setTrackType(9);
                            rTPDescribeInfo = object3.getDescribeInfo((RTPTrack)object, iMediaStream, aMFPacket2, 0, n5);
                            ((RTPTrack)object).setRTPPacketizer((IRTPPacketizer)(iRTPPacketizer != null ? iRTPPacketizer : object3));
                            ((RTPTrack)object).setTimescale(rTPDescribeInfo.getTimescale());
                            if (iRTPPacketizer == null) {
                                stringBuffer.append("m=video 0 " + string + " " + rTPDescribeInfo.getSDPTypeId() + "\r\n");
                                stringBuffer.append(rTPDescribeInfo.getSDPStr());
                                stringBuffer.append("a=control:" + (String)object2 + "\r\n");
                            }
                        }
                    }
                }
            }
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public String getTransportMode() {
        return this.transportMode;
    }

    public void setTransportMode(String string) {
        this.transportMode = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNormalizedNTPTimecode(long l) {
        long l2 = l;
        this.streamLock.writeLock().lock();
        try {
            if (this.ntpRTOffset == -1L) {
                this.ntpRTOffset = l;
            }
            l2 = this.createTime + (l - this.ntpRTOffset);
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
        return SystemUtils.toNTPTime(l2);
    }

    public boolean isForceRTSPInterleaved() {
        return this.isForceRTSPInterleaved;
    }

    public void setForceRTSPInterleaved(boolean bl) {
        this.isForceRTSPInterleaved = bl;
    }

    public String getRTPInfo() {
        String string = null;
        long l = -1L;
        try {
            IMediaStream iMediaStream;
            IApplicationInstance iApplicationInstance;
            RTPTrack rTPTrack = this.getStreamTrack();
            if (rTPTrack == null && (iApplicationInstance = this.getAppInstance()) != null && (iMediaStream = iApplicationInstance.getStreams().getStream(this.getStreamName())) != null) {
                AMFPacket[] aMFPacketArray = this.getLastPacketsByType(iMediaStream);
                AMFPacket aMFPacket = aMFPacketArray[0];
                AMFPacket aMFPacket2 = aMFPacketArray[1];
                if (aMFPacket != null || aMFPacket2 != null) {
                    if (aMFPacket2 != null) {
                        l = aMFPacket2.getAbsTimecode();
                    }
                    if (aMFPacket != null) {
                        l = aMFPacket.getAbsTimecode();
                    }
                    if (l >= 0L) {
                        Object object;
                        IMediaStream iMediaStream2 = this.getStream();
                        if (iMediaStream2 != null && aMFPacket != null && (object = iMediaStream2.getPlayer()) != null && object instanceof MediaStreamRTPPlay) {
                            ((MediaStreamRTPPlay)((Object)object)).setRTPTargetPacketSeq(aMFPacket.getSeq());
                        }
                        for (String string2 : this.tracks.keySet()) {
                            RTPTrack rTPTrack2 = this.tracks.get(string2);
                            if (rTPTrack2 == null) continue;
                            long l2 = rTPTrack2.getTimescale();
                            long l3 = l * l2 / 1000L;
                            string = string == null ? "" : string + ",";
                            string = string + "url=" + string2 + ";seq=1;rtptime=" + (l3 %= 0x100000000L);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(ModuleCore.class).error("RTPPlayer.getRTPInfo: " + exception.toString());
        }
        return string;
    }

    public String getRTSPBindIpAddress() {
        return this.rtspBindIpAddress;
    }

    public void setRTSPBindIpAddress(String string) {
        this.rtspBindIpAddress = string;
    }

    public String getRTSPSessionName() {
        return this.rtspSessionName;
    }

    public void setRTSPSessionName(String string) {
        this.rtspSessionName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSendSDESEvents() {
        boolean bl = false;
        this.streamLock.readLock().lock();
        try {
            bl = this.sendSDESEvents;
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSendSDESEvents(boolean bl) {
        this.streamLock.writeLock().lock();
        try {
            this.sendSDESEvents = bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMPEGTSOut() {
        boolean bl = false;
        this.streamLock.readLock().lock();
        try {
            bl = this.isMPEGTSOut;
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMPEGTSOut(boolean bl) {
        this.streamLock.writeLock().lock();
        try {
            this.isMPEGTSOut = bl;
        }
        catch (Exception exception) {
        }
        finally {
            this.streamLock.writeLock().unlock();
        }
    }

    public String transportFindBestMatch(String string) {
        String string2 = string;
        if (string.indexOf(",") >= 0) {
            try {
                int n;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                ArrayList<String> arrayList = new ArrayList<String>();
                String[] stringArray = string.split("[,]");
                for (n = 0; n < stringArray.length; ++n) {
                    String string3 = stringArray[n].trim();
                    if (string3.length() <= 0) continue;
                    arrayList.add(string3);
                    try {
                        Object object = string3.split("[;]");
                        if (((String[])object).length < 2) continue;
                        hashMap.put(object[0] + ";" + object[1], string3);
                        continue;
                    }
                    catch (Exception exception) {
                        WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.transportFindBestMatch[1]: " + string + ": " + exception.toString());
                    }
                }
                n = this.isMPEGTSOut() ? 1 : 0;
                string2 = null;
                if (n != 0) {
                    string2 = (String)hashMap.get("MP2T/AVP/TCP;unicast");
                    if (string2 == null && (string2 = (String)hashMap.get("MP2T/AVP/UDP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/H2221/TCP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/H2221/UDP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/TCP;unicast")) == null && (string2 = (String)hashMap.get("MP2T/UDP;unicast")) == null) {
                        for (Object object : hashMap.keySet()) {
                            if (!((String)object).startsWith("MP2T") || ((String)object).indexOf("unicast") < 0) continue;
                            string2 = (String)hashMap.get(object);
                            break;
                        }
                    }
                } else {
                    string2 = (String)hashMap.get("RTP/AVP/TCP;unicast");
                    if (string2 == null && (string2 = (String)hashMap.get("RTP/AVP/UDP;unicast")) == null && (string2 = (String)hashMap.get("RTP/TCP;unicast")) == null && (string2 = (String)hashMap.get("RTP/UDP;unicast")) == null) {
                        for (Object object : hashMap.keySet()) {
                            if (!((String)object).startsWith("RTP") || ((String)object).indexOf("unicast") < 0) continue;
                            string2 = (String)hashMap.get(object);
                            break;
                        }
                    }
                }
                if (string2 == null) {
                    string2 = arrayList.size() > 0 ? (String)arrayList.get(0) : string;
                }
                WMSLoggerFactory.getLogger(RTSPCore.class).debug("RTSPBestMatch: " + string2);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.transportFindBestMatch[2]: " + string + ": " + exception.toString());
            }
        }
        return string2;
    }
}

