/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.NetworkUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.rtp.depacketizer.IRTPDePacketizer;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerFactory;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerItem;
import com.wowza.wms.rtp.depacketizer.RTPDePacketizerList;
import com.wowza.wms.rtp.model.IRTPMessageHandler;
import com.wowza.wms.rtp.model.RTPContext;
import com.wowza.wms.rtp.model.RTPPort;
import com.wowza.wms.rtp.model.RTPRequestStatus;
import com.wowza.wms.rtp.model.RTPSSRCGeneratorSingleton;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtsp.RTSPCore;
import com.wowza.wms.rtsp.RTSPStatics;
import com.wowza.wms.server.RtmpSessionInfo;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.util.RTPUtils;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RTPTrack {
    public static final String STREAMINFO_SAMPLETYPE = "sample-type";
    public static final String STREAMINFO_TIMESCALE = "timescale";
    public static final String STREAMINFO_CHANNELCOUNT = "channel-count";
    public static final String STREAMINFO_PARAMETERSETS = "sprop-parameter-sets";
    public static final String STREAMINFO_CLIPRECT = "cliprect";
    public static final String STREAMINFO_CONFIG = "config";
    public static final String STREAMINFO_PROFILELEVELID = "profile-level-id";
    public static final String STREAMINFO_SESSIONCONNECTIONDATA = "connectiondata";
    public static final String STREAMINFO_AUXILIARYDATASIZELENGTH = "auxiliarydatasizelength";
    public static final String STREAMINFO_CONSTANTSIZE = "constantsize";
    public static final String STREAMINFO_CONSTANTDURATION = "constantduration";
    public static final String STREAMINFO_MAXDISPLACEMENT = "maxdisplacement";
    public static final String STREAMINFO_DEINTERLEAVEBUFFERSIZE = "de-interleavebuffersize";
    public static final String STREAMINFO_SIZELENGTH = "sizelength";
    public static final String STREAMINFO_INDEXLENGTH = "indexlength";
    public static final String STREAMINFO_INDEXDELTALENGTH = "indexdeltalength";
    public static final String STREAMINFO_CTSDELTALENGTH = "ctsdeltalength";
    public static final String STREAMINFO_DTSDELTALENGTH = "dtsdeltalength";
    public static final String STREAMINFO_RANDOMACCESSINDICATION = "randomaccessindication";
    public static final String STREAMINFO_STREAMSTATEINDICATION = "streamstateindication";
    public static final int SAMPLES_PERFRAME = 1024;
    public static final int RTPMAPTYPE_MP3 = 14;
    public static final int RTPMAPTYPE_H264 = 96;
    public static final int RTPMAPTYPE_AAC = 97;
    private String trackId = "unknown";
    private RTPStream rtpStream = null;
    private Map<String, String> trackInfo = new HashMap<String, String>();
    private int trackType = 0;
    private int width = 0;
    private int height = 0;
    private HandleRTPMessage rtpMessageHandler = new HandleRTPMessage(this);
    private HandleRTCPMessage rtcpMessageHandler = new HandleRTCPMessage(this);
    private IRTPDePacketizer rtpDePacketizer = null;
    private String rtpDePacketizerName = null;
    private int timescale = 0;
    private int channelCount = 0;
    private String sampleType = "";
    private String announceData = "";
    private boolean isInterleaved = false;
    private byte[] codecConfig = null;
    private byte[] sps = null;
    private List<byte[]> ppss = null;
    private int samplesPerFrame = 1024;
    private boolean waitForFirstEnd = true;
    private String host = null;
    private String outHost = null;
    private long ssrc = 0L;
    private int maxPacketSize = 1438;
    private int rtpMapType = -1;
    private int bitrate = -1;
    private boolean reportRTPTransportError = true;
    private boolean reportRTCPTransportError = true;
    private RTPPort rtpInPort = null;
    private RTPPort rtcpInPort = null;
    private int rtpOutPortNum = -1;
    private int rtcpOutPortNum = -1;
    private int rtpInPortNum = -1;
    private int rtcpInPortNum = -1;
    private int rtpTTL = 63;
    private int rtcpTTL = 63;
    private int rtpAddressCount = 1;
    private int rtcpAddressCount = 1;
    private boolean isRTCP = true;
    private boolean isRTPWrapped = true;
    private InetSocketAddress rtpOutAddress = null;
    private InetSocketAddress rtcpOutAddress = null;
    private IRTPPacketizer rtpPacketizer = null;

    public RTPTrack(String string) {
        this.trackId = string;
        this.ssrc = RTPSSRCGeneratorSingleton.getInstance().getNextSSRC();
    }

    public String getTrackId() {
        return this.trackId;
    }

    public void setTrackId(String string) {
        this.trackId = string;
    }

    public RTPStream getStream() {
        return this.rtpStream;
    }

    public void setStream(RTPStream rTPStream) {
        this.rtpStream = rTPStream;
    }

    public String getOutHost() {
        return this.outHost == null ? this.rtpStream.getOutHost() : this.outHost;
    }

    public void setOutHost(String string) {
        this.outHost = string;
    }

    public String getHost() {
        return this.host == null ? this.rtpStream.getHost() : this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStreamTrack() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.trackType == 0;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAudio() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.trackType == 8;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVideo() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.trackType == 9;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackType() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.trackType;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackType(int n) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.trackType = n;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTrackInfoKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            arrayList.addAll(this.trackInfo.keySet());
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrackInfo(String string, String string2) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.trackInfo.put(string, string2);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTrackInfo(String string) {
        String string2 = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string2 = this.trackInfo.get(string);
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCodecConfig() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.codecConfig != null;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSPS() {
        byte[] byArray = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            byArray = this.sps;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getPPS() {
        List<byte[]> list = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            list = this.ppss;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCodecConfig() {
        byte[] byArray = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            byArray = this.codecConfig;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodecConfig(byte[] byArray) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            H264CodecConfigParts h264CodecConfigParts;
            this.codecConfig = byArray;
            this.ppss = null;
            this.sps = null;
            if (this.codecConfig != null && (h264CodecConfigParts = H264Utils.breakApartAVCC(this.codecConfig, 0, this.codecConfig.length)) != null) {
                this.ppss = h264CodecConfigParts.ppss;
                this.sps = h264CodecConfigParts.sps;
            }
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    public void extractCodecConfigFromTrackInfo() {
        block27: {
            String string;
            String string2;
            block28: {
                String[] stringArray;
                String[] stringArray2;
                String string3;
                byte[] byArray = null;
                byte[] byArray2 = null;
                ArrayList<byte[]> arrayList = null;
                if (this.isVideo()) {
                    if (byArray == null && (string3 = this.getTrackInfo(STREAMINFO_PARAMETERSETS)) != null) {
                        stringArray2 = string3.split("[,]");
                        int n = 0;
                        for (int i = 0; i < stringArray2.length; ++i) {
                            byte[] byArray3;
                            stringArray = stringArray2[i].trim();
                            if (stringArray.length() <= 0 || (byArray3 = Base64.decode(stringArray2[i].trim())) == null) continue;
                            int n2 = byArray3[0] & 0x1F;
                            if (n2 == 7) {
                                byArray2 = byArray3;
                                continue;
                            }
                            if (n2 != 8) continue;
                            if (arrayList == null) {
                                arrayList = new ArrayList<byte[]>();
                            }
                            arrayList.add(byArray3);
                            ++n;
                        }
                        if (byArray2 != null && n > 0) {
                            try {
                                byte[] byArray4 = null;
                                stringArray = this.getTrackInfo(STREAMINFO_PROFILELEVELID);
                                if (stringArray != null) {
                                    byArray4 = BufferUtils.decodeHexString((String)stringArray);
                                }
                                byArray = RTPUtils.formatH264CodecConfig(byArray2, (List<byte[]>)arrayList, byArray4);
                            }
                            catch (Exception exception) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): " + exception.toString());
                            }
                        } else {
                            if (byArray2 == null) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL SPS(7)");
                            }
                            if (arrayList == null) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL PPS(8)");
                            } else if (arrayList.size() == 0) {
                                WMSLoggerFactory.getLogger(RTPTrack.class).warn("RTPTrack.getCodecConfig(video): Missing NAL PPS(8)");
                            }
                        }
                    }
                } else if (this.isAudio() && (string3 = this.getTrackInfo(STREAMINFO_CONFIG)) != null) {
                    byArray = BufferUtils.decodeHexString(string3);
                }
                if (byArray != null) {
                    this.codecConfig = byArray;
                }
                if (this.isVideo()) {
                    this.sps = byArray2;
                    this.ppss = arrayList;
                }
                if ((string3 = this.getTrackInfo(STREAMINFO_SESSIONCONNECTIONDATA)) == null) {
                    string3 = this.getStream().getStreamInfo(STREAMINFO_SESSIONCONNECTIONDATA);
                }
                if (string3 == null || (stringArray2 = string3.split("[ ]")).length < 3) break block27;
                string2 = stringArray2[2];
                string = null;
                if (string2.indexOf("/") < 0) break block28;
                stringArray = string2.split("/");
                if (stringArray.length > 0) {
                    this.host = string = stringArray[0];
                }
                if (stringArray.length > 1) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(stringArray[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n >= 0) {
                        this.rtpTTL = n;
                        this.rtcpTTL = n;
                    }
                }
                if (stringArray.length <= 2) break block27;
                int n = -1;
                try {
                    n = Integer.parseInt(stringArray[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n >= 0) {
                    this.rtpAddressCount = n;
                    this.rtcpAddressCount = n;
                }
                break block27;
            }
            this.host = string = string2;
        }
    }

    public synchronized int getRTPOutPortNum() {
        return this.rtpOutPortNum;
    }

    public synchronized void setRTPOutPortNum(int n) {
        this.rtpOutPortNum = n;
    }

    public synchronized int getRTCPOutPortNum() {
        return this.rtcpOutPortNum;
    }

    public synchronized void setRTCPOutPortNum(int n) {
        this.rtcpOutPortNum = n;
    }

    public IVHost getVHost() {
        return this.rtpStream.getVHost();
    }

    public RTPContext getRTPContext() {
        return this.rtpStream.getVHost().getRTPContext();
    }

    public void bind() {
        IRTPPacketizer iRTPPacketizer = this.getRTPPacketizer();
        if (iRTPPacketizer != null) {
            iRTPPacketizer.setRTPWrapped(this.isRTPWrapped);
        }
        if (!this.isInterleaved) {
            int n;
            String string = this.getBindHost();
            String string2 = this.getRTPStream().getOutHost();
            boolean bl = false;
            bl = this.getRTPStream().isModePublish() ? NetworkUtils.isAddressMulticast(string) : NetworkUtils.isAddressMulticast(string2);
            if (!bl && this.rtpInPortNum < 0) {
                n = -1;
                RTPContext rTPContext = this.getRTPContext();
                this.rtpInPortNum = n = rTPContext.acquireUDPPortPair();
                this.rtcpInPortNum = n + 1;
            }
            int n2 = n = this.getRTPStream().isModePublish() ? 1 : 2;
            if (this.rtpInPort == null) {
                this.rtpInPort = new RTPPort(string, this.rtpInPortNum, string2, this.rtpOutPortNum, bl);
                this.rtpInPort.setTrack(this);
            }
            if (this.rtpInPort != null) {
                this.rtpInPort.setHandler(this.rtpMessageHandler);
                this.rtpInPort.setTTL(this.rtpTTL);
                this.rtpInPort.setAddressCount(this.rtpAddressCount);
                this.rtpInPort.bind(n);
            }
            if (this.isRTCP()) {
                if (this.rtcpInPort == null) {
                    this.rtcpInPort = new RTPPort(string, this.rtcpInPortNum, string2, this.rtcpOutPortNum, bl);
                    this.rtcpInPort.setTrack(this);
                }
                if (this.rtcpInPort != null) {
                    this.rtcpInPort.setHandler(this.rtcpMessageHandler);
                    this.rtcpInPort.setTTL(this.rtcpTTL);
                    this.rtcpInPort.setAddressCount(this.rtcpAddressCount);
                    this.rtcpInPort.bind(n);
                }
            }
        }
        this.reportRTPTransportError = true;
        this.reportRTCPTransportError = true;
    }

    public void unbind() {
        if (this.rtpInPort != null) {
            this.rtpInPort.shutdown();
        }
        this.rtpInPort = null;
        if (this.rtcpInPort != null) {
            this.rtcpInPort.shutdown();
        }
        this.rtcpInPort = null;
        if (this.rtpInPortNum > 0) {
            RTPContext rTPContext = this.getRTPContext();
            if (this.rtpInPortNum % 2 == 0 && this.rtpInPortNum + 1 == this.rtcpInPortNum) {
                rTPContext.releaseUDPPortPair(this.rtpInPortNum);
            } else {
                rTPContext.releaseUDPPortPair(this.rtpInPortNum);
                rTPContext.releaseUDPPortPair(this.rtcpInPortNum);
            }
        }
        this.rtpInPortNum = -1;
        this.rtcpInPortNum = -1;
    }

    public void shutdown(RTPRequestStatus rTPRequestStatus) {
        this.unbind();
        if (this.rtpDePacketizer != null) {
            this.rtpDePacketizer.shutdown(this);
        }
        this.rtpDePacketizer = null;
    }

    private String getBindHost() {
        String string = null;
        string = this.rtpStream.isRTSP() ? this.rtpStream.getRTSPBindIpAddress() : this.getHost();
        return string;
    }

    public void addPorts() {
        if (this.rtpInPortNum <= 0 && this.rtcpInPortNum <= 0) {
            int n = -1;
            RTPContext rTPContext = this.getRTPContext();
            this.rtpInPortNum = n = rTPContext.acquireUDPPortPair();
            this.rtcpInPortNum = n + 1;
        }
    }

    public void setRTPInPortNum(int n) {
        this.rtpInPortNum = n;
    }

    public void setRTCPInPortNum(int n) {
        this.rtcpInPortNum = n;
    }

    public int getRTPInPortNum() {
        return this.rtpInPortNum;
    }

    public int getRTCPInPortNum() {
        return this.rtcpInPortNum;
    }

    public RTPPort getRTPPort() {
        return this.rtpInPort;
    }

    public RTPPort getRTCPPort() {
        return this.rtcpInPort;
    }

    public void attachToWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        if (this.isInterleaved) {
            rtmpSessionInfo.addRTPInterleaveHandler(this.rtpOutPortNum, this.rtpMessageHandler);
            rtmpSessionInfo.addRTPInterleaveHandler(this.rtcpOutPortNum, this.rtcpMessageHandler);
        }
    }

    public void detachFromWMSSession(RtmpSessionInfo rtmpSessionInfo) {
        rtmpSessionInfo.clearRTPInterleaveHandler();
    }

    public void record(RTPRequestStatus rTPRequestStatus) {
        this.bind();
    }

    public void play(RTPRequestStatus rTPRequestStatus) {
        this.bind();
    }

    public void pause(RTPRequestStatus rTPRequestStatus) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimescale() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.timescale;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimescale(int n) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.timescale = n;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelCount() {
        int n = 0;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            n = this.channelCount;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelCount(int n) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.channelCount = n;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSampleType() {
        String string = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string = this.sampleType;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSampleType(String string) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.sampleType = string;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    public RTPStream getRTPStream() {
        return this.rtpStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPorts() {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.rtpInPort = null;
            this.rtcpInPort = null;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(RTPRequestStatus rTPRequestStatus, String string) {
        try {
            Object object;
            String[] stringArray;
            Object object2 = null;
            if (string != null) {
                stringArray = this.getRTPStream().transportFindBestMatch(string).split("[;]");
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2;
                    int n;
                    object = stringArray[i].trim();
                    if (((String)object).length() <= 0) continue;
                    if (i == 0) {
                        object2 = object;
                    }
                    if (((String)object).startsWith("client_port=")) {
                        int n2;
                        n = ((String)object).indexOf(",");
                        if (n >= 0) {
                            object = ((String)object).substring(0, n);
                        }
                        if ((n2 = ((String)object).indexOf("=")) < 0) {
                            n2 = ((String)object).indexOf(":");
                        }
                        if (n2 < 0) continue;
                        stringArray2 = ((String)object).substring(n2 + 1);
                        String[] stringArray3 = stringArray2.split("[-]");
                        if (stringArray3.length >= 2) {
                            try {
                                this.rtpOutPortNum = Integer.parseInt(stringArray3[0]);
                                this.rtcpOutPortNum = Integer.parseInt(stringArray3[1]);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        if (stringArray3.length < 1) continue;
                        try {
                            this.rtpOutPortNum = Integer.parseInt(stringArray3[0]);
                            this.setRTCP(false);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!((String)object).startsWith("interleaved=")) continue;
                    this.isInterleaved = true;
                    n = ((String)object).indexOf("=");
                    if (n < 0) {
                        n = ((String)object).indexOf(":");
                    }
                    if (n < 0) continue;
                    String string2 = ((String)object).substring(n + 1);
                    stringArray2 = string2.split("[-]");
                    if (stringArray2.length >= 2) {
                        try {
                            this.rtpOutPortNum = Integer.parseInt(stringArray2[0]);
                            this.rtcpOutPortNum = Integer.parseInt(stringArray2[1]);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (stringArray2.length < 1) continue;
                    try {
                        this.rtpOutPortNum = Integer.parseInt(stringArray2[0]);
                        this.setRTCP(false);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            stringArray = this.getRTPStream().getRTPContext();
            WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                if (this.getRTPStream().isModePublish()) {
                    object = stringArray.getDePacketizerList();
                    RTPDePacketizerItem rTPDePacketizerItem = ((RTPDePacketizerList)object).getDePacketizerItem(this.rtpDePacketizerName);
                    IApplicationInstance iApplicationInstance = this.getRTPStream().getAppInstance();
                    if (rTPDePacketizerItem != null) {
                        this.rtpDePacketizer = RTPDePacketizerFactory.createInstance((RTPContext)stringArray, rTPDePacketizerItem, iApplicationInstance);
                    } else {
                        WMSLoggerFactory.getLogger(RTPTrack.class).warn("Failed to find an appropriate depacketizer for this track (" + this.getSampleType() + "): You may not have the proper software license to use this feature. Please contact sales@wowzamedia.com for more information.");
                    }
                    if (this.rtpDePacketizer != null) {
                        this.rtpDePacketizer.startup(this);
                    }
                } else if (object2 != null && this.getRTPStream().isMPEGTSOut()) {
                    if (((String)object2).startsWith("MP2T/H2221")) {
                        this.isRTPWrapped = false;
                    } else if (((String)object2).startsWith("MP2T/AVP")) {
                        this.isRTPWrapped = true;
                    }
                }
                if (!this.isInterleaved) {
                    this.addPorts();
                }
            }
            catch (Exception exception) {
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.setup: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public String getAnnounceData() {
        return this.announceData;
    }

    public void setAnnounceData(String string) {
        this.announceData = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRTPDePacketizer getRTPDePacketizer() {
        IRTPDePacketizer iRTPDePacketizer = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            iRTPDePacketizer = this.rtpDePacketizer;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return iRTPDePacketizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRTPDePacketizerName() {
        String string = null;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            string = this.rtpDePacketizerName;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return string;
    }

    public void setRTPDePacketizerName(String string) {
        this.rtpDePacketizerName = string;
    }

    public void announce(RTPRequestStatus rTPRequestStatus) {
        try {
            if (this.rtpDePacketizerName == null) {
                this.rtpDePacketizerName = this.getRTPStream().getRTPContext().getDePacketizerName(this);
            }
            if (this.rtpDePacketizerName == null) {
                RTSPStatics.setStatus(rTPRequestStatus, 461, "Missing DePacketizer");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTSPCore.class).warn("RTPTrack.announce: " + exception.toString());
        }
    }

    public String getTransportStr(String string) {
        RTPStream rTPStream = this.getRTPStream();
        String string2 = rTPStream.transportFindBestMatch(string);
        if (!this.isInterleaved) {
            string2 = string2 + ";source=" + this.getHost() + ";server_port=" + this.getRTPInPortNum() + (this.isRTCP() ? "-" + this.getRTCPInPortNum() : "");
        }
        WMSLoggerFactory.getLogger(RTSPCore.class).debug("RTPTrack.getTransportStr: " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterleaved(boolean bl) {
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.writeLock().lock();
        try {
            this.isInterleaved = bl;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterleaved() {
        boolean bl = false;
        WMSReadWriteLock wMSReadWriteLock = this.rtpStream.getStreamLock();
        wMSReadWriteLock.readLock().lock();
        try {
            bl = this.isInterleaved;
        }
        catch (Exception exception) {
        }
        finally {
            wMSReadWriteLock.readLock().unlock();
        }
        return bl;
    }

    public int getSamplesPerFrame() {
        return this.samplesPerFrame;
    }

    public void setSamplesPerFrame(int n) {
        this.samplesPerFrame = n;
    }

    public boolean isWaitForFirstEnd() {
        return this.waitForFirstEnd;
    }

    public void setWaitForFirstEnd(boolean bl) {
        this.waitForFirstEnd = bl;
    }

    public void checkSendMetadata(long l) {
        this.rtpStream.checkSendMetadata(l);
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public void setSSRC(long l) {
        this.ssrc = l;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int n) {
        this.maxPacketSize = n;
    }

    public IRTPPacketizer getRTPPacketizer() {
        return this.rtpPacketizer;
    }

    public void setRTPPacketizer(IRTPPacketizer iRTPPacketizer) {
        this.rtpPacketizer = iRTPPacketizer;
    }

    public int getRTPMapType() {
        return this.rtpMapType;
    }

    public void setRTPMapType(int n) {
        this.rtpMapType = n;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public void setBitrate(int n) {
        this.bitrate = n;
    }

    public InetSocketAddress getRTPOutAddress() {
        if (this.rtpOutAddress == null) {
            String string = this.getRTPStream().getOutHost();
            int n = this.getRTPOutPortNum();
            if (n > 0) {
                this.rtpOutAddress = new InetSocketAddress(string, n);
            }
        }
        return this.rtpOutAddress;
    }

    public InetSocketAddress getRTCPOutAddress() {
        if (this.rtcpOutAddress == null) {
            String string = this.getRTPStream().getOutHost();
            int n = this.getRTCPOutPortNum();
            if (n > 0) {
                this.rtcpOutAddress = new InetSocketAddress(string, n);
            }
        }
        return this.rtcpOutAddress;
    }

    public void sendRTPMessage(OutputStream outputStream, byte[] byArray, int n, int n2) {
        Object object;
        if (this.isInterleaved) {
            try {
                object = new byte[4];
                object[0] = 36;
                object[1] = (byte)(this.rtpOutPortNum & 0x7F);
                BufferUtils.intToByteArray(n2, (byte[])object, 2, 2);
                outputStream.write((byte[])object, 0, ((Object)object).length);
                outputStream.write(byArray, n, n2);
            }
            catch (Exception exception) {
                if (this.reportRTPTransportError) {
                    WMSLoggerFactory.getLogger(RTSPCore.class).error("RTPTrack.sendRTPMessage: " + exception.toString());
                }
                this.reportRTPTransportError = false;
            }
        } else {
            object = this.getRTPOutAddress();
            if (object != null) {
                this.getRTPPort().sendResponse(byArray, n, n2, (SocketAddress)object);
            }
        }
        if ((object = this.rtpStream.getStream()) != null) {
            object.getMediaIOPerformance().incrementMessagesOut(n2, 1L);
        }
    }

    public void sendRCTPMessage(OutputStream outputStream, byte[] byArray, int n, int n2) {
        Object object;
        if (this.isInterleaved) {
            try {
                object = new byte[4];
                object[0] = 36;
                object[1] = (byte)(this.rtcpOutPortNum & 0x7F);
                BufferUtils.intToByteArray(n2, (byte[])object, 2, 2);
                outputStream.write((byte[])object, 0, ((Object)object).length);
                outputStream.write(byArray, n, n2);
            }
            catch (Exception exception) {
                if (this.reportRTCPTransportError) {
                    WMSLoggerFactory.getLogger(RTSPCore.class).error("RTPTrack.sendRCTPMessage: " + exception.toString());
                }
                this.reportRTCPTransportError = false;
            }
        } else {
            object = this.getRTCPOutAddress();
            if (object != null) {
                this.getRTCPPort().sendResponse(byArray, n, n2, (SocketAddress)object);
            }
        }
        if ((object = this.rtpStream.getStream()) != null) {
            object.getMediaIOPerformance().incrementMessagesOut(n2, 1L);
        }
    }

    public IRTPMessageHandler getRTPMessageHandler() {
        return this.rtpMessageHandler;
    }

    public IRTPMessageHandler getRTCPMessageHandler() {
        return this.rtcpMessageHandler;
    }

    public boolean isRTCP() {
        return this.isRTCP;
    }

    public void setRTCP(boolean bl) {
        this.isRTCP = bl;
    }

    public boolean isRTPWrapped() {
        return this.isRTPWrapped;
    }

    public void setRTPWrapped(boolean bl) {
        this.isRTPWrapped = bl;
    }

    class HandleRTCPMessage
    implements IRTPMessageHandler {
        RTPTrack rtpTrack = null;

        public HandleRTCPMessage(RTPTrack rTPTrack2) {
            this.rtpTrack = rTPTrack2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SocketAddress socketAddress, byte[] byArray, int n, int n2) {
            this.rtpTrack.getRTPStream().touch();
            WMSReadWriteLock wMSReadWriteLock = this.rtpTrack.getRTPStream().getStreamLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                if (RTPTrack.this.rtpDePacketizer != null) {
                    RTPTrack.this.rtpDePacketizer.handleRTCPPacket(socketAddress, this.rtpTrack, byArray, n, n2);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("HandleRTCPMessage.handleMessage: " + exception.toString());
                exception.printStackTrace();
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
            IMediaStream iMediaStream = RTPTrack.this.rtpStream.getStream();
            if (iMediaStream != null) {
                iMediaStream.getMediaIOPerformance().incrementMessagesIn(n2, 1L);
            }
        }
    }

    class HandleRTPMessage
    implements IRTPMessageHandler {
        private RTPTrack rtpTrack = null;

        public HandleRTPMessage(RTPTrack rTPTrack2) {
            this.rtpTrack = rTPTrack2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(SocketAddress socketAddress, byte[] byArray, int n, int n2) {
            this.rtpTrack.getRTPStream().touch();
            RTPStream rTPStream = this.rtpTrack.getRTPStream();
            WMSReadWriteLock wMSReadWriteLock = rTPStream.getStreamLock();
            wMSReadWriteLock.writeLock().lock();
            try {
                if (RTPTrack.this.rtpDePacketizer != null) {
                    RTPTrack.this.rtpDePacketizer.handleRTPPacket(socketAddress, this.rtpTrack, byArray, n, n2);
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPCore.class).warn("HandleRTPMessage.handleMessage: " + exception.toString());
                exception.printStackTrace();
            }
            finally {
                wMSReadWriteLock.writeLock().unlock();
            }
            IMediaStream iMediaStream = rTPStream.getStream();
            if (iMediaStream != null) {
                iMediaStream.getMediaIOPerformance().incrementMessagesIn(n2, 1L);
            }
        }
    }
}

