/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.model;

import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.rtsp.RTSPResponseMessage;
import java.net.URI;
import java.util.ArrayList;

public class RTPUrl {
    private String url = null;
    private String streamName = "";
    private String appName = "_defapp_";
    private String appInstanceName = "_definst_";
    private String queryStr = "";
    private String host = null;

    public RTPUrl(String string) {
        this.url = string;
        this.decode(false);
    }

    public RTPUrl(String string, boolean bl) {
        if (string.indexOf("://") < 0 && string.indexOf(":/") >= 0) {
            string = string.replace(":/", "://127.0.0.1/");
        }
        this.url = string;
        this.decode(bl);
    }

    public void decode(boolean bl) {
        if (this.url.indexOf("://") >= 0) {
            this.decodeURL(bl);
        } else {
            this.decodeNonURL(bl);
        }
    }

    public void decodeNonURL(boolean bl) {
        String string = this.url;
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        this.decodePath(string, bl);
    }

    public void decodePath(String string, boolean bl) {
        if (string != null) {
            int n;
            int n2 = string.indexOf("?");
            if (n2 >= 0) {
                this.queryStr = string.substring(n2 + 1);
                string = string.substring(0, n2);
            }
            String[] stringArray = string.split("/");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < stringArray.length; ++n) {
                String string2 = stringArray[n].trim();
                if (string2.length() == 0) continue;
                arrayList.add(string2);
            }
            n = arrayList.size();
            if (bl && n > 0) {
                --n;
            }
            if (n == 1) {
                this.streamName = (String)arrayList.get(0);
            } else if (n == 2) {
                this.appName = (String)arrayList.get(0);
                this.streamName = (String)arrayList.get(1);
            } else if (n > 2) {
                this.appName = (String)arrayList.get(0);
                this.appInstanceName = (String)arrayList.get(1);
                this.streamName = "";
                for (int i = 2; i < n; ++i) {
                    if (this.streamName.length() > 0) {
                        this.streamName = this.streamName + "/";
                    }
                    this.streamName = this.streamName + (String)arrayList.get(i);
                }
            }
        }
    }

    public void decodeURL(boolean bl) {
        block3: {
            URI uRI = null;
            try {
                uRI = new URI(this.url);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLogger(RTSPResponseMessage.class).warn("RTSPCore.announce: context url is bad format(" + this.url + "): " + exception.toString());
                break block3;
            }
            if (uRI.getQuery() != null) {
                this.queryStr = uRI.getQuery();
            }
            this.host = uRI.getHost();
            this.streamName = "";
            this.appName = "_defapp_";
            this.appInstanceName = "_definst_";
            String string = uRI.getPath();
            this.decodePath(string, bl);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public String getAppInstanceName() {
        return this.appInstanceName;
    }

    public void setAppInstanceName(String string) {
        this.appInstanceName = string;
    }

    public String getUrlId() {
        return this.getAppName() + "/" + this.getAppInstanceName() + "/" + this.streamName;
    }

    public synchronized String getQueryStr() {
        return this.queryStr;
    }

    public synchronized void setQueryStr(String string) {
        this.queryStr = string;
    }

    public String getHost() {
        return this.host;
    }
}

