/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.RTPPacketizerRTCPSender;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public abstract class RTPPacketizerBase {
    public static final int RTPHEADERSIZE = 12;
    protected List<PendingBlock> pendingBlocks = new ArrayList<PendingBlock>();
    protected long sequence = 0L;
    protected RTPPacketizerRTCPSender rtcpSender = new RTPPacketizerRTCPSender();
    protected AtomicLong packetCount = new AtomicLong();
    protected AtomicLong byteCount = new AtomicLong();
    protected boolean isRTPWrapped = false;

    protected void addPendingBlock(PendingBlock pendingBlock) {
        this.pendingBlocks.add(pendingBlock);
    }

    protected void fillHeader(byte[] byArray, boolean bl, long l, long l2, long l3, int n) {
        byArray[0] = -128;
        byArray[1] = (byte)((bl ? 128 : 0) + n);
        BufferUtils.longToByteArray(l, byArray, 2, 2);
        BufferUtils.longToByteArray(l2, byArray, 4, 4);
        BufferUtils.longToByteArray(l3, byArray, 8, 4);
    }

    public long getPacketCount() {
        return this.packetCount.get();
    }

    public long getByteCount() {
        return this.byteCount.get();
    }

    public long getRTCPOctetCount() {
        return this.byteCount.get() - this.packetCount.get() * 12L;
    }

    protected void writePendingBlocks(OutputStream outputStream, RTPTrack rTPTrack, int n) {
        block1: {
            int n2 = this.pendingBlocks.size();
            long l = rTPTrack.getSSRC();
            if (n2 <= 0) break block1;
            for (int i = 0; i < n2; ++i) {
                PendingBlock pendingBlock = this.pendingBlocks.get(i);
                ++this.sequence;
                this.fillHeader(pendingBlock.block, i == n2 - 1, this.sequence, pendingBlock.timecode, l, n);
                rTPTrack.sendRTPMessage(outputStream, pendingBlock.block, 0, pendingBlock.size);
                this.packetCount.incrementAndGet();
                this.byteCount.addAndGet(pendingBlock.size);
            }
            this.pendingBlocks.clear();
        }
    }

    public boolean isRTPWrapped() {
        return this.isRTPWrapped;
    }

    public void setRTPWrapped(boolean bl) {
        this.isRTPWrapped = bl;
    }

    protected class PendingBlock {
        byte[] block = null;
        int size = 0;
        long timecode = 0L;

        public PendingBlock(byte[] byArray, int n, long l) {
            this.block = byArray;
            this.size = n;
            this.timecode = l;
        }
    }
}

