/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BitWriter;
import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;

public class RTPPacketizerMPEG4LATM
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    private int timescale = -1;
    private int channels = -1;
    private int sampleCount = 1024;
    private int lastAACSampleRate = -1;
    private long lastAACTimecode = -1L;

    public RTPPacketizerMPEG4LATM() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            if (aMFPacket.getSize() >= 4) {
                int n = aMFPacket.getFirstByte();
                int n2 = aMFPacket.getSecondByte();
                int n3 = FLVUtils.getAudioCodec(n);
                if (n3 != 10 || n2 == 1) {
                    AACFrame aACFrame;
                    AMFPacket aMFPacket2;
                    if (this.timescale < 0 && (aMFPacket2 = iMediaStream.getAudioCodecConfigPacket(l)) != null && aMFPacket2.getSize() >= 4 && (aACFrame = AACUtils.decodeAACCodecConfig(aMFPacket2.getData(), 2)) != null) {
                        this.timescale = aACFrame.getSampleRate();
                        this.channels = aACFrame.getChannels();
                        this.sampleCount = aACFrame.getSampleCount();
                    }
                    if (this.timescale > 0) {
                        int n4;
                        int n5;
                        long l2 = Math.round((double)(l * (long)this.timescale) / 1000.0);
                        if (this.lastAACSampleRate == -1 || this.lastAACSampleRate != this.timescale) {
                            this.lastAACSampleRate = this.timescale;
                            this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                        } else {
                            long l3 = this.lastAACTimecode + (long)this.sampleCount;
                            long l4 = Math.round((double)l3 * 1000.0 / (double)this.lastAACSampleRate);
                            n5 = (int)Math.abs(l4 - l);
                            if (n5 <= 1) {
                                l2 = l3;
                                this.lastAACTimecode = l3;
                            } else {
                                this.lastAACTimecode = Math.round((double)(l * (long)this.lastAACSampleRate) / 1000.0);
                            }
                        }
                        byte[] byArray = aMFPacket.getData();
                        int n6 = 2;
                        int n7 = aMFPacket.getSize() - n6;
                        byte[] byArray2 = new byte[6];
                        n5 = 0;
                        for (n4 = n7; n4 > 255; n4 -= 255) {
                            byArray2[n5] = -1;
                            ++n5;
                        }
                        if (n4 == 255) {
                            byArray2[n5] = -1;
                            byArray2[++n5] = 0;
                            ++n5;
                        } else {
                            byArray2[n5] = (byte)n4;
                            ++n5;
                        }
                        int n8 = 12 + n5 + n7;
                        byte[] byArray3 = new byte[n8];
                        this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n8, l2));
                        System.arraycopy(byArray2, 0, byArray3, 12, n5);
                        System.arraycopy(byArray, n6, byArray3, 12 + n5, n7);
                        this.writePendingBlocks(outputStream, rTPTrack, 96);
                    }
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.RTPPacketizerMPEG4LATM: " + exception.toString());
            exception.printStackTrace();
        }
        return 0;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.channels = 0;
        this.timescale = n2;
        try {
            Object object;
            long l = aMFPacket == null ? 0L : aMFPacket.getAbsTimecode();
            AMFPacket aMFPacket2 = iMediaStream.getAudioCodecConfigPacket(l);
            int n3 = 2;
            int n4 = 4;
            int n5 = 2;
            int n6 = 0;
            int n7 = 255;
            byte[] byArray = new byte[1];
            if (aMFPacket2 != null && aMFPacket2.getSize() >= 4) {
                byArray = new byte[aMFPacket2.getSize() - 2];
                System.arraycopy(aMFPacket2.getData(), 2, byArray, 0, byArray.length);
                object = AACUtils.decodeAACCodecConfig(byArray, 0);
                if (object != null) {
                    if (this.timescale <= 0) {
                        this.timescale = ((AACFrame)object).getSampleRate();
                    }
                    this.channels = ((AACFrame)object).getChannels();
                    n3 = ((AACFrame)object).getProfileObjectType();
                    n4 = ((AACFrame)object).getRateIndex();
                    n5 = ((AACFrame)object).getChannelIndex();
                }
            }
            object = new byte[6];
            BitWriter bitWriter = new BitWriter((byte[])object);
            bitWriter.putInt(1, 0);
            bitWriter.putInt(1, 1);
            bitWriter.putInt(6, 0);
            bitWriter.putInt(4, 0);
            bitWriter.putInt(3, 0);
            bitWriter.putInt(5, n3);
            bitWriter.putInt(4, n4);
            bitWriter.putInt(4, n5);
            bitWriter.putInt(3, n6);
            bitWriter.putInt(1, 0);
            bitWriter.putInt(1, 0);
            bitWriter.putInt(1, 0);
            bitWriter.putInt(8, n7);
            bitWriter.putInt(6, 0);
            stringBuffer.append("a=rtpmap:96 MP4A-LATM/" + this.timescale + "/" + this.channels + "\r\n");
            stringBuffer.append("a=fmtp:96 profile-level-id=15;object=2;cpresent=0;config=" + BufferUtils.encodeHexString((byte[])object) + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4LATM.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(this.timescale);
        rTPDescribeInfo.setChannels(this.channels);
        rTPDescribeInfo.setSDPTypeId(96);
        return rTPDescribeInfo;
    }

    public int getSDPTypeId() {
        return 96;
    }
}

