/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.aac.AACFrame;
import com.wowza.wms.media.aac.AACUtils;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPStream;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPMPEGTSFill;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.stream.IMediaStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerMPEGTS
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    public static final int PATINTERVAL = 90;
    public static final int PCRINTERVAL = 36;
    public static final int TS_PACKETLEN = 188;
    public static final int TS_RTPHEADER = 12;
    public static final int TS_SYNCBYTE = 71;
    public static final int TS_PACKETPERBLOCK = 6;
    public static final int FILESEGMENTTC = 10000;
    private RTPTrack transportTrack = null;
    private long lastPAT = -1L;
    private long lastPCR = -1L;
    private long startPCRRT = -1L;
    private long startPCRTimecode = -1L;
    private byte[] block = null;
    private int pcount = 0;
    private int pptr = 0;
    private int videoPID = 256;
    private byte videoStreamID = (byte)-32;
    private int audioPID = 257;
    private byte audioStreamID = (byte)-64;
    private long videoCCounter = -1L;
    private long audioCCounter = -1L;
    private long patCCounter = 0L;
    private AACFrame aacFrame = null;
    private H264CodecConfigParts h264CodecConfigPart = null;
    private long lastAudioTimecode = -1L;
    private long lastVideoTimecode = -1L;
    private long lastPCRTimecode = -1L;
    private boolean isFirstAudioPacket = true;
    private boolean isFirstVideoPacket = true;
    private WaitingAAC waitingAAC = new WaitingAAC();
    private long lastFileSegmentTC = 0L;
    private long lastFileSegmentId = 0L;
    private String testOutPath = null;
    private boolean testOutFirst = true;
    private boolean inited = false;
    private int pcrBufferTime = 750;

    private void nextBlock(OutputStream outputStream, RTPTrack rTPTrack, long l) {
        if (this.block == null || this.pcount >= 6) {
            if (this.block != null) {
                this.flushBlock(outputStream, rTPTrack, false, l);
            }
            this.block = new byte[(this.isRTPWrapped ? 12 : 0) + 1128];
            this.pcount = 1;
            this.pptr = this.isRTPWrapped ? 12 : 0;
        } else {
            ++this.pcount;
            this.pptr += 188;
        }
    }

    private void flushBlock(OutputStream outputStream, RTPTrack rTPTrack, boolean bl, long l) {
        block1: {
            if (this.block == null) break block1;
            if (this.isRTPWrapped) {
                long l2 = rTPTrack.getSSRC();
                this.fillHeader(this.block, false, this.sequence, l, l2, 98);
                ++this.sequence;
            }
            int n = (this.isRTPWrapped ? 12 : 0) + this.pcount * 188;
            rTPTrack.sendRTPMessage(outputStream, this.block, 0, n);
        }
    }

    private void fillBlock(int n) {
        System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n, 188 - n);
    }

    private int sendPCR(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, long l) {
        return this.sendPCR(outputStream, iMediaStream, rTPTrack, l, false);
    }

    private int sendPCR(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, long l, boolean bl) {
        int n = 0;
        byte[] byArray = new byte[]{71, 1, 0, 32, -73, 16, 0, 0, 0, 0, 0, 0};
        this.nextBlock(outputStream, this.transportTrack, l);
        int n2 = 0;
        System.arraycopy(byArray, 0, this.block, this.pptr + n2, byArray.length);
        if (this.videoCCounter == -1L) {
            this.videoCCounter = 1L;
        }
        int n3 = this.pptr + n2 + 3;
        this.block[n3] = (byte)(this.block[n3] & 0xFFFFFFF0);
        int n4 = this.pptr + n2 + 3;
        this.block[n4] = (byte)(this.block[n4] | (byte)(this.videoCCounter & 0xFL));
        if (bl) {
            int n5 = this.pptr + n2 + 5;
            this.block[n5] = (byte)(this.block[n5] | 0xFFFFFF80);
        }
        long l2 = l * 90L;
        byte[] byArray2 = BufferUtils.longToByteArray(l2 <<= 7);
        n2 = 6;
        this.block[this.pptr + n2 + 4] = (byte)((byArray2[7] & 0x80) + 126);
        this.block[this.pptr + n2 + 3] = (byte)(byArray2[6] & 0xFF);
        this.block[this.pptr + n2 + 2] = (byte)(byArray2[5] & 0xFF);
        this.block[this.pptr + n2 + 1] = (byte)(byArray2[4] & 0xFF);
        this.block[this.pptr + n2 + 0] = (byte)(byArray2[3] & 0xFF);
        n2 = byArray.length;
        this.fillBlock(n2);
        return n;
    }

    private int sendPAT(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, long l) {
        int n = 0;
        String string = "";
        string = "474FFF100002B0170001C10000E100F0001BE100F0000FE101F0002F44B99B";
        byte[] byArray = BufferUtils.decodeHexString(string);
        string = "474000100000B00D0001C100000001EFFF3690E23D";
        byte[] byArray2 = BufferUtils.decodeHexString(string);
        this.nextBlock(outputStream, this.transportTrack, l);
        int n2 = 0;
        System.arraycopy(byArray2, 0, this.block, this.pptr + n2, byArray2.length);
        int n3 = this.pptr + n2 + 3;
        this.block[n3] = (byte)(this.block[n3] & 0xFFFFFFF0);
        int n4 = this.pptr + n2 + 3;
        this.block[n4] = (byte)(this.block[n4] | (byte)(this.patCCounter & 0xFL));
        n2 = byArray2.length;
        this.fillBlock(n2);
        this.nextBlock(outputStream, this.transportTrack, l);
        n2 = 0;
        System.arraycopy(byArray, 0, this.block, this.pptr + n2, byArray.length);
        int n5 = this.pptr + n2 + 3;
        this.block[n5] = (byte)(this.block[n5] & 0xFFFFFFF0);
        int n6 = this.pptr + n2 + 3;
        this.block[n6] = (byte)(this.block[n6] | (byte)(this.patCCounter & 0xFL));
        n2 = byArray.length;
        this.fillBlock(n2);
        ++this.patCCounter;
        return n;
    }

    private long getPCRTimecode() {
        long l = -1L;
        if (this.lastAudioTimecode >= 0L && this.lastVideoTimecode >= 0L) {
            l = Math.min(this.lastAudioTimecode, this.lastVideoTimecode);
        } else if (this.lastAudioTimecode >= 0L) {
            l = this.lastAudioTimecode;
        } else if (this.lastVideoTimecode >= 0L) {
            l = this.lastVideoTimecode;
        }
        if (this.lastPCRTimecode != -1L && l < this.lastPCRTimecode) {
            l = this.lastPCRTimecode;
        }
        if (l < 0L) {
            l = 0L;
        }
        if (l >= (long)this.pcrBufferTime) {
            l -= (long)this.pcrBufferTime;
        }
        this.lastPCRTimecode = l;
        return l;
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        int n;
        block53: {
            byte[] byArray;
            byte[] byArray2;
            int n2;
            int n3;
            int n4;
            boolean bl;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            block56: {
                Object object;
                int n10;
                int n11;
                block54: {
                    long l2;
                    int n12;
                    byte[] byArray3;
                    block55: {
                        n = 0;
                        if (!this.inited) {
                            WMSProperties wMSProperties = iMediaStream.getProperties();
                            if (wMSProperties != null) {
                                this.pcrBufferTime = wMSProperties.getPropertyInt("pcrBufferTime", this.pcrBufferTime);
                            }
                            this.inited = true;
                        }
                        long l3 = System.currentTimeMillis();
                        if (this.lastPAT == -1L || l3 - this.lastPAT > 90L) {
                            this.lastPAT = l3;
                            n += this.sendPAT(outputStream, iMediaStream, rTPTrack, l * 90L);
                        }
                        if (this.transportTrack == null) {
                            this.transportTrack = rTPTrack.getRTPStream().getTrack("mpegts-transport");
                        }
                        if (this.transportTrack == null) break block53;
                        RTPStream rTPStream = rTPTrack.getRTPStream();
                        if (aMFPacket.getSize() < 2) break block53;
                        n11 = aMFPacket.getType();
                        n9 = aMFPacket.getFirstByte();
                        n10 = aMFPacket.getSecondByte();
                        if (n11 != 8) break block54;
                        byArray3 = aMFPacket.getData();
                        n12 = aMFPacket.getSize();
                        n8 = FLVUtils.getAudioCodec(n9);
                        if (n8 != 10 || n10 == 1) break block55;
                        if (n10 != 0) break block53;
                        this.aacFrame = AACUtils.decodeAACCodecConfig(byArray3, 2);
                        break block53;
                    }
                    if (n8 == 10 && this.aacFrame == null) break block53;
                    this.aacFrame.setSize(n12 - 2 + 7);
                    object = new byte[7];
                    AACUtils.frameToDTSBuffer(this.aacFrame, object, 0);
                    this.waitingAAC.fragments.add(new RTPPacketFragment((byte[])object, 0, ((byte[])object).length));
                    this.waitingAAC.size += ((byte[])object).length;
                    this.waitingAAC.fragments.add(new RTPPacketFragment(byArray3, 2, n12 - 2));
                    this.waitingAAC.size += n12 - 2;
                    ++this.waitingAAC.count;
                    if (this.waitingAAC.timecode == -1L) {
                        this.waitingAAC.timecode = l;
                    }
                    this.waitingAAC.lastTimecode = l;
                    if (this.waitingAAC.count < 3) break block53;
                    this.lastAudioTimecode = this.waitingAAC.timecode;
                    int n13 = this.waitingAAC.size;
                    long l4 = l2 = this.waitingAAC.timecode * 90L;
                    boolean bl2 = false;
                    int n14 = 0;
                    RTPPacketFragment rTPPacketFragment = this.waitingAAC.fragments.remove(0);
                    n7 = 0;
                    n6 = rTPPacketFragment.getOffset();
                    n5 = rTPPacketFragment.getLen();
                    byte[] byArray4 = rTPPacketFragment.getBuffer();
                    bl = true;
                    n4 = 0;
                    do {
                        long l5;
                        int n15;
                        int n16;
                        int n17;
                        n3 = 0;
                        this.nextBlock(outputStream, this.transportTrack, l * 90L);
                        this.block[this.pptr + n3] = 71;
                        this.block[this.pptr + ++n3] = (byte)((bl ? 64 : 0) + (0x1F & this.audioPID >> 8));
                        this.block[this.pptr + ++n3] = (byte)(this.audioPID & 0xFF);
                        this.audioCCounter = this.audioCCounter == -1L ? 1L : ++this.audioCCounter;
                        this.block[this.pptr + ++n3] = (byte)(16L + (this.audioCCounter & 0xFL));
                        ++n3;
                        n2 = 0;
                        if (bl) {
                            n2 = 9 + (bl2 ? 10 : 5);
                        }
                        if ((n17 = 188 - n3 - n2) > n13 - n14) {
                            n17 = n13 - n14;
                        }
                        if (n4 != 0) {
                            int n18 = this.pptr + 3;
                            this.block[n18] = (byte)(this.block[n18] | 0x20);
                            n16 = 8;
                            n17 = 188 - n3 - n2 - n16;
                            if (n17 > n13 - n14) {
                                n17 = n13 - n14;
                            }
                            if ((n15 = 188 - (n3 + n17 + n2 + n16)) < 0) {
                                n15 = 0;
                            }
                            this.block[this.pptr + n3] = (byte)(n16 - 1 + n15 & 0xFF);
                            this.block[this.pptr + ++n3] = (byte)(this.isFirstAudioPacket ? 144 : 16);
                            l5 = l * 90L;
                            byArray2 = BufferUtils.longToByteArray(l5 <<= 7);
                            this.block[this.pptr + ++n3 + 4] = (byte)((byArray2[7] & 0x80) + 126);
                            this.block[this.pptr + n3 + 3] = (byte)(byArray2[6] & 0xFF);
                            this.block[this.pptr + n3 + 2] = (byte)(byArray2[5] & 0xFF);
                            this.block[this.pptr + n3 + 1] = (byte)(byArray2[4] & 0xFF);
                            this.block[this.pptr + n3 + 0] = (byte)(byArray2[3] & 0xFF);
                            n3 += 6;
                            if (n15 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n3, n15);
                                n3 += n15;
                            }
                            if ((n17 = 188 - n3 - n2) > n13 - n14) {
                                n17 = n13 - n14;
                            }
                        } else if (n3 + n17 + n2 < 188) {
                            n16 = 188 - (n3 + n17 + n2);
                            int n19 = this.pptr + 3;
                            this.block[n19] = (byte)(this.block[n19] | 0x20);
                            if (n16 > 1) {
                                this.block[this.pptr + n3] = (byte)(--n16 & 0xFF);
                                this.block[this.pptr + ++n3] = 0;
                                ++n3;
                                if (--n16 > 0) {
                                    System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n3, n16);
                                }
                                n3 += n16;
                            } else {
                                this.block[this.pptr + n3] = 0;
                                ++n3;
                            }
                        }
                        if (bl) {
                            this.block[this.pptr + n3] = 0;
                            this.block[this.pptr + ++n3] = 0;
                            this.block[this.pptr + ++n3] = 1;
                            this.block[this.pptr + ++n3] = this.audioStreamID;
                            n16 = bl2 ? 10 : 5;
                            n15 = n13 + n16 + 3;
                            BufferUtils.intToByteArray(n15, this.block, this.pptr + ++n3, 2);
                            this.block[this.pptr + (n3 += 2)] = -128;
                            this.block[this.pptr + ++n3] = (byte)(bl2 ? 192 : 128);
                            this.block[this.pptr + ++n3] = (byte)n16;
                            l5 = l4;
                            this.block[this.pptr + ++n3 + 4] = (byte)(((l5 & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n3 + 3] = (byte)((l5 >>= 7) & 0xFFL);
                            this.block[this.pptr + n3 + 2] = (byte)((((l5 >>= 8) & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n3 + 1] = (byte)((l5 >>= 7) & 0xFFL);
                            this.block[this.pptr + n3 + 0] = (byte)((((l5 >>= 8) & 7L) << 1) + 1L + (long)(bl2 ? 48 : 32));
                            n3 += 5;
                            if (bl2) {
                                l5 = l2;
                                this.block[this.pptr + n3 + 4] = (byte)(((l5 & 0x7FL) << 1) + 1L);
                                this.block[this.pptr + n3 + 3] = (byte)((l5 >>= 7) & 0xFFL);
                                this.block[this.pptr + n3 + 2] = (byte)((((l5 >>= 8) & 0x7FL) << 1) + 1L);
                                this.block[this.pptr + n3 + 1] = (byte)((l5 >>= 7) & 0xFFL);
                                this.block[this.pptr + n3 + 0] = (byte)((((l5 >>= 8) & 7L) << 1) + 1L + (long)(bl2 ? 16 : 32));
                                n3 += 5;
                            }
                        }
                        do {
                            if ((n16 = n17) > n5 - n7) {
                                n16 = n5 - n7;
                            }
                            System.arraycopy(byArray4, n6 + n7, this.block, this.pptr + n3, n16);
                            n3 += n16;
                            n14 += n16;
                            n17 -= n16;
                            if ((n7 += n16) < n5) continue;
                            n7 = 0;
                            if (this.waitingAAC.fragments.size() <= 0) continue;
                            rTPPacketFragment = this.waitingAAC.fragments.remove(0);
                            n6 = rTPPacketFragment.getOffset();
                            n5 = rTPPacketFragment.getLen();
                            byArray4 = rTPPacketFragment.getBuffer();
                        } while (n3 < 188 && n14 < n13);
                        bl = false;
                        this.isFirstAudioPacket = false;
                    } while (n14 < n13);
                    this.waitingAAC.clear();
                }
                if (n11 != 9) break block53;
                this.lastVideoTimecode = l;
                int n20 = FLVUtils.getVideoCodec(n9);
                byArray = aMFPacket.getData();
                n8 = aMFPacket.getSize();
                if (n20 != 7 || n10 == 1) break block56;
                if (n10 != 0) break block53;
                this.h264CodecConfigPart = H264Utils.breakApartAVCC(byArray, 5, n8 - 5);
                object = H264Utils.decodeAVCC(byArray, 5);
                break block53;
            }
            int n21 = BufferUtils.byteArrayToInt(byArray, 2, 3);
            long l6 = l * 90L;
            long l7 = n21 == 0 ? l6 : (l + (long)n21) * 90L;
            boolean bl3 = n21 != 0;
            ArrayList<RTPPacketFragment> arrayList = new ArrayList<RTPPacketFragment>();
            byte[] byArray5 = new byte[4];
            byArray5[3] = 1;
            int n22 = 0;
            n7 = 0;
            n6 = 5;
            n5 = 0;
            boolean bl4 = false;
            bl = false;
            while (n6 + 4 <= n8 && (n4 = BufferUtils.byteArrayToInt(byArray, n6, 4)) > 0 && (n6 += 4) + n4 <= n8) {
                n3 = byArray[n6] & 0x1F;
                if (n3 == 7) {
                    n5 = 1;
                } else if (n3 == 8) {
                    bl4 = true;
                } else if (n3 == 9) {
                    bl = true;
                }
                arrayList.add(new RTPPacketFragment(byArray5, 0, byArray5.length));
                arrayList.add(new RTPPacketFragment(byArray, n6, n4));
                n22 += n4 + byArray5.length;
                ++n7;
                if ((n6 += n4) < n8) continue;
                break;
            }
            n4 = 0;
            n3 = FLVUtils.getFrameType(n9);
            n2 = 0;
            if (!bl && !bl) {
                byte[] byArray6 = new byte[6];
                byArray6[3] = 1;
                byArray6[4] = 9;
                byArray6[5] = n3 == 1 ? 16 : (n3 == 3 ? 80 : 48);
                arrayList.add(n2, new RTPPacketFragment(byArray6, 0, byArray6.length));
                ++n2;
                n22 += byArray6.length;
                ++n7;
                n4 = 1;
            }
            if (!(n3 != 1 || bl4 && bl)) {
                if (n3 == 1 && n5 == 0 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.sps != null) {
                    byte[] byArray7 = new byte[4];
                    byArray7[3] = 1;
                    arrayList.add(n2, new RTPPacketFragment(byArray7, 0, byArray7.length));
                    arrayList.add(++n2, new RTPPacketFragment(this.h264CodecConfigPart.sps, 0, this.h264CodecConfigPart.sps.length));
                    ++n2;
                    n22 += this.h264CodecConfigPart.sps.length + byArray7.length;
                    ++n7;
                    n4 = 1;
                }
                if (n3 == 1 && !bl4 && this.h264CodecConfigPart != null && this.h264CodecConfigPart.ppss != null) {
                    for (byte[] byArray8 : this.h264CodecConfigPart.ppss) {
                        byte[] byArray9 = new byte[4];
                        byArray9[3] = 1;
                        arrayList.add(n2, new RTPPacketFragment(byArray9, 0, byArray9.length));
                        arrayList.add(++n2, new RTPPacketFragment(byArray8, 0, byArray8.length));
                        ++n2;
                        n22 += byArray8.length + byArray9.length;
                        ++n7;
                        n4 = 1;
                    }
                }
            }
            if (n7 <= 0) break block53;
            int n23 = 0;
            RTPPacketFragment rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
            int n24 = 0;
            int n25 = rTPPacketFragment.getOffset();
            int n26 = rTPPacketFragment.getLen();
            byArray2 = rTPPacketFragment.getBuffer();
            long l8 = this.getPCRTimecode();
            boolean bl5 = true;
            boolean bl6 = true;
            int n27 = 9000;
            do {
                bl5 = true;
                bl6 = true;
                int n28 = 0;
                int n29 = n22 - n23;
                if (n29 > n27) {
                    n29 = n27;
                }
                do {
                    long l9;
                    int n30;
                    int n31;
                    int n32;
                    int n33 = 0;
                    this.nextBlock(outputStream, this.transportTrack, l * 90L);
                    this.block[this.pptr + n33] = 71;
                    this.block[this.pptr + ++n33] = (byte)((bl5 ? 64 : 0) + (0x1F & this.videoPID >> 8));
                    this.block[this.pptr + ++n33] = (byte)(this.videoPID & 0xFF);
                    this.videoCCounter = this.videoCCounter == -1L ? 1L : ++this.videoCCounter;
                    this.block[this.pptr + ++n33] = (byte)(16L + (this.videoCCounter & 0xFL));
                    ++n33;
                    int n34 = 0;
                    if (bl5) {
                        n34 = 9 + (bl3 ? 10 : 5);
                    }
                    if ((n32 = 188 - n33 - n34) > n29 - n28) {
                        n32 = n29 - n28;
                    }
                    if (bl6) {
                        int n35 = this.pptr + 3;
                        this.block[n35] = (byte)(this.block[n35] | 0x20);
                        n31 = 8;
                        n32 = 188 - n33 - n34 - n31;
                        if (n32 > n29 - n28) {
                            n32 = n29 - n28;
                        }
                        n30 = 0;
                        if (n33 + n32 + n34 + n31 < 188) {
                            n30 = 188 - (n33 + n32 + n34 + n31);
                        }
                        this.block[this.pptr + n33] = (byte)(n31 - 1 + n30 & 0xFF);
                        this.block[this.pptr + ++n33] = (byte)(this.isFirstVideoPacket ? 144 : 16);
                        l9 = l8 * 90L;
                        byte[] byArray10 = BufferUtils.longToByteArray(l9 <<= 7);
                        this.block[this.pptr + ++n33 + 4] = (byte)((byArray10[7] & 0x80) + 126);
                        this.block[this.pptr + n33 + 3] = (byte)(byArray10[6] & 0xFF);
                        this.block[this.pptr + n33 + 2] = (byte)(byArray10[5] & 0xFF);
                        this.block[this.pptr + n33 + 1] = (byte)(byArray10[4] & 0xFF);
                        this.block[this.pptr + n33 + 0] = (byte)(byArray10[3] & 0xFF);
                        n33 += 6;
                        if (n30 > 0) {
                            System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n33, n30);
                            n33 += n30;
                        }
                        if ((n32 = 188 - n33 - n34) > n29 - n28) {
                            n32 = n29 - n28;
                        }
                    } else if (n33 + n32 + n34 < 188) {
                        n31 = 188 - (n33 + n32 + n34);
                        int n36 = this.pptr + 3;
                        this.block[n36] = (byte)(this.block[n36] | 0x20);
                        if (n31 > 1) {
                            this.block[this.pptr + n33] = (byte)(--n31 & 0xFF);
                            this.block[this.pptr + ++n33] = 0;
                            ++n33;
                            if (--n31 > 0) {
                                System.arraycopy(RTPMPEGTSFill.FILL, 0, this.block, this.pptr + n33, n31);
                            }
                            n33 += n31;
                        } else {
                            this.block[this.pptr + n33] = 0;
                            ++n33;
                        }
                    }
                    if (bl5) {
                        this.block[this.pptr + n33] = 0;
                        this.block[this.pptr + ++n33] = 0;
                        this.block[this.pptr + ++n33] = 1;
                        this.block[this.pptr + ++n33] = this.videoStreamID;
                        ++n33;
                        n31 = bl3 ? 10 : 5;
                        n30 = n29 + n31 + 3;
                        if (n30 >= 65536) {
                            System.out.println("toolong: " + n30);
                        }
                        BufferUtils.intToByteArray(n30, this.block, this.pptr + n33, 2);
                        this.block[this.pptr + (n33 += 2)] = -124;
                        this.block[this.pptr + ++n33] = (byte)(bl3 ? 192 : 128);
                        this.block[this.pptr + ++n33] = (byte)n31;
                        l9 = l7;
                        this.block[this.pptr + ++n33 + 4] = (byte)(((l9 & 0x7FL) << 1) + 1L);
                        this.block[this.pptr + n33 + 3] = (byte)((l9 >>= 7) & 0xFFL);
                        this.block[this.pptr + n33 + 2] = (byte)((((l9 >>= 8) & 0x7FL) << 1) + 1L);
                        this.block[this.pptr + n33 + 1] = (byte)((l9 >>= 7) & 0xFFL);
                        this.block[this.pptr + n33 + 0] = (byte)((((l9 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 48 : 32));
                        n33 += 5;
                        if (bl3) {
                            l9 = l6;
                            this.block[this.pptr + n33 + 4] = (byte)(((l9 & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n33 + 3] = (byte)((l9 >>= 7) & 0xFFL);
                            this.block[this.pptr + n33 + 2] = (byte)((((l9 >>= 8) & 0x7FL) << 1) + 1L);
                            this.block[this.pptr + n33 + 1] = (byte)((l9 >>= 7) & 0xFFL);
                            this.block[this.pptr + n33 + 0] = (byte)((((l9 >>= 8) & 7L) << 1) + 1L + (long)(bl3 ? 16 : 32));
                            n33 += 5;
                        }
                    }
                    do {
                        if ((n31 = n32) > n26 - n24) {
                            n31 = n26 - n24;
                        }
                        System.arraycopy(byArray2, n25 + n24, this.block, this.pptr + n33, n31);
                        n33 += n31;
                        n23 += n31;
                        n32 -= n31;
                        n28 += n31;
                        if ((n24 += n31) < n26) continue;
                        n24 = 0;
                        if (arrayList.size() <= 0) continue;
                        rTPPacketFragment = (RTPPacketFragment)arrayList.remove(0);
                        n25 = rTPPacketFragment.getOffset();
                        n26 = rTPPacketFragment.getLen();
                        byArray2 = rTPPacketFragment.getBuffer();
                    } while (n33 < 188 && n28 < n29 && n23 < n22);
                    bl5 = false;
                    this.isFirstVideoPacket = false;
                } while (n28 < n29 && n23 < n22);
            } while (n23 < n22);
        }
        return n;
    }

    private void breakToNewFile(long l) {
        ++this.lastFileSegmentId;
        this.lastFileSegmentTC = l;
        this.testOutFirst = true;
        this.lastPAT = -1L;
        System.out.println("****BREAK:[" + this.lastFileSegmentId + "]****");
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        int n = 0;
        if (this.transportTrack == null) {
            this.transportTrack = rTPTrack.getRTPStream().getTrack("mpegts-transport");
        }
        if (this.transportTrack == null) {
            // empty if block
        }
        return n;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        n2 = 90000;
        try {
            stringBuffer.append("a=rtpmap:98 MP2T/" + n2 + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(n2);
        rTPDescribeInfo.setSDPTypeId(98);
        return rTPDescribeInfo;
    }

    public int getSDPTypeId() {
        return 98;
    }

    class WaitingAAC {
        long timecode = -1L;
        long lastTimecode = -1L;
        int count = 0;
        int size = 0;
        List<RTPPacketFragment> fragments = new ArrayList<RTPPacketFragment>();

        WaitingAAC() {
        }

        public void clear() {
            this.timecode = -1L;
            this.lastTimecode = -1L;
            this.count = 0;
            this.size = 0;
            this.fragments.clear();
        }
    }
}

