/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BitReader;
import com.wowza.util.BitWriter;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h263.H263Frame;
import com.wowza.wms.media.h263.H263Utils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerRFC2190H263
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    private int maxPacketSize = 1438;
    private List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    private boolean isBalanced = true;

    public RTPPacketizerRFC2190H263() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            if (aMFPacket.getSize() >= 2) {
                int n;
                int n2 = aMFPacket.getFirstByte();
                int n3 = aMFPacket.getSecondByte();
                int n4 = FLVUtils.getVideoCodec(n2);
                if (n4 == 2 && (n = FLVUtils.getFrameType(n2)) != 3) {
                    int n5;
                    int n6;
                    byte[] byArray = aMFPacket.getData();
                    int n7 = 1;
                    int n8 = aMFPacket.getSize() - n7;
                    byte[] byArray2 = new byte[n8 + 20];
                    BitReader bitReader = new BitReader(byArray, n7 + n8);
                    BitWriter bitWriter = new BitWriter(byArray2);
                    bitReader.skip(8);
                    H263Frame h263Frame = H263Utils.decodeSorensonSparkHeader(bitReader);
                    H263Utils.encodeH263Header(bitWriter, h263Frame);
                    while (bitReader.remaining() > 0) {
                        n6 = 32;
                        if (n6 > bitReader.remaining()) {
                            n6 = bitReader.remaining();
                        }
                        bitWriter.putInt(n6, bitReader.getInt(n6));
                    }
                    n6 = rTPTrack.getTimescale();
                    n8 = bitWriter.count() / 8 + (bitWriter.count() % 8 > 0 ? 1 : 0);
                    int n9 = 0;
                    int n10 = 2;
                    do {
                        if ((n5 = this.maxPacketSize - n10) > n8 - n9) {
                            n5 = n8 - n9;
                        }
                        int n11 = 12 + n10 + n5;
                        byte[] byArray3 = new byte[n11];
                        this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n11, l * (long)n6 / 1000L));
                        byArray3[12] = (byte)(n9 == 0 ? 4 : 0);
                        System.out.println("pos: " + n9 + ":" + n5 + ":" + n8 + ":" + byArray2.length);
                        System.arraycopy(byArray2, n9, byArray3, 12 + n10, n5);
                    } while ((n9 += n5) < n8);
                    this.writePendingBlocks(outputStream, rTPTrack, 96);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC2190H263.class).error("RTPPacketizerRFC2190H263.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return 0;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 <= 0) {
            n2 = 90000;
        }
        try {
            int n3 = 96;
            stringBuffer.append("a=rtpmap:" + n3 + " H263-1998/" + n2 + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC2190H263.class).error("RTPPacketizerRFC2190H263.handleAMFPacket: " + exception.toString());
        }
        RTPDescribeInfo rTPDescribeInfo = new RTPDescribeInfo();
        rTPDescribeInfo.setSDPStr(stringBuffer.toString());
        rTPDescribeInfo.setTimescale(n2);
        rTPDescribeInfo.setSDPTypeId(96);
        return rTPDescribeInfo;
    }

    public int getSDPTypeId() {
        return 96;
    }
}

