/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javazoom.jl.decoder.buffered.MP3BufferedDecoder;
import javazoom.jl.decoder.buffered.MP3HeaderData;

public class RTPPacketizerRFC2250MP3
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    private int maxPacketSize = 1438;
    private List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    private int timescale = -1;
    private int channels = -1;

    public RTPPacketizerRFC2250MP3() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            int n;
            int n2;
            if (aMFPacket.getSize() >= 2 && (n2 = FLVUtils.getAudioCodec(n = aMFPacket.getFirstByte())) == 2) {
                int n3;
                byte[] byArray = aMFPacket.getData();
                int n4 = 1;
                int n5 = aMFPacket.getSize() - n4;
                int n6 = rTPTrack.getTimescale();
                int n7 = 0;
                do {
                    if ((n3 = this.maxPacketSize - 4) > n5 - n7) {
                        n3 = n5 - n7;
                    }
                    int n8 = 16 + n3;
                    byte[] byArray2 = new byte[n8];
                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n8, l * (long)n6 / 1000L));
                    BufferUtils.intToByteArray(n7, byArray2, 2, 2);
                    System.arraycopy(byArray, n4 + n7, byArray2, 16, n3);
                } while ((n7 += n3) < n5);
                this.writePendingBlocks(outputStream, rTPTrack, 14);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerRFC2250MP3.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return 0;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.channels = 0;
        this.timescale = n2;
        try {
            if (aMFPacket != null) {
                object = aMFPacket.getData();
                int n3 = 1;
                int n4 = aMFPacket.getSize() - n3;
                byte[] byArray = new byte[4];
                System.arraycopy(object, n3, byArray, 0, byArray.length);
                MP3HeaderData mP3HeaderData = new MP3HeaderData();
                int n5 = MP3BufferedDecoder.syncHeader((byte)0, (byte[])byArray, (MP3HeaderData)mP3HeaderData);
                if (n5 != 0) {
                    MP3BufferedDecoder.decodeHeader((int)n5, (int)0, (MP3HeaderData)mP3HeaderData);
                    if (this.timescale <= 0) {
                        this.timescale = MP3BufferedDecoder.frequency((MP3HeaderData)mP3HeaderData);
                    }
                    this.channels = 0;
                    switch (mP3HeaderData.h_mode) {
                        case 0: {
                            this.channels = 2;
                            break;
                        }
                        case 1: {
                            this.channels = 2;
                            break;
                        }
                        case 2: {
                            this.channels = 2;
                            break;
                        }
                        case 3: {
                            this.channels = 1;
                        }
                    }
                }
            }
            stringBuffer.append("a=rtpmap:14 MPA/" + this.timescale + "/" + this.channels + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC2250MP3.class).error("RTPPacketizerRFC2250MP3.handleAMFPacket: " + exception.toString());
        }
        object = new RTPDescribeInfo();
        ((RTPDescribeInfo)object).setSDPStr(stringBuffer.toString());
        ((RTPDescribeInfo)object).setTimescale(this.timescale);
        ((RTPDescribeInfo)object).setChannels(this.channels);
        ((RTPDescribeInfo)object).setSDPTypeId(14);
        return object;
    }

    public int getSDPTypeId() {
        return 14;
    }
}

