/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.BufferUtils;
import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.media.h264.H264CodecConfigInfo;
import com.wowza.wms.media.h264.H264CodecConfigParts;
import com.wowza.wms.media.h264.H264Utils;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerMPEG4AAC;
import com.wowza.wms.rtp.packetizer.RTPPacketizerVideoBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerRFC3984H264
extends RTPPacketizerVideoBase
implements IRTPPacketizer {
    private int maxPacketSize = 1438;
    private List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    private boolean isBalanced = true;

    public RTPPacketizerRFC3984H264() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            if (aMFPacket.getSize() >= 9) {
                int n = aMFPacket.getFirstByte();
                int n2 = aMFPacket.getSecondByte();
                int n3 = FLVUtils.getVideoCodec(n);
                if (n3 != 7 || n2 == 1) {
                    byte[] byArray = aMFPacket.getData();
                    int n4 = aMFPacket.getSize();
                    int n5 = rTPTrack.getTimescale();
                    int n6 = BufferUtils.byteArrayToInt(byArray, 2, 3);
                    long l2 = (l + (long)n6) * (long)n5 / 1000L;
                    int n7 = 0;
                    int n8 = 0;
                    int n9 = 5;
                    while (n9 + 4 <= n4) {
                        int n10;
                        int n11 = BufferUtils.byteArrayToInt(byArray, n9, 4);
                        if (n11 <= 0 || (n9 += 4) + n11 > n4) break;
                        if (n11 > this.maxPacketSize) {
                            int n12;
                            int n13;
                            int n14;
                            int n15;
                            this.flushPending(outputStream, n7, n8, l2);
                            n7 = 0;
                            n8 = 0;
                            if (this.isBalanced) {
                                int n16;
                                n10 = (n11 - 1) / (this.maxPacketSize - 2) + ((n11 - 1) % (this.maxPacketSize - 2) > 0 ? 1 : 0);
                                n15 = (n11 - 1) / n10 + ((n11 - 1) % n10 > 0 ? 1 : 0);
                                n14 = 1;
                                n13 = byArray[n9];
                                n12 = 0;
                                do {
                                    if (n14 + (n16 = n15) > n11) {
                                        n16 = n11 - n14;
                                    }
                                    int n17 = 14 + n16;
                                    byte[] byArray2 = new byte[n17];
                                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n17, l2));
                                    byArray2[12] = (byte)((n13 & 0xE0) + 28);
                                    byArray2[13] = (byte)((n12 == 0 ? 128 : 0) + (n14 + n16 == n11 ? 64 : 0) + (n13 & 0x1F));
                                    System.arraycopy(byArray, n9 + n14, byArray2, 14, n16);
                                    ++n12;
                                } while ((n14 += n16) < n11);
                            } else {
                                n10 = 1;
                                n15 = byArray[n9];
                                n14 = 0;
                                do {
                                    if (n10 + (n13 = this.maxPacketSize - 2) > n11) {
                                        n13 = n11 - n10;
                                    }
                                    n12 = 14 + n13;
                                    byte[] byArray3 = new byte[n12];
                                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray3, n12, l2));
                                    byArray3[12] = (byte)((n15 & 0xE0) + 28);
                                    byArray3[13] = (byte)((n14 == 0 ? 128 : 0) + (n10 + n13 == n11 ? 64 : 0) + (n15 & 0x1F));
                                    System.arraycopy(byArray, n9 + n10, byArray3, 14, n13);
                                    ++n14;
                                } while ((n10 += n13) < n11);
                            }
                        } else {
                            n10 = 1 + 2 * (n7 + 1) + (n8 + n11);
                            if (n10 > this.maxPacketSize) {
                                this.flushPending(outputStream, n7, n8, l2);
                                n7 = 0;
                                n8 = 0;
                            }
                            this.pendingFragments.add(new RTPPacketFragment(byArray, n9, n11));
                            ++n7;
                            n8 += n11;
                        }
                        if ((n9 += n11) < n4) continue;
                        break;
                    }
                    this.flushPending(outputStream, n7, n8, l2);
                    n7 = 0;
                    n8 = 0;
                    this.writePendingBlocks(outputStream, rTPTrack, 97);
                }
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerRFC3984H264.class).error("RTPPacketizerRFC3984H264.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return 0;
    }

    private void flushPending(OutputStream outputStream, int n, int n2, long l) {
        int n3 = this.pendingFragments.size();
        if (n3 > 0) {
            if (n3 == 1) {
                RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                int n4 = 12 + rTPPacketFragment.getLen();
                byte[] byArray = new byte[n4];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n4, l));
                System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12, rTPPacketFragment.getLen());
            } else {
                int n5 = 13 + 2 * n + n2;
                byte[] byArray = new byte[n5];
                this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray, n5, l));
                byArray[12] = 24;
                int n6 = 1;
                while (n3 > 0) {
                    RTPPacketFragment rTPPacketFragment = this.pendingFragments.remove(0);
                    BufferUtils.intToByteArray(rTPPacketFragment.getLen(), byArray, 12 + n6, 2);
                    System.arraycopy(rTPPacketFragment.getBuffer(), rTPPacketFragment.getOffset(), byArray, 12 + (n6 += 2), rTPPacketFragment.getLen());
                    n6 += rTPPacketFragment.getLen();
                    --n3;
                }
            }
        }
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 <= 0) {
            n2 = 90000;
        }
        try {
            int n3;
            object = "packetization-mode=1";
            String string = null;
            String string2 = null;
            long l = aMFPacket == null ? 0L : aMFPacket.getAbsTimecode();
            AMFPacket aMFPacket2 = iMediaStream.getVideoCodecConfigPacket(l);
            if (aMFPacket2 != null && aMFPacket2.getSize() >= 7) {
                n3 = 5;
                H264CodecConfigParts h264CodecConfigParts = H264Utils.breakApartAVCC(aMFPacket2.getData(), n3, aMFPacket2.getSize() - n3);
                if (h264CodecConfigParts != null) {
                    String string3;
                    Object object2;
                    try {
                        object2 = H264Utils.decodeAVCC(aMFPacket2.getData(), n3);
                        if (object2 != null) {
                            string = ((H264CodecConfigInfo)object2).width + "-" + ((H264CodecConfigInfo)object2).height;
                            string2 = "0,0," + ((H264CodecConfigInfo)object2).height + "," + ((H264CodecConfigInfo)object2).width;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object2 = h264CodecConfigParts.getProfileLevelIdStr();
                    if (((String)object2).length() > 0) {
                        object = (String)object + ";profile-level-id=" + ((String)object2).toUpperCase();
                    }
                    if ((string3 = h264CodecConfigParts.getSpropParameterSetsStr()).length() > 0) {
                        object = (String)object + ";sprop-parameter-sets=" + string3;
                    }
                }
            }
            n3 = 97;
            stringBuffer.append("a=rtpmap:" + n3 + " H264/" + n2 + "\r\n");
            stringBuffer.append("a=fmtp:" + n3 + " " + (String)object + "\r\n");
            if (string2 != null) {
                stringBuffer.append("a=cliprect:" + string2 + "\r\n");
            }
            if (string != null) {
                stringBuffer.append("a=framesize:" + n3 + " " + string + "\r\n");
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerMPEG4AAC.class).error("RTPPacketizerMPEG4AAC.handleAMFPacket: " + exception.toString());
        }
        object = new RTPDescribeInfo();
        ((RTPDescribeInfo)object).setSDPStr(stringBuffer.toString());
        ((RTPDescribeInfo)object).setTimescale(n2);
        ((RTPDescribeInfo)object).setSDPTypeId(97);
        return object;
    }

    public int getSDPTypeId() {
        return 97;
    }
}

