/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.rtp.packetizer;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleConnect;
import com.wowza.wms.request.RTMPRequestAdapter;
import com.wowza.wms.rtp.depacketizer.RTPPacketFragment;
import com.wowza.wms.rtp.model.RTPDescribeInfo;
import com.wowza.wms.rtp.model.RTPTrack;
import com.wowza.wms.rtp.packetizer.IRTPPacketizer;
import com.wowza.wms.rtp.packetizer.RTPPacketizerAudioBase;
import com.wowza.wms.rtp.packetizer.RTPPacketizerBase;
import com.wowza.wms.server.LicensingException;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamBase;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RTPPacketizerSpeex
extends RTPPacketizerAudioBase
implements IRTPPacketizer {
    private int maxPacketSize = 1438;
    private List<RTPPacketFragment> pendingFragments = new ArrayList<RTPPacketFragment>();
    private int timescale = -1;
    private int channels = -1;

    public RTPPacketizerSpeex() throws LicensingException {
        try {
            String string = (String)MediaStreamBase.sinfo.get("s");
            BigInteger bigInteger = (BigInteger)MediaStreamBase.sinfo.get("k");
            String string2 = RTMPRequestAdapter.fS(bigInteger.toByteArray(), string);
            if (string2.indexOf(RTMPRequestAdapter.fN(ModuleConnect.getN(116))) < 0) {
                throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
            }
        }
        catch (Exception exception) {
            throw new LicensingException(RTMPRequestAdapter.fN(ModuleConnect.getN(0)));
        }
    }

    public int handleAMFPacket(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack, AMFPacket aMFPacket, long l) {
        this.rtcpSender.sendRTCP(outputStream, this, iMediaStream, rTPTrack, aMFPacket, l);
        try {
            int n;
            int n2;
            if (aMFPacket.getSize() >= 2 && (n2 = FLVUtils.getAudioCodec(n = aMFPacket.getFirstByte())) == 11) {
                int n3;
                byte[] byArray = aMFPacket.getData();
                int n4 = 1;
                int n5 = aMFPacket.getSize() - n4;
                int n6 = rTPTrack.getTimescale();
                int n7 = 0;
                do {
                    if ((n3 = this.maxPacketSize) > n5 - n7) {
                        n3 = n5 - n7;
                    }
                    int n8 = 0;
                    if (n3 % 4 > 0) {
                        n8 = 4 - n3 % 4;
                    }
                    int n9 = 12 + n3 + n8;
                    byte[] byArray2 = new byte[n9];
                    this.addPendingBlock(new RTPPacketizerBase.PendingBlock(byArray2, n9, l * (long)n6 / 1000L));
                    System.arraycopy(byArray, n4 + n7, byArray2, 12, n3);
                    for (int i = 0; i < n8; ++i) {
                        byArray2[12 + n3 + i] = (byte)(i == 0 ? 127 : 255);
                    }
                } while ((n7 += n3) < n5);
                this.writePendingBlocks(outputStream, rTPTrack, 97);
            }
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerSpeex.class).error("RTPPacketizerSpeex.handleAMFPacket: " + exception.toString());
            exception.printStackTrace();
        }
        return 0;
    }

    public int flushPackets(OutputStream outputStream, IMediaStream iMediaStream, RTPTrack rTPTrack) {
        return 0;
    }

    public RTPDescribeInfo getDescribeInfo(RTPTrack rTPTrack, IMediaStream iMediaStream, AMFPacket aMFPacket, int n, int n2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        this.channels = 1;
        this.timescale = n2;
        try {
            if (aMFPacket != null) {
                object = aMFPacket.getData();
                int n3 = 1;
                int n4 = aMFPacket.getSize() - n3;
                if (this.timescale <= 0) {
                    this.timescale = 16000;
                }
                if ((object[0] & 1) == 1) {
                    this.channels = 2;
                }
            }
            stringBuffer.append("a=rtpmap:97 SPEEX/" + this.timescale + "/" + this.channels + "\r\n");
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(RTPPacketizerSpeex.class).error("RTPPacketizerSpeex.handleAMFPacket: " + exception.toString());
        }
        object = new RTPDescribeInfo();
        ((RTPDescribeInfo)object).setSDPStr(stringBuffer.toString());
        ((RTPDescribeInfo)object).setTimescale(this.timescale);
        ((RTPDescribeInfo)object).setChannels(this.channels);
        ((RTPDescribeInfo)object).setSDPTypeId(97);
        return object;
    }

    public int getSDPTypeId() {
        return 97;
    }
}

